/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.util;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.util.ExtensionPointCandidate;
import org.jetbrains.idea.devkit.util.PluginRelatedLocatorsUtils;

public class ExtensionPointLocator {
    private final PsiClass myPsiClass;

    public ExtensionPointLocator(PsiClass psiClass) {
        this.myPsiClass = psiClass;
    }

    public Set<ExtensionPointCandidate> findDirectCandidates() {
        SmartHashSet candidates = new SmartHashSet();
        ExtensionPointLocator.findExtensionPointCandidates(this.myPsiClass, (Set<? super ExtensionPointCandidate>)candidates);
        return candidates;
    }

    public Set<ExtensionPointCandidate> findSuperCandidates() {
        SmartHashSet candidates = new SmartHashSet();
        ExtensionPointLocator.findExtensionPointCandidatesInHierarchy(this.myPsiClass, (Set<? super ExtensionPointCandidate>)candidates, new HashSet());
        return candidates;
    }

    private static void findExtensionPointCandidatesInHierarchy(PsiClass psiClass, Set<? super ExtensionPointCandidate> candidates, HashSet<? super PsiClass> processed) {
        for (PsiClass superClass : psiClass.getSupers()) {
            if (!processed.add((PsiClass)superClass) || "java.lang.Object".equals(superClass.getQualifiedName())) continue;
            ExtensionPointLocator.findExtensionPointCandidates(superClass, candidates);
            ExtensionPointLocator.findExtensionPointCandidatesInHierarchy(superClass, candidates, processed);
        }
    }

    private static void findExtensionPointCandidates(PsiClass psiClass, Set<? super ExtensionPointCandidate> candidates) {
        String name = ClassUtil.getJVMClassName((PsiClass)psiClass);
        if (name == null) {
            return;
        }
        Project project = psiClass.getProject();
        GlobalSearchScope scope = PluginRelatedLocatorsUtils.getCandidatesScope(project);
        PsiSearchHelper.getInstance((Project)project).processUsagesInNonJavaFiles(name, (file, startOffset, endOffset) -> {
            PsiElement element = file.findElementAt(startOffset);
            ExtensionPointLocator.processExtensionPointCandidate(element, candidates);
            return true;
        }, scope);
    }

    private static void processExtensionPointCandidate(PsiElement element, Set<? super ExtensionPointCandidate> candidates) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        if (tag == null) {
            return;
        }
        if ("extensionPoint".equals(tag.getName())) {
            String epName = ExtensionPointLocator.getEPName(tag);
            if (epName != null) {
                candidates.add(new ExtensionPointCandidate((SmartPsiElementPointer<XmlTag>)SmartPointerManager.getInstance((Project)tag.getProject()).createSmartPsiElementPointer((PsiElement)tag), epName));
            }
        } else if ("with".equals(tag.getName())) {
            XmlTag extensionPointTag = tag.getParentTag();
            if (extensionPointTag == null) {
                return;
            }
            if (!"extensionPoint".equals(extensionPointTag.getName())) {
                return;
            }
            String attrName = tag.getAttributeValue("attribute");
            String tagName = tag.getAttributeValue("tag");
            String epName = ExtensionPointLocator.getEPName(extensionPointTag);
            String beanClassName = extensionPointTag.getAttributeValue("beanClass");
            if (attrName == null && tagName == null || epName == null) {
                return;
            }
            candidates.add(new ExtensionPointCandidate((SmartPsiElementPointer<XmlTag>)SmartPointerManager.getInstance((Project)extensionPointTag.getProject()).createSmartPsiElementPointer((PsiElement)extensionPointTag), epName, attrName, tagName, beanClassName));
        }
    }

    @Nullable
    private static String getEPName(XmlTag tag) {
        DomElement domElement = DomUtil.getDomElement((PsiElement)tag);
        if (!(domElement instanceof ExtensionPoint)) {
            return null;
        }
        return ((ExtensionPoint)domElement).getEffectiveQualifiedName();
    }
}

