/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant.vfs;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.dummy.DummyCachingFileSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.testAssistant.vfs.TestDataGroupVirtualFile;

public class TestDataGroupFileSystem
extends DummyCachingFileSystem<VirtualFile> {
    private static final String GROUP_FILES_SEPARATOR = "33d0ee30-8c8f-11e7-bb31-be2e44b06b34";
    private static final String PROTOCOL = "testdata";

    public TestDataGroupFileSystem() {
        super(PROTOCOL);
    }

    public static TestDataGroupFileSystem getTestDataGroupFileSystem() {
        return (TestDataGroupFileSystem)VirtualFileManager.getInstance().getFileSystem(PROTOCOL);
    }

    public static String getPath(VirtualFile beforeFile, VirtualFile afterFile) {
        return beforeFile.getPath() + GROUP_FILES_SEPARATOR + afterFile.getPath();
    }

    @NotNull
    public String extractPresentableUrl(@NotNull String path) {
        String[] parts;
        if (path == null) {
            TestDataGroupFileSystem.$$$reportNull$$$0(0);
        }
        if ((parts = path.split(GROUP_FILES_SEPARATOR)).length != 2) {
            String string = super.extractPresentableUrl(path);
            if (string == null) {
                TestDataGroupFileSystem.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = FileUtil.getLocationRelativeToUserHome((String)parts[0]) + "\n" + FileUtil.getLocationRelativeToUserHome((String)parts[1]);
        if (string == null) {
            TestDataGroupFileSystem.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected VirtualFile findFileByPathInner(@NotNull String path) {
        String[] parts;
        if (path == null) {
            TestDataGroupFileSystem.$$$reportNull$$$0(3);
        }
        if ((parts = path.split(GROUP_FILES_SEPARATOR)).length != 2) {
            return null;
        }
        String beforePath = parts[0];
        String afterPath = parts[1];
        if (StringUtil.isEmpty((String)beforePath) || StringUtil.isEmpty((String)afterPath)) {
            return null;
        }
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        VirtualFile beforeFile = localFileSystem.refreshAndFindFileByPath(beforePath);
        VirtualFile afterFile = localFileSystem.refreshAndFindFileByPath(afterPath);
        if (beforeFile == null || afterFile == null) {
            return null;
        }
        return new TestDataGroupVirtualFile(beforeFile, afterFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/testAssistant/vfs/TestDataGroupFileSystem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/testAssistant/vfs/TestDataGroupFileSystem";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPresentableUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractPresentableUrl";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPathInner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

