/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.execution.testDiscovery.TestDiscoveryProducer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TestDataGuessByTestDiscoveryUtil {
    public static final String COMMUNITY_PREFIX = "/community";
    private static final Logger LOG = Logger.getInstance(TestDataGuessByTestDiscoveryUtil.class);

    @NotNull
    static List<String> collectTestDataByExistingFiles(@NotNull PsiMethod method) {
        ArrayList<String> arrayList;
        if (method == null) {
            TestDataGuessByTestDiscoveryUtil.$$$reportNull$$$0(0);
        }
        if (!Registry.is((String)"testDiscovery.enabled") && !ApplicationManager.getApplication().isInternal()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                TestDataGuessByTestDiscoveryUtil.$$$reportNull$$$0(1);
            }
            return list;
        }
        PsiClass testClass = method.getContainingClass();
        if (testClass == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                TestDataGuessByTestDiscoveryUtil.$$$reportNull$$$0(2);
            }
            return list;
        }
        String testClassQualifiedName = testClass.getQualifiedName();
        if (testClassQualifiedName == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                TestDataGuessByTestDiscoveryUtil.$$$reportNull$$$0(3);
            }
            return list;
        }
        List<String> testQName = Collections.singletonList(testClassQualifiedName + "." + method.getName());
        try {
            ArrayList<String> testData = new ArrayList<String>();
            Project project = method.getProject();
            String basePath = project.getBasePath();
            TestDiscoveryProducer.consumeAffectedPaths((Project)project, testQName, path -> {
                String fullPath = basePath + path;
                if (FileUtil.exists((String)fullPath)) {
                    testData.add(fullPath);
                    return;
                }
                path = StringUtil.trimStart((String)path, (String)COMMUNITY_PREFIX);
                fullPath = basePath + path;
                if (FileUtil.exists((String)fullPath)) {
                    testData.add(fullPath);
                }
            }, (byte)0);
            arrayList = testData;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            List<String> list = Collections.emptyList();
            if (list == null) {
                TestDataGuessByTestDiscoveryUtil.$$$reportNull$$$0(5);
            }
            return list;
        }
        if (arrayList == null) {
            TestDataGuessByTestDiscoveryUtil.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByTestDiscoveryUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByTestDiscoveryUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTestDataByExistingFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectTestDataByExistingFiles";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

