/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import com.intellij.util.xml.reflect.DomGenericInfo;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.With;
import org.jetbrains.idea.devkit.dom.impl.PluginPsiClassConverter;
import org.jetbrains.idea.devkit.inspections.MoveRegistrationQuickFix;
import org.jetbrains.idea.devkit.util.PsiUtil;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000N\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a$\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u001a.\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u001a \u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a$\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u001a\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00020\u0011H\u0002\u001a\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0015\u001a\u00020\u0011H\u0002\u001a\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\u0019H\u0002\u001a\u0010\u0010\u001a\u001a\u00020\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0011\u001a\u0012\u0010\u001b\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u00a8\u0006\u001c"}, d2={"checkProperModule", "", "extensionPoint", "Lorg/jetbrains/idea/devkit/dom/ExtensionPoint;", "holder", "Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;", "ignoreClassList", "", "", "checkProperXmlFileForClass", "", "element", "Lcom/intellij/util/xml/DomElement;", "psiClass", "Lcom/intellij/psi/PsiClass;", "checkProperXmlFileForDefinition", "definingModule", "Lcom/intellij/openapi/module/Module;", "checkProperXmlFileForExtension", "Lorg/jetbrains/idea/devkit/dom/Extension;", "findMatchingImplModule", "module", "findModulePluginXmlFile", "Lcom/intellij/psi/xml/XmlFile;", "getRegisteringModule", "Lcom/intellij/psi/PsiElement;", "isIdeaPlatformModule", "shouldCheckExtensionPointClassAttribute", "intellij.devkit"})
@JvmName(name="ComponentModuleRegistrationChecker")
public final class ComponentModuleRegistrationChecker {
    /*
     * WARNING - void declaration
     */
    public static final void checkProperModule(@NotNull ExtensionPoint extensionPoint, @NotNull DomElementAnnotationHolder holder, @NotNull List<String> ignoreClassList) {
        block5: {
            void epRegistration;
            Module module;
            Intrinsics.checkParameterIsNotNull((Object)extensionPoint, (String)"extensionPoint");
            Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
            Intrinsics.checkParameterIsNotNull(ignoreClassList, (String)"ignoreClassList");
            GenericAttributeValue<PsiClass> genericAttributeValue = extensionPoint.getInterface();
            Intrinsics.checkExpressionValueIsNotNull(genericAttributeValue, (String)"extensionPoint.`interface`");
            PsiClass interfacePsiClass = (PsiClass)genericAttributeValue.getValue();
            if (ComponentModuleRegistrationChecker.shouldCheckExtensionPointClassAttribute(interfacePsiClass) && ComponentModuleRegistrationChecker.checkProperXmlFileForClass(extensionPoint, holder, interfacePsiClass, ignoreClassList)) {
                return;
            }
            GenericAttributeValue<PsiClass> genericAttributeValue2 = extensionPoint.getBeanClass();
            Intrinsics.checkExpressionValueIsNotNull(genericAttributeValue2, (String)"extensionPoint.beanClass");
            PsiClass beanClassPsiClass = (PsiClass)genericAttributeValue2.getValue();
            if (ComponentModuleRegistrationChecker.shouldCheckExtensionPointClassAttribute(beanClassPsiClass) && ComponentModuleRegistrationChecker.checkProperXmlFileForClass(extensionPoint, holder, beanClassPsiClass, ignoreClassList)) {
                return;
            }
            for (With withElement : extensionPoint.getWithElements()) {
                DomElement domElement = extensionPoint;
                With with = withElement;
                Intrinsics.checkExpressionValueIsNotNull((Object)with, (String)"withElement");
                GenericAttributeValue<PsiClass> genericAttributeValue3 = with.getImplements();
                Intrinsics.checkExpressionValueIsNotNull(genericAttributeValue3, (String)"withElement.implements");
                if (!ComponentModuleRegistrationChecker.checkProperXmlFileForClass(domElement, holder, (PsiClass)genericAttributeValue3.getValue(), ignoreClassList)) continue;
                return;
            }
            String string = extensionPoint.getEffectiveQualifiedName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"extensionPoint.effectiveQualifiedName");
            String shortName = StringsKt.substringAfterLast$default((String)string, (char)'.', null, (int)2, null);
            Module module2 = module = extensionPoint.getModule();
            if (module2 == null) {
                Intrinsics.throwNpe();
            }
            Project project = module2.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module!!.project");
            Project project2 = project;
            PsiSearchHelper psiSearchHelper = PsiSearchHelper.getInstance((Project)project2);
            Intrinsics.checkExpressionValueIsNotNull((Object)psiSearchHelper, (String)"PsiSearchHelper.getInstance(project)");
            PsiSearchHelper psiSearchHelper2 = psiSearchHelper;
            GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)project2);
            Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"GlobalSearchScope.projectScope(project)");
            GlobalSearchScope scope = globalSearchScope;
            if (psiSearchHelper2.isCheapEnoughToSearch(shortName, scope, null, null) != PsiSearchHelper.SearchCostResult.FEW_OCCURRENCES) break block5;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            psiSearchHelper2.processElementsWithWord(new TextOccurenceProcessor((Ref.ObjectRef)epRegistration){
                final /* synthetic */ Ref.ObjectRef $epRegistration;

                public final boolean execute(@NotNull PsiElement element, int $noName_1) {
                    Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                    this.$epRegistration.element = ComponentModuleRegistrationChecker.access$getRegisteringModule(element);
                    return (Module)this.$epRegistration.element == null;
                }
                {
                    this.$epRegistration = objectRef;
                }
            }, (SearchScope)scope, shortName, (short)4, true, false);
            Module module3 = (Module)epRegistration.element;
            if (module3 != null) {
                Module module4;
                Module it = module4 = module3;
                ComponentModuleRegistrationChecker.checkProperXmlFileForDefinition(extensionPoint, holder, it);
            }
        }
    }

    private static final Module getRegisteringModule(PsiElement element) {
        PsiClassType psiClassType;
        PsiField psiField = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class);
        if (psiField == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiField, (String)"PsiTreeUtil.getParentOfT\u2026lass.java) ?: return null");
        PsiField epName = psiField;
        PsiType psiType = epName.getType();
        if (!(psiType instanceof PsiClassType)) {
            psiType = null;
        }
        if ((psiClassType = (PsiClassType)psiType) == null || (psiClassType = psiClassType.resolve()) == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClassType, (String)"(epName.type as? PsiClas\u2026.resolve() ?: return null");
        PsiClassType psiClass = psiClassType;
        if (Intrinsics.areEqual((Object)psiClass.getQualifiedName(), (Object)"com.intellij.openapi.extensions.ExtensionPointName")) {
            return ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)epName));
        }
        return null;
    }

    public static final void checkProperXmlFileForExtension(@NotNull Extension element, @NotNull DomElementAnnotationHolder holder, @NotNull List<String> ignoreClassList) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull(ignoreClassList, (String)"ignoreClassList");
        DomGenericInfo domGenericInfo = element.getGenericInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)domGenericInfo, (String)"element.genericInfo");
        Iterator iterator = domGenericInfo.getAttributeChildrenDescriptions().iterator();
        while (iterator.hasNext()) {
            PsiClass psiClass;
            GenericAttributeValue attributeValue;
            DomAttributeChildDescription attributeDescription;
            DomAttributeChildDescription domAttributeChildDescription = attributeDescription = (DomAttributeChildDescription)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)domAttributeChildDescription, (String)"attributeDescription");
            String attributeName = domAttributeChildDescription.getName();
            if (Intrinsics.areEqual((Object)attributeName, (Object)"interfaceClass") || Intrinsics.areEqual((Object)attributeName, (Object)"serviceInterface") || Intrinsics.areEqual((Object)attributeName, (Object)"forClass") || (attributeValue = attributeDescription.getDomAttributeValue((DomElement)element)) == null || !DomUtil.hasXml((DomElement)((DomElement)attributeValue)) || !(attributeValue.getConverter() instanceof PluginPsiClassConverter)) continue;
            if ((PsiClass)attributeValue.getValue() == null) {
                continue;
            }
            if (!ComponentModuleRegistrationChecker.checkProperXmlFileForClass(element, holder, psiClass, ignoreClassList)) continue;
            return;
        }
        DomGenericInfo domGenericInfo2 = element.getGenericInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)domGenericInfo2, (String)"element.genericInfo");
        for (DomFixedChildDescription childDescription : domGenericInfo2.getFixedChildrenDescriptions()) {
            Project project;
            XmlTag tag;
            DomElement domElement;
            List list = childDescription.getValues((DomElement)element);
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"childDescription.getValues(element)");
            if ((DomElement)CollectionsKt.firstOrNull((List)list) == null) {
                continue;
            }
            if (domElement.getXmlTag() == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)tag, (String)"domElement.xmlTag ?: continue");
            Intrinsics.checkExpressionValueIsNotNull((Object)tag.getProject(), (String)"tag.project");
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
            XmlTagValue xmlTagValue = tag.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)xmlTagValue, (String)"tag.value");
            PsiClass psiClass = javaPsiFacade.findClass(xmlTagValue.getText(), GlobalSearchScope.projectScope((Project)project));
            if (psiClass == null || !ComponentModuleRegistrationChecker.checkProperXmlFileForClass(element, holder, psiClass, ignoreClassList)) continue;
            return;
        }
    }

    private static final boolean shouldCheckExtensionPointClassAttribute(PsiClass psiClass) {
        PsiField[] psiFieldArray = psiClass;
        if (psiClass != null && (psiFieldArray = psiFieldArray.getFields()) != null) {
            PsiField[] $receiver$iv;
            PsiField[] psiFieldArray2 = $receiver$iv = psiFieldArray;
            int n = psiFieldArray2.length;
            for (int i = 0; i < n; ++i) {
                PsiField element$iv;
                PsiField field = element$iv = psiFieldArray2[i];
                String string = ExtensionPointName.class.getCanonicalName();
                PsiField psiField = field;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiField, (String)"field");
                if (!TypeUtils.typeEquals((String)string, (PsiType)psiField.getType())) continue;
                return true;
            }
        }
        return false;
    }

    public static final boolean checkProperXmlFileForClass(@NotNull DomElement element, @NotNull DomElementAnnotationHolder holder, @Nullable PsiClass psiClass, @NotNull List<String> ignoreClassList) {
        PsiClass psiClass2;
        PsiClass it;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull(ignoreClassList, (String)"ignoreClassList");
        PsiClass psiClass3 = psiClass;
        if (CollectionsKt.contains((Iterable)ignoreClassList, (Object)(psiClass3 != null ? psiClass3.getQualifiedName() : null))) {
            return false;
        }
        PsiClass psiClass4 = psiClass;
        if (psiClass4 == null || (psiClass4 = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)(it = (psiClass2 = psiClass4))))) == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass4, (String)"psiClass?.let { ModuleUt\u2026ent(it) } ?: return false");
        PsiClass definingModule = psiClass4;
        return ComponentModuleRegistrationChecker.checkProperXmlFileForDefinition(element, holder, (Module)definingModule);
    }

    private static final boolean checkProperXmlFileForDefinition(DomElement element, DomElementAnnotationHolder holder, Module definingModule) {
        Module implModule;
        Module definingModule2 = definingModule;
        XmlFile modulePluginXmlFile = ComponentModuleRegistrationChecker.findModulePluginXmlFile(definingModule2);
        if (modulePluginXmlFile == null && (implModule = ComponentModuleRegistrationChecker.findMatchingImplModule(definingModule2)) != null) {
            definingModule2 = implModule;
            modulePluginXmlFile = ComponentModuleRegistrationChecker.findModulePluginXmlFile(implModule);
        }
        if (modulePluginXmlFile != null && element.getModule() != definingModule2) {
            String string = "Element should be registered in " + modulePluginXmlFile.getName();
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
            String string2 = modulePluginXmlFile.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"modulePluginXmlFile.name");
            localQuickFixArray[0] = new MoveRegistrationQuickFix(definingModule2, string2);
            holder.createProblem(element, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, string, null, localQuickFixArray);
            return true;
        }
        return false;
    }

    public static final boolean isIdeaPlatformModule(@Nullable Module module) {
        VirtualFile[] contentRoots;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            return true;
        }
        if (module == null || !PsiUtil.isIdeaProject(module.getProject())) {
            return false;
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
        VirtualFile[] virtualFileArray = moduleRootManager.getContentRoots();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"ModuleRootManager.getInstance(module).contentRoots");
        VirtualFile[] virtualFileArray2 = contentRoots = virtualFileArray;
        if (virtualFileArray2.length == 0) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)contentRoots[0], (String)"contentRoots[0]");
        for (VirtualFile parent = (v33126).getParent(); parent != null; parent = parent.getParent()) {
            if (Intrinsics.areEqual((Object)parent.getName(), (Object)"plugins")) {
                return false;
            }
            if (parent.findChild(".idea") == null) continue;
            return true;
        }
        return true;
    }

    private static final Module findMatchingImplModule(Module module) {
        return ModuleManager.getInstance((Project)module.getProject()).findModuleByName(module.getName() + ".impl");
    }

    private static final XmlFile findModulePluginXmlFile(Module module) {
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
        for (VirtualFile sourceRoot : moduleRootManager.getSourceRoots()) {
            VirtualFile metaInf = sourceRoot.findChild("META-INF");
            if (metaInf == null || !metaInf.isDirectory()) continue;
            VirtualFile[] virtualFileArray = metaInf.getChildren();
            int n = virtualFileArray.length;
            for (int i = 0; i < n; ++i) {
                PsiFile psiFile;
                VirtualFile file;
                VirtualFile virtualFile = file = virtualFileArray[i];
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file");
                String string = virtualFile.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
                if (!StringsKt.endsWith$default((String)string, (String)"Plugin.xml", (boolean)false, (int)2, null) || !((psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(file)) instanceof XmlFile)) continue;
                return (XmlFile)psiFile;
            }
        }
        return null;
    }

    @Nullable
    public static final /* synthetic */ XmlFile access$findModulePluginXmlFile(@NotNull Module module) {
        return ComponentModuleRegistrationChecker.findModulePluginXmlFile(module);
    }

    @Nullable
    public static final /* synthetic */ Module access$getRegisteringModule(@NotNull PsiElement element) {
        return ComponentModuleRegistrationChecker.getRegisteringModule(element);
    }
}

