/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.build;

import com.intellij.compiler.server.CompileServerPlugin;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.make.ManifestBuilder;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PathUtil;
import com.intellij.util.io.ZipUtil;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.build.PluginBuildConfiguration;
import org.jetbrains.idea.devkit.build.PluginBuildUtil;
import org.jetbrains.idea.devkit.dom.Extensions;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.module.PluginModuleType;

public class PrepareToDeployAction
extends AnAction {
    @NonNls
    private static final String ZIP_EXTENSION = ".zip";
    @NonNls
    private static final String JAR_EXTENSION = ".jar";
    @NonNls
    private static final String TEMP_PREFIX = "temp";
    @NonNls
    private static final String MIDDLE_LIB_DIR = "lib";
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.balloonGroup((String)"Plugin DevKit Deployment");

    public void actionPerformed(@NotNull AnActionEvent e) {
        Module module;
        if (e == null) {
            PrepareToDeployAction.$$$reportNull$$$0(0);
        }
        if ((module = (Module)LangDataKeys.MODULE.getData(e.getDataContext())) != null && PluginModuleType.isOfType(module)) {
            this.doPrepare(Arrays.asList(module), e.getProject());
        }
    }

    public void doPrepare(final List<Module> pluginModules, final Project project) {
        final ArrayList errorMessages = new ArrayList();
        final ArrayList successMessages = new ArrayList();
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
        compilerManager.make(compilerManager.createModulesCompileScope(pluginModules.toArray(Module.EMPTY_ARRAY), true), new CompileStatusNotification(){

            public void finished(boolean aborted, int errors, int warnings, @NotNull CompileContext compileContext) {
                if (compileContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (aborted || errors != 0) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    for (Object aModule : pluginModules) {
                        if (PrepareToDeployAction.doPrepare((Module)aModule, errorMessages, successMessages)) continue;
                        return;
                    }
                    if (!errorMessages.isEmpty()) {
                        Messages.showErrorDialog((String)((String)errorMessages.iterator().next()), (String)DevKitBundle.message("error.occurred", new Object[0]));
                    } else if (!successMessages.isEmpty()) {
                        StringBuilder messageBuf = new StringBuilder();
                        for (String message : successMessages) {
                            if (messageBuf.length() != 0) {
                                messageBuf.append('\n');
                            }
                            messageBuf.append(message);
                        }
                        String title = pluginModules.size() == 1 ? DevKitBundle.message("success.deployment.message", ((Module)pluginModules.get(0)).getName()) : DevKitBundle.message("success.deployment.message.all", new Object[0]);
                        NOTIFICATION_GROUP.createNotification(title, messageBuf.toString(), NotificationType.INFORMATION, null).notify(project);
                    }
                }, project.getDisposed());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compileContext", "org/jetbrains/idea/devkit/build/PrepareToDeployAction$1", "finished"));
            }
        });
    }

    public static boolean doPrepare(Module module, List<? super String> errorMessages, List<? super String> successMessages) {
        String pluginName = module.getName();
        String defaultPath = new File(module.getModuleFilePath()).getParent() + File.separator + pluginName;
        HashSet<Module> modules = new HashSet<Module>();
        PluginBuildUtil.getDependencies(module, modules);
        modules.add(module);
        HashSet libs = new HashSet();
        for (Module dep : modules) {
            PluginBuildUtil.getLibraries(dep, libs);
        }
        Map<Module, String> jpsModules = PrepareToDeployAction.collectJpsPluginModules(module);
        modules.removeAll(jpsModules.keySet());
        boolean isZip = !libs.isEmpty() || !jpsModules.isEmpty();
        String oldPath = defaultPath + (isZip ? JAR_EXTENSION : ZIP_EXTENSION);
        File oldFile = new File(oldPath);
        if (oldFile.exists() && Messages.showYesNoDialog((Project)module.getProject(), (String)DevKitBundle.message("suggest.to.delete", oldPath), (String)DevKitBundle.message("info.message", new Object[0]), (Icon)Messages.getInformationIcon()) == 0) {
            FileUtil.delete((File)oldFile);
        }
        String dstPath = defaultPath + (isZip ? ZIP_EXTENSION : JAR_EXTENSION);
        File dstFile = new File(dstPath);
        return PrepareToDeployAction.clearReadOnly(module.getProject(), dstFile) && ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            if (progressIndicator != null) {
                progressIndicator.setText(DevKitBundle.message("prepare.for.deployment.common", new Object[0]));
                progressIndicator.setIndeterminate(true);
            }
            try {
                File jarFile = PrepareToDeployAction.preparePluginsJar(module, modules);
                if (isZip) {
                    PrepareToDeployAction.processLibrariesAndJpsPlugins(jarFile, dstFile, pluginName, libs, jpsModules, progressIndicator);
                } else {
                    FileUtil.copy((File)jarFile, (File)dstFile);
                }
                LocalFileSystem.getInstance().refreshIoFiles(Collections.singleton(dstFile), true, false, null);
                successMessages.add(DevKitBundle.message("saved.message", isZip ? 1 : 2, pluginName, dstPath));
            }
            catch (IOException e) {
                errorMessages.add(e.getMessage() + "\n(" + dstPath + ")");
            }
        }, DevKitBundle.message("prepare.for.deployment", pluginName), true, module.getProject());
    }

    @NotNull
    private static Map<Module, String> collectJpsPluginModules(@NotNull Module module) {
        XmlFile pluginXml;
        if (module == null) {
            PrepareToDeployAction.$$$reportNull$$$0(1);
        }
        if ((pluginXml = PluginModuleType.getPluginXml(module)) == null) {
            Map<Module, String> map = Collections.emptyMap();
            if (map == null) {
                PrepareToDeployAction.$$$reportNull$$$0(2);
            }
            return map;
        }
        DomFileElement fileElement = DomManager.getDomManager((Project)module.getProject()).getFileElement(pluginXml, IdeaPlugin.class);
        if (fileElement == null) {
            Map<Module, String> map = Collections.emptyMap();
            if (map == null) {
                PrepareToDeployAction.$$$reportNull$$$0(3);
            }
            return map;
        }
        HashMap<Module, String> jpsPluginToOutputPath = new HashMap<Module, String>();
        IdeaPlugin plugin = (IdeaPlugin)fileElement.getRootElement();
        List<Extensions> extensions = plugin.getExtensions();
        for (Extensions extensionGroup : extensions) {
            XmlTag extensionsTag = extensionGroup.getXmlTag();
            String defaultExtensionNs = extensionsTag.getAttributeValue("defaultExtensionNs");
            for (XmlTag tag : extensionsTag.getSubTags()) {
                String classpath;
                String qualifiedName;
                String name = tag.getLocalName();
                String string = qualifiedName = defaultExtensionNs != null ? defaultExtensionNs + "." + name : name;
                if (!CompileServerPlugin.EP_NAME.getName().equals(qualifiedName) || (classpath = tag.getAttributeValue("classpath")) == null) continue;
                for (String path : StringUtil.split((String)classpath, (String)";")) {
                    String moduleName = FileUtil.getNameWithoutExtension((String)PathUtil.getFileName((String)path));
                    Module jpsModule = ModuleManager.getInstance((Project)module.getProject()).findModuleByName(moduleName);
                    if (jpsModule == null) continue;
                    jpsPluginToOutputPath.put(jpsModule, path);
                }
            }
        }
        HashMap<Module, String> hashMap = jpsPluginToOutputPath;
        if (hashMap == null) {
            PrepareToDeployAction.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    private static boolean clearReadOnly(Project project, File dstFile) {
        URL url;
        try {
            url = dstFile.toURL();
        }
        catch (MalformedURLException e) {
            return true;
        }
        VirtualFile vfile = VfsUtil.findFileByURL((URL)url);
        return vfile == null || !ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(new VirtualFile[]{vfile}).hasReadonlyFiles();
    }

    private static FileFilter createFilter(ProgressIndicator progressIndicator, @Nullable FileTypeManager fileTypeManager) {
        return pathName -> {
            if (progressIndicator != null) {
                progressIndicator.setText2("");
            }
            return fileTypeManager == null || !fileTypeManager.isFileIgnored(FileUtil.toSystemIndependentName((String)pathName.getName()));
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processLibrariesAndJpsPlugins(File jarFile, File zipFile, String pluginName, Set<? extends Library> libs, Map<Module, String> jpsModules, ProgressIndicator progressIndicator) throws IOException {
        if (FileUtil.ensureCanCreateFile((File)zipFile)) {
            try (ZipOutputStream zos = null;){
                zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));
                PrepareToDeployAction.addStructure(pluginName, zos);
                PrepareToDeployAction.addStructure(pluginName + "/" + MIDDLE_LIB_DIR, zos);
                String entryName = pluginName + JAR_EXTENSION;
                ZipUtil.addFileToZip((ZipOutputStream)zos, (File)jarFile, (String)PrepareToDeployAction.getZipPath(pluginName, entryName), new HashSet(), (FileFilter)PrepareToDeployAction.createFilter(progressIndicator, FileTypeManager.getInstance()));
                for (Map.Entry<Module, String> entry : jpsModules.entrySet()) {
                    File jpsPluginJar = PrepareToDeployAction.jarModulesOutput(Collections.singleton(entry.getKey()), null, null);
                    ZipUtil.addFileToZip((ZipOutputStream)zos, (File)jpsPluginJar, (String)PrepareToDeployAction.getZipPath(pluginName, entry.getValue()), null, null);
                }
                HashSet<String> usedJarNames = new HashSet<String>();
                usedJarNames.add(entryName);
                HashSet<VirtualFile> jarredVirtualFiles = new HashSet<VirtualFile>();
                for (Library library : libs) {
                    VirtualFile[] files;
                    for (VirtualFile virtualFile : files = library.getFiles(OrderRootType.CLASSES)) {
                        if (!jarredVirtualFiles.add(virtualFile)) continue;
                        if (virtualFile.getFileSystem() instanceof JarFileSystem) {
                            PrepareToDeployAction.addLibraryJar(virtualFile, zipFile, pluginName, zos, usedJarNames, progressIndicator);
                            continue;
                        }
                        PrepareToDeployAction.makeAndAddLibraryJar(virtualFile, zipFile, pluginName, zos, usedJarNames, progressIndicator, library.getName());
                    }
                }
            }
        }
    }

    private static String getZipPath(String pluginName, String entryName) {
        return "/" + pluginName + "/" + MIDDLE_LIB_DIR + "/" + entryName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void makeAndAddLibraryJar(VirtualFile virtualFile, File zipFile, String pluginName, ZipOutputStream zos, Set<? super String> usedJarNames, ProgressIndicator progressIndicator, String preferredName) throws IOException {
        File libraryJar = FileUtil.createTempFile((String)TEMP_PREFIX, (String)JAR_EXTENSION);
        libraryJar.deleteOnExit();
        try (ZipOutputStream jar = null;){
            jar = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(libraryJar)));
            ZipUtil.addFileOrDirRecursively((ZipOutputStream)jar, (File)libraryJar, (File)VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile), (String)"", (FileFilter)PrepareToDeployAction.createFilter(progressIndicator, FileTypeManager.getInstance()), null);
        }
        String jarName = PrepareToDeployAction.getLibraryJarName(virtualFile.getName() + JAR_EXTENSION, usedJarNames, preferredName == null ? null : preferredName + JAR_EXTENSION);
        ZipUtil.addFileOrDirRecursively((ZipOutputStream)zos, (File)zipFile, (File)libraryJar, (String)PrepareToDeployAction.getZipPath(pluginName, jarName), (FileFilter)PrepareToDeployAction.createFilter(progressIndicator, null), null);
    }

    private static String getLibraryJarName(String fileName, Set<? super String> usedJarNames, @Nullable String preferredName) {
        String uniqueName;
        if (preferredName != null && !usedJarNames.contains(preferredName)) {
            uniqueName = preferredName;
        } else {
            uniqueName = fileName;
            if (usedJarNames.contains(uniqueName)) {
                int dotPos = uniqueName.lastIndexOf(".");
                String name = dotPos < 0 ? uniqueName : uniqueName.substring(0, dotPos);
                String ext = dotPos < 0 ? "" : uniqueName.substring(dotPos);
                int i = 0;
                while (usedJarNames.contains(uniqueName = name + ++i + ext)) {
                }
            }
        }
        usedJarNames.add(uniqueName);
        return uniqueName;
    }

    private static void addLibraryJar(VirtualFile virtualFile, File zipFile, String pluginName, ZipOutputStream zos, Set<? super String> usedJarNames, ProgressIndicator progressIndicator) throws IOException {
        File ioFile = VfsUtil.virtualToIoFile((VirtualFile)virtualFile);
        String jarName = PrepareToDeployAction.getLibraryJarName(ioFile.getName(), usedJarNames, null);
        ZipUtil.addFileOrDirRecursively((ZipOutputStream)zos, (File)zipFile, (File)ioFile, (String)PrepareToDeployAction.getZipPath(pluginName, jarName), (FileFilter)PrepareToDeployAction.createFilter(progressIndicator, null), null);
    }

    private static void addStructure(@NonNls String relativePath, ZipOutputStream zos) throws IOException {
        ZipEntry e = new ZipEntry(relativePath + "/");
        e.setMethod(0);
        e.setSize(0L);
        e.setCrc(0L);
        zos.putNextEntry(e);
        zos.closeEntry();
    }

    private static File preparePluginsJar(Module module, HashSet<? extends Module> modules) throws IOException {
        PluginBuildConfiguration pluginModuleBuildProperties = PluginBuildConfiguration.getInstance(module);
        Manifest manifest = PrepareToDeployAction.createOrFindManifest(pluginModuleBuildProperties);
        return PrepareToDeployAction.jarModulesOutput(modules, manifest, pluginModuleBuildProperties.getPluginXmlPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File jarModulesOutput(@NotNull Set<? extends Module> modules, @Nullable Manifest manifest, @Nullable String pluginXmlPath) throws IOException {
        if (modules == null) {
            PrepareToDeployAction.$$$reportNull$$$0(5);
        }
        File jarFile = FileUtil.createTempFile((String)TEMP_PREFIX, (String)JAR_EXTENSION);
        jarFile.deleteOnExit();
        try (ZipOutputStream jarPlugin = null;){
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(jarFile));
            jarPlugin = manifest != null ? new JarOutputStream((OutputStream)out, manifest) : new JarOutputStream(out);
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            HashSet writtenItemRelativePaths = new HashSet();
            for (Module module : modules) {
                VirtualFile compilerOutputPath = CompilerModuleExtension.getInstance((Module)module).getCompilerOutputPath();
                if (compilerOutputPath == null) continue;
                ZipUtil.addDirToZipRecursively((ZipOutputStream)jarPlugin, (File)jarFile, (File)new File(compilerOutputPath.getPath()), (String)"", (FileFilter)PrepareToDeployAction.createFilter(progressIndicator, FileTypeManager.getInstance()), writtenItemRelativePaths);
            }
            if (pluginXmlPath != null) {
                ZipUtil.addFileToZip((ZipOutputStream)jarPlugin, (File)new File(pluginXmlPath), (String)"/META-INF/plugin.xml", writtenItemRelativePaths, (FileFilter)PrepareToDeployAction.createFilter(progressIndicator, null));
            }
        }
        return jarFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manifest createOrFindManifest(PluginBuildConfiguration pluginModuleBuildProperties) throws IOException {
        Manifest manifest = new Manifest();
        VirtualFile vManifest = pluginModuleBuildProperties.getManifest();
        if (pluginModuleBuildProperties.isUseUserManifest() && vManifest != null) {
            try (BufferedInputStream in = null;){
                in = new BufferedInputStream(vManifest.getInputStream());
                manifest.read(in);
            }
        } else {
            Attributes mainAttributes = manifest.getMainAttributes();
            ManifestBuilder.setGlobalAttributes((Attributes)mainAttributes);
        }
        return manifest;
    }

    public void update(@NotNull AnActionEvent e) {
        Module module;
        if (e == null) {
            PrepareToDeployAction.$$$reportNull$$$0(6);
        }
        boolean enabled = (module = (Module)LangDataKeys.MODULE.getData(e.getDataContext())) != null && PluginModuleType.isOfType(module);
        e.getPresentation().setVisible(enabled);
        e.getPresentation().setEnabled(enabled);
        if (enabled) {
            e.getPresentation().setText(DevKitBundle.message("prepare.for.deployment", module.getName()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/build/PrepareToDeployAction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/build/PrepareToDeployAction";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectJpsPluginModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "collectJpsPluginModules";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "jarModulesOutput";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

