/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.ModuleRenamingHistoryState;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainText;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.JdomKt;
import com.intellij.util.Processor;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.actions.MigrateModuleNamesInSourcesAction;
import org.jetbrains.idea.devkit.actions.MigrateModuleNamesInSourcesActionKt;
import org.jetbrains.idea.devkit.actions.ModuleNameUsageTarget;
import org.jetbrains.idea.devkit.util.PsiUtil;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J,\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/idea/devkit/actions/MigrateModuleNamesInSourcesAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "processOccurrences", "project", "Lcom/intellij/openapi/project/Project;", "moduleNames", "", "", "consumer", "Lcom/intellij/util/Processor;", "Lcom/intellij/usageView/UsageInfo;", "update", "intellij.devkit"})
public final class MigrateModuleNamesInSourcesAction
extends AnAction {
    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Object object;
        Iterable<Object> iterable;
        String item$iv$iv;
        Iterable destination$iv$iv;
        UsageViewPresentation usageViewPresentation;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"e.project!!");
        Project project2 = project;
        UsageViewPresentation $receiver = usageViewPresentation = new UsageViewPresentation();
        $receiver.setTabText("Occurrences of Module Names");
        $receiver.setToolwindowTitle("Occurrences of Module Names");
        $receiver.setUsagesString("occurrences of module names");
        $receiver.setUsagesWord("occurrence");
        $receiver.setCodeUsagesString("Found Occurrences");
        $receiver.setOpenInNewTab(true);
        $receiver.setCodeUsages(false);
        $receiver.setUsageTypeFilteringAvailable(true);
        UsageViewPresentation viewPresentation = usageViewPresentation;
        UsageViewPresentation $receiver2 = $receiver = new FindUsagesProcessPresentation(viewPresentation);
        $receiver2.setShowNotFoundMessage(true);
        $receiver2.setShowPanelIfOnlyOneUsage(true);
        UsageViewPresentation processPresentation = $receiver;
        try {
            HashMap hashMap;
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(VfsUtil.virtualToIoFile((VirtualFile)project2.getBaseDir()), "module-renaming-scheme.xml"));
            if (virtualFile != null) {
                UsageViewPresentation it;
                UsageViewPresentation usageViewPresentation2 = it = ($receiver2 = virtualFile);
                Intrinsics.checkExpressionValueIsNotNull((Object)usageViewPresentation2, (String)"it");
                InputStream inputStream = usageViewPresentation2.getInputStream();
                Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"it.inputStream");
                hashMap = ((ModuleRenamingHistoryState)XmlSerializer.deserialize((Element)JdomKt.loadElement((InputStream)inputStream), ModuleRenamingHistoryState.class)).oldToNewName;
            } else {
                hashMap = null;
            }
            $receiver2 = hashMap;
        }
        catch (XmlSerializationException e2) {
            MigrateModuleNamesInSourcesActionKt.access$getLOG$p().error((Throwable)e2);
            return;
        }
        UsageViewPresentation renamingScheme = $receiver2;
        Object object2 = renamingScheme;
        if (object2 == null || (object2 = object2.keySet()) == null || (object2 = CollectionsKt.toList((Iterable)((Iterable)object2))) == null) {
            void $receiver$iv$iv2;
            Module[] $receiver$iv2;
            ModuleManager moduleManager = ModuleManager.getInstance((Project)project2);
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
            Module[] moduleArray = moduleManager.getModules();
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleArray, (String)"ModuleManager.getInstance(project).modules");
            Module[] $i$a$1$let = $receiver$iv2 = moduleArray;
            destination$iv$iv = new ArrayList($receiver$iv2.length);
            void var10_11 = $receiver$iv$iv2;
            int n = ((void)var10_11).length;
            for (int i = 0; i < n; ++i) {
                void it;
                String string = item$iv$iv = var10_11[i];
                iterable = destination$iv$iv;
                void v8 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"it");
                object = v8.getName();
                iterable.add((Object)object);
            }
            object2 = (List)destination$iv$iv;
        }
        Object moduleNames = object2;
        destination$iv$iv = $receiver$iv = (Iterable)moduleNames;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv2 : $receiver$iv$iv) {
            void p1;
            item$iv$iv = (String)item$iv$iv2;
            iterable = destination$iv$iv2;
            object = new ModuleNameUsageTarget((String)p1);
            iterable.add(object);
        }
        $receiver$iv = (List)destination$iv$iv2;
        Iterable thisCollection$iv = $receiver$iv;
        ModuleNameUsageTarget[] moduleNameUsageTargetArray = thisCollection$iv.toArray(new ModuleNameUsageTarget[0]);
        if (moduleNameUsageTargetArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        ModuleNameUsageTarget[] targets = moduleNameUsageTargetArray;
        Factory searcherFactory2 = (Factory)new Factory<UsageSearcher>(this, project2, (List)moduleNames){
            final /* synthetic */ MigrateModuleNamesInSourcesAction this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ List $moduleNames;

            @NotNull
            public final UsageSearcher create() {
                HashSet<E> processed = new HashSet<E>();
                return new UsageSearcher(this, processed){
                    final /* synthetic */ actionPerformed.searcherFactory.1 this$0;
                    final /* synthetic */ HashSet $processed;

                    public final void generate(@NotNull Processor<Usage> consumer) {
                        Intrinsics.checkParameterIsNotNull(consumer, (String)"consumer");
                        Processor usageInfoConsumer2 = (Processor)new Processor<UsageInfo>(this, consumer){
                            final /* synthetic */ actionPerformed.searcherFactory.1 this$0;
                            final /* synthetic */ Processor $consumer;

                            public final boolean process(UsageInfo it) {
                                HashSet hashSet = this.this$0.$processed;
                                UsageInfo usageInfo = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)usageInfo, (String)"it");
                                VirtualFile virtualFile = usageInfo.getVirtualFile();
                                if (virtualFile == null) {
                                    Intrinsics.throwNpe();
                                }
                                Segment segment = it.getNavigationRange();
                                if (segment == null) {
                                    Intrinsics.throwNpe();
                                }
                                return hashSet.add(new Pair((Object)virtualFile, (Object)segment.getStartOffset())) ? this.$consumer.process((Object)new UsageInfo2UsageAdapter(it)) : true;
                            }
                            {
                                this.this$0 = var1_1;
                                this.$consumer = processor;
                            }
                        };
                        MigrateModuleNamesInSourcesAction.access$processOccurrences(this.this$0.this$0, this.this$0.$project, this.this$0.$moduleNames, usageInfoConsumer2);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$processed = hashSet;
                    }
                };
            }
            {
                this.this$0 = migrateModuleNamesInSourcesAction;
                this.$project = project;
                this.$moduleNames = list;
            }
        };
        UsageViewManager.UsageViewStateListener listener2 = new UsageViewManager.UsageViewStateListener((HashMap)renamingScheme){
            final /* synthetic */ HashMap $renamingScheme;

            public void usageViewCreated(@NotNull UsageView usageView) {
                Intrinsics.checkParameterIsNotNull((Object)usageView, (String)"usageView");
                if (this.$renamingScheme == null) {
                    return;
                }
                Runnable migrateOccurrences2 = new Runnable(this, usageView){
                    final /* synthetic */ actionPerformed.listener.1 this$0;
                    final /* synthetic */ UsageView $usageView;

                    /*
                     * WARNING - void declaration
                     */
                    public final void run() {
                        Object list$iv$iv;
                        Object key$iv$iv2;
                        void $receiver$iv$iv;
                        Iterable $receiver$iv;
                        Set set = this.$usageView.getUsages();
                        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"usageView.usages");
                        Set set2 = this.$usageView.getExcludedUsages();
                        Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"usageView.excludedUsages");
                        Set set3 = SetsKt.minus((Set)set, (Iterable)set2);
                        if (set3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Set<com.intellij.usages.UsageInfo2UsageAdapter>");
                        }
                        Set usages = set3;
                        Iterable iterable = $receiver$iv = (Iterable)usages;
                        Map destination$iv$iv = new LinkedHashMap<K, V>();
                        Object object = $receiver$iv$iv.iterator();
                        while (object.hasNext()) {
                            Object object2;
                            Map $receiver$iv$iv$iv = destination$iv$iv;
                            T element$iv$iv = object.next();
                            UsageInfo2UsageAdapter it = (UsageInfo2UsageAdapter)element$iv$iv;
                            key$iv$iv2 = it.getFile();
                            V value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv2);
                            if (value$iv$iv$iv == null) {
                                ArrayList<E> answer$iv$iv$iv = new ArrayList<E>();
                                $receiver$iv$iv$iv.put(key$iv$iv2, answer$iv$iv$iv);
                                object2 = answer$iv$iv$iv;
                            } else {
                                object2 = value$iv$iv$iv;
                            }
                            list$iv$iv = (List)object2;
                            list$iv$iv.add(element$iv$iv);
                        }
                        Map usagesByFile = destination$iv$iv;
                        ProgressManager progressManager = ProgressManager.getInstance();
                        Intrinsics.checkExpressionValueIsNotNull((Object)progressManager, (String)"ProgressManager.getInstance()");
                        ProgressIndicator progressIndicator = progressManager.getProgressIndicator();
                        int i = 0;
                        Map $receiver$iv2 = usagesByFile;
                        object = $receiver$iv2;
                        Iterator<Map.Entry<K, V>> iterator = object.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<K, V> element$iv;
                            Map.Entry<K, V> $file_usages = element$iv = iterator.next();
                            key$iv$iv2 = $file_usages;
                            VirtualFile file = (VirtualFile)key$iv$iv2.getKey();
                            key$iv$iv2 = $file_usages;
                            List usages2 = (List)key$iv$iv2.getValue();
                            ProgressIndicator progressIndicator2 = progressIndicator;
                            if (progressIndicator2 != null) {
                                int key$iv$iv2 = i;
                                i = key$iv$iv2 + 1;
                                progressIndicator2.setFraction((double)key$iv$iv2 / (double)usagesByFile.size());
                            }
                            try {
                                Iterable $receiver$iv3 = usages2;
                                Iterable iterable2 = $receiver$iv3;
                                list$iv$iv = new Comparator<T>(){

                                    public final int compare(T a, T b) {
                                        UsageInfo2UsageAdapter it = (UsageInfo2UsageAdapter)b;
                                        UsageInfo usageInfo = it.getUsageInfo();
                                        Intrinsics.checkExpressionValueIsNotNull((Object)usageInfo, (String)"it.usageInfo");
                                        Segment segment = usageInfo.getNavigationRange();
                                        if (segment == null) {
                                            Intrinsics.throwNpe();
                                        }
                                        it = (UsageInfo2UsageAdapter)a;
                                        Comparable comparable = Integer.valueOf(segment.getStartOffset());
                                        UsageInfo usageInfo2 = it.getUsageInfo();
                                        Intrinsics.checkExpressionValueIsNotNull((Object)usageInfo2, (String)"it.usageInfo");
                                        Segment segment2 = usageInfo2.getNavigationRange();
                                        if (segment2 == null) {
                                            Intrinsics.throwNpe();
                                        }
                                        Integer n = segment2.getStartOffset();
                                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n);
                                    }
                                };
                                $receiver$iv3 = CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)list$iv$iv);
                                for (E element$iv2 : $receiver$iv3) {
                                    Map map;
                                    void range;
                                    UsageInfo2UsageAdapter it = (UsageInfo2UsageAdapter)element$iv2;
                                    Ref.ObjectRef $i$f$groupByTo = new Ref.ObjectRef();
                                    UsageInfo usageInfo = it.getUsageInfo();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)usageInfo, (String)"it.usageInfo");
                                    if (usageInfo.getNavigationRange() == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    $i$f$groupByTo.element = $i$f$groupByTo.element;
                                    List list = CollectionsKt.listOf((Object[])new Character[]{Character.valueOf('\"'), Character.valueOf('\'')});
                                    Document document = it.getDocument();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"it.document");
                                    if (list.contains(Character.valueOf(document.getCharsSequence().charAt(((Segment)range.element).getStartOffset())))) {
                                        range.element = (Segment)new TextRange(((Segment)range.element).getStartOffset() + 1, ((Segment)range.element).getEndOffset() - 1);
                                    }
                                    Document document2 = it.getDocument();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"it.document");
                                    String oldName = ((Object)document2.getCharsSequence().subSequence(((Segment)range.element).getStartOffset(), ((Segment)range.element).getEndOffset())).toString();
                                    Map map2 = map = (Map)this.this$0.$renamingScheme;
                                    if (!map2.containsKey(oldName)) {
                                        throw (Throwable)new RuntimeException("Unknown module " + oldName);
                                    }
                                    V v = this.this$0.$renamingScheme.get(oldName);
                                    if (v == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    Intrinsics.checkExpressionValueIsNotNull(v, (String)"renamingScheme[oldName]!!");
                                    String newName = (String)v;
                                    ApplicationManager.getApplication().runWriteAction((Computable)new Computable<T>(it, (Ref.ObjectRef)range, newName){
                                        final /* synthetic */ UsageInfo2UsageAdapter $it$inlined;
                                        final /* synthetic */ Ref.ObjectRef $range$inlined;
                                        final /* synthetic */ String $newName$inlined;
                                        {
                                            this.$it$inlined = usageInfo2UsageAdapter;
                                            this.$range$inlined = objectRef;
                                            this.$newName$inlined = string;
                                        }

                                        public final T compute() {
                                            this.$it$inlined.getDocument().replaceString(((Segment)this.$range$inlined.element).getStartOffset(), ((Segment)this.$range$inlined.element).getEndOffset(), (CharSequence)this.$newName$inlined);
                                            return (T)Unit.INSTANCE;
                                        }
                                    });
                                }
                            }
                            catch (Exception e) {
                                StringBuilder stringBuilder = new StringBuilder().append("Cannot replace usage in ");
                                VirtualFile virtualFile = file;
                                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file");
                                throw (Throwable)new RuntimeException(stringBuilder.append(virtualFile.getPresentableUrl()).append(": ").append(e.getMessage()).toString(), e);
                            }
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$usageView = usageView;
                    }
                };
                usageView.addPerformOperationAction(migrateOccurrences2, "Migrate Module Name Occurrences", "Cannot migrate occurrences", "Migrate Module Name Occurrences");
            }

            public void findingUsagesFinished(@Nullable UsageView usageView) {
            }
            {
                this.$renamingScheme = $captured_local_variable$0;
            }
        };
        UsageViewManager.getInstance((Project)project2).searchAndShowUsages((UsageTarget[])targets, searcherFactory2, (FindUsagesProcessPresentation)processPresentation, viewPresentation, listener2);
    }

    /*
     * WARNING - void declaration
     */
    private final void processOccurrences(Project project, List<String> moduleNames, Processor<UsageInfo> consumer) {
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)progressManager, (String)"ProgressManager.getInstance()");
        ProgressIndicator progressIndicator = progressManager.getProgressIndicator();
        if (progressIndicator == null) {
            progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
        }
        ProgressIndicator progress = progressIndicator;
        progress.setText("Searching for module names...");
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"GlobalSearchScope.projectScope(project)");
        GlobalSearchScope scope = globalSearchScope;
        PsiSearchHelper psiSearchHelper = PsiSearchHelper.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiSearchHelper, (String)"PsiSearchHelper.getInstance(project)");
        PsiSearchHelper searchHelper = psiSearchHelper;
        processOccurrences.1 isModuleNamePart$ = processOccurrences.1.INSTANCE;
        processOccurrences.2 filter$ = processOccurrences.2.INSTANCE;
        processOccurrences.3 mayMentionModuleNames$ = processOccurrences.3.INSTANCE;
        processOccurrences.4 isBuildScript$ = processOccurrences.4.INSTANCE;
        Function3<String, String, Boolean, Unit> processCodeUsages$ = new Function3<String, String, Boolean, Unit>(consumer, scope, searchHelper){
            final /* synthetic */ Processor $consumer;
            final /* synthetic */ GlobalSearchScope $scope;
            final /* synthetic */ PsiSearchHelper $searchHelper;

            public final void invoke(@NotNull String moduleName, @NotNull String quotedString, boolean groovyOnly) {
                Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
                Intrinsics.checkParameterIsNotNull((Object)quotedString, (String)"quotedString");
                List ignoredMethods = CollectionsKt.listOf((Object[])new String[]{"getPluginHomePath(", "getPluginHome(", "getPluginHomePathRelative(", "dir(", "withProjectLibrary(", "directoryName = "});
                TextOccurenceProcessor quotedOccurrencesProcessor2 = new TextOccurenceProcessor(this, quotedString, ignoredMethods){
                    final /* synthetic */ processOccurrences.5 this$0;
                    final /* synthetic */ String $quotedString;
                    final /* synthetic */ List $ignoredMethods;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean execute(@NotNull PsiElement element, int offset) {
                        boolean bl;
                        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                        if (Intrinsics.areEqual((Object)element.getText(), (Object)this.$quotedString) ^ true) {
                            return true;
                        }
                        Iterable $receiver$iv = this.$ignoredMethods;
                        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $receiver$iv) {
                                String it = (String)element$iv;
                                TextRange textRange = element.getTextRange();
                                Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"element.textRange");
                                if (textRange.getStartOffset() > it.length()) {
                                    PsiFile psiFile = element.getContainingFile();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"element.containingFile");
                                    String string = psiFile.getText();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.containingFile.text");
                                    TextRange textRange2 = element.getTextRange();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"element.textRange");
                                    if (StringsKt.startsWith$default((String)string, (String)it, (int)(textRange2.getStartOffset() - it.length()), (boolean)false, (int)4, null)) {
                                        return true;
                                    }
                                }
                                boolean bl2 = false;
                                if (!bl2) continue;
                                return true;
                            }
                            bl = false;
                        }
                        if (!bl) return this.this$0.$consumer.process((Object)new UsageInfo(element, offset, offset + this.$quotedString.length()));
                        return true;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$quotedString = string;
                        this.$ignoredMethods = list;
                    }
                };
                GlobalSearchScope literalsScope2 = SetsKt.plus((Set)MigrateModuleNamesInSourcesActionKt.access$getRegularWordsUsedAsModuleNames$p(), (Iterable)MigrateModuleNamesInSourcesActionKt.access$getModuleNamesUsedAsIDs$p()).contains(moduleName) ? (GlobalSearchScope)processOccurrences.2.INSTANCE.invoke(this.$scope, (Function1<? super VirtualFile, Boolean>)((Function1)new Function1<VirtualFile, Boolean>(groovyOnly){
                    final /* synthetic */ boolean $groovyOnly;

                    public final boolean invoke(@NotNull VirtualFile it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        return processOccurrences.4.INSTANCE.invoke(it) && !this.$groovyOnly || CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])new String[]{"groovy", "gant"}), (Object)it.getExtension());
                    }
                    {
                        this.$groovyOnly = bl;
                        super(1);
                    }
                })) : this.$scope;
                int n = 1;
                int n2 = 4;
                String string = quotedString;
                SearchScope searchScope = (SearchScope)literalsScope2;
                TextOccurenceProcessor textOccurenceProcessor = quotedOccurrencesProcessor2;
                PsiSearchHelper psiSearchHelper = this.$searchHelper;
                short s = (short)(n | n2);
                psiSearchHelper.processElementsWithWord(textOccurenceProcessor, searchScope, string, s, true);
            }
            {
                this.$consumer = processor;
                this.$scope = globalSearchScope;
                this.$searchHelper = psiSearchHelper;
                super(3);
            }
        };
        Function2<String, String, Unit> processUsagesInStrings$ = new Function2<String, String, Unit>(consumer, searchHelper, scope){
            final /* synthetic */ Processor $consumer;
            final /* synthetic */ PsiSearchHelper $searchHelper;
            final /* synthetic */ GlobalSearchScope $scope;

            public final void invoke(@NotNull String moduleName, @NotNull String substring) {
                Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
                Intrinsics.checkParameterIsNotNull((Object)substring, (String)"substring");
                TextOccurenceProcessor quotedOccurrencesProcessor2 = new TextOccurenceProcessor(this, substring, moduleName){
                    final /* synthetic */ processOccurrences.6 this$0;
                    final /* synthetic */ String $substring;
                    final /* synthetic */ String $moduleName;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean execute(@NotNull PsiElement element, int offset) {
                        block3: {
                            String text;
                            block2: {
                                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                                text = element.getText();
                                if (text.charAt(0) != '\"') break block2;
                                String string = text;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text");
                                Character c = StringsKt.lastOrNull((CharSequence)string);
                                if (c != null && c.charValue() == '\"') break block3;
                            }
                            if (text.charAt(0) != '\'') return true;
                            String string = text;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text");
                            Character c = StringsKt.lastOrNull((CharSequence)string);
                            if (c == null) return true;
                            if (c.charValue() != '\'') return true;
                        }
                        boolean bl = this.this$0.$consumer.process((Object)new UsageInfo(element, offset + StringsKt.indexOf$default((CharSequence)this.$substring, (String)this.$moduleName, (int)0, (boolean)false, (int)6, null), offset + this.$substring.length()));
                        return bl;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$substring = string;
                        this.$moduleName = string2;
                    }
                };
                this.$searchHelper.processElementsWithWord(quotedOccurrencesProcessor2, (SearchScope)this.$scope, substring, (short)4, true);
            }
            {
                this.$consumer = processor;
                this.$searchHelper = psiSearchHelper;
                this.$scope = globalSearchScope;
                super(2);
            }
        };
        boolean bl = false;
        for (String moduleName : (Iterable)moduleNames) {
            void i;
            progress.setFraction((double)i / (double)moduleNames.size());
            progress.setText2("Searching for \"" + moduleName + '\"');
            processCodeUsages$.invoke(moduleName, '\"' + moduleName + '\"', false);
            processCodeUsages$.invoke(moduleName, '\'' + moduleName + '\'', true);
            if (Intrinsics.areEqual((Object)moduleName, (Object)"resources") ^ true) {
                processUsagesInStrings$.invoke(moduleName, "production/" + moduleName);
                processUsagesInStrings$.invoke(moduleName, "test/" + moduleName);
            }
            TextOccurenceProcessor plainOccurrencesProcessor2 = new TextOccurenceProcessor(moduleName, consumer){
                final /* synthetic */ String $moduleName;
                final /* synthetic */ Processor $consumer;

                public final boolean execute(@NotNull PsiElement element, int offset) {
                    Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                    int endOffset = offset + this.$moduleName.length();
                    return !(offset != 0 && !CharsKt.isWhitespace((char)element.getText().charAt(offset - 1)) || endOffset != element.getTextLength() && !CharsKt.isWhitespace((char)element.getText().charAt(endOffset)) || !(element instanceof PsiPlainText)) ? this.$consumer.process((Object)new UsageInfo(element, offset, endOffset)) : true;
                }
                {
                    this.$moduleName = string;
                    this.$consumer = processor;
                }
            };
            GlobalSearchScope plainTextScope2 = SetsKt.plus((Set)MigrateModuleNamesInSourcesActionKt.access$getRegularWordsUsedAsModuleNames$p(), (Iterable)MigrateModuleNamesInSourcesActionKt.access$getModuleNamesUsedAsIDs$p()).contains(moduleName) ? (GlobalSearchScope)filter$.invoke(scope, (Function1<? super VirtualFile, Boolean>)((Function1)processOccurrences.plainTextScope.1.INSTANCE)) : scope;
            searchHelper.processElementsWithWord(plainOccurrencesProcessor2, (SearchScope)plainTextScope2, moduleName, (short)16, true);
            if (!MigrateModuleNamesInSourcesActionKt.access$getRegularWordsUsedAsModuleNames$p().contains(moduleName)) {
                TextOccurenceProcessor commentsOccurrencesProcessor2 = new TextOccurenceProcessor(moduleName, consumer){
                    final /* synthetic */ String $moduleName;
                    final /* synthetic */ Processor $consumer;

                    public final boolean execute(@NotNull PsiElement element, int offset) {
                        char c;
                        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                        int endOffset = offset + this.$moduleName.length();
                        return (offset == 0 || !processOccurrences.1.INSTANCE.invoke(element.getText().charAt(offset - 1)) && element.getText().charAt(offset - 1) != '.') && (endOffset == element.getTextLength() || !processOccurrences.1.INSTANCE.invoke(element.getText().charAt(endOffset)) && element.getText().charAt(endOffset) != '/' && (endOffset >= element.getTextLength() - 2 || element.getText().charAt(endOffset) != '.' || !Character.isLetter(c = element.getText().charAt(endOffset + 1)))) && element instanceof PsiComment ? this.$consumer.process((Object)new UsageInfo(element, offset, endOffset)) : true;
                    }
                    {
                        this.$moduleName = string;
                        this.$consumer = processor;
                    }
                };
                searchHelper.processElementsWithWord(commentsOccurrencesProcessor2, (SearchScope)scope, moduleName, (short)2, true);
            }
            ++i;
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(PsiUtil.isIdeaProject(e.getProject()));
    }

    public MigrateModuleNamesInSourcesAction() {
        super("Find/Update Module Names in Sources...", "Find and migrate to the new scheme occurrences of module names in IntelliJ IDEA project sources", null);
    }

    public static final /* synthetic */ void access$processOccurrences(MigrateModuleNamesInSourcesAction $this, @NotNull Project project, @NotNull List moduleNames, @NotNull Processor consumer) {
        $this.processOccurrences(project, moduleNames, (Processor<UsageInfo>)consumer);
    }
}

