/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.config;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.impl.storage.ClasspathStorageProvider;
import java.io.IOException;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.eclipse.config.CachedXmlDocumentSet;
import org.jetbrains.idea.eclipse.config.ClasspathSaveSession;
import org.jetbrains.idea.eclipse.config.EclipseClasspathStorageProvider;
import org.jetbrains.idea.eclipse.conversion.EclipseClasspathReader;
import org.jetbrains.idea.eclipse.conversion.IdeaSpecificSettings;

public final class EclipseClasspathConverter
implements ClasspathStorageProvider.ClasspathConverter {
    private final Module module;

    public EclipseClasspathConverter(@NotNull Module module) {
        if (module == null) {
            EclipseClasspathConverter.$$$reportNull$$$0(0);
        }
        this.module = module;
    }

    @NotNull
    public List<String> getFilePaths() {
        List<String> list = this.getFileSet().getFilePaths();
        if (list == null) {
            EclipseClasspathConverter.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public ClasspathSaveSession startExternalization() {
        ClasspathSaveSession classpathSaveSession = new ClasspathSaveSession(this.module);
        if (classpathSaveSession == null) {
            EclipseClasspathConverter.$$$reportNull$$$0(2);
        }
        return classpathSaveSession;
    }

    @NotNull
    public CachedXmlDocumentSet getFileSet() {
        CachedXmlDocumentSet cachedXmlDocumentSet = EclipseClasspathStorageProvider.getFileCache(this.module);
        if (cachedXmlDocumentSet == null) {
            EclipseClasspathConverter.$$$reportNull$$$0(3);
        }
        return cachedXmlDocumentSet;
    }

    public void readClasspath(@NotNull ModifiableRootModel model) throws IOException {
        if (model == null) {
            EclipseClasspathConverter.$$$reportNull$$$0(4);
        }
        try {
            CachedXmlDocumentSet fileSet = this.getFileSet();
            String path = fileSet.getParent(".project");
            Element classpath = null;
            if (!fileSet.exists(".project")) {
                classpath = fileSet.load(".classpath", false);
                if (classpath == null) {
                    return;
                }
                path = fileSet.getParent(".classpath");
            }
            EclipseClasspathReader classpathReader = new EclipseClasspathReader(path, this.module.getProject(), null);
            classpathReader.init(model);
            if (classpath == null) {
                classpath = fileSet.load(".classpath", false);
            }
            if (classpath == null) {
                EclipseClasspathReader.setOutputUrl(model, path + "/bin");
            } else {
                classpathReader.readClasspath(model, classpath);
            }
            Element eml = fileSet.load(model.getModule().getName() + ".eml", false);
            if (eml == null) {
                ((CompilerModuleExtension)model.getModuleExtension(CompilerModuleExtension.class)).setExcludeOutput(false);
            } else {
                new IdeaSpecificSettings().readIdeaSpecific(eml, model, null, null);
            }
        }
        catch (JDOMException e) {
            throw new IOException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/eclipse/config/EclipseClasspathConverter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/eclipse/config/EclipseClasspathConverter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePaths";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "startExternalization";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readClasspath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

