"""Generated client library for serverless version v1alpha1."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.serverless.v1alpha1 import serverless_v1alpha1_messages as messages


class ServerlessV1alpha1(base_api.BaseApiClient):
  """Generated client library for service serverless version v1alpha1."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://serverless.googleapis.com/'

  _PACKAGE = u'serverless'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-platform']
  _VERSION = u'v1alpha1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = u'ServerlessV1alpha1'
  _URL_VERSION = u'v1alpha1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new serverless handle."""
    url = url or self.BASE_URL
    super(ServerlessV1alpha1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.namespaces_authorizeddomains = self.NamespacesAuthorizeddomainsService(self)
    self.namespaces_configurations = self.NamespacesConfigurationsService(self)
    self.namespaces_domainmappings = self.NamespacesDomainmappingsService(self)
    self.namespaces_revisions = self.NamespacesRevisionsService(self)
    self.namespaces_routes = self.NamespacesRoutesService(self)
    self.namespaces_services = self.NamespacesServicesService(self)
    self.namespaces = self.NamespacesService(self)
    self.projects_locations_authorizeddomains = self.ProjectsLocationsAuthorizeddomainsService(self)
    self.projects_locations_configurations = self.ProjectsLocationsConfigurationsService(self)
    self.projects_locations_domainmappings = self.ProjectsLocationsDomainmappingsService(self)
    self.projects_locations_revisions = self.ProjectsLocationsRevisionsService(self)
    self.projects_locations_routes = self.ProjectsLocationsRoutesService(self)
    self.projects_locations_services = self.ProjectsLocationsServicesService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class NamespacesAuthorizeddomainsService(base_api.BaseApiService):
    """Service class for the namespaces_authorizeddomains resource."""

    _NAME = u'namespaces_authorizeddomains'

    def __init__(self, client):
      super(ServerlessV1alpha1.NamespacesAuthorizeddomainsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""RPC to list authorized domains.

      Args:
        request: (ServerlessNamespacesAuthorizeddomainsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListAuthorizedDomainsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/domains.cloudrun.com/v1alpha1/namespaces/{namespacesId}/authorizeddomains',
        http_method=u'GET',
        method_id=u'serverless.namespaces.authorizeddomains.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'apis/domains.cloudrun.com/v1alpha1/{+parent}/authorizeddomains',
        request_field='',
        request_type_name=u'ServerlessNamespacesAuthorizeddomainsListRequest',
        response_type_name=u'ListAuthorizedDomainsResponse',
        supports_download=False,
    )

  class NamespacesConfigurationsService(base_api.BaseApiService):
    """Service class for the namespaces_configurations resource."""

    _NAME = u'namespaces_configurations'

    def __init__(self, client):
      super(ServerlessV1alpha1.NamespacesConfigurationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a configuration.

      Args:
        request: (ServerlessNamespacesConfigurationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Configuration) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/serving.knative.dev/v1alpha1/namespaces/{namespacesId}/configurations/{configurationsId}',
        http_method=u'GET',
        method_id=u'serverless.namespaces.configurations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'apis/serving.knative.dev/v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ServerlessNamespacesConfigurationsGetRequest',
        response_type_name=u'Configuration',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list configurations.

      Args:
        request: (ServerlessNamespacesConfigurationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListConfigurationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/serving.knative.dev/v1alpha1/namespaces/{namespacesId}/configurations',
        http_method=u'GET',
        method_id=u'serverless.namespaces.configurations.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'continue_', u'fieldSelector', u'includeUninitialized', u'labelSelector', u'limit', u'resourceVersion', u'watch'],
        relative_path=u'apis/serving.knative.dev/v1alpha1/{+parent}/configurations',
        request_field='',
        request_type_name=u'ServerlessNamespacesConfigurationsListRequest',
        response_type_name=u'ListConfigurationsResponse',
        supports_download=False,
    )

  class NamespacesDomainmappingsService(base_api.BaseApiService):
    """Service class for the namespaces_domainmappings resource."""

    _NAME = u'namespaces_domainmappings'

    def __init__(self, client):
      super(ServerlessV1alpha1.NamespacesDomainmappingsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new domain mapping.

      Args:
        request: (ServerlessNamespacesDomainmappingsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DomainMapping) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/domains.cloudrun.com/v1alpha1/namespaces/{namespacesId}/domainmappings',
        http_method=u'POST',
        method_id=u'serverless.namespaces.domainmappings.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'apis/domains.cloudrun.com/v1alpha1/{+parent}/domainmappings',
        request_field=u'domainMapping',
        request_type_name=u'ServerlessNamespacesDomainmappingsCreateRequest',
        response_type_name=u'DomainMapping',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a domain mapping.

      Args:
        request: (ServerlessNamespacesDomainmappingsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/domains.cloudrun.com/v1alpha1/namespaces/{namespacesId}/domainmappings/{domainmappingsId}',
        http_method=u'DELETE',
        method_id=u'serverless.namespaces.domainmappings.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'orphanDependents'],
        relative_path=u'apis/domains.cloudrun.com/v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ServerlessNamespacesDomainmappingsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a domain mapping.

      Args:
        request: (ServerlessNamespacesDomainmappingsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DomainMapping) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/domains.cloudrun.com/v1alpha1/namespaces/{namespacesId}/domainmappings/{domainmappingsId}',
        http_method=u'GET',
        method_id=u'serverless.namespaces.domainmappings.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'apis/domains.cloudrun.com/v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ServerlessNamespacesDomainmappingsGetRequest',
        response_type_name=u'DomainMapping',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list domain mappings.

      Args:
        request: (ServerlessNamespacesDomainmappingsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListDomainMappingsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/domains.cloudrun.com/v1alpha1/namespaces/{namespacesId}/domainmappings',
        http_method=u'GET',
        method_id=u'serverless.namespaces.domainmappings.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'continue_', u'fieldSelector', u'includeUninitialized', u'labelSelector', u'limit', u'resourceVersion', u'watch'],
        relative_path=u'apis/domains.cloudrun.com/v1alpha1/{+parent}/domainmappings',
        request_field='',
        request_type_name=u'ServerlessNamespacesDomainmappingsListRequest',
        response_type_name=u'ListDomainMappingsResponse',
        supports_download=False,
    )

    def ReplaceDomainMapping(self, request, global_params=None):
      r"""Rpc to replace a domain mapping.

Only the spec and metadata labels and annotations are modifiable. After
the Update request, Cloud Run will work to make the 'status'
match the requested 'spec'.

May provide metadata.resourceVersion to enforce update from last read for
optimistic concurrency control.

      Args:
        request: (ServerlessNamespacesDomainmappingsReplaceDomainMappingRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DomainMapping) The response message.
      """
      config = self.GetMethodConfig('ReplaceDomainMapping')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplaceDomainMapping.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/domains.cloudrun.com/v1alpha1/namespaces/{namespacesId}/domainmappings/{domainmappingsId}',
        http_method=u'PUT',
        method_id=u'serverless.namespaces.domainmappings.replaceDomainMapping',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'apis/domains.cloudrun.com/v1alpha1/{+name}',
        request_field=u'domainMapping',
        request_type_name=u'ServerlessNamespacesDomainmappingsReplaceDomainMappingRequest',
        response_type_name=u'DomainMapping',
        supports_download=False,
    )

  class NamespacesRevisionsService(base_api.BaseApiService):
    """Service class for the namespaces_revisions resource."""

    _NAME = u'namespaces_revisions'

    def __init__(self, client):
      super(ServerlessV1alpha1.NamespacesRevisionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a revision.

      Args:
        request: (ServerlessNamespacesRevisionsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/serving.knative.dev/v1alpha1/namespaces/{namespacesId}/revisions/{revisionsId}',
        http_method=u'DELETE',
        method_id=u'serverless.namespaces.revisions.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'orphanDependents'],
        relative_path=u'apis/serving.knative.dev/v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ServerlessNamespacesRevisionsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a revision.

      Args:
        request: (ServerlessNamespacesRevisionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Revision) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/serving.knative.dev/v1alpha1/namespaces/{namespacesId}/revisions/{revisionsId}',
        http_method=u'GET',
        method_id=u'serverless.namespaces.revisions.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'apis/serving.knative.dev/v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ServerlessNamespacesRevisionsGetRequest',
        response_type_name=u'Revision',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list revisions.

      Args:
        request: (ServerlessNamespacesRevisionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListRevisionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/serving.knative.dev/v1alpha1/namespaces/{namespacesId}/revisions',
        http_method=u'GET',
        method_id=u'serverless.namespaces.revisions.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'continue_', u'fieldSelector', u'includeUninitialized', u'labelSelector', u'limit', u'resourceVersion', u'watch'],
        relative_path=u'apis/serving.knative.dev/v1alpha1/{+parent}/revisions',
        request_field='',
        request_type_name=u'ServerlessNamespacesRevisionsListRequest',
        response_type_name=u'ListRevisionsResponse',
        supports_download=False,
    )

  class NamespacesRoutesService(base_api.BaseApiService):
    """Service class for the namespaces_routes resource."""

    _NAME = u'namespaces_routes'

    def __init__(self, client):
      super(ServerlessV1alpha1.NamespacesRoutesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a route.

      Args:
        request: (ServerlessNamespacesRoutesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Route) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/serving.knative.dev/v1alpha1/namespaces/{namespacesId}/routes/{routesId}',
        http_method=u'GET',
        method_id=u'serverless.namespaces.routes.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'apis/serving.knative.dev/v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ServerlessNamespacesRoutesGetRequest',
        response_type_name=u'Route',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list routes.

      Args:
        request: (ServerlessNamespacesRoutesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListRoutesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/serving.knative.dev/v1alpha1/namespaces/{namespacesId}/routes',
        http_method=u'GET',
        method_id=u'serverless.namespaces.routes.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'continue_', u'fieldSelector', u'includeUninitialized', u'labelSelector', u'limit', u'resourceVersion', u'watch'],
        relative_path=u'apis/serving.knative.dev/v1alpha1/{+parent}/routes',
        request_field='',
        request_type_name=u'ServerlessNamespacesRoutesListRequest',
        response_type_name=u'ListRoutesResponse',
        supports_download=False,
    )

  class NamespacesServicesService(base_api.BaseApiService):
    """Service class for the namespaces_services resource."""

    _NAME = u'namespaces_services'

    def __init__(self, client):
      super(ServerlessV1alpha1.NamespacesServicesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Rpc to create a service.

      Args:
        request: (ServerlessNamespacesServicesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Service) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/serving.knative.dev/v1alpha1/namespaces/{namespacesId}/services',
        http_method=u'POST',
        method_id=u'serverless.namespaces.services.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'apis/serving.knative.dev/v1alpha1/{+parent}/services',
        request_field=u'service',
        request_type_name=u'ServerlessNamespacesServicesCreateRequest',
        response_type_name=u'Service',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a service.
This will cause the Service to stop serving traffic and will delete the
child entities like Routes, Configurations and Revisions.

      Args:
        request: (ServerlessNamespacesServicesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/serving.knative.dev/v1alpha1/namespaces/{namespacesId}/services/{servicesId}',
        http_method=u'DELETE',
        method_id=u'serverless.namespaces.services.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'orphanDependents'],
        relative_path=u'apis/serving.knative.dev/v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ServerlessNamespacesServicesDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a service.

      Args:
        request: (ServerlessNamespacesServicesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Service) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/serving.knative.dev/v1alpha1/namespaces/{namespacesId}/services/{servicesId}',
        http_method=u'GET',
        method_id=u'serverless.namespaces.services.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'apis/serving.knative.dev/v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ServerlessNamespacesServicesGetRequest',
        response_type_name=u'Service',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list services.

      Args:
        request: (ServerlessNamespacesServicesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListServicesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/serving.knative.dev/v1alpha1/namespaces/{namespacesId}/services',
        http_method=u'GET',
        method_id=u'serverless.namespaces.services.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'continue_', u'fieldSelector', u'includeUninitialized', u'labelSelector', u'limit', u'resourceVersion', u'watch'],
        relative_path=u'apis/serving.knative.dev/v1alpha1/{+parent}/services',
        request_field='',
        request_type_name=u'ServerlessNamespacesServicesListRequest',
        response_type_name=u'ListServicesResponse',
        supports_download=False,
    )

    def ReplaceService(self, request, global_params=None):
      r"""Rpc to replace a service.

Only the spec and metadata labels and annotations are modifiable. After
the Update request, Cloud Run will work to make the 'status'
match the requested 'spec'.

May provide metadata.resourceVersion to enforce update from last read for
optimistic concurrency control.

      Args:
        request: (ServerlessNamespacesServicesReplaceServiceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Service) The response message.
      """
      config = self.GetMethodConfig('ReplaceService')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplaceService.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'apis/serving.knative.dev/v1alpha1/namespaces/{namespacesId}/services/{servicesId}',
        http_method=u'PUT',
        method_id=u'serverless.namespaces.services.replaceService',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'apis/serving.knative.dev/v1alpha1/{+name}',
        request_field=u'service',
        request_type_name=u'ServerlessNamespacesServicesReplaceServiceRequest',
        response_type_name=u'Service',
        supports_download=False,
    )

  class NamespacesService(base_api.BaseApiService):
    """Service class for the namespaces resource."""

    _NAME = u'namespaces'

    def __init__(self, client):
      super(ServerlessV1alpha1.NamespacesService, self).__init__(client)
      self._upload_configs = {
          }

  class ProjectsLocationsAuthorizeddomainsService(base_api.BaseApiService):
    """Service class for the projects_locations_authorizeddomains resource."""

    _NAME = u'projects_locations_authorizeddomains'

    def __init__(self, client):
      super(ServerlessV1alpha1.ProjectsLocationsAuthorizeddomainsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""RPC to list authorized domains.

      Args:
        request: (ServerlessProjectsLocationsAuthorizeddomainsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListAuthorizedDomainsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/authorizeddomains',
        http_method=u'GET',
        method_id=u'serverless.projects.locations.authorizeddomains.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v1alpha1/{+parent}/authorizeddomains',
        request_field='',
        request_type_name=u'ServerlessProjectsLocationsAuthorizeddomainsListRequest',
        response_type_name=u'ListAuthorizedDomainsResponse',
        supports_download=False,
    )

  class ProjectsLocationsConfigurationsService(base_api.BaseApiService):
    """Service class for the projects_locations_configurations resource."""

    _NAME = u'projects_locations_configurations'

    def __init__(self, client):
      super(ServerlessV1alpha1.ProjectsLocationsConfigurationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a configuration.

      Args:
        request: (ServerlessProjectsLocationsConfigurationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Configuration) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/configurations/{configurationsId}',
        http_method=u'GET',
        method_id=u'serverless.projects.locations.configurations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ServerlessProjectsLocationsConfigurationsGetRequest',
        response_type_name=u'Configuration',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list configurations.

      Args:
        request: (ServerlessProjectsLocationsConfigurationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListConfigurationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/configurations',
        http_method=u'GET',
        method_id=u'serverless.projects.locations.configurations.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'continue_', u'fieldSelector', u'includeUninitialized', u'labelSelector', u'limit', u'resourceVersion', u'watch'],
        relative_path=u'v1alpha1/{+parent}/configurations',
        request_field='',
        request_type_name=u'ServerlessProjectsLocationsConfigurationsListRequest',
        response_type_name=u'ListConfigurationsResponse',
        supports_download=False,
    )

  class ProjectsLocationsDomainmappingsService(base_api.BaseApiService):
    """Service class for the projects_locations_domainmappings resource."""

    _NAME = u'projects_locations_domainmappings'

    def __init__(self, client):
      super(ServerlessV1alpha1.ProjectsLocationsDomainmappingsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new domain mapping.

      Args:
        request: (ServerlessProjectsLocationsDomainmappingsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DomainMapping) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/domainmappings',
        http_method=u'POST',
        method_id=u'serverless.projects.locations.domainmappings.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1alpha1/{+parent}/domainmappings',
        request_field=u'domainMapping',
        request_type_name=u'ServerlessProjectsLocationsDomainmappingsCreateRequest',
        response_type_name=u'DomainMapping',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a domain mapping.

      Args:
        request: (ServerlessProjectsLocationsDomainmappingsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/domainmappings/{domainmappingsId}',
        http_method=u'DELETE',
        method_id=u'serverless.projects.locations.domainmappings.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'orphanDependents'],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ServerlessProjectsLocationsDomainmappingsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a domain mapping.

      Args:
        request: (ServerlessProjectsLocationsDomainmappingsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DomainMapping) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/domainmappings/{domainmappingsId}',
        http_method=u'GET',
        method_id=u'serverless.projects.locations.domainmappings.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ServerlessProjectsLocationsDomainmappingsGetRequest',
        response_type_name=u'DomainMapping',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list domain mappings.

      Args:
        request: (ServerlessProjectsLocationsDomainmappingsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListDomainMappingsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/domainmappings',
        http_method=u'GET',
        method_id=u'serverless.projects.locations.domainmappings.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'continue_', u'fieldSelector', u'includeUninitialized', u'labelSelector', u'limit', u'resourceVersion', u'watch'],
        relative_path=u'v1alpha1/{+parent}/domainmappings',
        request_field='',
        request_type_name=u'ServerlessProjectsLocationsDomainmappingsListRequest',
        response_type_name=u'ListDomainMappingsResponse',
        supports_download=False,
    )

    def ReplaceDomainMapping(self, request, global_params=None):
      r"""Rpc to replace a domain mapping.

Only the spec and metadata labels and annotations are modifiable. After
the Update request, Cloud Run will work to make the 'status'
match the requested 'spec'.

May provide metadata.resourceVersion to enforce update from last read for
optimistic concurrency control.

      Args:
        request: (ServerlessProjectsLocationsDomainmappingsReplaceDomainMappingRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DomainMapping) The response message.
      """
      config = self.GetMethodConfig('ReplaceDomainMapping')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplaceDomainMapping.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/domainmappings/{domainmappingsId}',
        http_method=u'PUT',
        method_id=u'serverless.projects.locations.domainmappings.replaceDomainMapping',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field=u'domainMapping',
        request_type_name=u'ServerlessProjectsLocationsDomainmappingsReplaceDomainMappingRequest',
        response_type_name=u'DomainMapping',
        supports_download=False,
    )

  class ProjectsLocationsRevisionsService(base_api.BaseApiService):
    """Service class for the projects_locations_revisions resource."""

    _NAME = u'projects_locations_revisions'

    def __init__(self, client):
      super(ServerlessV1alpha1.ProjectsLocationsRevisionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a revision.

      Args:
        request: (ServerlessProjectsLocationsRevisionsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/revisions/{revisionsId}',
        http_method=u'DELETE',
        method_id=u'serverless.projects.locations.revisions.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'orphanDependents'],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ServerlessProjectsLocationsRevisionsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a revision.

      Args:
        request: (ServerlessProjectsLocationsRevisionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Revision) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/revisions/{revisionsId}',
        http_method=u'GET',
        method_id=u'serverless.projects.locations.revisions.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ServerlessProjectsLocationsRevisionsGetRequest',
        response_type_name=u'Revision',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list revisions.

      Args:
        request: (ServerlessProjectsLocationsRevisionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListRevisionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/revisions',
        http_method=u'GET',
        method_id=u'serverless.projects.locations.revisions.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'continue_', u'fieldSelector', u'includeUninitialized', u'labelSelector', u'limit', u'resourceVersion', u'watch'],
        relative_path=u'v1alpha1/{+parent}/revisions',
        request_field='',
        request_type_name=u'ServerlessProjectsLocationsRevisionsListRequest',
        response_type_name=u'ListRevisionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsRoutesService(base_api.BaseApiService):
    """Service class for the projects_locations_routes resource."""

    _NAME = u'projects_locations_routes'

    def __init__(self, client):
      super(ServerlessV1alpha1.ProjectsLocationsRoutesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a route.

      Args:
        request: (ServerlessProjectsLocationsRoutesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Route) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/routes/{routesId}',
        http_method=u'GET',
        method_id=u'serverless.projects.locations.routes.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ServerlessProjectsLocationsRoutesGetRequest',
        response_type_name=u'Route',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list routes.

      Args:
        request: (ServerlessProjectsLocationsRoutesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListRoutesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/routes',
        http_method=u'GET',
        method_id=u'serverless.projects.locations.routes.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'continue_', u'fieldSelector', u'includeUninitialized', u'labelSelector', u'limit', u'resourceVersion', u'watch'],
        relative_path=u'v1alpha1/{+parent}/routes',
        request_field='',
        request_type_name=u'ServerlessProjectsLocationsRoutesListRequest',
        response_type_name=u'ListRoutesResponse',
        supports_download=False,
    )

  class ProjectsLocationsServicesService(base_api.BaseApiService):
    """Service class for the projects_locations_services resource."""

    _NAME = u'projects_locations_services'

    def __init__(self, client):
      super(ServerlessV1alpha1.ProjectsLocationsServicesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Rpc to create a service.

      Args:
        request: (ServerlessProjectsLocationsServicesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Service) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/services',
        http_method=u'POST',
        method_id=u'serverless.projects.locations.services.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1alpha1/{+parent}/services',
        request_field=u'service',
        request_type_name=u'ServerlessProjectsLocationsServicesCreateRequest',
        response_type_name=u'Service',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a service.
This will cause the Service to stop serving traffic and will delete the
child entities like Routes, Configurations and Revisions.

      Args:
        request: (ServerlessProjectsLocationsServicesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/services/{servicesId}',
        http_method=u'DELETE',
        method_id=u'serverless.projects.locations.services.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'orphanDependents'],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ServerlessProjectsLocationsServicesDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a service.

      Args:
        request: (ServerlessProjectsLocationsServicesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Service) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/services/{servicesId}',
        http_method=u'GET',
        method_id=u'serverless.projects.locations.services.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field='',
        request_type_name=u'ServerlessProjectsLocationsServicesGetRequest',
        response_type_name=u'Service',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Get the IAM Access Control policy currently in effect for the given.
Cloud Run service. This result does not include any inherited policies.

      Args:
        request: (ServerlessProjectsLocationsServicesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/services/{servicesId}:getIamPolicy',
        http_method=u'GET',
        method_id=u'serverless.projects.locations.services.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha1/{+resource}:getIamPolicy',
        request_field='',
        request_type_name=u'ServerlessProjectsLocationsServicesGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list services.

      Args:
        request: (ServerlessProjectsLocationsServicesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListServicesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/services',
        http_method=u'GET',
        method_id=u'serverless.projects.locations.services.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'continue_', u'fieldSelector', u'includeUninitialized', u'labelSelector', u'limit', u'resourceVersion', u'watch'],
        relative_path=u'v1alpha1/{+parent}/services',
        request_field='',
        request_type_name=u'ServerlessProjectsLocationsServicesListRequest',
        response_type_name=u'ListServicesResponse',
        supports_download=False,
    )

    def ReplaceService(self, request, global_params=None):
      r"""Rpc to replace a service.

Only the spec and metadata labels and annotations are modifiable. After
the Update request, Cloud Run will work to make the 'status'
match the requested 'spec'.

May provide metadata.resourceVersion to enforce update from last read for
optimistic concurrency control.

      Args:
        request: (ServerlessProjectsLocationsServicesReplaceServiceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Service) The response message.
      """
      config = self.GetMethodConfig('ReplaceService')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplaceService.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/services/{servicesId}',
        http_method=u'PUT',
        method_id=u'serverless.projects.locations.services.replaceService',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha1/{+name}',
        request_field=u'service',
        request_type_name=u'ServerlessProjectsLocationsServicesReplaceServiceRequest',
        response_type_name=u'Service',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the IAM Access control policy for the specified Service. Overwrites.
any existing policy.

      Args:
        request: (ServerlessProjectsLocationsServicesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/services/{servicesId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'serverless.projects.locations.services.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha1/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'ServerlessProjectsLocationsServicesSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified Project.

There are no permissions required for making this API call.

      Args:
        request: (ServerlessProjectsLocationsServicesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations/{locationsId}/services/{servicesId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'serverless.projects.locations.services.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha1/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'ServerlessProjectsLocationsServicesTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = u'projects_locations'

    def __init__(self, client):
      super(ServerlessV1alpha1.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists information about the supported locations for this service.

      Args:
        request: (ServerlessProjectsLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLocationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha1/projects/{projectsId}/locations',
        http_method=u'GET',
        method_id=u'serverless.projects.locations.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha1/{+name}/locations',
        request_field='',
        request_type_name=u'ServerlessProjectsLocationsListRequest',
        response_type_name=u'ListLocationsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = u'projects'

    def __init__(self, client):
      super(ServerlessV1alpha1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
