(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define gerbil/tools/gxpkg#main
    (lambda _args6740_
      (letrec* ((_install-cmd6742_
                 (std/getopt#command__%
                  '#f
                  '"install one or more packages"
                  'install
                  (std/getopt#rest-arguments__%
                   '#f
                   '"package to install"
                   absent-value
                   'pkg)))
                (_uninstall-cmd6743_
                 (std/getopt#command__%
                  '#f
                  '"uninstall one or more packages"
                  'uninstall
                  (std/getopt#flag__%__0
                   '#f
                   '"force uninstall even if there are orphaned dependencies"
                   'force
                   '"-f")
                  (std/getopt#rest-arguments__%
                   '#f
                   '"package to uninstall"
                   absent-value
                   'pkg)))
                (_update-cmd6744_
                 (std/getopt#command__%
                  '#f
                  '"update one or more packages"
                  'update
                  (std/getopt#rest-arguments__%
                   '#f
                   '"package to update; all for all packages"
                   absent-value
                   'pkg)))
                (_link-cmd6745_
                 (std/getopt#command__%
                  '#f
                  '"link a local development package"
                  'link
                  (std/getopt#argument__%
                   '#f
                   '"package to link"
                   absent-value
                   'pkg)
                  (std/getopt#argument__%
                   '#f
                   '"path to package source directory"
                   absent-value
                   'src)))
                (_unlink-cmd6746_
                 (std/getopt#command__%
                  '#f
                  '"unlink one or more local development packages"
                  'unlink
                  (std/getopt#flag__%__0
                   '#f
                   '"force unlink even if there are orphaned dependencies"
                   'force
                   '"-f")
                  (std/getopt#rest-arguments__%
                   '#f
                   '"package to unlink"
                   absent-value
                   'pkg)))
                (_build-cmd6747_
                 (std/getopt#command__%
                  '#f
                  '"rebuild one or more packages and their dependents"
                  'build
                  (std/getopt#rest-arguments__%
                   '#f
                   '"package to build; all for all packages"
                   absent-value
                   'pkg)))
                (_clean-cmd6748_
                 (std/getopt#command__%
                  '#f
                  '"clean compilation artefacts from one or more packages"
                  'clean
                  (std/getopt#rest-arguments__%
                   '#f
                   '"package to clean"
                   absent-value
                   'pkg)))
                (_list-cmd6749_
                 (std/getopt#command__% '#f '"list installed packages" 'list))
                (_retag-cmd6750_
                 (std/getopt#command__%
                  '#f
                  '"retag installed packages"
                  'retag))
                (_search-cmd6751_
                 (std/getopt#command__%
                  '#f
                  '"search the package directory"
                  'search
                  (std/getopt#rest-arguments__%
                   '#f
                   '"keywords to search for"
                   absent-value
                   'keywords)))
                (_help-cmd6752_
                 (std/getopt#command__%
                  '#f
                  '"display help; help <command> for command help"
                  'help
                  (std/getopt#optional-argument__%
                   '#f
                   absent-value
                   string->symbol
                   absent-value
                   'command)))
                (_gopt6753_
                 (std/getopt#getopt
                  _install-cmd6742_
                  _uninstall-cmd6743_
                  _update-cmd6744_
                  _link-cmd6745_
                  _unlink-cmd6746_
                  _build-cmd6747_
                  _clean-cmd6748_
                  _list-cmd6749_
                  _retag-cmd6750_
                  _search-cmd6751_
                  _help-cmd6752_)))
        (with-exception-catcher
         (lambda (_g67546756_)
           (if ((lambda (_$obj6759_)
                  (##structure-instance-of?
                   _$obj6759_
                   'std/getopt#getopt-error::t))
                _g67546756_)
               (let ((_exn6762_ _g67546756_))
                 (std/getopt#getopt-display-help__%
                  _exn6762_
                  '"gxpkg"
                  (current-error-port))
                 (exit '1))
               (if '#t
                   (let ((_e6764_ _g67546756_))
                     (display-exception _e6764_ (current-error-port))
                     (exit '2))
                   (raise _g67546756_))))
         (lambda ()
           (let ((_g7090_ (std/getopt#getopt-parse _gopt6753_ _args6740_)))
             (begin
               (let ((_g7091_ (if (##values? _g7090_)
                                  (##vector-length _g7090_)
                                  1)))
                 (if (not (##fx= _g7091_ 2))
                     (error "Context expects 2 values" _g7091_)))
               (let ((_cmd6767_ (##vector-ref _g7090_ 0))
                     (_opt6768_ (##vector-ref _g7090_ 1)))
                 (let* ((_ht6770_ _opt6768_) (_$e7023_ _cmd6767_))
                   (if (eq? 'install _$e7023_)
                       (gerbil/tools/gxpkg#install-pkgs
                        (table-ref _ht6770_ 'pkg))
                       (if (eq? 'uninstall _$e7023_)
                           (gerbil/tools/gxpkg#uninstall-pkgs
                            (table-ref _ht6770_ 'pkg)
                            (table-ref _ht6770_ 'force '#f))
                           (if (eq? 'update _$e7023_)
                               (gerbil/tools/gxpkg#update-pkgs
                                (table-ref _ht6770_ 'pkg))
                               (if (eq? 'link _$e7023_)
                                   (gerbil/tools/gxpkg#pkg-link
                                    (table-ref _ht6770_ 'pkg)
                                    (table-ref _ht6770_ 'src))
                                   (if (eq? 'unlink _$e7023_)
                                       (gerbil/tools/gxpkg#unlink-pkgs
                                        (table-ref _ht6770_ 'pkg)
                                        (table-ref _ht6770_ 'force '#f))
                                       (if (eq? 'build _$e7023_)
                                           (gerbil/tools/gxpkg#build-pkgs
                                            (table-ref _ht6770_ 'pkg))
                                           (if (eq? 'clean _$e7023_)
                                               (gerbil/tools/gxpkg#clean-pkgs
                                                (table-ref _ht6770_ 'pkg))
                                               (if (eq? 'list _$e7023_)
                                                   (gerbil/tools/gxpkg#list-pkgs)
                                                   (if (eq? 'retag _$e7023_)
                                                       (gerbil/tools/gxpkg#pkg-retag)
                                                       (if (eq? 'search
                                                                _$e7023_)
                                                           (gerbil/tools/gxpkg#pkg-search
                                                            (table-ref
                                                             _ht6770_
                                                             'keywords))
                                                           (if (eq? 'help
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                            _$e7023_)
                       (std/getopt#getopt-display-help-topic__0
                        _gopt6753_
                        (table-ref _ht6770_ 'command '#f)
                        '"gxkpg")
                       '#!void))))))))))))))))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
  (define gerbil/tools/gxpkg#install-pkgs
    (lambda (_pkgs6696_)
      (if (let _lp6698_ ((_rest6701_ _pkgs6696_) (_result6703_ '#f))
            (let* ((_rest67056713_ _rest6701_)
                   (_else67076721_ (lambda () _result6703_))
                   (_K67096728_
                    (lambda (_rest6724_ _pkg6725_)
                      (if (gerbil/tools/gxpkg#pkg-install _pkg6725_)
                          (_lp6698_ _rest6724_ '#t)
                          (_lp6698_ _rest6724_ _result6703_)))))
              (if (##pair? _rest67056713_)
                  (let ((_hd67106731_ (##car _rest67056713_))
                        (_tl67116733_ (##cdr _rest67056713_)))
                    (let* ((_pkg6736_ _hd67106731_) (_rest6738_ _tl67116733_))
                      (_K67096728_ _rest6738_ _pkg6736_)))
                  (_else67076721_))))
          (gerbil/tools/gxpkg#pkg-retag)
          '#!void)))
  (define gerbil/tools/gxpkg#uninstall-pkgs
    (lambda (_pkgs6651_ _force?6652_)
      (if (let _lp6654_ ((_rest6657_ _pkgs6651_) (_result6659_ '#f))
            (let* ((_rest66616669_ _rest6657_)
                   (_else66636677_ (lambda () _result6659_))
                   (_K66656684_
                    (lambda (_rest6680_ _pkg6681_)
                      (if (gerbil/tools/gxpkg#pkg-uninstall__%
                           _pkg6681_
                           _force?6652_)
                          (_lp6654_ _rest6680_ '#t)
                          (_lp6654_ _rest6680_ _result6659_)))))
              (if (##pair? _rest66616669_)
                  (let ((_hd66666687_ (##car _rest66616669_))
                        (_tl66676689_ (##cdr _rest66616669_)))
                    (let* ((_pkg6692_ _hd66666687_) (_rest6694_ _tl66676689_))
                      (_K66656684_ _rest6694_ _pkg6692_)))
                  (_else66636677_))))
          (gerbil/tools/gxpkg#pkg-retag)
          '#!void)))
  (define gerbil/tools/gxpkg#update-pkgs
    (lambda (_pkgs6605_)
      (if (let _lp6607_ ((_rest6610_ _pkgs6605_) (_result6612_ '#f))
            (let* ((_rest66146622_ _rest6610_)
                   (_else66166630_ (lambda () _result6612_))
                   (_K66186637_
                    (lambda (_rest6633_ _pkg6634_)
                      (if (gerbil/tools/gxpkg#pkg-update _pkg6634_)
                          (_lp6607_ _rest6633_ '#t)
                          (_lp6607_ _rest6633_ _result6612_)))))
              (if (##pair? _rest66146622_)
                  (let ((_hd66196640_ (##car _rest66146622_))
                        (_tl66206642_ (##cdr _rest66146622_)))
                    (let* ((_pkg6645_ _hd66196640_) (_rest6647_ _tl66206642_))
                      (_K66186637_ _rest6647_ _pkg6645_)))
                  (_else66166630_))))
          (begin
            (for-each
             (lambda (_pkg6649_)
               (if (equal? _pkg6649_ '"all")
                   (for-each
                    gerbil/tools/gxpkg#pkg-install-deps
                    (gerbil/tools/gxpkg#pkg-list))
                   (gerbil/tools/gxpkg#pkg-install-deps _pkg6649_)))
             _pkgs6605_)
            (for-each gerbil/tools/gxpkg#pkg-build _pkgs6605_)
            (gerbil/tools/gxpkg#pkg-retag))
          '#!void)))
  (define gerbil/tools/gxpkg#link-pkg
    (lambda (_pkg6602_ _src6603_)
      (gerbil/tools/gxpkg#pkg-link _pkg6602_ _src6603_)))
  (define gerbil/tools/gxpkg#unlink-pkgs
    (lambda (_pkgs6595_ _force?6596_)
      (for-each
       (lambda (_g65976599_)
         (gerbil/tools/gxpkg#pkg-unlink__% _g65976599_ _force?6596_))
       _pkgs6595_)))
  (define gerbil/tools/gxpkg#build-pkgs
    (lambda (_pkgs6593_) (for-each gerbil/tools/gxpkg#pkg-build _pkgs6593_)))
  (define gerbil/tools/gxpkg#clean-pkgs
    (lambda (_pkgs6591_) (for-each gerbil/tools/gxpkg#pkg-clean _pkgs6591_)))
  (define gerbil/tools/gxpkg#list-pkgs
    (lambda () (for-each displayln (gerbil/tools/gxpkg#pkg-list))))
  (define gerbil/tools/gxpkg#retag-pkgs
    (lambda () (gerbil/tools/gxpkg#pkg-retag)))
  (define gerbil/tools/gxpkg#search-pkgs
    (lambda (_keywords6587_) (gerbil/tools/gxpkg#pkg-search _keywords6587_)))
  (define gerbil/tools/gxpkg#+pkg-root-dir+
    (path-expand '"pkg" (getenv '"GERBIL_PATH" '"~/.gerbil")))
  (define gerbil/tools/gxpkg#pkg-root-dir
    (let ((_once6584_
           (make-promise
            (lambda ()
              (create-directory* gerbil/tools/gxpkg#+pkg-root-dir+)))))
      (lambda () (force _once6584_) gerbil/tools/gxpkg#+pkg-root-dir+)))
  (define gerbil/tools/gxpkg#pkg-install
    (lambda (_pkg6571_)
      (letrec ((_git-clone-url6573_
                (lambda (_pkg6581_)
                  (string-append '"https://" _pkg6581_ '".git"))))
        (if (or (string-prefix? '"github.com/" _pkg6571_)
                (string-prefix? '"gitlab.com/" _pkg6571_)
                (string-prefix? '"bitbucket.org/" _pkg6571_))
            (gerbil/tools/gxpkg#pkg-install-git
             _pkg6571_
             (_git-clone-url6573_ _pkg6571_))
            (error '"Unknown package provider" _pkg6571_)))))
  (define gerbil/tools/gxpkg#pkg-install-git
    (lambda (_pkg6561_ _clone-url6562_)
      (let* ((_root6564_ (gerbil/tools/gxpkg#pkg-root-dir))
             (_dest6566_ (path-expand _pkg6561_ _root6564_)))
        (if (file-exists? _dest6566_)
            '#f
            (let ((_path6569_ (path-directory _dest6566_)))
              (displayln '"... install " _pkg6561_)
              (create-directory* _path6569_)
              (std/misc/process#run-process__%
               '#f
               void
               absent-value
               absent-value
               _path6569_
               absent-value
               '#f
               absent-value
               absent-value
               absent-value
               (cons '"git"
                     (cons '"clone" (cons '"-q" (cons _clone-url6562_ '())))))
              (gerbil/tools/gxpkg#pkg-install-deps _pkg6561_)
              (gerbil/tools/gxpkg#pkg-build__0 _pkg6561_)
              '#t)))))
  (define gerbil/tools/gxpkg#pkg-install-deps
    (lambda (_pkg6554_)
      (let* ((_plist6556_ (gerbil/tools/gxpkg#pkg-plist _pkg6554_))
             (_deps6558_ (pgetq 'depend: _plist6556_ '())))
        (for-each gerbil/tools/gxpkg#pkg-install _deps6558_))))
  (define gerbil/tools/gxpkg#pkg-uninstall__%
    (lambda (_pkg6534_ _force?6535_)
      (let* ((_root6537_ (gerbil/tools/gxpkg#pkg-root-dir))
             (_dest6539_ (path-expand _pkg6534_ _root6537_)))
        (if (file-exists? _dest6539_)
            (if (not (gerbil/tools/gxpkg#file-symbolic-link? _dest6539_))
                (begin
                  (if _force?6535_
                      '#!void
                      (let ((_deps6542_
                             (gerbil/tools/gxpkg#pkg-dependents__0 _pkg6534_)))
                        (if (null? _deps6542_)
                            '#!void
                            (error '"Refuse to uninstall package; orphaned dependencies"
                                   _deps6542_))))
                  (gerbil/tools/gxpkg#pkg-clean _pkg6534_)
                  (displayln '"... uninstall " _pkg6534_)
                  (std/misc/process#run-process__%
                   '#f
                   void
                   absent-value
                   absent-value
                   absent-value
                   absent-value
                   absent-value
                   absent-value
                   absent-value
                   absent-value
                   (cons '"rm"
                         (cons '"-rf" (cons (path-normalize _dest6539_) '()))))
                  '#t)
                '#f)
            '#f))))
  (define gerbil/tools/gxpkg#pkg-uninstall__0
    (lambda (_pkg6547_)
      (let ((_force?6549_ '#f))
        (gerbil/tools/gxpkg#pkg-uninstall__% _pkg6547_ _force?6549_))))
  (define gerbil/tools/gxpkg#pkg-uninstall
    (lambda _g7093_
      (let ((_g7092_ (length _g7093_)))
        (cond ((##fx= _g7092_ 1)
               (apply gerbil/tools/gxpkg#pkg-uninstall__0 _g7093_))
              ((##fx= _g7092_ 2)
               (apply gerbil/tools/gxpkg#pkg-uninstall__% _g7093_))
              (else
               (##raise-wrong-number-of-arguments-exception
                gerbil/tools/gxpkg#pkg-uninstall
                _g7093_))))))
  (define gerbil/tools/gxpkg#pkg-update
    (lambda (_pkg6483_)
      (if (equal? _pkg6483_ '"all")
          (let _lp6485_ ((_rest6488_ (gerbil/tools/gxpkg#pkg-list))
                         (_result6490_ '#f))
            (let* ((_rest64926500_ _rest6488_)
                   (_else64946508_ (lambda () _result6490_))
                   (_K64966515_
                    (lambda (_rest6511_ _pkg6512_)
                      (if (gerbil/tools/gxpkg#pkg-update _pkg6512_)
                          (_lp6485_ _rest6511_ '#t)
                          (_lp6485_ _rest6511_ _result6490_)))))
              (if (##pair? _rest64926500_)
                  (let ((_hd64976518_ (##car _rest64926500_))
                        (_tl64986520_ (##cdr _rest64926500_)))
                    (let* ((_pkg6523_ _hd64976518_) (_rest6525_ _tl64986520_))
                      (_K64966515_ _rest6525_ _pkg6523_)))
                  (_else64946508_))))
          (if (or (string-prefix? '"github.com/" _pkg6483_)
                  (string-prefix? '"gitlab.com/" _pkg6483_)
                  (string-prefix? '"bitbucket.org/" _pkg6483_))
              (gerbil/tools/gxpkg#pkg-update-git _pkg6483_)
              (error '"Unknown package provider" _pkg6483_)))))
  (define gerbil/tools/gxpkg#pkg-update-git
    (lambda (_pkg6471_)
      (let* ((_root6473_ (gerbil/tools/gxpkg#pkg-root-dir))
             (_dest6475_ (path-expand _pkg6471_ _root6473_)))
        (if (file-exists? _dest6475_)
            '#!void
            (error '"Cannot update uknown package" _pkg6471_))
        (if (not (gerbil/tools/gxpkg#file-symbolic-link? _dest6475_))
            (begin
              (displayln '"... update " _pkg6471_)
              (let* ((_result6478_
                      (std/misc/process#run-process__%
                       '#f
                       absent-value
                       absent-value
                       absent-value
                       _dest6475_
                       absent-value
                       absent-value
                       absent-value
                       absent-value
                       absent-value
                       (cons '"git" (cons '"pull" '()))))
                     (_update?6480_
                      (not (equal? _result6478_ '"Already up-to-date.\n"))))
                _update?6480_))
            '#f))))
  (define gerbil/tools/gxpkg#pkg-link
    (lambda (_pkg6463_ _src6464_)
      (let* ((_root6466_ (gerbil/tools/gxpkg#pkg-root-dir))
             (_dest6468_ (path-expand _pkg6463_ _root6466_)))
        (if (file-exists? _dest6468_)
            (error '"Cannot link package; destination already exists"
                   _pkg6463_
                   _dest6468_)
            '#!void)
        (create-directory* (path-directory _dest6468_))
        (create-symbolic-link _src6464_ _dest6468_))))
  (define gerbil/tools/gxpkg#pkg-unlink__%
    (lambda (_pkg6443_ _force?6444_)
      (let* ((_root6446_ (gerbil/tools/gxpkg#pkg-root-dir))
             (_dest6448_ (path-expand _pkg6443_ _root6446_)))
        (if (file-exists? _dest6448_)
            (begin
              (if (gerbil/tools/gxpkg#file-symbolic-link? _dest6448_)
                  '#!void
                  (error '"Cannot unlink package; not a symbolic link"
                         _dest6448_))
              (if _force?6444_
                  '#!void
                  (let ((_deps6451_
                         (gerbil/tools/gxpkg#pkg-dependents__0 _pkg6443_)))
                    (if (null? _deps6451_)
                        '#!void
                        (error '"Refuse to unlink package; orphaned dependencies"
                               _deps6451_))))
              (gerbil/tools/gxpkg#pkg-clean _pkg6443_)
              (delete-file _dest6448_))
            '#!void))))
  (define gerbil/tools/gxpkg#pkg-unlink__0
    (lambda (_pkg6456_)
      (let ((_force?6458_ '#f))
        (gerbil/tools/gxpkg#pkg-unlink__% _pkg6456_ _force?6458_))))
  (define gerbil/tools/gxpkg#pkg-unlink
    (lambda _g7095_
      (let ((_g7094_ (length _g7095_)))
        (cond ((##fx= _g7094_ 1)
               (apply gerbil/tools/gxpkg#pkg-unlink__0 _g7095_))
              ((##fx= _g7094_ 2)
               (apply gerbil/tools/gxpkg#pkg-unlink__% _g7095_))
              (else
               (##raise-wrong-number-of-arguments-exception
                gerbil/tools/gxpkg#pkg-unlink
                _g7095_))))))
  (define gerbil/tools/gxpkg#pkg-build__%
    (lambda (_pkg6401_ _dependents?6402_)
      (if (equal? _pkg6401_ '"all")
          (let* ((_pkgs6404_ (gerbil/tools/gxpkg#pkg-list))
                 (_deps6410_
                  (map (lambda (_g64056407_)
                         (gerbil/tools/gxpkg#pkg-dependents*__%
                          _g64056407_
                          _pkgs6404_))
                       _pkgs6404_))
                 (_pkgs+deps6412_ (map cons _pkgs6404_ _deps6410_))
                 (_sorted6417_
                  (std/sort#sort
                   _pkgs+deps6412_
                   (lambda (_pa6414_ _pb6415_)
                     (member (car _pb6415_) (cdr _pa6414_))))))
            (for-each
             (lambda (_g64196421_)
               (gerbil/tools/gxpkg#pkg-build__% _g64196421_ '#f))
             (map car _sorted6417_)))
          (let* ((_root6424_ (gerbil/tools/gxpkg#pkg-root-dir))
                 (_path6426_ (path-expand _pkg6401_ _root6424_))
                 (_g7096_ (if (file-exists? _path6426_)
                              '#!void
                              (error '"Cannot build unknown package"
                                     _pkg6401_)))
                 (_build.ss6429_
                  (gerbil/tools/gxpkg#pkg-build-script _pkg6401_)))
            (displayln '"... build " _pkg6401_)
            (std/misc/process#run-process__%
             '#f
             void
             absent-value
             absent-value
             _path6426_
             absent-value
             '#f
             absent-value
             absent-value
             absent-value
             (cons _build.ss6429_ (cons '"deps" '())))
            (std/misc/process#run-process__%
             '#f
             void
             absent-value
             absent-value
             _path6426_
             absent-value
             '#f
             absent-value
             absent-value
             absent-value
             (cons _build.ss6429_ (cons '"compile" '())))
            (if _dependents?6402_
                (for-each
                 gerbil/tools/gxpkg#pkg-build
                 (gerbil/tools/gxpkg#pkg-dependents__0 _pkg6401_))
                '#!void)))))
  (define gerbil/tools/gxpkg#pkg-build__0
    (lambda (_pkg6435_)
      (let ((_dependents?6437_ '#t))
        (gerbil/tools/gxpkg#pkg-build__% _pkg6435_ _dependents?6437_))))
  (define gerbil/tools/gxpkg#pkg-build
    (lambda _g7098_
      (let ((_g7097_ (length _g7098_)))
        (cond ((##fx= _g7097_ 1)
               (apply gerbil/tools/gxpkg#pkg-build__0 _g7098_))
              ((##fx= _g7097_ 2)
               (apply gerbil/tools/gxpkg#pkg-build__% _g7098_))
              (else
               (##raise-wrong-number-of-arguments-exception
                gerbil/tools/gxpkg#pkg-build
                _g7098_))))))
  (define gerbil/tools/gxpkg#pkg-clean
    (lambda (_pkg6122_)
      (letrec* ((_gpath6124_ (getenv '"GERBIL_PATH" '"~/.gerbil"))
                (_libdir6125_ (path-expand '"lib" _gpath6124_))
                (_bindir6126_ (path-expand '"bin" _gpath6124_))
                (_clean-lib6127_
                 (lambda (_mod6359_)
                   (let* ((_modpath6361_ (path-expand _mod6359_ _libdir6125_))
                          (_moddir6363_ (path-directory _modpath6361_))
                          (_modname6365_ (path-strip-directory _modpath6361_))
                          (_mod-dot6367_ (string-append _modname6365_ '"."))
                          (_mod-us6369_ (string-append _modname6365_ '"__"))
                          (_mod-nested6371_
                           (string-append _modname6365_ '"$")))
                     (if (file-exists? _moddir6363_)
                         (for-each
                          (lambda (_file6374_)
                            (if (or (string-prefix? _mod-dot6367_ _file6374_)
                                    (string-prefix? _mod-us6369_ _file6374_)
                                    (string-prefix?
                                     _mod-nested6371_
                                     _file6374_))
                                (let ((_path6382_
                                       (path-expand _file6374_ _moddir6363_)))
                                  (delete-file _path6382_))
                                '#!void))
                          (directory-files _moddir6363_))
                         '#!void))
                   (let* ((_static-libdir6384_
                           (path-expand '"static" _libdir6125_))
                          (_static-modname6386_
                           (string-join (string-split _mod6359_ '#\/) '"__"))
                          (_mod-self6388_
                           (string-append _static-modname6386_ '".scm"))
                          (_mod-nested6390_
                           (string-append _static-modname6386_ '"$")))
                     (if (file-exists? _static-libdir6384_)
                         (for-each
                          (lambda (_file6393_)
                            (if (or (equal? _file6393_ _mod-self6388_)
                                    (string-prefix?
                                     _mod-nested6390_
                                     _file6393_))
                                (let ((_path6398_
                                       (path-expand
                                        _file6393_
                                        _static-libdir6384_)))
                                  (delete-file _path6398_))
                                '#!void))
                          (directory-files _static-libdir6384_))
                         '#!void))))
                (_clean-bin6128_
                 (lambda (_exe6355_)
                   (let ((_bin6357_ (path-expand _exe6355_ _bindir6126_)))
                     (if (file-exists? _bin6357_)
                         (delete-file _bin6357_)
                         '#!void))))
                (_clean-static-include6129_
                 (lambda (_file6348_)
                   (let* ((_filename6350_ (path-strip-directory _file6348_))
                          (_static-path6352_
                           (path-expand
                            _filename6350_
                            (path-expand '"static" _libdir6125_))))
                     (if (file-exists? _static-path6352_)
                         (delete-file _static-path6352_)
                         '#!void)))))
        (let* ((_root6131_ (gerbil/tools/gxpkg#pkg-root-dir))
               (_path6133_ (path-expand _pkg6122_ _root6131_))
               (_g7099_ (if (file-exists? _path6133_)
                            '#!void
                            (error '"Cannot clean unknown package" _pkg6122_)))
               (_build.ss6136_ (gerbil/tools/gxpkg#pkg-build-script _pkg6122_))
               (_build-spec6138_
                (std/misc/process#run-process__%
                 '#f
                 read
                 absent-value
                 absent-value
                 _path6133_
                 absent-value
                 absent-value
                 absent-value
                 absent-value
                 absent-value
                 (cons _build.ss6136_ (cons '"spec" '()))))
               (_plist6140_ (gerbil/tools/gxpkg#pkg-plist _pkg6122_))
               (_prefix6142_ (pgetq 'package: _plist6140_))
               (_prefix6144_
                (if _prefix6142_ (symbol->string _prefix6142_) '#f))
               (_with-prefix6148_
                (if _prefix6144_
                    (lambda (_mod6146_)
                      (string-append _prefix6144_ '"/" _mod6146_))
                    values)))
          (for-each
           (lambda (_e61506152_)
             (let* ((_g61546197_ _e61506152_)
                    (_E61636201_
                     (lambda () (error '"No clause matching" _g61546197_))))
               (let ((_K61956343_
                      (lambda (_modf6341_)
                        (_clean-lib6127_ (_with-prefix6148_ _modf6341_))))
                     (_K61906325_
                      (lambda (_modf6323_)
                        (_clean-lib6127_ (_with-prefix6148_ _modf6323_))))
                     (_K61856306_
                      (lambda (_modf6304_)
                        (_clean-lib6127_ (_with-prefix6148_ _modf6304_))))
                     (_K61806287_
                      (lambda (_modf6285_)
                        (_clean-lib6127_ (_with-prefix6148_ _modf6285_))))
                     (_K61756264_
                      (lambda (_opts6261_ _modf6262_)
                        (_clean-lib6127_ (_with-prefix6148_ _modf6262_))
                        (_clean-bin6128_ (pgetq 'bin: _opts6261_ _modf6262_))))
                     (_K61706240_
                      (lambda (_opts6237_ _modf6238_)
                        (_clean-lib6127_ (_with-prefix6148_ _modf6238_))
                        (_clean-bin6128_ (pgetq 'bin: _opts6237_ _modf6238_))))
                     (_K61656218_
                      (lambda (_file6216_)
                        (_clean-static-include6129_ _file6216_)))
                     (_K61646207_
                      (lambda (_unexpected6205_)
                        (displayln
                         '"Ignoring unexpected build artifact "
                         _unexpected6205_))))
                 (let ((_try-match61566338_
                        (lambda ()
                          (if (##pair? _g61546197_)
                              (let ((_tl61926330_ (##cdr _g61546197_))
                                    (_hd61916328_ (##car _g61546197_)))
                                (if (##eq? _hd61916328_ 'gxc:)
                                    (if (##pair? _tl61926330_)
                                        (let* ((_hd61936333_
                                                (##car _tl61926330_))
                                               (_modf6336_ _hd61936333_))
                                          (_K61906325_ _modf6336_))
                                        (let ((_unexpected6210_ _g61546197_))
                                          (_K61646207_ _unexpected6210_)))
                                    (if (##eq? _hd61916328_ 'gsc:)
                                        (if (##pair? _tl61926330_)
                                            (let* ((_hd61886314_
                                                    (##car _tl61926330_))
                                                   (_modf6317_ _hd61886314_))
                                              (_K61856306_ _modf6317_))
                                            (let ((_unexpected6210_
                                                   _g61546197_))
                                              (_K61646207_ _unexpected6210_)))
                                        (if (##eq? _hd61916328_ 'ssi:)
                                            (if (##pair? _tl61926330_)
                                                (let* ((_hd61836295_
                                                        (##car _tl61926330_))
                                                       (_modf6298_
                                                        _hd61836295_))
                                                  (_K61806287_ _modf6298_))
                                                (let ((_unexpected6210_
                                                       _g61546197_))
                                                  (_K61646207_
                                                   _unexpected6210_)))
                                            (if (##eq? _hd61916328_ 'exe:)
                                                (if (##pair? _tl61926330_)
                                                    (let ((_tl61796274_
                                                           (##cdr _tl61926330_))
                                                          (_hd61786272_
                                                           (##car _tl61926330_)))
                                                      (let ((_modf6277_
                                                             _hd61786272_)
                                                            (_opts6279_
                                                             _tl61796274_))
                                                        (_K61756264_
                                                         _opts6279_
                                                         _modf6277_)))
                                                    (let ((_unexpected6210_
                                                           _g61546197_))
                                                      (_K61646207_
                                                       _unexpected6210_)))
                                                (if (##eq? _hd61916328_
                                                           'static-exe:)
                                                    (if (##pair? _tl61926330_)
                                                        (let ((_tl61746250_
                                                               (##cdr _tl61926330_))
                                                              (_hd61736248_
                                                               (##car _tl61926330_)))
                                                          (let ((_modf6253_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         _hd61736248_)
                        (_opts6255_ _tl61746250_))
                    (_K61706240_ _opts6255_ _modf6253_)))
                (let ((_unexpected6210_ _g61546197_))
                  (_K61646207_ _unexpected6210_)))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                    (if (##eq? _hd61916328_
                                                               'static-include:)
                                                        (if (##pair? _tl61926330_)
                                                            (let ((_tl61696228_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                           (##cdr _tl61926330_))
                          (_hd61686226_ (##car _tl61926330_)))
                      (if (##null? _tl61696228_)
                          (let ((_file6231_ _hd61686226_))
                            (_clean-static-include6129_ _file6231_))
                          (let ((_unexpected6210_ _g61546197_))
                            (_K61646207_ _unexpected6210_))))
                    (let ((_unexpected6210_ _g61546197_))
                      (_K61646207_ _unexpected6210_)))
                (let ((_unexpected6210_ _g61546197_))
                  (_K61646207_ _unexpected6210_)))))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                              (let ((_unexpected6210_ _g61546197_))
                                (_K61646207_ _unexpected6210_))))))
                   (if (string? _g61546197_)
                       (let ((_modf6346_ _g61546197_))
                         (_K61956343_ _modf6346_))
                       (_try-match61566338_))))))
           _build-spec6138_)))))
  (define gerbil/tools/gxpkg#pkg-list
    (lambda ()
      (letrec* ((_root6066_ (gerbil/tools/gxpkg#pkg-root-dir))
                (_walk6067_
                 (lambda (_dir6110_ _pkgpath6111_)
                   (for-each
                    (lambda (_file6113_)
                      (let* ((_path6115_ (path-expand _file6113_ _dir6110_))
                             (_gerbil.pkg6117_
                              (path-expand '"gerbil.pkg" _path6115_))
                             (_pkgpath6119_
                              (if (string-empty? _pkgpath6111_)
                                  _file6113_
                                  (string-append
                                   _pkgpath6111_
                                   '"/"
                                   _file6113_))))
                        (if (file-exists? _gerbil.pkg6117_)
                            (std/coroutine#yield _pkgpath6119_)
                            (if (gerbil/tools/gxpkg#file-directory? _path6115_)
                                (_walk6067_ _path6115_ _pkgpath6119_)
                                '#!void))))
                    (directory-files _dir6110_)))))
        (let ((_iterable6091_ (lambda () (_walk6067_ _root6066_ '"")))
              (_iter-do6093_
               (lambda (_val6070_)
                 (let* ((_val60726077_ _val6070_)
                        (_E60746081_
                         (lambda ()
                           (error '"No clause matching" _val60726077_)))
                        (_K60756086_ (lambda (_pkg6084_) _pkg6084_))
                        (_pkg6089_ _val60726077_))
                   (_K60756086_ _pkg6089_)))))
          (if (pair? _iterable6091_)
              (map _iter-do6093_ _iterable6091_)
              (if (null? _iterable6091_)
                  '()
                  (let ((_it6096_ (std/iter#iter _iterable6091_)))
                    (let _lp6099_ ((_rval6102_ '()))
                      (let ((_val6105_ (std/iter#iter-next! _it6096_)))
                        (if (eq? std/iter#iter-end _val6105_)
                            (begin
                              (std/iter#iter-fini! _it6096_)
                              (reverse _rval6102_))
                            (let ((_xval6107_ (_iter-do6093_ _val6105_)))
                              (_lp6099_
                               (cons _xval6107_ _rval6102_)))))))))))))
  (define gerbil/tools/gxpkg#pkg-retag
    (lambda ()
      (let* ((_root6058_ (gerbil/tools/gxpkg#pkg-root-dir))
             (_dirs6062_
              (filter (lambda (_file6060_)
                        (gerbil/tools/gxpkg#file-directory?
                         (path-expand _file6060_ _root6058_)))
                      (directory-files _root6058_))))
        (displayln '"... tagging packages")
        (std/misc/process#run-process__%
         '#f
         absent-value
         absent-value
         absent-value
         _root6058_
         absent-value
         absent-value
         absent-value
         absent-value
         absent-value
         (cons '"gxtags" _dirs6062_)))))
  (define gerbil/tools/gxpkg#pkg-search
    (lambda (_keywords5938_)
      (letrec ((_search5940_
                (lambda (_alst5997_)
                  (let _lp5999_ ((_rest6001_ _alst5997_) (_r6002_ '()))
                    (let* ((_rest60036013_ _rest6001_)
                           (_else60056021_ (lambda () (reverse _r6002_)))
                           (_K60076036_
                            (lambda (_rest6024_ _desc6025_ _pkg6026_ _hd6027_)
                              (if (andmap1 (lambda (_kw6029_)
                                             (let ((_rx6031_
                                                    (std/pregexp#pregexp
                                                     (string-append
                                                      '"(?i:"
                                                      _kw6029_
                                                      '")"))))
                                               (or (std/pregexp#pregexp-match
                                                    _rx6031_
                                                    _pkg6026_)
                                                   (std/pregexp#pregexp-match
                                                    _rx6031_
                                                    _desc6025_))))
                                           _keywords5938_)
                                  (_lp5999_ _rest6024_ (cons _hd6027_ _r6002_))
                                  (_lp5999_ _rest6024_ _r6002_)))))
                      (if (##pair? _rest60036013_)
                          (let ((_hd60086039_ (##car _rest60036013_))
                                (_tl60096041_ (##cdr _rest60036013_)))
                            (let ((_hd6044_ _hd60086039_))
                              (if (##pair? _hd60086039_)
                                  (let ((_hd60106046_ (##car _hd60086039_))
                                        (_tl60116048_ (##cdr _hd60086039_)))
                                    (let* ((_pkg6051_ _hd60106046_)
                                           (_desc6053_ _tl60116048_)
                                           (_rest6055_ _tl60096041_))
                                      (_K60076036_
                                       _rest6055_
                                       _desc6053_
                                       _pkg6051_
                                       _hd6044_)))
                                  (_else60056021_))))
                          (_else60056021_))))))
               (_display-pkgs5941_
                (lambda (_alst5947_)
                  (let ((_iterable5980_ _alst5947_)
                        (_iter-do5982_
                         (lambda (_val5949_)
                           (let* ((_val59515958_ _val5949_)
                                  (_E59535962_
                                   (lambda ()
                                     (error '"No clause matching"
                                            _val59515958_)))
                                  (_K59545968_
                                   (lambda (_desc5965_ _pkg5966_)
                                     (displayln _pkg5966_ '": " _desc5965_))))
                             (if (##pair? _val59515958_)
                                 (let ((_hd59555971_ (##car _val59515958_))
                                       (_tl59565973_ (##cdr _val59515958_)))
                                   (let* ((_pkg5976_ _hd59555971_)
                                          (_desc5978_ _tl59565973_))
                                     (_K59545968_ _desc5978_ _pkg5976_)))
                                 (_E59535962_))))))
                    (if (pair? _iterable5980_)
                        (for-each _iter-do5982_ _iterable5980_)
                        (let ((_$e5985_ (null? _iterable5980_)))
                          (if _$e5985_
                              _$e5985_
                              (let ((_it5988_ (std/iter#iter _iterable5980_)))
                                (let _lp5991_ ()
                                  (let ((_val5995_
                                         (std/iter#iter-next! _it5988_)))
                                    (if (eq? std/iter#iter-end _val5995_)
                                        '#!void
                                        (begin
                                          (_iter-do5982_ _val5995_)
                                          (_lp5991_)))))
                                (std/iter#iter-fini! _it5988_)
                                '#!void))))))))
        (let ((_alst5943_ (gerbil/tools/gxpkg#pkg-directory-list)))
          (if (null? _keywords5938_)
              (_display-pkgs5941_ _alst5943_)
              (let ((_matches5945_ (_search5940_ _alst5943_)))
                (_display-pkgs5941_ _matches5945_)))))))
  (define gerbil/tools/gxpkg#+pkg-directory+
    '"https://raw.githubusercontent.com/vyzo/gerbil-directory/master/README.md")
  (define gerbil/tools/gxpkg#pkg-directory-list
    (lambda ()
      (let* ((_txt5800_
              (std/net/request#request-text
               (std/net/request#http-get__%
                '#f
                absent-value
                absent-value
                absent-value
                absent-value
                gerbil/tools/gxpkg#+pkg-directory+)))
             (_lines5802_ (string-split _txt5800_ '#\newline)))
        (let _lp5805_ ((_rest5807_ _lines5802_))
          (let* ((_rest58085815_ _rest5807_)
                 (_E58105819_
                  (lambda () (error '"No clause matching" _rest58085815_)))
                 (_K58115926_
                  (lambda (_rest5822_ _hd5823_)
                    (if (equal? _hd5823_ '"<!-- begin-pkg -->")
                        (let _lp25825_ ((_rest5827_ (cddr _rest5822_))
                                        (_pkgs5828_ '()))
                          (let* ((_rest58295836_ _rest5827_)
                                 (_E58315840_
                                  (lambda ()
                                    (error '"No clause matching"
                                           _rest58295836_)))
                                 (_K58325914_
                                  (lambda (_rest5843_ _hd5844_)
                                    (if (equal? _hd5844_ '"<!-- end-pkg -->")
                                        (reverse _pkgs5828_)
                                        (let* ((_g58455856_
                                                (string-split _hd5844_ '#\|))
                                               (_E58475860_
                                                (lambda ()
                                                  (error '"No clause matching"
                                                         _g58455856_)))
                                               (_K58485896_
                                                (lambda (_pkg-desc5863_
                                                         _pkg-link5864_)
                                                  (let* ((_g58655874_
                                                          (std/pregexp#pregexp-match
                                                           '"\\[([^]]+)\\]"
                                                           _pkg-link5864_))
                                                         (_E58675878_
                                                          (lambda ()
                                                            (error '"No clause matching"
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                           _g58655874_)))
                 (_K58685883_
                  (lambda (_pkg5881_)
                    (_lp25825_
                     _rest5843_
                     (cons (cons _pkg5881_
                                 (std/srfi/13#string-trim__0 _pkg-desc5863_))
                           _pkgs5828_)))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                    (if (##pair? _g58655874_)
                                                        (let ((_tl58705886_
                                                               (##cdr _g58655874_)))
                                                          (if (##pair? _tl58705886_)
                                                              (let ((_hd58715889_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                             (##car _tl58705886_))
                            (_tl58725891_ (##cdr _tl58705886_)))
                        (let ((_pkg5894_ _hd58715889_))
                          (if (##null? _tl58725891_)
                              (_K58685883_ _pkg5894_)
                              (_E58675878_))))
                      (_E58675878_)))
                (_E58675878_))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                          (if (##pair? _g58455856_)
                                              (let ((_tl58505899_
                                                     (##cdr _g58455856_)))
                                                (if (##pair? _tl58505899_)
                                                    (let ((_hd58515902_
                                                           (##car _tl58505899_))
                                                          (_tl58525904_
                                                           (##cdr _tl58505899_)))
                                                      (let ((_pkg-link5907_
                                                             _hd58515902_))
                                                        (if (##pair? _tl58525904_)
                                                            (let* ((_hd58535909_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                            (##car _tl58525904_))
                           (_pkg-desc5912_ _hd58535909_))
                      (_K58485896_ _pkg-desc5912_ _pkg-link5907_))
                    (_E58475860_))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                    (_E58475860_)))
                                              (_E58475860_)))))))
                            (if (##pair? _rest58295836_)
                                (let ((_hd58335917_ (##car _rest58295836_))
                                      (_tl58345919_ (##cdr _rest58295836_)))
                                  (let* ((_hd5922_ _hd58335917_)
                                         (_rest5924_ _tl58345919_))
                                    (_K58325914_ _rest5924_ _hd5922_)))
                                (_E58315840_))))
                        (_lp5805_ _rest5822_)))))
            (if (##pair? _rest58085815_)
                (let ((_hd58125929_ (##car _rest58085815_))
                      (_tl58135931_ (##cdr _rest58085815_)))
                  (let* ((_hd5934_ _hd58125929_) (_rest5936_ _tl58135931_))
                    (_K58115926_ _rest5936_ _hd5934_)))
                (_E58105819_)))))))
  (define gerbil/tools/gxpkg#+pkg-plist+ (make-table))
  (define gerbil/tools/gxpkg#pkg-plist
    (lambda (_pkg5782_)
      (let ((_$e5784_
             (table-ref gerbil/tools/gxpkg#+pkg-plist+ _pkg5782_ '#f)))
        (if _$e5784_
            (values _$e5784_)
            (let* ((_root5787_ (gerbil/tools/gxpkg#pkg-root-dir))
                   (_path5789_ (path-expand _pkg5782_ _root5787_))
                   (_gerbil.pkg5791_ (path-expand '"gerbil.pkg" _path5789_))
                   (_g7100_ (if (file-exists? _gerbil.pkg5791_)
                                '#!void
                                (error '"Bad package; missing gerbil.pkg"
                                       _pkg5782_)))
                   (_plist5794_ (call-with-input-file _gerbil.pkg5791_ read))
                   (_plist5796_
                    (if (eof-object? _plist5794_) '() _plist5794_)))
              (table-set! gerbil/tools/gxpkg#+pkg-plist+ _pkg5782_ _plist5796_)
              _plist5796_)))))
  (define gerbil/tools/gxpkg#pkg-build-script
    (lambda (_pkg5766_)
      (let* ((_root5768_ (gerbil/tools/gxpkg#pkg-root-dir))
             (_path5770_ (path-expand _pkg5766_ _root5768_))
             (_plist5772_ (gerbil/tools/gxpkg#pkg-plist _pkg5766_))
             (_build5774_ (pgetq 'build: _plist5772_))
             (_build.ss5779_
              (path-expand
               (let ((_$e5776_ _build5774_))
                 (if _$e5776_ _$e5776_ '"build.ss"))
               _path5770_)))
        (if (file-exists? _build.ss5779_)
            '#!void
            (error '"Bad package; missing build script"
                   _pkg5766_
                   _build.ss5779_))
        (path-normalize _build.ss5779_))))
  (define gerbil/tools/gxpkg#pkg-dependents__%
    (lambda (_pkg5744_ _pkgs5745_)
      (letrec ((_dependent5747_
                (lambda (_xpkg5749_)
                  (let* ((_plist5751_
                          (gerbil/tools/gxpkg#pkg-plist _xpkg5749_))
                         (_deps5753_ (pgetq 'depend: _plist5751_ '())))
                    (if (member _pkg5744_ _deps5753_) _xpkg5749_ '#f)))))
        (filter-map1 _dependent5747_ _pkgs5745_))))
  (define gerbil/tools/gxpkg#pkg-dependents__0
    (lambda (_pkg5759_)
      (let ((_pkgs5761_ (gerbil/tools/gxpkg#pkg-list)))
        (gerbil/tools/gxpkg#pkg-dependents__% _pkg5759_ _pkgs5761_))))
  (define gerbil/tools/gxpkg#pkg-dependents
    (lambda _g7102_
      (let ((_g7101_ (length _g7102_)))
        (cond ((##fx= _g7101_ 1)
               (apply gerbil/tools/gxpkg#pkg-dependents__0 _g7102_))
              ((##fx= _g7101_ 2)
               (apply gerbil/tools/gxpkg#pkg-dependents__% _g7102_))
              (else
               (##raise-wrong-number-of-arguments-exception
                gerbil/tools/gxpkg#pkg-dependents
                _g7102_))))))
  (define gerbil/tools/gxpkg#pkg-dependents*__%
    (lambda (_pkg5688_ _pkgs5689_)
      (let ((_deps5691_
             (gerbil/tools/gxpkg#pkg-dependents__% _pkg5688_ _pkgs5689_)))
        (let _lp5693_ ((_rest5695_ _deps5691_) (_r5696_ '()))
          (let* ((_rest56975705_ _rest5695_)
                 (_else56995713_ (lambda () _r5696_))
                 (_K57015721_
                  (lambda (_rest5716_ _pkg5717_)
                    (if (member _pkg5717_ _r5696_)
                        (_lp5693_ _rest5716_ _r5696_)
                        (let ((_deps5719_
                               (gerbil/tools/gxpkg#pkg-dependents__%
                                _pkg5717_
                                _pkgs5689_)))
                          (_lp5693_
                           (foldl1 cons _rest5716_ _deps5719_)
                           (cons _pkg5717_ _r5696_)))))))
            (if (##pair? _rest56975705_)
                (let ((_hd57025724_ (##car _rest56975705_))
                      (_tl57035726_ (##cdr _rest56975705_)))
                  (let* ((_pkg5729_ _hd57025724_) (_rest5731_ _tl57035726_))
                    (_K57015721_ _rest5731_ _pkg5729_)))
                (_else56995713_)))))))
  (define gerbil/tools/gxpkg#pkg-dependents*__0
    (lambda (_pkg5736_)
      (let ((_pkgs5738_ (gerbil/tools/gxpkg#pkg-list)))
        (gerbil/tools/gxpkg#pkg-dependents*__% _pkg5736_ _pkgs5738_))))
  (define gerbil/tools/gxpkg#pkg-dependents*
    (lambda _g7104_
      (let ((_g7103_ (length _g7104_)))
        (cond ((##fx= _g7103_ 1)
               (apply gerbil/tools/gxpkg#pkg-dependents*__0 _g7104_))
              ((##fx= _g7103_ 2)
               (apply gerbil/tools/gxpkg#pkg-dependents*__% _g7104_))
              (else
               (##raise-wrong-number-of-arguments-exception
                gerbil/tools/gxpkg#pkg-dependents*
                _g7104_))))))
  (define gerbil/tools/gxpkg#file-directory?
    (lambda (_path5685_) (eq? (file-type _path5685_) 'directory)))
  (define gerbil/tools/gxpkg#file-symbolic-link?
    (lambda (_path5683_)
      (eq? (file-info-type (file-info _path5683_ '#f)) 'symbolic-link))))
