/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.png;

import gnu.javax.imageio.png.PNGHeader;

public class PNGFilter {
    public static final byte FILTER_NONE = 0;
    public static final byte FILTER_SUB = 1;
    public static final byte FILTER_UP = 2;
    public static final byte FILTER_AVERAGE = 3;
    public static final byte FILTER_PAETH = 4;

    public static boolean useFilter(PNGHeader header) {
        switch (header.getColorType()) {
            case 3: {
                return false;
            }
            case 0: 
            case 2: {
                if (header.bytesPerPixel() > 1) break;
                return false;
            }
        }
        return true;
    }

    public static byte chooseFilter(byte[] scanline, byte[] lastScanline, int bpp) {
        long[] values = new long[5];
        int idx = 0;
        int i = 0;
        while (i < 5) {
            byte[] filtered = PNGFilter.filterScanline((byte)i, scanline, lastScanline, bpp);
            values[i] = 0L;
            int j = 0;
            while (j < filtered.length) {
                int n = i;
                values[n] = values[n] + (long)(filtered[j] & 0xFF);
                ++j;
            }
            if (values[idx] > values[i]) {
                idx = i;
            }
            ++i;
        }
        return (byte)idx;
    }

    public static byte[] filterScanline(byte filtertype, byte[] scanline, byte[] lastScanline, int bpp) {
        int stride = scanline.length;
        byte[] out = new byte[stride];
        switch (filtertype) {
            case 1: {
                int i = 0;
                while (i < bpp) {
                    out[i] = scanline[i];
                    ++i;
                }
                i = bpp;
                while (i < stride) {
                    out[i] = (byte)(scanline[i] - scanline[i - bpp]);
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < stride) {
                    out[i] = (byte)(scanline[i] - lastScanline[i]);
                    ++i;
                }
                break;
            }
            case 3: {
                int i = 0;
                while (i < bpp) {
                    out[i] = (byte)((scanline[i] & 0xFF) - ((lastScanline[i] & 0xFF) >> 1));
                    ++i;
                }
                i = bpp;
                while (i < stride) {
                    out[i] = (byte)((scanline[i] & 0xFF) - ((scanline[i - bpp] & 0xFF) + (lastScanline[i] & 0xFF) >> 1));
                    ++i;
                }
                break;
            }
            case 4: {
                int i = 0;
                while (i < stride) {
                    int pc;
                    int c;
                    int a;
                    if (i >= bpp) {
                        a = scanline[i - bpp] & 0xFF;
                        c = lastScanline[i - bpp] & 0xFF;
                    } else {
                        c = 0;
                        a = 0;
                    }
                    int b = lastScanline[i] & 0xFF;
                    int p = a + b - c;
                    int pa = p > a ? p - a : a - p;
                    int pb = p > b ? p - b : b - p;
                    int n = pc = p > c ? p - c : c - p;
                    int x = pa <= pb && pa <= pc ? a : (pb <= pc ? b : c);
                    out[i] = (byte)(scanline[i] - x);
                    ++i;
                }
                break;
            }
            default: {
                return scanline;
            }
        }
        return out;
    }

    public static byte[] unFilterScanline(int filtertype, byte[] scanline, byte[] lastScanline, int bpp) {
        int stride = scanline.length;
        byte[] out = new byte[stride];
        switch (filtertype) {
            case 0: {
                System.arraycopy(scanline, 0, out, 0, stride);
                break;
            }
            case 1: {
                int i = 0;
                while (i < bpp) {
                    out[i] = scanline[i];
                    ++i;
                }
                i = bpp;
                while (i < stride) {
                    out[i] = (byte)(scanline[i] + out[i - bpp]);
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < stride) {
                    out[i] = (byte)(scanline[i] + lastScanline[i]);
                    ++i;
                }
                break;
            }
            case 3: {
                int i = 0;
                while (i < bpp) {
                    out[i] = (byte)((scanline[i] & 0xFF) + ((lastScanline[i] & 0xFF) >> 1));
                    ++i;
                }
                i = bpp;
                while (i < stride) {
                    out[i] = (byte)((scanline[i] & 0xFF) + ((out[i - bpp] & 0xFF) + (lastScanline[i] & 0xFF) >> 1));
                    ++i;
                }
                break;
            }
            case 4: {
                int i = 0;
                while (i < stride) {
                    int pc;
                    int c;
                    int a;
                    if (i >= bpp) {
                        a = out[i - bpp] & 0xFF;
                        c = lastScanline[i - bpp] & 0xFF;
                    } else {
                        c = 0;
                        a = 0;
                    }
                    int b = lastScanline[i] & 0xFF;
                    int p = a + b - c;
                    int pa = p > a ? p - a : a - p;
                    int pb = p > b ? p - b : b - p;
                    int n = pc = p > c ? p - c : c - p;
                    int x = pa <= pb && pa <= pc ? a : (pb <= pc ? b : c);
                    out[i] = (byte)(scanline[i] + x);
                    ++i;
                }
                break;
            }
        }
        return out;
    }
}

