/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.sasl.crammd5;

import gnu.java.lang.CPStringBuilder;
import gnu.java.security.util.Util;
import gnu.javax.crypto.mac.HMacFactory;
import gnu.javax.crypto.mac.IMac;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.util.HashMap;
import javax.security.sasl.SaslException;

class CramMD5Util {
    private CramMD5Util() {
    }

    static byte[] createMsgID() throws SaslException {
        byte[] result;
        String encoded;
        try {
            encoded = Util.toBase64(Thread.currentThread().getName().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException x) {
            throw new SaslException("createMsgID()", x);
        }
        String hostname = "localhost";
        try {
            hostname = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {}
        try {
            result = new CPStringBuilder("<").append(encoded.substring(0, encoded.length())).append(".").append(String.valueOf(System.currentTimeMillis())).append("@").append(hostname).append(">").toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException x) {
            throw new SaslException("createMsgID()", x);
        }
        return result;
    }

    static byte[] createHMac(char[] passwd, byte[] data) throws InvalidKeyException, SaslException {
        byte[] km;
        IMac mac = HMacFactory.getInstance("hmac-md5");
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        try {
            km = new String(passwd).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException x) {
            throw new SaslException("createHMac()", x);
        }
        map.put("gnu.crypto.mac.key.material", km);
        mac.init(map);
        mac.update(data, 0, data.length);
        return mac.digest();
    }
}

