/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.activation;

import gnu.java.rmi.activation.ActivationSystemTransient;
import gnu.java.rmi.server.ActivatableServerRef;
import gnu.java.rmi.server.UnicastServer;
import java.lang.reflect.Constructor;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.UnknownObjectException;

public class DefaultActivationGroup
extends ActivationGroup {
    private static final long serialVersionUID = 1L;
    static final Class[] cConstructorTypes = new Class[]{ActivationID.class, MarshalledObject.class};

    public DefaultActivationGroup(ActivationGroupID id, MarshalledObject data) throws RemoteException {
        super(id);
    }

    public void activeObject(ActivationID id, Remote obj) throws ActivationException, UnknownObjectException, RemoteException {
    }

    public MarshalledObject newInstance(ActivationID id, ActivationDesc desc) throws ActivationException, RemoteException {
        try {
            if (ActivationSystemTransient.debug) {
                System.out.println("Instantiating " + desc.getClassName());
            }
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> objectClass = loader.loadClass(desc.getClassName());
            Constructor<?> constructor = objectClass.getConstructor(cConstructorTypes);
            Remote object = (Remote)constructor.newInstance(id, desc.getData());
            ActivatableServerRef ref = UnicastServer.getActivatableRef(id);
            Remote stub = ref.exportObject(object);
            MarshalledObject<Remote> marsh = new MarshalledObject<Remote>(stub);
            this.activeObject(id, marsh);
            this.activeObject(id, stub);
            return marsh;
        }
        catch (Exception e) {
            ActivationException acex = new ActivationException("Unable to activate " + desc.getClassName() + " from " + desc.getLocation(), e);
            throw acex;
        }
    }
}

