/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.dnd;

import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.event.MouseEvent;

public class GtkMouseDragGestureRecognizer
extends MouseDragGestureRecognizer {
    public GtkMouseDragGestureRecognizer(DragSource ds) {
        this(ds, null, 0, null);
    }

    public GtkMouseDragGestureRecognizer(DragSource ds, Component c) {
        this(ds, c, 0, null);
    }

    public GtkMouseDragGestureRecognizer(DragSource ds, Component c, int act) {
        this(ds, c, act, null);
    }

    public GtkMouseDragGestureRecognizer(DragSource ds, Component c, int act, DragGestureListener dgl) {
        super(ds, c, act, dgl);
    }

    public void registerListeners() {
        super.registerListeners();
    }

    public void unregisterListeners() {
        super.unregisterListeners();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.events.clear();
        if (this.getDropActionFromEvent(e) != 0) {
            this.appendEvent(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.events.clear();
    }

    public void mouseEntered(MouseEvent e) {
        this.events.clear();
    }

    public void mouseExited(MouseEvent e) {
        if (!this.events.isEmpty() && this.getDropActionFromEvent(e) == 0) {
            this.events.clear();
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (!this.events.isEmpty()) {
            int act = this.getDropActionFromEvent(e);
            if (act == 0) {
                return;
            }
            Point origin = ((MouseEvent)this.events.get(0)).getPoint();
            Point current = e.getPoint();
            int dx = Math.abs(origin.x - current.x);
            int dy = Math.abs(origin.y - current.y);
            int threshold = DragSource.getDragThreshold();
            if (dx > threshold || dy > threshold) {
                this.fireDragGestureRecognized(act, origin);
            } else {
                this.appendEvent(e);
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    private int getDropActionFromEvent(MouseEvent e) {
        int modEx = e.getModifiersEx();
        int buttons = modEx & 0x1C00;
        if (buttons != 1024 && buttons != 2048) {
            return 0;
        }
        int sourceActions = this.getSourceActions();
        int mod = modEx & 0xC0;
        switch (mod) {
            case 192: {
                return 0x40000000 & sourceActions;
            }
            case 128: {
                return 1 & sourceActions;
            }
            case 64: {
                return 2 & sourceActions;
            }
        }
        if ((sourceActions & 2) != 0) {
            return 2 & sourceActions;
        }
        if ((sourceActions & 1) != 0) {
            return 1 & sourceActions;
        }
        if ((sourceActions & 0x40000000) != 0) {
            return 0x40000000 & sourceActions;
        }
        return 0;
    }
}

