/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.config.ConfigUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class RememberMeBeanDefinitionParser
implements BeanDefinitionParser {
    static final String ATT_KEY = "key";
    static final String DEF_KEY = "SpringSecured";
    static final String ATT_DATA_SOURCE = "data-source-ref";
    static final String ATT_SERVICES_REF = "services-ref";
    static final String ATT_TOKEN_REPOSITORY = "token-repository-ref";
    static final String ATT_USER_SERVICE_REF = "user-service-ref";
    static final String ATT_TOKEN_VALIDITY = "token-validity-seconds";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String servicesName;
    static /* synthetic */ Class class$org$springframework$security$ui$rememberme$PersistentTokenBasedRememberMeServices;
    static /* synthetic */ Class class$org$springframework$security$ui$rememberme$JdbcTokenRepositoryImpl;
    static /* synthetic */ Class class$org$springframework$security$ui$rememberme$TokenBasedRememberMeServices;
    static /* synthetic */ Class class$org$springframework$security$providers$rememberme$RememberMeAuthenticationProvider;
    static /* synthetic */ Class class$org$springframework$security$ui$rememberme$RememberMeProcessingFilter;

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        boolean isPersistent;
        String tokenRepository = null;
        String dataSource = null;
        String key = null;
        Object source = null;
        String userServiceRef = null;
        String rememberMeServicesRef = null;
        String tokenValiditySeconds = null;
        if (element != null) {
            tokenRepository = element.getAttribute(ATT_TOKEN_REPOSITORY);
            dataSource = element.getAttribute(ATT_DATA_SOURCE);
            key = element.getAttribute(ATT_KEY);
            userServiceRef = element.getAttribute(ATT_USER_SERVICE_REF);
            rememberMeServicesRef = element.getAttribute(ATT_SERVICES_REF);
            tokenValiditySeconds = element.getAttribute(ATT_TOKEN_VALIDITY);
            source = parserContext.extractSource((Object)element);
        }
        if (!StringUtils.hasText(key)) {
            key = DEF_KEY;
        }
        RootBeanDefinition services = null;
        boolean dataSourceSet = StringUtils.hasText(dataSource);
        boolean tokenRepoSet = StringUtils.hasText((String)tokenRepository);
        boolean servicesRefSet = StringUtils.hasText(rememberMeServicesRef);
        boolean userServiceSet = StringUtils.hasText((String)userServiceRef);
        boolean tokenValiditySet = StringUtils.hasText(tokenValiditySeconds);
        if (servicesRefSet && (dataSourceSet || tokenRepoSet || userServiceSet || tokenValiditySet)) {
            parserContext.getReaderContext().error("services-ref can't be used in combination with attributes token-repository-ref,data-source-ref, user-service-ref or token-validity-seconds", source);
        }
        if (dataSourceSet && tokenRepoSet) {
            parserContext.getReaderContext().error("Specify token-repository-ref or data-source-ref but not both", source);
        }
        if (isPersistent = dataSourceSet | tokenRepoSet) {
            RuntimeBeanReference tokenRepo;
            services = new RootBeanDefinition(class$org$springframework$security$ui$rememberme$PersistentTokenBasedRememberMeServices == null ? (class$org$springframework$security$ui$rememberme$PersistentTokenBasedRememberMeServices = RememberMeBeanDefinitionParser.class$("org.springframework.security.ui.rememberme.PersistentTokenBasedRememberMeServices")) : class$org$springframework$security$ui$rememberme$PersistentTokenBasedRememberMeServices);
            if (tokenRepoSet) {
                tokenRepo = new RuntimeBeanReference(tokenRepository);
            } else {
                tokenRepo = new RootBeanDefinition(class$org$springframework$security$ui$rememberme$JdbcTokenRepositoryImpl == null ? (class$org$springframework$security$ui$rememberme$JdbcTokenRepositoryImpl = RememberMeBeanDefinitionParser.class$("org.springframework.security.ui.rememberme.JdbcTokenRepositoryImpl")) : class$org$springframework$security$ui$rememberme$JdbcTokenRepositoryImpl);
                ((BeanDefinition)tokenRepo).getPropertyValues().addPropertyValue("dataSource", (Object)new RuntimeBeanReference(dataSource));
            }
            services.getPropertyValues().addPropertyValue("tokenRepository", (Object)tokenRepo);
        } else if (!servicesRefSet) {
            services = new RootBeanDefinition(class$org$springframework$security$ui$rememberme$TokenBasedRememberMeServices == null ? (class$org$springframework$security$ui$rememberme$TokenBasedRememberMeServices = RememberMeBeanDefinitionParser.class$("org.springframework.security.ui.rememberme.TokenBasedRememberMeServices")) : class$org$springframework$security$ui$rememberme$TokenBasedRememberMeServices);
        }
        if (services != null) {
            if (userServiceSet) {
                services.getPropertyValues().addPropertyValue("userDetailsService", (Object)new RuntimeBeanReference(userServiceRef));
            }
            if (tokenValiditySet) {
                services.getPropertyValues().addPropertyValue("tokenValiditySeconds", (Object)new Integer(tokenValiditySeconds));
            }
            services.setSource(source);
            services.getPropertyValues().addPropertyValue(ATT_KEY, (Object)key);
            parserContext.getRegistry().registerBeanDefinition("_rememberMeServices", (BeanDefinition)services);
            this.servicesName = "_rememberMeServices";
        } else {
            this.servicesName = rememberMeServicesRef;
            parserContext.getRegistry().registerAlias(rememberMeServicesRef, "_rememberMeServices");
        }
        this.registerProvider(parserContext, source, key);
        this.registerFilter(parserContext, source);
        return null;
    }

    String getServicesName() {
        return this.servicesName;
    }

    private void registerProvider(ParserContext pc, Object source, String key) {
        RootBeanDefinition provider = new RootBeanDefinition(class$org$springframework$security$providers$rememberme$RememberMeAuthenticationProvider == null ? (class$org$springframework$security$providers$rememberme$RememberMeAuthenticationProvider = RememberMeBeanDefinitionParser.class$("org.springframework.security.providers.rememberme.RememberMeAuthenticationProvider")) : class$org$springframework$security$providers$rememberme$RememberMeAuthenticationProvider);
        provider.setSource(source);
        provider.getPropertyValues().addPropertyValue(ATT_KEY, (Object)key);
        pc.getRegistry().registerBeanDefinition("_rememberMeAuthenticationProvider", (BeanDefinition)provider);
        ConfigUtils.addAuthenticationProvider(pc, "_rememberMeAuthenticationProvider");
    }

    private void registerFilter(ParserContext pc, Object source) {
        RootBeanDefinition filter = new RootBeanDefinition(class$org$springframework$security$ui$rememberme$RememberMeProcessingFilter == null ? (class$org$springframework$security$ui$rememberme$RememberMeProcessingFilter = RememberMeBeanDefinitionParser.class$("org.springframework.security.ui.rememberme.RememberMeProcessingFilter")) : class$org$springframework$security$ui$rememberme$RememberMeProcessingFilter);
        filter.setSource(source);
        filter.getPropertyValues().addPropertyValue("authenticationManager", (Object)new RuntimeBeanReference("_authenticationManager"));
        filter.getPropertyValues().addPropertyValue("rememberMeServices", (Object)new RuntimeBeanReference("_rememberMeServices"));
        pc.getRegistry().registerBeanDefinition("_rememberMeFilter", (BeanDefinition)filter);
        ConfigUtils.addHttpFilter(pc, (BeanMetadataElement)new RuntimeBeanReference("_rememberMeFilter"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

