%% Generated by lilypond-book.py
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}





% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "overriding-articulations-of-destinct-type.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it is automatically
%% generated from LSR http://lsr.dsi.unimi.it
%% Make any changes in LSR itself, or in Documentation/snippets/new/ ,
%% and then run scripts/auxiliar/makelsr.py
%%
%% This file is in the public domain.
\version "2.17.25"

\header {
%% Translation of GIT committish: 56145dfed8f19bb34459d5b40cab388776d2ec49
  texidoces = "
A veces queremos modificar un solo timpo de articulación.  Aunque
siempre es posible usar la instrucción @code{\\tweak}, podría hacerse
tedioso hacerlo para todos y cada uno de los símbolos de una partitura
completa.  El ejemplo muestra cómo trucar articulaciones con una lista
de ajustes personalizados.  Un caso sería la creación de una hoja de
estilos.

Con 2.16.2 it es posible introducir la función propuesta,
@code{\\customScripts}, en un bloque @code{\\layout}.

"
  doctitlees = "Modificación de articulaciones de diversos tipos"

  lsrtags = "scheme-language, tweaks-and-overrides"

  texidoc = "
Sometimes you may want to affect a single articulation-type. Although
it is always possible to use @code{\\tweak}, it might become tedious to
do so for every single sign of a whole score. The following shows how
to tweak articulations with a list of custom-settings. One use-case
might be to create a style-sheet.

With 2.16.2 it is possible to put the proposed function,
@code{\\customScripts}, into a @code{\\layout}-block.

"
  doctitle = "Overriding articulations of destinct type"
} % begin verbatim

% Code by David Nalesnik and Thomas Morley

#(define (custom-script-tweaks ls)
  (lambda (grob)
    (let* ((type (ly:prob-property
                    (assoc-ref (ly:grob-properties grob) 'cause)
                    'articulation-type))
           (tweaks (assoc-ref ls type)))
      (if tweaks
          (for-each
            (lambda (x) (ly:grob-set-property! grob (car x) (cdr x)))
            tweaks)))))

customScripts =
#(define-music-function (parser location settings)(list?)
#{
  \override Script.before-line-breaking =
    #(custom-script-tweaks settings)
#})

revertCustomScripts = { \revert Script.before-line-breaking }

%%%%%%%%%%%%%
% Example:
%%%%%%%%%%%%%

% Predefine a list of desired tweaks.
#(define my-settings-1
  '(
    ("staccato" . ((color . (1 0 0))(padding . 0.5)))
    ("accent" . ((font-size . 0)(color . (1 0 0))))
    ("tenuto" . ((rotation . (45 0 0)) (padding . 2)(font-size . 10)))
    ("staccatissimo" . ((padding . 1) (color . (1 0 0))))
    ("segno" . ((font-size . 0)(color . (1 0 0))))
    ))

#(define my-settings-2
  '(
    ("staccato" . ((color . (0 1 0))))
    ("accent" . ((font-size . 4)(color . (0 1 0))(padding . 1.5)))
    ("tenuto" . ((font-size . 10)))
    ("staccatissimo" . ((padding . 2) (color . (0 1 0))))
    ("coda" . ((color . (0 1 0)) (padding . 1)))
    ))

one =
\relative c'' {
  f1--
  \customScripts #my-settings-1
  f-. f-! f-> f-- f-!\segno
  \revertCustomScripts
  f-> f-.
}

two =
\relative c' {
  f1--
  \customScripts #my-settings-2
  f-. f-! f-> f---> f-!
  f-> f-.\coda
}

\new Staff <<
   \new Voice { \voiceOne \one }
   \new Voice { \voiceTwo \two }
   >>



% ****************************************************************
% end ly snippet
% ****************************************************************
