/*
 * Decompiled with CFR 0.152.
 */
package basic;

import elements.Brick;
import elements.Corner;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import values.Settings;

public class Layout
implements LayoutManager {
    public static final int CORNER = 3;
    public static final int FIELD = 10;
    public static final int MAX = 16;
    private Brick[][] bricks = new Brick[16][16];
    private Corner[][] corners = new Corner[2][2];

    public Layout() {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                this.bricks[i][j] = null;
            }
        }
    }

    public void addLayoutComponent(String string, Component component) {
        String[] stringArray = string.split(",");
        if ("corner".equals(stringArray[0])) {
            int n = Integer.parseInt(stringArray[1]);
            int n2 = Integer.parseInt(stringArray[2]);
            this.corners[n][n2] = (Corner)component;
        } else {
            int n = Integer.parseInt(stringArray[0]);
            int n3 = Integer.parseInt(stringArray[1]);
            this.bricks[n][n3] = (Brick)component;
        }
    }

    public void removeLayoutComponent(Component component) {
        Point point = this.getPosition((Brick)component);
        if (point != null) {
            this.bricks[point.x][point.y] = null;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        int n = 16 * Settings.getBrickSize();
        int n2 = 16 * Settings.getBrickSize();
        return new Dimension(n, n2);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.minimumLayoutSize(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n;
            int n2 = Settings.getBrickSize();
            int n3 = Settings.getBrickSize();
            int n4 = (container.getWidth() - n2 * 16) / 2;
            int n5 = (container.getHeight() - n3 * 16) / 2;
            Insets insets = container.getInsets();
            int n6 = container.getComponentCount();
            if (n6 == 0) {
                return;
            }
            int n7 = insets.left + n4;
            for (n = 0; n < 16; ++n) {
                int n8 = insets.top + n5;
                for (int i = 0; i < 16; ++i) {
                    if (this.bricks[n][i] != null) {
                        this.bricks[n][i].setBounds(n7, n8, n2, n3);
                    }
                    n8 += n2;
                }
                n7 += n3;
            }
            for (n = 0; n < 2; ++n) {
                for (n7 = 0; n7 < 2; ++n7) {
                    this.corners[n][n7].setBounds(13 * n2 * n + n4, 13 * n3 * n7 + n5, n2 * 3, n3 * 3);
                }
            }
        }
    }

    public Point getPosition(Brick brick) {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                if (this.bricks[i][j] != brick) continue;
                return new Point(i, j);
            }
        }
        return null;
    }

    public boolean isBorder(Brick brick) {
        Point point = this.getPosition(brick);
        return point.x == 2 || point.x == 13 || point.y == 2 || point.y == 13;
    }

    public Brick getBrick(int n, int n2) {
        return this.bricks[n][n2];
    }
}

