"""Generated message classes for vision version v1.

Integrates Google Vision features, including image labeling, face, logo, and
landmark detection, optical character recognition (OCR), and detection of
explicit content, into applications.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'vision'


class AnnotateImageRequest(_messages.Message):
  """Request for performing Google Cloud Vision API tasks over a user-provided
  image, with user-requested features.

  Fields:
    features: Requested features.
    image: The image to be processed.
    imageContext: Additional context that may accompany the image.
  """

  features = _messages.MessageField('Feature', 1, repeated=True)
  image = _messages.MessageField('Image', 2)
  imageContext = _messages.MessageField('ImageContext', 3)


class AnnotateImageResponse(_messages.Message):
  """Response to an image annotation request.

  Fields:
    cropHintsAnnotation: If present, crop hints have completed successfully.
    error: If set, represents the error message for the operation. Note that
      filled-in image annotations are guaranteed to be correct, even when
      `error` is set.
    faceAnnotations: If present, face detection has completed successfully.
    fullTextAnnotation: If present, text (OCR) detection or document (OCR)
      text detection has completed successfully. This annotation provides the
      structural hierarchy for the OCR detected text.
    imagePropertiesAnnotation: If present, image properties were extracted
      successfully.
    labelAnnotations: If present, label detection has completed successfully.
    landmarkAnnotations: If present, landmark detection has completed
      successfully.
    logoAnnotations: If present, logo detection has completed successfully.
    safeSearchAnnotation: If present, safe-search annotation has completed
      successfully.
    textAnnotations: If present, text (OCR) detection has completed
      successfully.
    webDetection: If present, web detection has completed successfully.
  """

  cropHintsAnnotation = _messages.MessageField('CropHintsAnnotation', 1)
  error = _messages.MessageField('Status', 2)
  faceAnnotations = _messages.MessageField('FaceAnnotation', 3, repeated=True)
  fullTextAnnotation = _messages.MessageField('TextAnnotation', 4)
  imagePropertiesAnnotation = _messages.MessageField('ImageProperties', 5)
  labelAnnotations = _messages.MessageField('EntityAnnotation', 6, repeated=True)
  landmarkAnnotations = _messages.MessageField('EntityAnnotation', 7, repeated=True)
  logoAnnotations = _messages.MessageField('EntityAnnotation', 8, repeated=True)
  safeSearchAnnotation = _messages.MessageField('SafeSearchAnnotation', 9)
  textAnnotations = _messages.MessageField('EntityAnnotation', 10, repeated=True)
  webDetection = _messages.MessageField('WebDetection', 11)


class BatchAnnotateImagesRequest(_messages.Message):
  """Multiple image annotation requests are batched into a single service
  call.

  Fields:
    requests: Individual image annotation requests for this batch.
  """

  requests = _messages.MessageField('AnnotateImageRequest', 1, repeated=True)


class BatchAnnotateImagesResponse(_messages.Message):
  """Response to a batch image annotation request.

  Fields:
    responses: Individual responses to image annotation requests within the
      batch.
  """

  responses = _messages.MessageField('AnnotateImageResponse', 1, repeated=True)


class Block(_messages.Message):
  """Logical element on the page.

  Enums:
    BlockTypeValueValuesEnum: Detected block type (text, image etc) for this
      block.

  Fields:
    blockType: Detected block type (text, image etc) for this block.
    boundingBox: The bounding box for the block. The vertices are in the order
      of top-left, top-right, bottom-right, bottom-left. When a rotation of
      the bounding box is detected the rotation is represented as around the
      top-left corner as defined when the text is read in the 'natural'
      orientation. For example:   * when the text is horizontal it might look
      like:      0----1      |    |      3----2   * when it's rotated 180
      degrees around the top-left corner it becomes:      2----3      |    |
      1----0   and the vertice order will still be (0, 1, 2, 3).
    paragraphs: List of paragraphs in this block (if this blocks is of type
      text).
    property: Additional information detected for the block.
  """

  class BlockTypeValueValuesEnum(_messages.Enum):
    """Detected block type (text, image etc) for this block.

    Values:
      UNKNOWN: Unknown block type.
      TEXT: Regular text block.
      TABLE: Table block.
      PICTURE: Image block.
      RULER: Horizontal/vertical line box.
      BARCODE: Barcode block.
    """
    UNKNOWN = 0
    TEXT = 1
    TABLE = 2
    PICTURE = 3
    RULER = 4
    BARCODE = 5

  blockType = _messages.EnumField('BlockTypeValueValuesEnum', 1)
  boundingBox = _messages.MessageField('BoundingPoly', 2)
  paragraphs = _messages.MessageField('Paragraph', 3, repeated=True)
  property = _messages.MessageField('TextProperty', 4)


class BoundingPoly(_messages.Message):
  """A bounding polygon for the detected image annotation.

  Fields:
    vertices: The bounding polygon vertices.
  """

  vertices = _messages.MessageField('Vertex', 1, repeated=True)


class Color(_messages.Message):
  """Represents a color in the RGBA color space. This representation is
  designed for simplicity of conversion to/from color representations in
  various languages over compactness; for example, the fields of this
  representation can be trivially provided to the constructor of
  "java.awt.Color" in Java; it can also be trivially provided to UIColor's
  "+colorWithRed:green:blue:alpha" method in iOS; and, with just a little
  work, it can be easily formatted into a CSS "rgba()" string in JavaScript,
  as well. Here are some examples:  Example (Java):       import
  com.google.type.Color;       // ...      public static java.awt.Color
  fromProto(Color protocolor) {        float alpha = protocolor.hasAlpha()
  ? protocolor.getAlpha().getValue()            : 1.0;         return new
  java.awt.Color(            protocolor.getRed(),
  protocolor.getGreen(),            protocolor.getBlue(),            alpha);
  }       public static Color toProto(java.awt.Color color) {        float red
  = (float) color.getRed();        float green = (float) color.getGreen();
  float blue = (float) color.getBlue();        float denominator = 255.0;
  Color.Builder resultBuilder =            Color                .newBuilder()
  .setRed(red / denominator)                .setGreen(green / denominator)
  .setBlue(blue / denominator);        int alpha = color.getAlpha();        if
  (alpha != 255) {          result.setAlpha(              FloatValue
  .newBuilder()                  .setValue(((float) alpha) / denominator)
  .build());        }        return resultBuilder.build();      }      // ...
  Example (iOS / Obj-C):       // ...      static UIColor* fromProto(Color*
  protocolor) {         float red = [protocolor red];         float green =
  [protocolor green];         float blue = [protocolor blue];
  FloatValue* alpha_wrapper = [protocolor alpha];         float alpha = 1.0;
  if (alpha_wrapper != nil) {           alpha = [alpha_wrapper value];
  }         return [UIColor colorWithRed:red green:green blue:blue
  alpha:alpha];      }       static Color* toProto(UIColor* color) {
  CGFloat red, green, blue, alpha;          if (![color getRed:&red
  green:&green blue:&blue alpha:&alpha]) {            return nil;          }
  Color* result = [Color alloc] init];          [result setRed:red];
  [result setGreen:green];          [result setBlue:blue];          if (alpha
  <= 0.9999) {            [result setAlpha:floatWrapperWithValue(alpha)];
  }          [result autorelease];          return result;     }     // ...
  Example (JavaScript):      // ...      var protoToCssColor =
  function(rgb_color) {        var redFrac = rgb_color.red || 0.0;        var
  greenFrac = rgb_color.green || 0.0;        var blueFrac = rgb_color.blue ||
  0.0;        var red = Math.floor(redFrac * 255);        var green =
  Math.floor(greenFrac * 255);        var blue = Math.floor(blueFrac * 255);
  if (!('alpha' in rgb_color)) {           return rgbToCssColor_(red, green,
  blue);        }         var alphaFrac = rgb_color.alpha.value || 0.0;
  var rgbParams = [red, green, blue].join(',');        return ['rgba(',
  rgbParams, ',', alphaFrac, ')'].join('');     };      var rgbToCssColor_ =
  function(red, green, blue) {       var rgbNumber = new Number((red << 16) |
  (green << 8) | blue);       var hexString = rgbNumber.toString(16);
  var missingZeros = 6 - hexString.length;       var resultBuilder = ['#'];
  for (var i = 0; i < missingZeros; i++) {          resultBuilder.push('0');
  }       resultBuilder.push(hexString);       return resultBuilder.join('');
  };      // ...

  Fields:
    alpha: The fraction of this color that should be applied to the pixel.
      That is, the final pixel color is defined by the equation:    pixel
      color = alpha * (this color) + (1.0 - alpha) * (background color)  This
      means that a value of 1.0 corresponds to a solid color, whereas a value
      of 0.0 corresponds to a completely transparent color. This uses a
      wrapper message rather than a simple float scalar so that it is possible
      to distinguish between a default value and the value being unset. If
      omitted, this color object is to be rendered as a solid color (as if the
      alpha value had been explicitly given with a value of 1.0).
    blue: The amount of blue in the color as a value in the interval [0, 1].
    green: The amount of green in the color as a value in the interval [0, 1].
    red: The amount of red in the color as a value in the interval [0, 1].
  """

  alpha = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  blue = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  green = _messages.FloatField(3, variant=_messages.Variant.FLOAT)
  red = _messages.FloatField(4, variant=_messages.Variant.FLOAT)


class ColorInfo(_messages.Message):
  """Color information consists of RGB channels, score, and the fraction of
  the image that the color occupies in the image.

  Fields:
    color: RGB components of the color.
    pixelFraction: The fraction of pixels the color occupies in the image.
      Value in range [0, 1].
    score: Image-specific score for this color. Value in range [0, 1].
  """

  color = _messages.MessageField('Color', 1)
  pixelFraction = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  score = _messages.FloatField(3, variant=_messages.Variant.FLOAT)


class CropHint(_messages.Message):
  """Single crop hint that is used to generate a new crop when serving an
  image.

  Fields:
    boundingPoly: The bounding polygon for the crop region. The coordinates of
      the bounding box are in the original image's scale, as returned in
      `ImageParams`.
    confidence: Confidence of this being a salient region.  Range [0, 1].
    importanceFraction: Fraction of importance of this salient region with
      respect to the original image.
  """

  boundingPoly = _messages.MessageField('BoundingPoly', 1)
  confidence = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  importanceFraction = _messages.FloatField(3, variant=_messages.Variant.FLOAT)


class CropHintsAnnotation(_messages.Message):
  """Set of crop hints that are used to generate new crops when serving
  images.

  Fields:
    cropHints: Crop hint results.
  """

  cropHints = _messages.MessageField('CropHint', 1, repeated=True)


class CropHintsParams(_messages.Message):
  """Parameters for crop hints annotation request.

  Fields:
    aspectRatios: Aspect ratios in floats, representing the ratio of the width
      to the height of the image. For example, if the desired aspect ratio is
      4/3, the corresponding float value should be 1.33333.  If not specified,
      the best possible crop is returned. The number of provided aspect ratios
      is limited to a maximum of 16; any aspect ratios provided after the 16th
      are ignored.
  """

  aspectRatios = _messages.FloatField(1, repeated=True, variant=_messages.Variant.FLOAT)


class DetectedBreak(_messages.Message):
  """Detected start or end of a structural component.

  Enums:
    TypeValueValuesEnum: Detected break type.

  Fields:
    isPrefix: True if break prepends the element.
    type: Detected break type.
  """

  class TypeValueValuesEnum(_messages.Enum):
    """Detected break type.

    Values:
      UNKNOWN: Unknown break label type.
      SPACE: Regular space.
      SURE_SPACE: Sure space (very wide).
      EOL_SURE_SPACE: Line-wrapping break.
      HYPHEN: End-line hyphen that is not present in text; does not co-occur
        with `SPACE`, `LEADER_SPACE`, or `LINE_BREAK`.
      LINE_BREAK: Line break that ends a paragraph.
    """
    UNKNOWN = 0
    SPACE = 1
    SURE_SPACE = 2
    EOL_SURE_SPACE = 3
    HYPHEN = 4
    LINE_BREAK = 5

  isPrefix = _messages.BooleanField(1)
  type = _messages.EnumField('TypeValueValuesEnum', 2)


class DetectedLanguage(_messages.Message):
  """Detected language for a structural component.

  Fields:
    confidence: Confidence of detected language. Range [0, 1].
    languageCode: The BCP-47 language code, such as "en-US" or "sr-Latn". For
      more information, see
      http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  languageCode = _messages.StringField(2)


class DominantColorsAnnotation(_messages.Message):
  """Set of dominant colors and their corresponding scores.

  Fields:
    colors: RGB color values with their score and pixel fraction.
  """

  colors = _messages.MessageField('ColorInfo', 1, repeated=True)


class EntityAnnotation(_messages.Message):
  """Set of detected entity features.

  Fields:
    boundingPoly: Image region to which this entity belongs. Not produced for
      `LABEL_DETECTION` features.
    confidence: The accuracy of the entity detection in an image. For example,
      for an image in which the "Eiffel Tower" entity is detected, this field
      represents the confidence that there is a tower in the query image.
      Range [0, 1].
    description: Entity textual description, expressed in its `locale`
      language.
    locale: The language code for the locale in which the entity textual
      `description` is expressed.
    locations: The location information for the detected entity. Multiple
      `LocationInfo` elements can be present because one location may indicate
      the location of the scene in the image, and another location may
      indicate the location of the place where the image was taken. Location
      information is usually present for landmarks.
    mid: Opaque entity ID. Some IDs may be available in [Google Knowledge
      Graph Search API](https://developers.google.com/knowledge-graph/).
    properties: Some entities may have optional user-supplied `Property`
      (name/value) fields, such a score or string that qualifies the entity.
    score: Overall score of the result. Range [0, 1].
    topicality: The relevancy of the ICA (Image Content Annotation) label to
      the image. For example, the relevancy of "tower" is likely higher to an
      image containing the detected "Eiffel Tower" than to an image containing
      a detected distant towering building, even though the confidence that
      there is a tower in each image may be the same. Range [0, 1].
  """

  boundingPoly = _messages.MessageField('BoundingPoly', 1)
  confidence = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  description = _messages.StringField(3)
  locale = _messages.StringField(4)
  locations = _messages.MessageField('LocationInfo', 5, repeated=True)
  mid = _messages.StringField(6)
  properties = _messages.MessageField('Property', 7, repeated=True)
  score = _messages.FloatField(8, variant=_messages.Variant.FLOAT)
  topicality = _messages.FloatField(9, variant=_messages.Variant.FLOAT)


class FaceAnnotation(_messages.Message):
  """A face annotation object contains the results of face detection.

  Enums:
    AngerLikelihoodValueValuesEnum: Anger likelihood.
    BlurredLikelihoodValueValuesEnum: Blurred likelihood.
    HeadwearLikelihoodValueValuesEnum: Headwear likelihood.
    JoyLikelihoodValueValuesEnum: Joy likelihood.
    SorrowLikelihoodValueValuesEnum: Sorrow likelihood.
    SurpriseLikelihoodValueValuesEnum: Surprise likelihood.
    UnderExposedLikelihoodValueValuesEnum: Under-exposed likelihood.

  Fields:
    angerLikelihood: Anger likelihood.
    blurredLikelihood: Blurred likelihood.
    boundingPoly: The bounding polygon around the face. The coordinates of the
      bounding box are in the original image's scale, as returned in
      `ImageParams`. The bounding box is computed to "frame" the face in
      accordance with human expectations. It is based on the landmarker
      results. Note that one or more x and/or y coordinates may not be
      generated in the `BoundingPoly` (the polygon will be unbounded) if only
      a partial face appears in the image to be annotated.
    detectionConfidence: Detection confidence. Range [0, 1].
    fdBoundingPoly: The `fd_bounding_poly` bounding polygon is tighter than
      the `boundingPoly`, and encloses only the skin part of the face.
      Typically, it is used to eliminate the face from any image analysis that
      detects the "amount of skin" visible in an image. It is not based on the
      landmarker results, only on the initial face detection, hence the
      <code>fd</code> (face detection) prefix.
    headwearLikelihood: Headwear likelihood.
    joyLikelihood: Joy likelihood.
    landmarkingConfidence: Face landmarking confidence. Range [0, 1].
    landmarks: Detected face landmarks.
    panAngle: Yaw angle, which indicates the leftward/rightward angle that the
      face is pointing relative to the vertical plane perpendicular to the
      image. Range [-180,180].
    rollAngle: Roll angle, which indicates the amount of clockwise/anti-
      clockwise rotation of the face relative to the image vertical about the
      axis perpendicular to the face. Range [-180,180].
    sorrowLikelihood: Sorrow likelihood.
    surpriseLikelihood: Surprise likelihood.
    tiltAngle: Pitch angle, which indicates the upwards/downwards angle that
      the face is pointing relative to the image's horizontal plane. Range
      [-180,180].
    underExposedLikelihood: Under-exposed likelihood.
  """

  class AngerLikelihoodValueValuesEnum(_messages.Enum):
    """Anger likelihood.

    Values:
      UNKNOWN: Unknown likelihood.
      VERY_UNLIKELY: It is very unlikely that the image belongs to the
        specified vertical.
      UNLIKELY: It is unlikely that the image belongs to the specified
        vertical.
      POSSIBLE: It is possible that the image belongs to the specified
        vertical.
      LIKELY: It is likely that the image belongs to the specified vertical.
      VERY_LIKELY: It is very likely that the image belongs to the specified
        vertical.
    """
    UNKNOWN = 0
    VERY_UNLIKELY = 1
    UNLIKELY = 2
    POSSIBLE = 3
    LIKELY = 4
    VERY_LIKELY = 5

  class BlurredLikelihoodValueValuesEnum(_messages.Enum):
    """Blurred likelihood.

    Values:
      UNKNOWN: Unknown likelihood.
      VERY_UNLIKELY: It is very unlikely that the image belongs to the
        specified vertical.
      UNLIKELY: It is unlikely that the image belongs to the specified
        vertical.
      POSSIBLE: It is possible that the image belongs to the specified
        vertical.
      LIKELY: It is likely that the image belongs to the specified vertical.
      VERY_LIKELY: It is very likely that the image belongs to the specified
        vertical.
    """
    UNKNOWN = 0
    VERY_UNLIKELY = 1
    UNLIKELY = 2
    POSSIBLE = 3
    LIKELY = 4
    VERY_LIKELY = 5

  class HeadwearLikelihoodValueValuesEnum(_messages.Enum):
    """Headwear likelihood.

    Values:
      UNKNOWN: Unknown likelihood.
      VERY_UNLIKELY: It is very unlikely that the image belongs to the
        specified vertical.
      UNLIKELY: It is unlikely that the image belongs to the specified
        vertical.
      POSSIBLE: It is possible that the image belongs to the specified
        vertical.
      LIKELY: It is likely that the image belongs to the specified vertical.
      VERY_LIKELY: It is very likely that the image belongs to the specified
        vertical.
    """
    UNKNOWN = 0
    VERY_UNLIKELY = 1
    UNLIKELY = 2
    POSSIBLE = 3
    LIKELY = 4
    VERY_LIKELY = 5

  class JoyLikelihoodValueValuesEnum(_messages.Enum):
    """Joy likelihood.

    Values:
      UNKNOWN: Unknown likelihood.
      VERY_UNLIKELY: It is very unlikely that the image belongs to the
        specified vertical.
      UNLIKELY: It is unlikely that the image belongs to the specified
        vertical.
      POSSIBLE: It is possible that the image belongs to the specified
        vertical.
      LIKELY: It is likely that the image belongs to the specified vertical.
      VERY_LIKELY: It is very likely that the image belongs to the specified
        vertical.
    """
    UNKNOWN = 0
    VERY_UNLIKELY = 1
    UNLIKELY = 2
    POSSIBLE = 3
    LIKELY = 4
    VERY_LIKELY = 5

  class SorrowLikelihoodValueValuesEnum(_messages.Enum):
    """Sorrow likelihood.

    Values:
      UNKNOWN: Unknown likelihood.
      VERY_UNLIKELY: It is very unlikely that the image belongs to the
        specified vertical.
      UNLIKELY: It is unlikely that the image belongs to the specified
        vertical.
      POSSIBLE: It is possible that the image belongs to the specified
        vertical.
      LIKELY: It is likely that the image belongs to the specified vertical.
      VERY_LIKELY: It is very likely that the image belongs to the specified
        vertical.
    """
    UNKNOWN = 0
    VERY_UNLIKELY = 1
    UNLIKELY = 2
    POSSIBLE = 3
    LIKELY = 4
    VERY_LIKELY = 5

  class SurpriseLikelihoodValueValuesEnum(_messages.Enum):
    """Surprise likelihood.

    Values:
      UNKNOWN: Unknown likelihood.
      VERY_UNLIKELY: It is very unlikely that the image belongs to the
        specified vertical.
      UNLIKELY: It is unlikely that the image belongs to the specified
        vertical.
      POSSIBLE: It is possible that the image belongs to the specified
        vertical.
      LIKELY: It is likely that the image belongs to the specified vertical.
      VERY_LIKELY: It is very likely that the image belongs to the specified
        vertical.
    """
    UNKNOWN = 0
    VERY_UNLIKELY = 1
    UNLIKELY = 2
    POSSIBLE = 3
    LIKELY = 4
    VERY_LIKELY = 5

  class UnderExposedLikelihoodValueValuesEnum(_messages.Enum):
    """Under-exposed likelihood.

    Values:
      UNKNOWN: Unknown likelihood.
      VERY_UNLIKELY: It is very unlikely that the image belongs to the
        specified vertical.
      UNLIKELY: It is unlikely that the image belongs to the specified
        vertical.
      POSSIBLE: It is possible that the image belongs to the specified
        vertical.
      LIKELY: It is likely that the image belongs to the specified vertical.
      VERY_LIKELY: It is very likely that the image belongs to the specified
        vertical.
    """
    UNKNOWN = 0
    VERY_UNLIKELY = 1
    UNLIKELY = 2
    POSSIBLE = 3
    LIKELY = 4
    VERY_LIKELY = 5

  angerLikelihood = _messages.EnumField('AngerLikelihoodValueValuesEnum', 1)
  blurredLikelihood = _messages.EnumField('BlurredLikelihoodValueValuesEnum', 2)
  boundingPoly = _messages.MessageField('BoundingPoly', 3)
  detectionConfidence = _messages.FloatField(4, variant=_messages.Variant.FLOAT)
  fdBoundingPoly = _messages.MessageField('BoundingPoly', 5)
  headwearLikelihood = _messages.EnumField('HeadwearLikelihoodValueValuesEnum', 6)
  joyLikelihood = _messages.EnumField('JoyLikelihoodValueValuesEnum', 7)
  landmarkingConfidence = _messages.FloatField(8, variant=_messages.Variant.FLOAT)
  landmarks = _messages.MessageField('Landmark', 9, repeated=True)
  panAngle = _messages.FloatField(10, variant=_messages.Variant.FLOAT)
  rollAngle = _messages.FloatField(11, variant=_messages.Variant.FLOAT)
  sorrowLikelihood = _messages.EnumField('SorrowLikelihoodValueValuesEnum', 12)
  surpriseLikelihood = _messages.EnumField('SurpriseLikelihoodValueValuesEnum', 13)
  tiltAngle = _messages.FloatField(14, variant=_messages.Variant.FLOAT)
  underExposedLikelihood = _messages.EnumField('UnderExposedLikelihoodValueValuesEnum', 15)


class Feature(_messages.Message):
  """Users describe the type of Google Cloud Vision API tasks to perform over
  images by using *Feature*s. Each Feature indicates a type of image detection
  task to perform. Features encode the Cloud Vision API vertical to operate on
  and the number of top-scoring results to return.

  Enums:
    TypeValueValuesEnum: The feature type.

  Fields:
    maxResults: Maximum number of results of this type.
    type: The feature type.
  """

  class TypeValueValuesEnum(_messages.Enum):
    """The feature type.

    Values:
      TYPE_UNSPECIFIED: Unspecified feature type.
      FACE_DETECTION: Run face detection.
      LANDMARK_DETECTION: Run landmark detection.
      LOGO_DETECTION: Run logo detection.
      LABEL_DETECTION: Run label detection.
      TEXT_DETECTION: Run OCR.
      DOCUMENT_TEXT_DETECTION: Run dense text document OCR. Takes precedence
        when both DOCUMENT_TEXT_DETECTION and TEXT_DETECTION are present.
      SAFE_SEARCH_DETECTION: Run computer vision models to compute image safe-
        search properties.
      IMAGE_PROPERTIES: Compute a set of image properties, such as the image's
        dominant colors.
      CROP_HINTS: Run crop hints.
      WEB_DETECTION: Run web detection.
    """
    TYPE_UNSPECIFIED = 0
    FACE_DETECTION = 1
    LANDMARK_DETECTION = 2
    LOGO_DETECTION = 3
    LABEL_DETECTION = 4
    TEXT_DETECTION = 5
    DOCUMENT_TEXT_DETECTION = 6
    SAFE_SEARCH_DETECTION = 7
    IMAGE_PROPERTIES = 8
    CROP_HINTS = 9
    WEB_DETECTION = 10

  maxResults = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  type = _messages.EnumField('TypeValueValuesEnum', 2)


class Image(_messages.Message):
  """Client image to perform Google Cloud Vision API tasks over.

  Fields:
    content: Image content, represented as a stream of bytes. Note: as with
      all `bytes` fields, protobuffers use a pure binary representation,
      whereas JSON representations use base64.
    source: Google Cloud Storage image location. If both `content` and
      `source` are provided for an image, `content` takes precedence and is
      used to perform the image annotation request.
  """

  content = _messages.BytesField(1)
  source = _messages.MessageField('ImageSource', 2)


class ImageContext(_messages.Message):
  """Image context and/or feature-specific parameters.

  Fields:
    cropHintsParams: Parameters for crop hints annotation request.
    languageHints: List of languages to use for TEXT_DETECTION. In most cases,
      an empty value yields the best results since it enables automatic
      language detection. For languages based on the Latin alphabet, setting
      `language_hints` is not needed. In rare cases, when the language of the
      text in the image is known, setting a hint will help get better results
      (although it will be a significant hindrance if the hint is wrong). Text
      detection returns an error if one or more of the specified languages is
      not one of the [supported languages](/vision/docs/languages).
    latLongRect: lat/long rectangle that specifies the location of the image.
  """

  cropHintsParams = _messages.MessageField('CropHintsParams', 1)
  languageHints = _messages.StringField(2, repeated=True)
  latLongRect = _messages.MessageField('LatLongRect', 3)


class ImageProperties(_messages.Message):
  """Stores image properties, such as dominant colors.

  Fields:
    dominantColors: If present, dominant colors completed successfully.
  """

  dominantColors = _messages.MessageField('DominantColorsAnnotation', 1)


class ImageSource(_messages.Message):
  """External image source (Google Cloud Storage image location).

  Fields:
    gcsImageUri: NOTE: For new code `image_uri` below is preferred. Google
      Cloud Storage image URI, which must be in the following form:
      `gs://bucket_name/object_name` (for details, see [Google Cloud Storage
      Request URIs](https://cloud.google.com/storage/docs/reference-uris)).
      NOTE: Cloud Storage object versioning is not supported.
    imageUri: Image URI which supports: 1) Google Cloud Storage image URI,
      which must be in the following form: `gs://bucket_name/object_name` (for
      details, see [Google Cloud Storage Request
      URIs](https://cloud.google.com/storage/docs/reference-uris)). NOTE:
      Cloud Storage object versioning is not supported. 2) Publicly accessible
      image HTTP/HTTPS URL. This is preferred over the legacy `gcs_image_uri`
      above. When both `gcs_image_uri` and `image_uri` are specified,
      `image_uri` takes precedence.
  """

  gcsImageUri = _messages.StringField(1)
  imageUri = _messages.StringField(2)


class Landmark(_messages.Message):
  """A face-specific landmark (for example, a face feature). Landmark
  positions may fall outside the bounds of the image if the face is near one
  or more edges of the image. Therefore it is NOT guaranteed that `0 <= x <
  width` or `0 <= y < height`.

  Enums:
    TypeValueValuesEnum: Face landmark type.

  Fields:
    position: Face landmark position.
    type: Face landmark type.
  """

  class TypeValueValuesEnum(_messages.Enum):
    """Face landmark type.

    Values:
      UNKNOWN_LANDMARK: Unknown face landmark detected. Should not be filled.
      LEFT_EYE: Left eye.
      RIGHT_EYE: Right eye.
      LEFT_OF_LEFT_EYEBROW: Left of left eyebrow.
      RIGHT_OF_LEFT_EYEBROW: Right of left eyebrow.
      LEFT_OF_RIGHT_EYEBROW: Left of right eyebrow.
      RIGHT_OF_RIGHT_EYEBROW: Right of right eyebrow.
      MIDPOINT_BETWEEN_EYES: Midpoint between eyes.
      NOSE_TIP: Nose tip.
      UPPER_LIP: Upper lip.
      LOWER_LIP: Lower lip.
      MOUTH_LEFT: Mouth left.
      MOUTH_RIGHT: Mouth right.
      MOUTH_CENTER: Mouth center.
      NOSE_BOTTOM_RIGHT: Nose, bottom right.
      NOSE_BOTTOM_LEFT: Nose, bottom left.
      NOSE_BOTTOM_CENTER: Nose, bottom center.
      LEFT_EYE_TOP_BOUNDARY: Left eye, top boundary.
      LEFT_EYE_RIGHT_CORNER: Left eye, right corner.
      LEFT_EYE_BOTTOM_BOUNDARY: Left eye, bottom boundary.
      LEFT_EYE_LEFT_CORNER: Left eye, left corner.
      RIGHT_EYE_TOP_BOUNDARY: Right eye, top boundary.
      RIGHT_EYE_RIGHT_CORNER: Right eye, right corner.
      RIGHT_EYE_BOTTOM_BOUNDARY: Right eye, bottom boundary.
      RIGHT_EYE_LEFT_CORNER: Right eye, left corner.
      LEFT_EYEBROW_UPPER_MIDPOINT: Left eyebrow, upper midpoint.
      RIGHT_EYEBROW_UPPER_MIDPOINT: Right eyebrow, upper midpoint.
      LEFT_EAR_TRAGION: Left ear tragion.
      RIGHT_EAR_TRAGION: Right ear tragion.
      LEFT_EYE_PUPIL: Left eye pupil.
      RIGHT_EYE_PUPIL: Right eye pupil.
      FOREHEAD_GLABELLA: Forehead glabella.
      CHIN_GNATHION: Chin gnathion.
      CHIN_LEFT_GONION: Chin left gonion.
      CHIN_RIGHT_GONION: Chin right gonion.
    """
    UNKNOWN_LANDMARK = 0
    LEFT_EYE = 1
    RIGHT_EYE = 2
    LEFT_OF_LEFT_EYEBROW = 3
    RIGHT_OF_LEFT_EYEBROW = 4
    LEFT_OF_RIGHT_EYEBROW = 5
    RIGHT_OF_RIGHT_EYEBROW = 6
    MIDPOINT_BETWEEN_EYES = 7
    NOSE_TIP = 8
    UPPER_LIP = 9
    LOWER_LIP = 10
    MOUTH_LEFT = 11
    MOUTH_RIGHT = 12
    MOUTH_CENTER = 13
    NOSE_BOTTOM_RIGHT = 14
    NOSE_BOTTOM_LEFT = 15
    NOSE_BOTTOM_CENTER = 16
    LEFT_EYE_TOP_BOUNDARY = 17
    LEFT_EYE_RIGHT_CORNER = 18
    LEFT_EYE_BOTTOM_BOUNDARY = 19
    LEFT_EYE_LEFT_CORNER = 20
    RIGHT_EYE_TOP_BOUNDARY = 21
    RIGHT_EYE_RIGHT_CORNER = 22
    RIGHT_EYE_BOTTOM_BOUNDARY = 23
    RIGHT_EYE_LEFT_CORNER = 24
    LEFT_EYEBROW_UPPER_MIDPOINT = 25
    RIGHT_EYEBROW_UPPER_MIDPOINT = 26
    LEFT_EAR_TRAGION = 27
    RIGHT_EAR_TRAGION = 28
    LEFT_EYE_PUPIL = 29
    RIGHT_EYE_PUPIL = 30
    FOREHEAD_GLABELLA = 31
    CHIN_GNATHION = 32
    CHIN_LEFT_GONION = 33
    CHIN_RIGHT_GONION = 34

  position = _messages.MessageField('Position', 1)
  type = _messages.EnumField('TypeValueValuesEnum', 2)


class LatLng(_messages.Message):
  """An object representing a latitude/longitude pair. This is expressed as a
  pair of doubles representing degrees latitude and degrees longitude. Unless
  specified otherwise, this must conform to the <a
  href="http://www.unoosa.org/pdf/icg/2012/template/WGS_84.pdf">WGS84
  standard</a>. Values must be within normalized ranges.  Example of
  normalization code in Python:      def NormalizeLongitude(longitude):
  " " "Wraps decimal degrees longitude to [-180.0, 180.0]." " "       q, r =
  divmod(longitude, 360.0)       if r > 180.0 or (r == 180.0 and q <= -1.0):
  return r - 360.0       return r      def NormalizeLatLng(latitude,
  longitude):       " " "Wraps decimal degrees latitude and longitude to
  [-90.0, 90.0] and [-180.0, 180.0], respectively." " "       r = latitude %
  360.0       if r <= 90.0:         return r, NormalizeLongitude(longitude)
  elif r >= 270.0:         return r - 360, NormalizeLongitude(longitude)
  else:         return 180 - r, NormalizeLongitude(longitude + 180.0)
  assert 180.0 == NormalizeLongitude(180.0)     assert -180.0 ==
  NormalizeLongitude(-180.0)     assert -179.0 == NormalizeLongitude(181.0)
  assert (0.0, 0.0) == NormalizeLatLng(360.0, 0.0)     assert (0.0, 0.0) ==
  NormalizeLatLng(-360.0, 0.0)     assert (85.0, 180.0) ==
  NormalizeLatLng(95.0, 0.0)     assert (-85.0, -170.0) ==
  NormalizeLatLng(-95.0, 10.0)     assert (90.0, 10.0) ==
  NormalizeLatLng(90.0, 10.0)     assert (-90.0, -10.0) ==
  NormalizeLatLng(-90.0, -10.0)     assert (0.0, -170.0) ==
  NormalizeLatLng(-180.0, 10.0)     assert (0.0, -170.0) ==
  NormalizeLatLng(180.0, 10.0)     assert (-90.0, 10.0) ==
  NormalizeLatLng(270.0, 10.0)     assert (90.0, 10.0) ==
  NormalizeLatLng(-270.0, 10.0)

  Fields:
    latitude: The latitude in degrees. It must be in the range [-90.0, +90.0].
    longitude: The longitude in degrees. It must be in the range [-180.0,
      +180.0].
  """

  latitude = _messages.FloatField(1)
  longitude = _messages.FloatField(2)


class LatLongRect(_messages.Message):
  """Rectangle determined by min and max `LatLng` pairs.

  Fields:
    maxLatLng: Max lat/long pair.
    minLatLng: Min lat/long pair.
  """

  maxLatLng = _messages.MessageField('LatLng', 1)
  minLatLng = _messages.MessageField('LatLng', 2)


class LocationInfo(_messages.Message):
  """Detected entity location information.

  Fields:
    latLng: lat/long location coordinates.
  """

  latLng = _messages.MessageField('LatLng', 1)


class Page(_messages.Message):
  """Detected page from OCR.

  Fields:
    blocks: List of blocks of text, images etc on this page.
    height: Page height in pixels.
    property: Additional information detected on the page.
    width: Page width in pixels.
  """

  blocks = _messages.MessageField('Block', 1, repeated=True)
  height = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  property = _messages.MessageField('TextProperty', 3)
  width = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class Paragraph(_messages.Message):
  """Structural unit of text representing a number of words in certain order.

  Fields:
    boundingBox: The bounding box for the paragraph. The vertices are in the
      order of top-left, top-right, bottom-right, bottom-left. When a rotation
      of the bounding box is detected the rotation is represented as around
      the top-left corner as defined when the text is read in the 'natural'
      orientation. For example:   * when the text is horizontal it might look
      like:      0----1      |    |      3----2   * when it's rotated 180
      degrees around the top-left corner it becomes:      2----3      |    |
      1----0   and the vertice order will still be (0, 1, 2, 3).
    property: Additional information detected for the paragraph.
    words: List of words in this paragraph.
  """

  boundingBox = _messages.MessageField('BoundingPoly', 1)
  property = _messages.MessageField('TextProperty', 2)
  words = _messages.MessageField('Word', 3, repeated=True)


class Position(_messages.Message):
  """A 3D position in the image, used primarily for Face detection landmarks.
  A valid Position must have both x and y coordinates. The position
  coordinates are in the same scale as the original image.

  Fields:
    x: X coordinate.
    y: Y coordinate.
    z: Z coordinate (or depth).
  """

  x = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  y = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  z = _messages.FloatField(3, variant=_messages.Variant.FLOAT)


class Property(_messages.Message):
  """A `Property` consists of a user-supplied name/value pair.

  Fields:
    name: Name of the property.
    uint64Value: Value of numeric properties.
    value: Value of the property.
  """

  name = _messages.StringField(1)
  uint64Value = _messages.IntegerField(2, variant=_messages.Variant.UINT64)
  value = _messages.StringField(3)


class SafeSearchAnnotation(_messages.Message):
  """Set of features pertaining to the image, computed by computer vision
  methods over safe-search verticals (for example, adult, spoof, medical,
  violence).

  Enums:
    AdultValueValuesEnum: Represents the adult content likelihood for the
      image.
    MedicalValueValuesEnum: Likelihood that this is a medical image.
    SpoofValueValuesEnum: Spoof likelihood. The likelihood that an
      modification was made to the image's canonical version to make it appear
      funny or offensive.
    ViolenceValueValuesEnum: Violence likelihood.

  Fields:
    adult: Represents the adult content likelihood for the image.
    medical: Likelihood that this is a medical image.
    spoof: Spoof likelihood. The likelihood that an modification was made to
      the image's canonical version to make it appear funny or offensive.
    violence: Violence likelihood.
  """

  class AdultValueValuesEnum(_messages.Enum):
    """Represents the adult content likelihood for the image.

    Values:
      UNKNOWN: Unknown likelihood.
      VERY_UNLIKELY: It is very unlikely that the image belongs to the
        specified vertical.
      UNLIKELY: It is unlikely that the image belongs to the specified
        vertical.
      POSSIBLE: It is possible that the image belongs to the specified
        vertical.
      LIKELY: It is likely that the image belongs to the specified vertical.
      VERY_LIKELY: It is very likely that the image belongs to the specified
        vertical.
    """
    UNKNOWN = 0
    VERY_UNLIKELY = 1
    UNLIKELY = 2
    POSSIBLE = 3
    LIKELY = 4
    VERY_LIKELY = 5

  class MedicalValueValuesEnum(_messages.Enum):
    """Likelihood that this is a medical image.

    Values:
      UNKNOWN: Unknown likelihood.
      VERY_UNLIKELY: It is very unlikely that the image belongs to the
        specified vertical.
      UNLIKELY: It is unlikely that the image belongs to the specified
        vertical.
      POSSIBLE: It is possible that the image belongs to the specified
        vertical.
      LIKELY: It is likely that the image belongs to the specified vertical.
      VERY_LIKELY: It is very likely that the image belongs to the specified
        vertical.
    """
    UNKNOWN = 0
    VERY_UNLIKELY = 1
    UNLIKELY = 2
    POSSIBLE = 3
    LIKELY = 4
    VERY_LIKELY = 5

  class SpoofValueValuesEnum(_messages.Enum):
    """Spoof likelihood. The likelihood that an modification was made to the
    image's canonical version to make it appear funny or offensive.

    Values:
      UNKNOWN: Unknown likelihood.
      VERY_UNLIKELY: It is very unlikely that the image belongs to the
        specified vertical.
      UNLIKELY: It is unlikely that the image belongs to the specified
        vertical.
      POSSIBLE: It is possible that the image belongs to the specified
        vertical.
      LIKELY: It is likely that the image belongs to the specified vertical.
      VERY_LIKELY: It is very likely that the image belongs to the specified
        vertical.
    """
    UNKNOWN = 0
    VERY_UNLIKELY = 1
    UNLIKELY = 2
    POSSIBLE = 3
    LIKELY = 4
    VERY_LIKELY = 5

  class ViolenceValueValuesEnum(_messages.Enum):
    """Violence likelihood.

    Values:
      UNKNOWN: Unknown likelihood.
      VERY_UNLIKELY: It is very unlikely that the image belongs to the
        specified vertical.
      UNLIKELY: It is unlikely that the image belongs to the specified
        vertical.
      POSSIBLE: It is possible that the image belongs to the specified
        vertical.
      LIKELY: It is likely that the image belongs to the specified vertical.
      VERY_LIKELY: It is very likely that the image belongs to the specified
        vertical.
    """
    UNKNOWN = 0
    VERY_UNLIKELY = 1
    UNLIKELY = 2
    POSSIBLE = 3
    LIKELY = 4
    VERY_LIKELY = 5

  adult = _messages.EnumField('AdultValueValuesEnum', 1)
  medical = _messages.EnumField('MedicalValueValuesEnum', 2)
  spoof = _messages.EnumField('SpoofValueValuesEnum', 3)
  violence = _messages.EnumField('ViolenceValueValuesEnum', 4)


class StandardQueryParameters(_messages.Message):
  """Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    bearer_token: OAuth bearer token.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    pp: Pretty-print response.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    """Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    """V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  bearer_token = _messages.StringField(4)
  callback = _messages.StringField(5)
  fields = _messages.StringField(6)
  key = _messages.StringField(7)
  oauth_token = _messages.StringField(8)
  pp = _messages.BooleanField(9, default=True)
  prettyPrint = _messages.BooleanField(10, default=True)
  quotaUser = _messages.StringField(11)
  trace = _messages.StringField(12)
  uploadType = _messages.StringField(13)
  upload_protocol = _messages.StringField(14)


class Status(_messages.Message):
  """The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). The error model is designed to be:
  - Simple to use and understand for most users - Flexible enough to meet
  unexpected needs  # Overview  The `Status` message contains three pieces of
  data: error code, error message, and error details. The error code should be
  an enum value of google.rpc.Code, but it may accept additional error codes
  if needed.  The error message should be a developer-facing English message
  that helps developers *understand* and *resolve* the error. If a localized
  user-facing error message is needed, put the localized message in the error
  details or localize it in the client. The optional error details may contain
  arbitrary information about the error. There is a predefined set of error
  detail types in the package `google.rpc` that can be used for common error
  conditions.  # Language mapping  The `Status` message is the logical
  representation of the error model, but it is not necessarily the actual wire
  format. When the `Status` message is exposed in different client libraries
  and different wire protocols, it can be mapped differently. For example, it
  will likely be mapped to some exceptions in Java, but more likely mapped to
  some error codes in C.  # Other uses  The error model and the `Status`
  message can be used in a variety of environments, either with or without
  APIs, to provide a consistent developer experience across different
  environments.  Example uses of this error model include:  - Partial errors.
  If a service needs to return partial errors to the client,     it may embed
  the `Status` in the normal response to indicate the partial     errors.  -
  Workflow errors. A typical workflow has multiple steps. Each step may
  have a `Status` message for error reporting.  - Batch operations. If a
  client uses batch request and batch response, the     `Status` message
  should be used directly inside batch response, one for     each error sub-
  response.  - Asynchronous operations. If an API call embeds asynchronous
  operation     results in its response, the status of those operations should
  be     represented directly using the `Status` message.  - Logging. If some
  API errors are stored in logs, the message `Status` could     be used
  directly after any stripping needed for security/privacy reasons.

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There will be a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    """A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class Symbol(_messages.Message):
  """A single symbol representation.

  Fields:
    boundingBox: The bounding box for the symbol. The vertices are in the
      order of top-left, top-right, bottom-right, bottom-left. When a rotation
      of the bounding box is detected the rotation is represented as around
      the top-left corner as defined when the text is read in the 'natural'
      orientation. For example:   * when the text is horizontal it might look
      like:      0----1      |    |      3----2   * when it's rotated 180
      degrees around the top-left corner it becomes:      2----3      |    |
      1----0   and the vertice order will still be (0, 1, 2, 3).
    property: Additional information detected for the symbol.
    text: The actual UTF-8 representation of the symbol.
  """

  boundingBox = _messages.MessageField('BoundingPoly', 1)
  property = _messages.MessageField('TextProperty', 2)
  text = _messages.StringField(3)


class TextAnnotation(_messages.Message):
  """TextAnnotation contains a structured representation of OCR extracted
  text. The hierarchy of an OCR extracted text structure is like this:
  TextAnnotation -> Page -> Block -> Paragraph -> Word -> Symbol Each
  structural component, starting from Page, may further have their own
  properties. Properties describe detected languages, breaks etc.. Please
  refer to the google.cloud.vision.v1.TextAnnotation.TextProperty message
  definition below for more detail.

  Fields:
    pages: List of pages detected by OCR.
    text: UTF-8 text detected on the pages.
  """

  pages = _messages.MessageField('Page', 1, repeated=True)
  text = _messages.StringField(2)


class TextProperty(_messages.Message):
  """Additional information detected on the structural component.

  Fields:
    detectedBreak: Detected start or end of a text segment.
    detectedLanguages: A list of detected languages together with confidence.
  """

  detectedBreak = _messages.MessageField('DetectedBreak', 1)
  detectedLanguages = _messages.MessageField('DetectedLanguage', 2, repeated=True)


class Vertex(_messages.Message):
  """A vertex represents a 2D point in the image. NOTE: the vertex coordinates
  are in the same scale as the original image.

  Fields:
    x: X coordinate.
    y: Y coordinate.
  """

  x = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  y = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class WebDetection(_messages.Message):
  """Relevant information for the image from the Internet.

  Fields:
    fullMatchingImages: Fully matching images from the Internet. Can include
      resized copies of the query image.
    pagesWithMatchingImages: Web pages containing the matching images from the
      Internet.
    partialMatchingImages: Partial matching images from the Internet. Those
      images are similar enough to share some key-point features. For example
      an original image will likely have partial matching for its crops.
    visuallySimilarImages: The visually similar image results.
    webEntities: Deduced entities from similar images on the Internet.
  """

  fullMatchingImages = _messages.MessageField('WebImage', 1, repeated=True)
  pagesWithMatchingImages = _messages.MessageField('WebPage', 2, repeated=True)
  partialMatchingImages = _messages.MessageField('WebImage', 3, repeated=True)
  visuallySimilarImages = _messages.MessageField('WebImage', 4, repeated=True)
  webEntities = _messages.MessageField('WebEntity', 5, repeated=True)


class WebEntity(_messages.Message):
  """Entity deduced from similar images on the Internet.

  Fields:
    description: Canonical description of the entity, in English.
    entityId: Opaque entity ID.
    score: Overall relevancy score for the entity. Not normalized and not
      comparable across different image queries.
  """

  description = _messages.StringField(1)
  entityId = _messages.StringField(2)
  score = _messages.FloatField(3, variant=_messages.Variant.FLOAT)


class WebImage(_messages.Message):
  """Metadata for online images.

  Fields:
    score: Overall relevancy score for the image. Not normalized and not
      comparable across different image queries.
    url: The result image URL.
  """

  score = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  url = _messages.StringField(2)


class WebPage(_messages.Message):
  """Metadata for web pages.

  Fields:
    score: Overall relevancy score for the web page. Not normalized and not
      comparable across different image queries.
    url: The result web page URL.
  """

  score = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  url = _messages.StringField(2)


class Word(_messages.Message):
  """A word representation.

  Fields:
    boundingBox: The bounding box for the word. The vertices are in the order
      of top-left, top-right, bottom-right, bottom-left. When a rotation of
      the bounding box is detected the rotation is represented as around the
      top-left corner as defined when the text is read in the 'natural'
      orientation. For example:   * when the text is horizontal it might look
      like:      0----1      |    |      3----2   * when it's rotated 180
      degrees around the top-left corner it becomes:      2----3      |    |
      1----0   and the vertice order will still be (0, 1, 2, 3).
    property: Additional information detected for the word.
    symbols: List of symbols in the word. The order of the symbols follows the
      natural reading order.
  """

  boundingBox = _messages.MessageField('BoundingPoly', 1)
  property = _messages.MessageField('TextProperty', 2)
  symbols = _messages.MessageField('Symbol', 3, repeated=True)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv',
    package=u'vision')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1',
    package=u'vision')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2',
    package=u'vision')
