untrusted comment: verify with openbsd-74-base.pub
RWRoyQmAD08ajRQUY69ARI8f1N+GYYkl+71UfmxvhcJ1LIkDymO74L1iz9qh1v+SZPqe1wm2eJ6SQyUj2eQ9MsUpndGEfRPJ6wI=

OpenBSD 7.4 errata 002, October 25, 2023:

A network buffer that had to be split at certain length could crash
the kernel.

Apply by doing:
    signify -Vep /etc/signify/openbsd-74-base.pub -x 002_msplit.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/kern/uipc_mbuf.c
===================================================================
RCS file: /cvs/src/sys/kern/uipc_mbuf.c,v
diff -u -p -r1.287 uipc_mbuf.c
--- sys/kern/uipc_mbuf.c	23 Jun 2023 04:36:49 -0000	1.287
+++ sys/kern/uipc_mbuf.c	20 Oct 2023 16:38:19 -0000
@@ -1080,9 +1080,7 @@ m_split(struct mbuf *m0, int len0, int w
 			n->m_len = 0;
 			return (n);
 		}
-		if (m->m_flags & M_EXT)
-			goto extpacket;
-		if (remain > MHLEN) {
+		if ((m->m_flags & M_EXT) == 0 && remain > MHLEN) {
 			/* m can't be the lead packet */
 			m_align(n, 0);
 			n->m_next = m_split(m, len, wait);
@@ -1094,8 +1092,7 @@ m_split(struct mbuf *m0, int len0, int w
 				n->m_len = 0;
 				return (n);
 			}
-		} else
-			m_align(n, remain);
+		}
 	} else if (remain == 0) {
 		n = m->m_next;
 		m->m_next = NULL;
@@ -1104,14 +1101,13 @@ m_split(struct mbuf *m0, int len0, int w
 		MGET(n, wait, m->m_type);
 		if (n == NULL)
 			return (NULL);
-		m_align(n, remain);
 	}
-extpacket:
 	if (m->m_flags & M_EXT) {
 		n->m_ext = m->m_ext;
 		MCLADDREFERENCE(m, n);
 		n->m_data = m->m_data + len;
 	} else {
+		m_align(n, remain);
 		memcpy(mtod(n, caddr_t), mtod(m, caddr_t) + len, remain);
 	}
 	n->m_len = remain;
