untrusted comment: verify with openbsd-68-base.pub
RWQZj25CSG5R2tHMsSzbcO8IXiSc9hWA1a+0S/P7kjlkCNmfPHdKxUTIgFhmPBgSrqpxgrEac0ypN9LQ6ZExyuMgHFpKj64gwQ0=

OpenBSD 6.8 errata 013, February 3, 2021:

Various interoperability issues and memory leaks were discovered in
libcrypto and libssl.

Apply by doing:
    signify -Vep /etc/signify/openbsd-68-base.pub -x 013_libressl.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install libcrypto, libssl, isakmpd and unwind:
    cd /usr/src/lib/libcrypto
    make obj
    make
    make install
    cd /usr/src/lib/libssl
    make obj
    make
    make install
    cd /usr/src/sbin/isakmpd
    make obj
    make
    make install
    cd /usr/src/sbin/unwind
    make obj
    make
    make install

Index: lib/libcrypto/x509/x509_verify.c
===================================================================
RCS file: /cvs/src/lib/libcrypto/x509/x509_verify.c,v
retrieving revision 1.13
diff -u -p -r1.13 x509_verify.c
--- lib/libcrypto/x509/x509_verify.c	26 Sep 2020 15:44:06 -0000	1.13
+++ lib/libcrypto/x509/x509_verify.c	18 Jan 2021 21:09:47 -0000
@@ -81,7 +81,7 @@ x509_verify_chain_dup(struct x509_verify
 {
 	struct x509_verify_chain *new_chain;
 
-	if ((new_chain = x509_verify_chain_new()) == NULL)
+	if ((new_chain = calloc(1, sizeof(*chain))) == NULL)
 		goto err;
 	if ((new_chain->certs = X509_chain_up_ref(chain->certs)) == NULL)
 		goto err;
Index: lib/libcrypto/x509/x509_vfy.c
===================================================================
RCS file: /cvs/src/lib/libcrypto/x509/x509_vfy.c,v
retrieving revision 1.81
diff -u -p -r1.81 x509_vfy.c
--- lib/libcrypto/x509/x509_vfy.c	26 Sep 2020 02:06:28 -0000	1.81
+++ lib/libcrypto/x509/x509_vfy.c	18 Jan 2021 21:09:54 -0000
@@ -1794,6 +1794,11 @@ x509_vfy_check_policy(X509_STORE_CTX *ct
 
 	if (ctx->parent)
 		return 1;
+
+	/* X509_policy_check always allocates a new tree. */
+	X509_policy_tree_free(ctx->tree);
+	ctx->tree = NULL;
+
 	ret = X509_policy_check(&ctx->tree, &ctx->explicit_policy, ctx->chain,
 	    ctx->param->policies, ctx->param->flags);
 	if (ret == 0) {
Index: lib/libcrypto/x509/x509_vpm.c
===================================================================
RCS file: /cvs/src/lib/libcrypto/x509/x509_vpm.c,v
retrieving revision 1.22
diff -u -p -r1.22 x509_vpm.c
--- lib/libcrypto/x509/x509_vpm.c	14 Sep 2020 08:10:04 -0000	1.22
+++ lib/libcrypto/x509/x509_vpm.c	30 Jan 2021 08:33:55 -0000
@@ -177,7 +177,7 @@ x509_verify_param_zero(X509_VERIFY_PARAM
 	param->trust = 0;
 	/*param->inh_flags = X509_VP_FLAG_DEFAULT;*/
 	param->inh_flags = 0;
-	param->flags = 0;
+	param->flags = X509_V_FLAG_LEGACY_VERIFY;
 	param->depth = -1;
 	if (param->policies) {
 		sk_ASN1_OBJECT_pop_free(param->policies, ASN1_OBJECT_free);
Index: lib/libssl/d1_both.c
===================================================================
RCS file: /cvs/src/lib/libssl/d1_both.c,v
retrieving revision 1.60
diff -u -p -r1.60 d1_both.c
--- lib/libssl/d1_both.c	26 Sep 2020 14:43:17 -0000	1.60
+++ lib/libssl/d1_both.c	18 Jan 2021 20:58:39 -0000
@@ -1060,18 +1060,18 @@ dtls1_retransmit_message(SSL *s, unsigne
 	    frag->msg_header.frag_len);
 
 	/* save current state */
-	saved_state.enc_write_ctx = s->internal->enc_write_ctx;
-	saved_state.write_hash = s->internal->write_hash;
 	saved_state.session = s->session;
 	saved_state.epoch = D1I(s)->w_epoch;
 
 	D1I(s)->retransmitting = 1;
 
 	/* restore state in which the message was originally sent */
-	s->internal->enc_write_ctx = frag->msg_header.saved_retransmit_state.enc_write_ctx;
-	s->internal->write_hash = frag->msg_header.saved_retransmit_state.write_hash;
 	s->session = frag->msg_header.saved_retransmit_state.session;
 	D1I(s)->w_epoch = frag->msg_header.saved_retransmit_state.epoch;
+	if (!tls12_record_layer_set_write_cipher_hash(s->internal->rl,
+	    frag->msg_header.saved_retransmit_state.enc_write_ctx,
+	    frag->msg_header.saved_retransmit_state.write_hash, 0))
+		return 0;
 
 	if (frag->msg_header.saved_retransmit_state.epoch ==
 	    saved_state.epoch - 1) {
@@ -1085,10 +1085,11 @@ dtls1_retransmit_message(SSL *s, unsigne
 	    SSL3_RT_CHANGE_CIPHER_SPEC : SSL3_RT_HANDSHAKE);
 
 	/* restore current state */
-	s->internal->enc_write_ctx = saved_state.enc_write_ctx;
-	s->internal->write_hash = saved_state.write_hash;
 	s->session = saved_state.session;
 	D1I(s)->w_epoch = saved_state.epoch;
+	if (!tls12_record_layer_set_write_cipher_hash(s->internal->rl,
+	    s->internal->enc_write_ctx, s->internal->write_hash, 0))
+		return 0;
 
 	if (frag->msg_header.saved_retransmit_state.epoch ==
 	    saved_state.epoch - 1) {
Index: lib/libssl/ssl_both.c
===================================================================
RCS file: /cvs/src/lib/libssl/ssl_both.c,v
retrieving revision 1.20
diff -u -p -r1.20 ssl_both.c
--- lib/libssl/ssl_both.c	24 Sep 2020 18:12:00 -0000	1.20
+++ lib/libssl/ssl_both.c	30 Jan 2021 08:32:31 -0000
@@ -408,6 +408,8 @@ ssl3_output_cert_chain(SSL *s, CBB *cbb,
 			SSLerror(s, ERR_R_X509_LIB);
 			goto err;
 		}
+		X509_VERIFY_PARAM_set_flags(X509_STORE_CTX_get0_param(xs_ctx),
+		    X509_V_FLAG_LEGACY_VERIFY);
 		X509_verify_cert(xs_ctx);
 		ERR_clear_error();
 		chain = xs_ctx->chain;
Index: lib/libssl/ssl_lib.c
===================================================================
RCS file: /cvs/src/lib/libssl/ssl_lib.c,v
retrieving revision 1.234
diff -u -p -r1.234 ssl_lib.c
--- lib/libssl/ssl_lib.c	24 Sep 2020 18:12:00 -0000	1.234
+++ lib/libssl/ssl_lib.c	18 Jan 2021 20:59:21 -0000
@@ -1710,8 +1710,17 @@ SSL_export_keying_material(SSL *s, unsig
     const char *label, size_t llen, const unsigned char *p, size_t plen,
     int use_context)
 {
-	return (tls1_export_keying_material(s, out, olen,
-	    label, llen, p, plen, use_context));
+	if (s->internal->tls13 != NULL && s->version == TLS1_3_VERSION) {
+		if (!use_context) {
+			p = NULL;
+			plen = 0;
+		}
+		return tls13_exporter(s->internal->tls13, label, llen, p, plen,
+		    out, olen);
+	}
+
+	return (tls1_export_keying_material(s, out, olen, label, llen, p, plen,
+	    use_context));
 }
 
 static unsigned long
Index: lib/libssl/tls13_internal.h
===================================================================
RCS file: /cvs/src/lib/libssl/tls13_internal.h,v
retrieving revision 1.86
diff -u -p -r1.86 tls13_internal.h
--- lib/libssl/tls13_internal.h	30 Jul 2020 16:23:17 -0000	1.86
+++ lib/libssl/tls13_internal.h	18 Jan 2021 20:59:21 -0000
@@ -148,6 +148,16 @@ void tls13_secrets_destroy(struct tls13_
 int tls13_hkdf_expand_label(struct tls13_secret *out, const EVP_MD *digest,
     const struct tls13_secret *secret, const char *label,
     const struct tls13_secret *context);
+int tls13_hkdf_expand_label_with_length(struct tls13_secret *out,
+    const EVP_MD *digest, const struct tls13_secret *secret,
+    const uint8_t *label, size_t label_len, const struct tls13_secret *context);
+
+int tls13_derive_secret(struct tls13_secret *out, const EVP_MD *digest,
+    const struct tls13_secret *secret, const char *label,   
+    const struct tls13_secret *context);
+int tls13_derive_secret_with_label_length(struct tls13_secret *out,
+    const EVP_MD *digest, const struct tls13_secret *secret,
+    const uint8_t *label, size_t label_len, const struct tls13_secret *context);
 
 int tls13_derive_early_secrets(struct tls13_secrets *secrets, uint8_t *psk,
     size_t psk_len, const struct tls13_secret *context);
@@ -411,6 +421,10 @@ int tls13_error_setx(struct tls13_error 
 #define tls13_set_errorx(ctx, code, subcode, fmt, ...) \
 	tls13_error_setx(&(ctx)->error, (code), (subcode), __FILE__, __LINE__, \
 	    (fmt), __VA_ARGS__)
+
+int tls13_exporter(struct tls13_ctx *ctx, const uint8_t *label, size_t label_len,
+    const uint8_t *context_value, size_t context_value_len, uint8_t *out,
+    size_t out_len);
 
 extern const uint8_t tls13_downgrade_12[8];
 extern const uint8_t tls13_downgrade_11[8];
Index: lib/libssl/tls13_key_schedule.c
===================================================================
RCS file: /cvs/src/lib/libssl/tls13_key_schedule.c,v
retrieving revision 1.8
diff -u -p -r1.8 tls13_key_schedule.c
--- lib/libssl/tls13_key_schedule.c	17 Nov 2019 21:01:08 -0000	1.8
+++ lib/libssl/tls13_key_schedule.c	18 Jan 2021 20:59:21 -0000
@@ -174,6 +174,15 @@ tls13_hkdf_expand_label(struct tls13_sec
     const struct tls13_secret *secret, const char *label,
     const struct tls13_secret *context)
 {
+	return tls13_hkdf_expand_label_with_length(out, digest, secret, label,
+	    strlen(label), context);
+}
+
+int
+tls13_hkdf_expand_label_with_length(struct tls13_secret *out,
+    const EVP_MD *digest, const struct tls13_secret *secret,
+    const uint8_t *label, size_t label_len, const struct tls13_secret *context)
+{
 	const char tls13_plabel[] = "tls13 ";
 	uint8_t *hkdf_label;
 	size_t hkdf_label_len;
@@ -188,7 +197,7 @@ tls13_hkdf_expand_label(struct tls13_sec
 		goto err;
 	if (!CBB_add_bytes(&child, tls13_plabel, strlen(tls13_plabel)))
 		goto err;
-	if (!CBB_add_bytes(&child, label, strlen(label)))
+	if (!CBB_add_bytes(&child, label, label_len))
 		goto err;
 	if (!CBB_add_u8_length_prefixed(&cbb, &child))
 		goto err;
@@ -207,12 +216,21 @@ tls13_hkdf_expand_label(struct tls13_sec
 	return(0);
 }
 
-static int
+int
 tls13_derive_secret(struct tls13_secret *out, const EVP_MD *digest,
     const struct tls13_secret *secret, const char *label,
     const struct tls13_secret *context)
 {
 	return tls13_hkdf_expand_label(out, digest, secret, label, context);
+}
+
+int
+tls13_derive_secret_with_label_length(struct tls13_secret *out,
+    const EVP_MD *digest, const struct tls13_secret *secret, const uint8_t *label,
+    size_t label_len, const struct tls13_secret *context)
+{
+	return tls13_hkdf_expand_label_with_length(out, digest, secret, label,
+	    label_len, context);
 }
 
 int
Index: lib/libssl/tls13_legacy.c
===================================================================
RCS file: /cvs/src/lib/libssl/tls13_legacy.c,v
retrieving revision 1.13
diff -u -p -r1.13 tls13_legacy.c
--- lib/libssl/tls13_legacy.c	13 Sep 2020 15:04:35 -0000	1.13
+++ lib/libssl/tls13_legacy.c	18 Jan 2021 20:57:38 -0000
@@ -40,8 +40,6 @@ tls13_legacy_wire_read(SSL *ssl, uint8_t
 	if ((n = BIO_read(ssl->rbio, buf, len)) <= 0) {
 		if (BIO_should_read(ssl->rbio))
 			return TLS13_IO_WANT_POLLIN;
-		if (BIO_should_write(ssl->rbio))
-			return TLS13_IO_WANT_POLLOUT;
 		if (n == 0)
 			return TLS13_IO_EOF;
 
@@ -79,8 +77,6 @@ tls13_legacy_wire_write(SSL *ssl, const 
 	errno = 0;
 
 	if ((n = BIO_write(ssl->wbio, buf, len)) <= 0) {
-		if (BIO_should_read(ssl->wbio))
-			return TLS13_IO_WANT_POLLIN;
 		if (BIO_should_write(ssl->wbio))
 			return TLS13_IO_WANT_POLLOUT;
 
Index: lib/libssl/tls13_lib.c
===================================================================
RCS file: /cvs/src/lib/libssl/tls13_lib.c,v
retrieving revision 1.54
diff -u -p -r1.54 tls13_lib.c
--- lib/libssl/tls13_lib.c	11 Sep 2020 15:03:36 -0000	1.54
+++ lib/libssl/tls13_lib.c	18 Jan 2021 20:59:21 -0000
@@ -579,3 +579,75 @@ tls13_clienthello_hash_validate(struct t
 	return 1;
 }
 
+int
+tls13_exporter(struct tls13_ctx *ctx, const uint8_t *label, size_t label_len,
+    const uint8_t *context_value, size_t context_value_len, uint8_t *out,
+    size_t out_len)
+{
+	struct tls13_secret context, export_out, export_secret;
+	struct tls13_secrets *secrets = ctx->hs->secrets;
+	EVP_MD_CTX *md_ctx = NULL;
+	unsigned int md_out_len;
+	int md_len;
+	int ret = 0;
+
+	/*
+	 * RFC 8446 Section 7.5.
+	 */
+
+	memset(&context, 0, sizeof(context));
+	memset(&export_secret, 0, sizeof(export_secret));
+
+	export_out.data = out;
+	export_out.len = out_len;
+
+	if (!ctx->handshake_completed)
+		return 0;
+
+	md_len = EVP_MD_size(secrets->digest);
+	if (md_len <= 0 || md_len > EVP_MAX_MD_SIZE)
+		goto err;
+
+	if ((export_secret.data = calloc(1, md_len)) == NULL)
+		goto err;
+	export_secret.len = md_len;
+
+	if ((context.data = calloc(1, md_len)) == NULL)
+		goto err;
+	context.len = md_len;
+
+	/* In TLSv1.3 no context is equivalent to an empty context. */
+	if (context_value == NULL) {
+		context_value = "";
+		context_value_len = 0;
+	}
+
+	if ((md_ctx = EVP_MD_CTX_new()) == NULL)
+		goto err;
+	if (!EVP_DigestInit_ex(md_ctx, secrets->digest, NULL))
+		goto err;
+	if (!EVP_DigestUpdate(md_ctx, context_value, context_value_len))
+		goto err;
+	if (!EVP_DigestFinal_ex(md_ctx, context.data, &md_out_len))
+		goto err;
+	if (md_len != md_out_len)
+		goto err;
+
+	if (!tls13_derive_secret_with_label_length(&export_secret,
+	    secrets->digest, &secrets->exporter_master, label, label_len,
+	    &secrets->empty_hash))
+		goto err;
+
+	if (!tls13_hkdf_expand_label(&export_out, secrets->digest,
+	    &export_secret, "exporter", &context))
+		goto err;
+
+	ret = 1;
+
+ err:
+	EVP_MD_CTX_free(md_ctx);
+	freezero(context.data, context.len);
+	freezero(export_secret.data, export_secret.len);
+
+	return ret;
+}
Index: lib/libssl/tls13_record_layer.c
===================================================================
RCS file: /cvs/src/lib/libssl/tls13_record_layer.c,v
retrieving revision 1.53
diff -u -p -r1.53 tls13_record_layer.c
--- lib/libssl/tls13_record_layer.c	11 Sep 2020 15:03:36 -0000	1.53
+++ lib/libssl/tls13_record_layer.c	18 Jan 2021 21:01:58 -0000
@@ -134,6 +134,9 @@ tls13_record_layer_free(struct tls13_rec
 {
 	if (rl == NULL)
 		return;
+
+	freezero(rl->alert_data, rl->alert_len);
+	freezero(rl->phh_data, rl->phh_len);
 
 	tls13_record_layer_rbuf_free(rl);
 
Index: lib/libssl/tls13_server.c
===================================================================
RCS file: /cvs/src/lib/libssl/tls13_server.c,v
retrieving revision 1.61
diff -u -p -r1.61 tls13_server.c
--- lib/libssl/tls13_server.c	3 Jul 2020 04:12:51 -0000	1.61
+++ lib/libssl/tls13_server.c	30 Jan 2021 08:32:31 -0000
@@ -611,6 +611,7 @@ tls13_server_certificate_send(struct tls
 	SSL *s = ctx->ssl;
 	CBB cert_request_context, cert_list;
 	const struct ssl_sigalg *sigalg;
+	X509_STORE_CTX *xsc = NULL;
 	STACK_OF(X509) *chain;
 	CERT_PKEY *cpk;
 	X509 *cert;
@@ -633,6 +634,18 @@ tls13_server_certificate_send(struct tls
 	if ((chain = cpk->chain) == NULL)
 		chain = s->ctx->extra_certs;
 
+	if (chain == NULL && !(s->internal->mode & SSL_MODE_NO_AUTO_CHAIN)) {
+		if ((xsc = X509_STORE_CTX_new()) == NULL)
+			goto err;
+		if (!X509_STORE_CTX_init(xsc, s->ctx->cert_store, cpk->x509, NULL))
+			goto err;
+		X509_VERIFY_PARAM_set_flags(X509_STORE_CTX_get0_param(xsc),
+		    X509_V_FLAG_LEGACY_VERIFY);
+		X509_verify_cert(xsc);
+		ERR_clear_error();
+		chain = xsc->chain;
+	}
+
 	if (!CBB_add_u8_length_prefixed(cbb, &cert_request_context))
 		goto err;
 	if (!CBB_add_u24_length_prefixed(cbb, &cert_list))
@@ -643,6 +656,15 @@ tls13_server_certificate_send(struct tls
 
 	for (i = 0; i < sk_X509_num(chain); i++) {
 		cert = sk_X509_value(chain, i);
+
+		/*
+		 * In the case of auto chain, the leaf certificate will be at
+		 * the top of the chain - skip over it as we've already added
+		 * it earlier.
+		 */
+		if (i == 0 && cert == cpk->x509)
+			continue;
+
 		/*
 		 * XXX we don't send extensions with chain certs to avoid sending
 		 * a leaf ocsp stape with the chain certs.  This needs to get
@@ -658,6 +680,8 @@ tls13_server_certificate_send(struct tls
 	ret = 1;
 
  err:
+	X509_STORE_CTX_free(xsc);
+
 	return ret;
 }
 
