/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.resource;

import com.warrenstrange.googleauth.GoogleAuthenticator;
import jakarta.annotation.security.PermitAll;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.LinkedList;
import org.traccar.api.BaseObjectResource;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.helper.LogAction;
import org.traccar.helper.model.UserUtil;
import org.traccar.model.Device;
import org.traccar.model.ManagedUser;
import org.traccar.model.Permission;
import org.traccar.model.User;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Order;
import org.traccar.storage.query.Request;

@Path(value="users")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class UserResource
extends BaseObjectResource<User> {
    @Inject
    private Config config;
    @Context
    private HttpServletRequest request;

    public UserResource() {
        super(User.class);
    }

    @GET
    public Collection<User> get(@QueryParam(value="userId") long userId, @QueryParam(value="deviceId") long deviceId) throws StorageException {
        LinkedList<Condition> conditions = new LinkedList<Condition>();
        if (userId > 0L) {
            this.permissionsService.checkUser(this.getUserId(), userId);
            conditions.add(new Condition.Permission(User.class, userId, ManagedUser.class).excludeGroups());
        } else if (this.permissionsService.notAdmin(this.getUserId())) {
            conditions.add(new Condition.Permission(User.class, this.getUserId(), ManagedUser.class).excludeGroups());
        }
        if (deviceId > 0L) {
            this.permissionsService.checkManager(this.getUserId());
            conditions.add(new Condition.Permission(User.class, Device.class, deviceId).excludeGroups());
        }
        return this.storage.getObjects(this.baseClass, new Request(new Columns.All(), Condition.merge(conditions), new Order("name")));
    }

    @Override
    @PermitAll
    @POST
    public Response add(User entity) throws StorageException {
        User currentUser;
        User user = currentUser = this.getUserId() > 0L ? this.permissionsService.getUser(this.getUserId()) : null;
        if (currentUser == null || !currentUser.getAdministrator()) {
            this.permissionsService.checkUserUpdate(this.getUserId(), new User(), entity);
            if (currentUser != null && currentUser.getUserLimit() != 0) {
                int userCount;
                int userLimit = currentUser.getUserLimit();
                if (userLimit > 0 && (userCount = this.storage.getObjects(this.baseClass, new Request((Columns)new Columns.All(), new Condition.Permission(User.class, this.getUserId(), ManagedUser.class).excludeGroups())).size()) >= userLimit) {
                    throw new SecurityException("Manager user limit reached");
                }
            } else {
                if (UserUtil.isEmpty(this.storage)) {
                    entity.setAdministrator(true);
                } else if (!this.permissionsService.getServer().getRegistration()) {
                    throw new SecurityException("Registration disabled");
                }
                if (this.permissionsService.getServer().getBoolean(Keys.WEB_TOTP_FORCE.getKey()) && entity.getTotpKey() == null) {
                    throw new SecurityException("One-time password key is required");
                }
                UserUtil.setUserDefaults(entity, this.config);
            }
        }
        entity.setId(this.storage.addObject(entity, new Request(new Columns.Exclude("id"))));
        this.storage.updateObject(entity, new Request((Columns)new Columns.Include("hashedPassword", "salt"), new Condition.Equals("id", entity.getId())));
        LogAction.create(this.getUserId(), entity);
        if (currentUser != null && currentUser.getUserLimit() != 0) {
            this.storage.addPermission(new Permission(User.class, this.getUserId(), ManagedUser.class, entity.getId()));
            LogAction.link(this.getUserId(), User.class, this.getUserId(), ManagedUser.class, entity.getId());
        }
        return Response.ok((Object)entity).build();
    }

    @Override
    @Path(value="{id}")
    @DELETE
    public Response remove(@PathParam(value="id") long id) throws Exception {
        Response response = super.remove(id);
        if (this.getUserId() == id) {
            this.request.getSession().removeAttribute("userId");
        }
        return response;
    }

    @Path(value="totp")
    @PermitAll
    @POST
    public String generateTotpKey() throws StorageException {
        if (!this.permissionsService.getServer().getBoolean(Keys.WEB_TOTP_ENABLE.getKey())) {
            throw new SecurityException("One-time password is disabled");
        }
        return new GoogleAuthenticator().createCredentials().getKey();
    }
}

