/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;

class GenericGlowingChiclet {
    public static final int STATE_PRESSED = 1;
    public static final int STATE_SELECTED = 2;
    public static final int STATE_ACTIVE = 4;
    public static final int STATE_CLOSING = 8;
    public static final int STATE_ATTENTION = 16;
    static Color[] selectedActive = new Color[]{new Color(220, 238, 255), new Color(139, 187, 238), new Color(90, 143, 229), new Color(190, 247, 255)};
    static Color[] selectedPressedActive = new Color[]{selectedActive[0], new Color(50, 150, 229), new Color(80, 80, 200), selectedActive[3]};
    static Color[] inactive = new Color[]{Color.WHITE, new Color(222, 222, 227), new Color(205, 205, 205), new Color(246, 243, 249)};
    static Color[] active = new Color[]{Color.WHITE, new Color(222, 222, 227), new Color(205, 205, 205), new Color(246, 243, 249)};
    static Color[] selectedInactive = new Color[]{new Color(240, 250, 255), new Color(212, 222, 242), new Color(180, 190, 200), new Color(230, 230, 255)};
    static Color[] closing = new Color[]{new Color(255, 238, 220), new Color(238, 137, 109), new Color(255, 50, 50), new Color(255, 237, 40)};
    static Color[] attention = new Color[]{new Color(255, 255, 220), new Color(238, 237, 109), new Color(255, 255, 50), new Color(255, 237, 40)};
    private Color upperTop = selectedActive[0];
    private Color upperBottom = selectedActive[1];
    private Color lowerTop = selectedActive[2];
    private Color lowerBottom = selectedActive[3];
    private Rectangle scratch = new Rectangle();
    private float fupperLeftArc = 0.0f;
    private float fupperRightArc = 0.0f;
    private float flowerLeftArc = 0.0f;
    private float flowerRightArc = 0.0f;
    private int upperLeftArc = 0;
    private int upperRightArc = 0;
    private int lowerLeftArc = 0;
    private int lowerRightArc = 0;
    private boolean usePercentages = false;
    private boolean notchRight = false;
    private boolean notchLeft = false;
    protected boolean changed = false;
    protected int state = 6;
    public static final GenericGlowingChiclet INSTANCE = new GenericGlowingChiclet();
    private Rectangle bounds = new Rectangle();
    private boolean allowVertical = false;
    private boolean drawOutline = true;
    private Shape clip = null;

    protected GenericGlowingChiclet() {
    }

    public void setColors(Color color, Color color2, Color color3, Color color4) {
        this.changed |= !color.equals(this.getUpperTop()) || !color2.equals(this.getUpperBottom()) || !color3.equals(this.getLowerTop()) || !color4.equals(this.getLowerBottom());
        this.upperTop = color;
        this.upperBottom = color2;
        this.lowerTop = color3;
        this.lowerBottom = color4;
    }

    public Color[] getColors() {
        return new Color[]{this.getUpperTop(), this.getUpperBottom(), this.getLowerTop(), this.getLowerBottom()};
    }

    protected int getState() {
        return this.state;
    }

    public void setState(int n) {
        this.changed |= this.state != n;
        if (this.state != n) {
            Color[] colorArray;
            if ((this.state & 1) != 0) {
                this.state |= 4;
            }
            this.state = n;
            if ((this.state & 8) != 0) {
                colorArray = closing;
            } else if ((this.state & 0x10) != 0) {
                colorArray = attention;
            } else {
                switch (this.state) {
                    case 5: 
                    case 7: {
                        colorArray = selectedPressedActive;
                        break;
                    }
                    case 6: {
                        colorArray = selectedActive;
                        break;
                    }
                    case 2: {
                        colorArray = selectedInactive;
                        break;
                    }
                    case 4: {
                        colorArray = active;
                        break;
                    }
                    default: {
                        colorArray = inactive;
                    }
                }
            }
            this.upperTop = colorArray[0];
            this.upperBottom = colorArray[1];
            this.lowerTop = colorArray[2];
            this.lowerBottom = colorArray[3];
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.changed |= n != this.bounds.x || n2 != this.bounds.y || n3 != this.bounds.width || n4 != this.bounds.height;
        this.bounds.setBounds(n, n2, n3, n4 - 1);
    }

    public void setAllowVertical(boolean bl) {
        if (bl != this.allowVertical) {
            this.allowVertical = bl;
            this.changed = true;
        }
    }

    private Rectangle getBounds() {
        this.scratch.setBounds(this.bounds);
        return this.scratch;
    }

    public void setArcs(int n, int n2, int n3, int n4) {
        this.changed |= n != this.upperLeftArc || n2 != this.upperRightArc || n3 != this.lowerLeftArc || n4 != this.lowerRightArc || this.usePercentages;
        this.upperLeftArc = n;
        this.upperRightArc = n2;
        this.lowerLeftArc = n3;
        this.lowerRightArc = n4;
        this.usePercentages = false;
    }

    public void setArcs(float f, float f2, float f3, float f4) {
        this.changed |= f != this.fupperLeftArc || f2 != this.fupperRightArc || f3 != this.flowerLeftArc || f4 != this.flowerRightArc || !this.usePercentages;
        this.fupperLeftArc = f;
        this.fupperRightArc = f2;
        this.flowerLeftArc = f3;
        this.flowerRightArc = f4;
        this.usePercentages = true;
    }

    public void setNotch(boolean bl, boolean bl2) {
        this.changed |= bl != this.notchRight || bl2 != this.notchLeft;
        this.notchRight = bl;
        this.notchLeft = bl2;
    }

    private int getNotchRightArc() {
        int n = this.getUpperRightArc();
        if (n == 0) {
            n = this.bounds.height / 2;
        }
        return n / 3;
    }

    private int getNotchLeftArc() {
        int n = this.getUpperLeftArc();
        if (n == 0) {
            n = this.bounds.height / 2;
        }
        return n / 3;
    }

    private int getUpperLeftArc() {
        if (!this.usePercentages) {
            return this.upperLeftArc;
        }
        return Math.round(this.fupperLeftArc * (float)Math.min(this.getBounds().height, this.getBounds().width));
    }

    private int getUpperRightArc() {
        if (!this.usePercentages) {
            return this.upperRightArc;
        }
        return Math.round(this.fupperRightArc * (float)Math.min(this.getBounds().height, this.getBounds().width));
    }

    private int getLowerLeftArc() {
        if (!this.usePercentages) {
            return this.lowerLeftArc;
        }
        return Math.round(this.flowerLeftArc * (float)Math.min(this.getBounds().height, this.getBounds().width));
    }

    private int getLowerRightArc() {
        if (!this.usePercentages) {
            return this.lowerRightArc;
        }
        return Math.round(this.flowerRightArc * (float)Math.min(this.getBounds().height, this.getBounds().width));
    }

    public void draw(Graphics2D graphics2D) {
        if (this.bounds.width == 0 || this.bounds.height == 0) {
            return;
        }
        this.drawInterior(graphics2D);
        if (this.drawOutline) {
            this.drawOutline(graphics2D);
        }
        this.changed = false;
    }

    public void setDrawOutline(boolean bl) {
        this.drawOutline = bl;
    }

    private void drawOutline(Graphics2D graphics2D) {
        Shape shape = this.getClipShape();
        graphics2D.setColor(this.dark());
        graphics2D.setStroke(new BasicStroke(0.95f));
        Rectangle rectangle = this.getBounds();
        ++rectangle.height;
        Shape shape2 = graphics2D.getClip();
        if (shape2 != null) {
            Area area = new Area(shape2);
            area.intersect(new Area(rectangle));
            graphics2D.setClip(area);
        } else {
            graphics2D.setClip(rectangle);
        }
        graphics2D.draw(shape);
        graphics2D.setColor(this.getOutlineDark());
        rectangle = this.getBounds();
        graphics2D.setStroke(new BasicStroke(0.7f));
        if (this.getLowerRightArc() != 0) {
            graphics2D.drawLine(Math.max(rectangle.x, rectangle.x + this.getLowerLeftArc() - 3), rectangle.y + rectangle.height - 1, Math.min(rectangle.x + rectangle.width - this.getLowerRightArc() + 3, rectangle.x + rectangle.width) - 1, rectangle.y + rectangle.height - 1);
        } else {
            graphics2D.drawLine(Math.max(rectangle.x, rectangle.x + this.getLowerLeftArc() - 3), rectangle.y + rectangle.height - 1, Math.min(rectangle.x + rectangle.width - this.getLowerRightArc() + 3, rectangle.x + rectangle.width), rectangle.y + rectangle.height - 1);
        }
        graphics2D.setClip(shape2);
    }

    protected Color getOutlineDark() {
        return new Color(50, 50, 50);
    }

    private void drawInterior(Graphics2D graphics2D) {
        Rectangle rectangle;
        Shape shape = this.getClipShape();
        Area area = new Area(shape);
        Shape shape2 = graphics2D.getClip();
        if (shape2 != null) {
            area.intersect(new Area(shape2));
        }
        if (this.isVertical()) {
            rectangle = this.getBounds();
            rectangle.width /= 2;
            area.intersect(new Area(rectangle));
            graphics2D.setClip(area);
            graphics2D.setPaint(this.getLeftPaint());
            graphics2D.fill(shape);
            rectangle = this.getBounds();
            rectangle.width /= 2;
            rectangle.x += rectangle.width;
            area = new Area(shape);
            if (shape2 != null) {
                area.intersect(new Area(shape2));
            }
            area.intersect(new Area(rectangle));
            graphics2D.setClip(area);
            graphics2D.setPaint(this.getRightPaint());
            graphics2D.fill(shape);
        } else {
            rectangle = this.getBounds();
            rectangle.height /= 2;
            area.intersect(new Area(rectangle));
            graphics2D.setClip(area);
            graphics2D.setPaint(this.getUpperPaint());
            graphics2D.fill(shape);
            area = new Area(shape);
            if (shape2 != null) {
                area.intersect(new Area(shape2));
            }
            rectangle = this.getBounds();
            rectangle.y += rectangle.height / 2;
            rectangle.height -= rectangle.height / 2;
            area.intersect(new Area(rectangle));
            graphics2D.setClip(area);
            graphics2D.setPaint(this.getLowerPaint());
            graphics2D.fill(shape);
        }
        Composite composite = graphics2D.getComposite();
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.8f);
        graphics2D.setComposite(alphaComposite);
        int n = this.getUpperLeftArc();
        rectangle = this.getBounds();
        rectangle.width = n;
        rectangle.height /= 2;
        area = new Area(shape);
        if (shape2 != null) {
            area.intersect(new Area(shape2));
        }
        area.intersect(new Area(rectangle));
        graphics2D.setClip(area);
        graphics2D.setPaint(this.getUpperLeftPaint());
        graphics2D.fill(shape);
        n = this.getUpperRightArc();
        rectangle = this.getBounds();
        rectangle.x = rectangle.x + rectangle.width - n;
        rectangle.width = n;
        rectangle.height /= 2;
        area = new Area(shape);
        if (shape2 != null) {
            area.intersect(new Area(shape2));
        }
        area.intersect(new Area(rectangle));
        graphics2D.setClip(area);
        graphics2D.setPaint(this.getUpperRightPaint());
        graphics2D.fill(shape);
        n = this.getLowerRightArc();
        rectangle = this.getBounds();
        rectangle.x = rectangle.x + rectangle.width - n;
        rectangle.width = n;
        rectangle.y += rectangle.height / 2;
        rectangle.height /= 2;
        area = new Area(shape);
        if (shape2 != null) {
            area.intersect(new Area(shape2));
        }
        area.intersect(new Area(rectangle));
        graphics2D.setClip(area);
        graphics2D.setPaint(this.getLowerRightPaint());
        graphics2D.fill(shape);
        n = this.getLowerLeftArc();
        rectangle = this.getBounds();
        rectangle.width = n;
        rectangle.y += rectangle.height / 2;
        rectangle.height /= 2;
        area = new Area(shape);
        if (shape2 != null) {
            area.intersect(new Area(shape2));
        }
        area.intersect(new Area(rectangle));
        graphics2D.setClip(area);
        graphics2D.setPaint(this.getLowerLeftPaint());
        graphics2D.fill(shape);
        graphics2D.setClip(shape2);
        graphics2D.setComposite(composite);
    }

    private boolean isVertical() {
        if (!this.allowVertical) {
            return false;
        }
        return this.bounds.height > this.bounds.width;
    }

    private GradientPaint getUpperPaint() {
        Rectangle rectangle = this.getBounds();
        return ColorUtil.getGradientPaint(rectangle.x, rectangle.y + rectangle.height / 9, this.getUpperTop(), rectangle.x, rectangle.y + rectangle.height / 2, this.getUpperBottom(), true);
    }

    private GradientPaint getLowerPaint() {
        Rectangle rectangle = this.getBounds();
        return ColorUtil.getGradientPaint(rectangle.x, rectangle.y + rectangle.height / 2, this.getLowerTop(), rectangle.x, rectangle.y + rectangle.height, this.getLowerBottom(), false);
    }

    private GradientPaint getLeftPaint() {
        Rectangle rectangle = this.getBounds();
        return ColorUtil.getGradientPaint(rectangle.x, rectangle.y, this.getUpperTop(), rectangle.x + rectangle.width / 2, rectangle.y, this.getUpperBottom());
    }

    private GradientPaint getRightPaint() {
        Rectangle rectangle = this.getBounds();
        return ColorUtil.getGradientPaint(rectangle.x + rectangle.width / 2, rectangle.y, this.getLowerTop(), rectangle.x + rectangle.width, rectangle.y, this.getLowerBottom());
    }

    private GradientPaint getUpperLeftPaint() {
        Rectangle rectangle = this.getBounds();
        int n = this.getUpperLeftArc();
        if (!this.isVertical()) {
            return ColorUtil.getGradientPaint(rectangle.x, rectangle.y + rectangle.height / 2, this.dark(), rectangle.x + n / 2, rectangle.y + rectangle.height / 2 - n / 2, this.light());
        }
        return ColorUtil.getGradientPaint(rectangle.x + rectangle.width / 2, rectangle.y, this.dark(), rectangle.x + rectangle.width / 2 - n / 2, rectangle.y + n, this.light());
    }

    private GradientPaint getUpperRightPaint() {
        Rectangle rectangle = this.getBounds();
        int n = this.getUpperRightArc();
        if (!this.isVertical()) {
            return ColorUtil.getGradientPaint(rectangle.x + rectangle.width, rectangle.y + rectangle.height / 2, this.dark(), rectangle.x + rectangle.width - n / 2, rectangle.y + rectangle.height / 2 - n / 2, this.light());
        }
        return ColorUtil.getGradientPaint(rectangle.x + rectangle.width / 2, rectangle.y, this.dark(), rectangle.x + rectangle.width / 2 + n / 2, rectangle.y + n, this.light());
    }

    private GradientPaint getLowerRightPaint() {
        Rectangle rectangle = this.getBounds();
        int n = this.getLowerRightArc();
        if (!this.isVertical()) {
            return ColorUtil.getGradientPaint(rectangle.x + rectangle.width, rectangle.y + rectangle.height / 2, this.dark(), rectangle.x + rectangle.width - n / 2, rectangle.y + rectangle.height / 2 + n / 2, this.light());
        }
        return ColorUtil.getGradientPaint(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height, this.dark(), rectangle.x + rectangle.width / 2 + n / 2, rectangle.y + rectangle.height - n, this.light());
    }

    private GradientPaint getLowerLeftPaint() {
        Rectangle rectangle = this.getBounds();
        int n = this.getLowerLeftArc();
        if (!this.isVertical()) {
            return ColorUtil.getGradientPaint(rectangle.x, rectangle.y + rectangle.height / 2, this.dark(), rectangle.x + n / 2, rectangle.y + rectangle.height / 2 + n / 2, this.light());
        }
        return ColorUtil.getGradientPaint(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height, this.dark(), rectangle.x + rectangle.width / 2 - n / 2, rectangle.y + rectangle.height - n, this.light());
    }

    private Shape getClipShape() {
        if (this.changed) {
            this.update();
        }
        if (this.clip == null) {
            this.clip = this.createClip();
        }
        return this.clip;
    }

    protected Color dark() {
        if ((this.getState() & 2) != 0 && (this.getState() & 4) != 0) {
            return new Color(80, 80, 150);
        }
        return new Color(130, 130, 150);
    }

    private Color light() {
        Color color = this.dark();
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), 0);
    }

    private void update() {
        this.clip = null;
    }

    private Shape createClip() {
        Rectangle rectangle = this.getBounds();
        if (!(this.notchLeft || this.notchRight || this.usePercentages || this.upperRightArc != this.lowerRightArc || this.lowerRightArc != this.lowerLeftArc || this.lowerLeftArc != this.upperLeftArc || this.upperLeftArc != 0)) {
            return new Rectangle(this.getBounds());
        }
        int n = this.getUpperRightArc();
        int n2 = this.getLowerRightArc();
        int n3 = this.getUpperLeftArc();
        int n4 = this.getLowerLeftArc();
        int n5 = this.getNotchRightArc();
        int n6 = this.getNotchLeftArc();
        GeneralPath generalPath = new GeneralPath();
        if (this.notchLeft) {
            generalPath.moveTo(rectangle.x + n6, rectangle.y + rectangle.height / 2);
            generalPath.curveTo(rectangle.x + n6, rectangle.y + rectangle.height / 2, rectangle.x + n6, rectangle.y + rectangle.height / 2 - n6, rectangle.x, rectangle.y + rectangle.height / 2 - n6);
            if (rectangle.y + rectangle.height / 2 - n6 > rectangle.y + n3) {
                generalPath.lineTo(rectangle.x, rectangle.y + n3);
            }
            generalPath.curveTo(rectangle.x, Math.min(rectangle.y + n3, rectangle.y + rectangle.height / 2 - n6), rectangle.x, rectangle.y, rectangle.x + n3, rectangle.y);
        } else {
            generalPath.moveTo(rectangle.x, rectangle.y + rectangle.height - n4);
            if (rectangle.y + rectangle.height - n4 > rectangle.y + n3) {
                generalPath.lineTo(rectangle.x, rectangle.y + n3);
            }
            generalPath.curveTo(rectangle.x, rectangle.y + n3, rectangle.x, rectangle.y, rectangle.x + n3, rectangle.y);
        }
        if (rectangle.x + rectangle.width - n3 > rectangle.x + n) {
            generalPath.lineTo(rectangle.x + rectangle.width - n, rectangle.y);
        }
        if (this.notchRight) {
            generalPath.curveTo(rectangle.x + rectangle.width - n - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, Math.min(rectangle.y + n, rectangle.y + rectangle.height / 2 - n5));
            if (rectangle.y + n < rectangle.y + rectangle.height / 2 - n5) {
                generalPath.lineTo(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height / 2 - n5);
            }
            generalPath.curveTo(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height / 2 - n5, rectangle.x + rectangle.width - n5 - 1, rectangle.y + rectangle.height / 2 - n5, rectangle.x + rectangle.width - n5 - 1, rectangle.y + rectangle.height / 2);
            generalPath.curveTo(rectangle.x + rectangle.width - n5 - 1, rectangle.y + rectangle.height / 2, rectangle.x + rectangle.width - n5 - 1, rectangle.y + rectangle.height / 2 + n5, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height / 2 + n5);
            if (rectangle.y + rectangle.height / 2 + n5 < rectangle.y + rectangle.height - n2) {
                generalPath.lineTo(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - n2);
            }
            generalPath.curveTo(rectangle.x + rectangle.width - 1, Math.max(rectangle.y + rectangle.height / 2 + n5, rectangle.y + rectangle.height - n2), rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height, rectangle.x + rectangle.width - n2 - 1, rectangle.y + rectangle.height);
        } else {
            if (n != 0) {
                generalPath.curveTo(rectangle.x + rectangle.width - n - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + n);
            } else {
                generalPath.curveTo(rectangle.x + rectangle.width - n, rectangle.y, rectangle.x + rectangle.width, rectangle.y, rectangle.x + rectangle.width, rectangle.y + n);
            }
            if (rectangle.y + n < rectangle.y + rectangle.height - n2) {
                if (n != 0 && n2 != 0) {
                    generalPath.lineTo(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - n2);
                } else {
                    generalPath.lineTo(rectangle.x + rectangle.width, rectangle.y + rectangle.height - n2);
                }
            }
            if (n2 != 0) {
                generalPath.curveTo(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - n2, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height, rectangle.x + rectangle.width - n2 - 1, rectangle.y + rectangle.height);
            } else {
                generalPath.curveTo(rectangle.x + rectangle.width, rectangle.y + rectangle.height - n2, rectangle.x + rectangle.width, rectangle.y + rectangle.height, rectangle.x + rectangle.width - n2, rectangle.y + rectangle.height);
            }
        }
        if (rectangle.x + rectangle.width - n2 > rectangle.x + n4) {
            generalPath.lineTo(rectangle.x + n4, rectangle.y + rectangle.height);
        }
        if (this.notchLeft) {
            generalPath.curveTo(rectangle.x + n4, rectangle.y + rectangle.height, rectangle.x, rectangle.y + rectangle.height, rectangle.x, Math.max(rectangle.y + rectangle.height - n4, rectangle.y + rectangle.height / 2 + n6));
            if (rectangle.y + rectangle.height - n4 > rectangle.y + rectangle.height / 2 + n6) {
                generalPath.lineTo(rectangle.x, rectangle.y + rectangle.height / 2 + n6);
            }
            generalPath.curveTo(rectangle.x, rectangle.y + rectangle.height / 2 + n6, rectangle.x + n6, rectangle.y + rectangle.height / 2 + n6, rectangle.x + n6, rectangle.y + rectangle.height / 2);
        } else {
            generalPath.curveTo(rectangle.x + n4, rectangle.y + rectangle.height, rectangle.x, rectangle.y + rectangle.height, rectangle.x, rectangle.y + rectangle.height - n4);
        }
        return generalPath;
    }

    protected Color getUpperTop() {
        return this.upperTop;
    }

    protected Color getUpperBottom() {
        return this.upperBottom;
    }

    protected Color getLowerTop() {
        return this.lowerTop;
    }

    protected Color getLowerBottom() {
        return this.lowerBottom;
    }
}

