/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class LTOObjectBuffer
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BUFFER;
    public static final int SIZE;

    public LTOObjectBuffer(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), LTOObjectBuffer.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char const *")
    public ByteBuffer Buffer() {
        return LTOObjectBuffer.nBuffer(this.address());
    }

    @NativeType(value="size_t")
    public long Size() {
        return LTOObjectBuffer.nSize(this.address());
    }

    public static LTOObjectBuffer malloc() {
        return (LTOObjectBuffer)LTOObjectBuffer.wrap(LTOObjectBuffer.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static LTOObjectBuffer calloc() {
        return (LTOObjectBuffer)LTOObjectBuffer.wrap(LTOObjectBuffer.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static LTOObjectBuffer create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (LTOObjectBuffer)LTOObjectBuffer.wrap(LTOObjectBuffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static LTOObjectBuffer create(long address) {
        return (LTOObjectBuffer)LTOObjectBuffer.wrap(LTOObjectBuffer.class, (long)address);
    }

    @Nullable
    public static LTOObjectBuffer createSafe(long address) {
        return address == 0L ? null : (LTOObjectBuffer)LTOObjectBuffer.wrap(LTOObjectBuffer.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)LTOObjectBuffer.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)LTOObjectBuffer.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)LTOObjectBuffer.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LTOObjectBuffer.__create((int)capacity, (int)SIZEOF);
        return (Buffer)LTOObjectBuffer.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)LTOObjectBuffer.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)LTOObjectBuffer.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static LTOObjectBuffer mallocStack() {
        return LTOObjectBuffer.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static LTOObjectBuffer callocStack() {
        return LTOObjectBuffer.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static LTOObjectBuffer mallocStack(MemoryStack stack) {
        return LTOObjectBuffer.malloc(stack);
    }

    @Deprecated
    public static LTOObjectBuffer callocStack(MemoryStack stack) {
        return LTOObjectBuffer.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return LTOObjectBuffer.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return LTOObjectBuffer.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return LTOObjectBuffer.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return LTOObjectBuffer.calloc(capacity, stack);
    }

    public static LTOObjectBuffer malloc(MemoryStack stack) {
        return (LTOObjectBuffer)LTOObjectBuffer.wrap(LTOObjectBuffer.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static LTOObjectBuffer calloc(MemoryStack stack) {
        return (LTOObjectBuffer)LTOObjectBuffer.wrap(LTOObjectBuffer.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)LTOObjectBuffer.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)LTOObjectBuffer.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static ByteBuffer nBuffer(long struct) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)BUFFER)), (int)((int)LTOObjectBuffer.nSize(struct)));
    }

    public static long nSize(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SIZE));
    }

    static {
        Struct.Layout layout = LTOObjectBuffer.__struct((Struct.Member[])new Struct.Member[]{LTOObjectBuffer.__member((int)POINTER_SIZE), LTOObjectBuffer.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BUFFER = layout.offsetof(0);
        SIZE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LTOObjectBuffer, Buffer>
    implements NativeResource {
        private static final LTOObjectBuffer ELEMENT_FACTORY = LTOObjectBuffer.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected LTOObjectBuffer getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char const *")
        public ByteBuffer Buffer() {
            return LTOObjectBuffer.nBuffer(this.address());
        }

        @NativeType(value="size_t")
        public long Size() {
            return LTOObjectBuffer.nSize(this.address());
        }
    }
}

