/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.computed.page;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.page.PageSize;
import org.jfree.layouting.input.style.keys.page.PageSizeFactory;
import org.jfree.layouting.input.style.keys.page.PageStyleKeys;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSStringValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValuePair;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.ResolveHandler;

public class PageSizeResolveHandler
implements ResolveHandler {
    @Override
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[0];
    }

    @Override
    public void resolve(LayoutProcess layoutProcess, LayoutElement layoutElement, StyleKey styleKey) {
        Object object;
        LayoutContext layoutContext = layoutElement.getLayoutContext();
        CSSValue cSSValue = layoutContext.getValue(PageStyleKeys.SIZE);
        String string = null;
        if (cSSValue instanceof CSSStringValue) {
            object = (CSSStringValue)cSSValue;
            string = ((CSSStringValue)object).getValue();
        } else if (cSSValue instanceof CSSConstant) {
            string = cSSValue.toString();
        }
        object = null;
        if (string != null) {
            object = PageSizeFactory.getInstance().getPageSizeByName(string);
        }
        if (object == null) {
            object = layoutProcess.getOutputMetaData().getDefaultPageSize();
        }
        CSSValuePair cSSValuePair = new CSSValuePair(CSSNumericValue.createPtValue(((PageSize)object).getWidth()), CSSNumericValue.createPtValue(((PageSize)object).getHeight()));
        layoutContext.setValue(PageStyleKeys.SIZE, cSSValuePair);
    }
}

