/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.organization.jpa;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelValidationException;
import org.keycloak.models.OrganizationDomainModel;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.jpa.JpaModel;
import org.keycloak.models.jpa.entities.OrganizationDomainEntity;
import org.keycloak.models.jpa.entities.OrganizationEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.organization.OrganizationProvider;
import org.keycloak.utils.EmailValidationUtil;
import org.keycloak.utils.StringUtil;

public final class OrganizationAdapter
implements OrganizationModel,
JpaModel<OrganizationEntity> {
    private final KeycloakSession session;
    private final RealmModel realm;
    private final OrganizationEntity entity;
    private final OrganizationProvider provider;
    private GroupModel group;
    private Map<String, List<String>> attributes;

    public OrganizationAdapter(KeycloakSession session, RealmModel realm, OrganizationEntity entity, OrganizationProvider provider) {
        this.session = session;
        this.realm = realm;
        this.entity = entity;
        this.provider = provider;
    }

    public String getId() {
        return this.entity.getId();
    }

    RealmModel getRealm() {
        return this.realm;
    }

    public String getGroupId() {
        return this.entity.getGroupId();
    }

    void setGroupId(String id) {
        this.entity.setGroupId(id);
    }

    public void setName(String name) {
        this.entity.setName(name);
    }

    public String getName() {
        return this.entity.getName();
    }

    public String getAlias() {
        return this.entity.getAlias();
    }

    public void setAlias(String alias) {
        if (StringUtil.isBlank((String)alias)) {
            alias = this.getName();
        }
        if (alias.equals(this.entity.getAlias())) {
            return;
        }
        if (StringUtil.isNotBlank((String)this.entity.getAlias())) {
            throw new ModelValidationException("Cannot change the alias");
        }
        this.entity.setAlias(alias);
    }

    public boolean isEnabled() {
        return this.provider.isEnabled() && this.entity.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.entity.setEnabled(enabled);
    }

    public String getDescription() {
        return this.entity.getDescription();
    }

    public void setDescription(String description) {
        this.entity.setDescription(description);
    }

    public String getRedirectUrl() {
        return this.entity.getRedirectUrl();
    }

    public void setRedirectUrl(String redirectUrl) {
        this.entity.setRedirectUrl(redirectUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(Map<String, List<String>> attributes) {
        if (attributes == null) {
            return;
        }
        OrganizationModel current = this.session.getContext().getOrganization();
        if (current == null) {
            this.session.getContext().setOrganization((OrganizationModel)this);
        }
        try {
            Set<String> attrsToRemove = this.getAttributes().keySet();
            attrsToRemove.removeAll(attributes.keySet());
            attrsToRemove.forEach(arg_0 -> ((GroupModel)this.group).removeAttribute(arg_0));
            attributes.forEach((arg_0, arg_1) -> ((GroupModel)this.group).setAttribute(arg_0, arg_1));
        }
        finally {
            if (current == null) {
                this.session.getContext().setOrganization(null);
            }
        }
    }

    public Map<String, List<String>> getAttributes() {
        if (this.attributes == null) {
            this.attributes = Optional.ofNullable(this.getGroup().getAttributes()).orElse(Map.of());
        }
        return this.attributes;
    }

    public Stream<OrganizationDomainModel> getDomains() {
        return this.entity.getDomains().stream().map(this::toModel);
    }

    public void setDomains(Set<OrganizationDomainModel> domains) {
        if (domains == null || domains.isEmpty()) {
            throw new ModelValidationException("You must provide at least one domain");
        }
        Map modelMap = domains.stream().map(this::validateDomain).collect(Collectors.toMap(OrganizationDomainModel::getName, Function.identity()));
        for (OrganizationDomainEntity domainEntity : new HashSet<OrganizationDomainEntity>(this.entity.getDomains())) {
            if (modelMap.containsKey(domainEntity.getName())) {
                domainEntity.setVerified(((OrganizationDomainModel)modelMap.get(domainEntity.getName())).isVerified());
                modelMap.remove(domainEntity.getName());
                continue;
            }
            this.entity.removeDomain(domainEntity);
            this.getIdentityProviders().filter(idp -> Objects.equals(domainEntity.getName(), idp.getConfig().get("kc.org.domain"))).forEach(idp -> {
                idp.getConfig().remove("kc.org.domain");
                this.session.identityProviders().update(idp);
            });
        }
        for (OrganizationDomainModel model : modelMap.values()) {
            OrganizationDomainEntity domainEntity = new OrganizationDomainEntity();
            domainEntity.setId(KeycloakModelUtils.generateId());
            domainEntity.setName(model.getName());
            domainEntity.setVerified(model.isVerified());
            domainEntity.setOrganization(this.entity);
            this.entity.addDomain(domainEntity);
        }
    }

    public Stream<IdentityProviderModel> getIdentityProviders() {
        return this.provider.getIdentityProviders((OrganizationModel)this);
    }

    public boolean isManaged(UserModel user) {
        return this.provider.isManagedMember((OrganizationModel)this, user);
    }

    public boolean isMember(UserModel user) {
        return this.provider.isMember((OrganizationModel)this, user);
    }

    @Override
    public OrganizationEntity getEntity() {
        return this.entity;
    }

    public String toString() {
        return "id=" + this.getId() + "," + "name=" + this.getName() + "," + "realm=" + this.getRealm().getName() + "," + "groupId=" + this.getGroupId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OrganizationModel)) {
            return false;
        }
        OrganizationModel that = (OrganizationModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    private OrganizationDomainModel toModel(OrganizationDomainEntity entity) {
        return new OrganizationDomainModel(entity.getName(), entity.isVerified().booleanValue());
    }

    private OrganizationDomainModel validateDomain(OrganizationDomainModel domainModel) {
        String domainName = domainModel.getName();
        if (StringUtil.isBlank((String)domainName) || !EmailValidationUtil.isValidEmail((String)("nouser@" + domainName))) {
            throw new ModelValidationException("The specified domain is invalid: " + domainName);
        }
        OrganizationModel orgModel = this.provider.getByDomainName(domainName);
        if (orgModel != null && !Objects.equals(this.getId(), orgModel.getId())) {
            throw new ModelValidationException("Domain " + domainName + " is already linked to another organization in realm " + this.realm.getName());
        }
        return domainModel;
    }

    private GroupModel getGroup() {
        if (this.group == null) {
            this.group = this.realm.getGroupById(this.getGroupId());
        }
        return this.group;
    }
}

