/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.MultiOperator;
import io.smallrye.mutiny.operators.multi.MultiConcatOp;
import java.util.concurrent.Flow;
import java.util.function.Supplier;

public class MultiSwitchOnCompletion<T>
extends MultiOperator<T, T> {
    private final Supplier<Flow.Publisher<? extends T>> supplier;

    public MultiSwitchOnCompletion(Multi<T> upstream, Supplier<Flow.Publisher<? extends T>> supplier) {
        super(upstream);
        this.supplier = supplier;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        if (subscriber == null) {
            throw new NullPointerException("The subscriber must not be `null`");
        }
        Multi followup = Multi.createFrom().deferred(() -> {
            Flow.Publisher<? extends T> publisher;
            try {
                publisher = this.supplier.get();
            }
            catch (Throwable e) {
                return Multi.createFrom().failure(e);
            }
            if (publisher == null) {
                return Multi.createFrom().failure(new NullPointerException("The supplier returned `null`"));
            }
            if (publisher instanceof Multi) {
                return (Multi)publisher;
            }
            return Multi.createFrom().publisher(publisher);
        });
        Flow.Publisher[] publishers = new Flow.Publisher[]{this.upstream(), followup};
        Multi<? super T> op = Infrastructure.onMultiCreation(new MultiConcatOp(false, publishers));
        op.subscribe(subscriber);
    }
}

