/*
 * Decompiled with CFR 0.152.
 */
package io.github.skylot.raung.common.asm;

import io.github.skylot.raung.common.asm.TypeRefFormat;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public enum TypeRef {
    CLASS_TYPE_PARAMETER(0, "class_type_parameter", TypeRefFormat.TYPE_PARAM_INDEX),
    CLASS_TYPE_PARAMETER_BOUND(17, "class_type_parameter_bound", TypeRefFormat.TYPE_PARAM_BOUND_INDEX),
    METHOD_TYPE_PARAMETER(1, "method_type_parameter", TypeRefFormat.TYPE_PARAM_INDEX),
    METHOD_TYPE_PARAMETER_BOUND(18, "method_type_parameter_bound", TypeRefFormat.TYPE_PARAM_BOUND_INDEX),
    METHOD_FORMAL_PARAMETER(22, "method_formal_parameter", TypeRefFormat.FORMAL_PARAM_INDEX),
    METHOD_INVOCATION_TYPE_ARGUMENT(73, "method_invocation_type_argument", TypeRefFormat.TYPE_ARGUMENT_INDEX),
    CLASS_EXTENDS(16, "class_extends", TypeRefFormat.SUPER_TYPE_INDEX),
    CAST(71, "cast", TypeRefFormat.TYPE_ARGUMENT_INDEX),
    FIELD(19, "field", TypeRefFormat.NO_ARGS),
    METHOD_RETURN(20, "method_return", TypeRefFormat.NO_ARGS),
    NEW(68, "new", TypeRefFormat.NO_ARGS),
    LOCAL_VARIABLE(64, "local_variable", TypeRefFormat.NO_ARGS);

    private final int value;
    private final String name;
    private final TypeRefFormat format;
    private static final TypeRef[] ARR_BY_VALUE;
    private static final Map<String, TypeRef> MAP_BY_NAME;

    private TypeRef(int value, String name, TypeRefFormat format) {
        this.value = value;
        this.name = name;
        this.format = format;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public TypeRefFormat getFormat() {
        return this.format;
    }

    public static TypeRef getByValue(int value) {
        return ARR_BY_VALUE[value];
    }

    @Nullable
    public static TypeRef getByName(String name) {
        return MAP_BY_NAME.get(name);
    }

    static {
        TypeRef[] values = TypeRef.values();
        TypeRef[] arr = new TypeRef[80];
        HashMap<String, TypeRef> map = new HashMap<String, TypeRef>(values.length);
        TypeRef[] typeRefArray = values;
        int n = typeRefArray.length;
        for (int i = 0; i < n; ++i) {
            TypeRef ref;
            arr[ref.value] = ref = typeRefArray[i];
            map.put(ref.name, ref);
        }
        ARR_BY_VALUE = arr;
        MAP_BY_NAME = map;
    }
}

