/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.paths;

import io.quarkus.fs.util.ZipUtils;
import io.quarkus.paths.DirectoryPathTree;
import io.quarkus.paths.OpenPathTree;
import io.quarkus.paths.PathFilter;
import io.quarkus.paths.PathTree;
import io.quarkus.paths.PathTreeVisit;
import io.quarkus.paths.PathTreeWithManifest;
import io.quarkus.paths.PathVisit;
import io.quarkus.paths.PathVisitor;
import io.quarkus.paths.SharedArchivePathTree;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.jar.Manifest;

public class ArchivePathTree
extends PathTreeWithManifest
implements PathTree {
    private static final String DISABLE_JAR_CACHE_PROPERTY = "quarkus.bootstrap.disable-jar-cache";
    private static final boolean ENABLE_SHARING = !Boolean.getBoolean("quarkus.bootstrap.disable-jar-cache");
    protected final Path archive;
    private final PathFilter pathFilter;

    static ArchivePathTree forPath(Path path) {
        return ArchivePathTree.forPath(path, null, true);
    }

    static ArchivePathTree forPath(Path path, PathFilter filter) {
        return ArchivePathTree.forPath(path, filter, true);
    }

    static ArchivePathTree forPath(Path path, PathFilter filter, boolean manifestEnabled) {
        if (filter != null || !ENABLE_SHARING) {
            return new ArchivePathTree(path, filter, manifestEnabled);
        }
        return SharedArchivePathTree.forPath(path);
    }

    ArchivePathTree(Path archive) {
        this(archive, null);
    }

    ArchivePathTree(Path archive, PathFilter pathFilter) {
        this(archive, pathFilter, true);
    }

    ArchivePathTree(Path archive, PathFilter pathFilter, boolean manifestEnabled) {
        super(manifestEnabled);
        this.archive = archive;
        this.pathFilter = pathFilter;
    }

    @Override
    public Collection<Path> getRoots() {
        return List.of(this.archive);
    }

    @Override
    public void walk(PathVisitor visitor) {
        try (FileSystem fs = this.openFs();){
            Path dir = fs.getPath("/", new String[0]);
            PathTreeVisit.walk(this.archive, dir, this.pathFilter, this.getMultiReleaseMapping(), visitor);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read " + this.archive, e);
        }
    }

    private void ensureResourcePath(String path) {
        DirectoryPathTree.ensureResourcePath(this.archive.getFileSystem(), path);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected <T> T apply(String relativePath, Function<PathVisit, T> func, boolean manifestEnabled) {
        this.ensureResourcePath(relativePath);
        if (!PathFilter.isVisible(this.pathFilter, relativePath)) {
            return (T)func.apply(null);
        }
        if (manifestEnabled) {
            relativePath = this.toMultiReleaseRelativePath(relativePath);
        }
        try (FileSystem fs = this.openFs();){
            Path root;
            Path path;
            Iterator<Path> iterator = fs.getRootDirectories().iterator();
            do {
                if (!iterator.hasNext()) return (T)func.apply(null);
            } while (!Files.exists(path = (root = iterator.next()).resolve(relativePath), new LinkOption[0]));
            Object object = PathTreeVisit.process(this.archive, root, path, this.pathFilter, func);
            return (T)object;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read " + this.archive, e);
        }
    }

    @Override
    public void accept(String relativePath, Consumer<PathVisit> consumer) {
        this.ensureResourcePath(relativePath);
        if (!PathFilter.isVisible(this.pathFilter, relativePath)) {
            consumer.accept(null);
            return;
        }
        if (this.manifestEnabled) {
            relativePath = this.toMultiReleaseRelativePath(relativePath);
        }
        try (FileSystem fs = this.openFs();){
            for (Path root : fs.getRootDirectories()) {
                Path path = root.resolve(relativePath);
                if (!Files.exists(path, new LinkOption[0])) continue;
                PathTreeVisit.consume(this.archive, root, path, this.pathFilter, consumer);
                return;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read " + this.archive, e);
        }
        consumer.accept(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean contains(String relativePath) {
        this.ensureResourcePath(relativePath);
        if (!PathFilter.isVisible(this.pathFilter, relativePath)) {
            return false;
        }
        if (this.manifestEnabled) {
            relativePath = this.toMultiReleaseRelativePath(relativePath);
        }
        try (FileSystem fs = this.openFs();){
            Path root;
            Path path;
            Iterator<Path> iterator = fs.getRootDirectories().iterator();
            do {
                if (!iterator.hasNext()) return false;
            } while (!Files.exists(path = (root = iterator.next()).resolve(relativePath), new LinkOption[0]));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read " + this.archive, e);
        }
    }

    protected FileSystem openFs() throws IOException {
        return ZipUtils.newFileSystem((Path)this.archive);
    }

    @Override
    public OpenPathTree open() {
        try {
            return new OpenArchivePathTree(this.openFs());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public int hashCode() {
        return Objects.hash(this.archive, this.pathFilter, this.manifestEnabled);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArchivePathTree other = (ArchivePathTree)obj;
        return Objects.equals(this.archive, other.archive) && Objects.equals(this.pathFilter, other.pathFilter) && this.manifestEnabled == other.manifestEnabled;
    }

    protected class OpenArchivePathTree
    extends DirectoryPathTree {
        private final FileSystem fs;
        private final ReentrantReadWriteLock lock;

        protected OpenArchivePathTree(FileSystem fs) {
            super(fs.getPath("/", new String[0]), ArchivePathTree.this.pathFilter, ArchivePathTree.this);
            this.lock = new ReentrantReadWriteLock();
            this.fs = fs;
        }

        protected ReentrantReadWriteLock.ReadLock readLock() {
            return this.lock.readLock();
        }

        protected ReentrantReadWriteLock.WriteLock writeLock() {
            return this.lock.writeLock();
        }

        @Override
        protected void initManifest(Manifest m) {
            super.initManifest(m);
            ArchivePathTree.this.manifestReadLock().lock();
            try {
                if (!ArchivePathTree.this.manifestInitialized) {
                    ArchivePathTree.this.manifestReadLock().unlock();
                    ArchivePathTree.this.manifestWriteLock().lock();
                    ArchivePathTree.this.initManifest(m);
                    ArchivePathTree.this.manifestReadLock().lock();
                    ArchivePathTree.this.manifestWriteLock().unlock();
                }
            }
            finally {
                ArchivePathTree.this.manifestReadLock().unlock();
            }
        }

        @Override
        protected void initMultiReleaseMapping(Map<String, String> mrMapping) {
            super.initMultiReleaseMapping(mrMapping);
            if (ArchivePathTree.this.multiReleaseMapping == null) {
                ArchivePathTree.this.initMultiReleaseMapping(mrMapping);
            }
        }

        @Override
        public boolean isOpen() {
            return this.fs.isOpen();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected <T> T apply(String relativePath, Function<PathVisit, T> func, boolean manifestEnabled) {
            this.lock.readLock().lock();
            try {
                this.ensureOpen();
                T t = super.apply(relativePath, func, manifestEnabled);
                return t;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        @Override
        public void accept(String relativePath, Consumer<PathVisit> consumer) {
            this.lock.readLock().lock();
            try {
                this.ensureOpen();
                super.accept(relativePath, consumer);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        @Override
        public void walk(PathVisitor visitor) {
            this.lock.readLock().lock();
            try {
                this.ensureOpen();
                super.walk(visitor);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        @Override
        public boolean contains(String relativePath) {
            this.lock.readLock().lock();
            try {
                this.ensureOpen();
                boolean bl = super.contains(relativePath);
                return bl;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        @Override
        public Path getPath(String relativePath) {
            this.lock.readLock().lock();
            try {
                this.ensureOpen();
                Path path = super.getPath(relativePath);
                return path;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        private void ensureOpen() {
            if (this.isOpen()) {
                return;
            }
            throw new RuntimeException("Failed to access " + ArchivePathTree.this.getRoots() + " because the FileSystem has been closed");
        }

        @Override
        public void close() throws IOException {
            Throwable t = null;
            this.lock.writeLock().lock();
            try {
                super.close();
            }
            catch (Throwable e) {
                t = e;
                throw e;
            }
            finally {
                try {
                    this.fs.close();
                }
                catch (IOException e) {
                    if (t != null) {
                        e.addSuppressed(t);
                    }
                    throw e;
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
        }

        @Override
        public PathTree getOriginalTree() {
            return ArchivePathTree.this;
        }
    }
}

