/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.nativeimage.NativeImageAllowIncompleteClasspathAggregateBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageAllowIncompleteClasspathBuildItem;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public final class NativeImageAllowIncompleteClasspathAggregateStep {
    private static final Logger log = Logger.getLogger(NativeImageAllowIncompleteClasspathAggregateStep.class);

    @BuildStep
    NativeImageAllowIncompleteClasspathAggregateBuildItem aggregateIndividualItems(List<NativeImageAllowIncompleteClasspathBuildItem> list) {
        if (list.isEmpty()) {
            return new NativeImageAllowIncompleteClasspathAggregateBuildItem(false);
        }
        String extensionsRequiringBrokenClasspath = list.stream().map(NativeImageAllowIncompleteClasspathBuildItem::getExtensionName).collect(Collectors.joining(","));
        log.warn((Object)("The following extensions have required native-image to allow run-time resolution of classes: {" + extensionsRequiringBrokenClasspath + "}. This is a global requirement which might have unexpected effects on other extensions as well, and is a hint of the library needing some additional refactoring to better support GraalVM native-image. In the case of 3rd party dependencies and/or proprietary code there is not much we can do - please ask for support to your library vendor. If you incur in any problem with other Quarkus extensions, please try reproducing the problem without these extensions first."));
        return new NativeImageAllowIncompleteClasspathAggregateBuildItem(true);
    }
}

