/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.findusages;

import com.almworks.tracklink.findusages.CodeLinkUsage;
import com.almworks.tracklink.findusages.CodeLinkUsageGroup;
import com.almworks.tracklink.findusages.FindUsagesActionUtil;
import com.almworks.tracklink.findusages.FindUsagesSettings;
import com.almworks.tracklink.findusages.IssueLinkUsageViewPresentation;
import com.almworks.tracklink.findusages.VCSLinkUsage;
import com.almworks.tracklink.findusages.VCSLinkUsageGroup;
import com.almworks.tracklink.util.PluginIcons;
import com.almworks.tracklink.util.StringBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.rules.UsageGroupingRule;
import com.intellij.usages.rules.UsageGroupingRuleProvider;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@State(name="TL_CODELINK_TYPE_PROVIDER", storages={@Storage(id="other", file="$APP_CONFIG$/tlsettings.xml")})
public class CodelinkTypeGroupingRuleProvider
implements UsageGroupingRuleProvider,
ApplicationComponent,
PersistentStateComponent<CodelinkTypeGroupingRuleProvider> {
    private static final String RULE_TOGGLE_ATTR = "rule_toggle";
    public boolean myRuleToggleFlag = false;
    public FindUsagesSettings myFindUsageSettings = new FindUsagesSettings();

    @NonNls
    public String getComponentName() {
        return "TL_CODELINK_TYPE_PROVIDER";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public UsageGroupingRule[] getActiveRules(Project project) {
        ArrayList<Object> rules = new ArrayList<Object>();
        if (this.myRuleToggleFlag) {
            rules.add(new VCSLinkGroupingRule(project));
            rules.add(new CodeLinkGroupingRule(project));
        }
        return rules.toArray(new UsageGroupingRule[rules.size()]);
    }

    public AnAction[] createGroupingActions(UsageView view) {
        if (!(view.getPresentation() instanceof IssueLinkUsageViewPresentation)) {
            return AnAction.EMPTY_ARRAY;
        }
        UsageViewImpl impl = (UsageViewImpl)view;
        return new AnAction[]{new CustomRuleAction(impl, StringBundle.get("usages.group.by.issue", new Object[0]), PluginIcons.BUG)};
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myRuleToggleFlag = Boolean.parseBoolean(element.getAttributeValue(RULE_TOGGLE_ATTR));
    }

    public void writeExternal(Element element) throws WriteExternalException {
        element.setAttribute(RULE_TOGGLE_ATTR, String.valueOf(this.myRuleToggleFlag));
    }

    public CodelinkTypeGroupingRuleProvider getState() {
        return this;
    }

    public void loadState(CodelinkTypeGroupingRuleProvider state) {
        FindUsagesActionUtil.setDefaultFindUsagesSettings(state.myFindUsageSettings);
    }

    private class CustomRuleAction
    extends ToggleAction {
        private final UsageViewImpl myView;

        public CustomRuleAction(UsageViewImpl view, String text, Icon icon) {
            super(text, null, icon);
            this.myView = view;
        }

        protected boolean getOptionValue() {
            return CodelinkTypeGroupingRuleProvider.this.myRuleToggleFlag;
        }

        public boolean isSelected(AnActionEvent e) {
            return CodelinkTypeGroupingRuleProvider.this.myRuleToggleFlag;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            CodelinkTypeGroupingRuleProvider.this.myRuleToggleFlag = state;
            this.myView.rulesChanged();
        }
    }

    private static class CodeLinkGroupingRule
    implements UsageGroupingRule {
        private final Project myProject;

        public CodeLinkGroupingRule(Project project) {
            this.myProject = project;
        }

        public UsageGroup groupUsage(Usage usage) {
            if (usage instanceof CodeLinkUsage) {
                return new CodeLinkUsageGroup(this.myProject, ((CodeLinkUsage)usage).getFile());
            }
            return null;
        }
    }

    private static class VCSLinkGroupingRule
    implements UsageGroupingRule {
        private final Project myProject;

        public VCSLinkGroupingRule(Project project) {
            this.myProject = project;
        }

        public UsageGroup groupUsage(Usage usage) {
            if (usage instanceof VCSLinkUsage) {
                return new VCSLinkUsageGroup(this.myProject, ((VCSLinkUsage)usage).getFile());
            }
            return null;
        }
    }
}

