/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.swing.renderer;

import java.text.Format;
import org.graalvm.visualvm.lib.ui.Formatters;
import org.graalvm.visualvm.lib.ui.swing.renderer.FormattedLabelRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.RelativeRenderer;

public class NumberRenderer
extends FormattedLabelRenderer
implements RelativeRenderer {
    private final Format outputFormat;
    protected boolean renderingDiff;

    public NumberRenderer() {
        this((Format)null);
    }

    public NumberRenderer(Format outputFormat) {
        super(Formatters.numberFormat());
        this.outputFormat = outputFormat;
        this.setHorizontalAlignment(11);
    }

    @Override
    public void setDiffMode(boolean diffMode) {
        this.renderingDiff = diffMode;
    }

    @Override
    public boolean isDiffMode() {
        return this.renderingDiff;
    }

    @Override
    protected String getValueString(Object value, int row, Format format) {
        if (value == null) {
            return "-";
        }
        String s = super.getValueString(value, row, format);
        String string = s = this.outputFormat == null ? s : NumberRenderer.formatImpl(this.outputFormat, s);
        if (this.renderingDiff && value instanceof Number && ((Number)value).doubleValue() >= 0.0) {
            s = '+' + s;
        }
        return s;
    }
}

