/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.MetaInfCache;
import org.openide.util.lookup.implspi.SharedClassObjectBridge;

final class MetaInfServicesLookup
extends AbstractLookup {
    static final Logger LOGGER = Logger.getLogger(MetaInfServicesLookup.class.getName());
    private static final MetaInfCache CACHE = new MetaInfCache(512);
    private static Reference<Executor> RP = new WeakReference<Object>(null);
    private final Map<Class<?>, Object> classes = new WeakHashMap();
    private final ClassLoader loader;
    private final String prefix;

    static synchronized Executor getRP() {
        Executor executor = RP.get();
        if (executor == null) {
            try {
                Class<?> clazz = Class.forName("org.openide.util.RequestProcessor");
                executor = (Executor)clazz.newInstance();
            }
            catch (Throwable throwable) {
                try {
                    executor = Executors.newSingleThreadExecutor();
                }
                catch (Throwable throwable2) {
                    executor = new Executor(){

                        @Override
                        public void execute(Runnable runnable) {
                            runnable.run();
                        }
                    };
                }
            }
            RP = new SoftReference<Executor>(executor);
        }
        return executor;
    }

    public MetaInfServicesLookup(ClassLoader classLoader, String string) {
        this.loader = classLoader;
        this.prefix = string;
        LOGGER.log(Level.FINE, "Created: {0}", this);
    }

    @Override
    public String toString() {
        return "MetaInfServicesLookup[" + this.loader + "]";
    }

    @Override
    void beforeLookupResult(Lookup.Template<?> template) {
        this.beforeLookup(template);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void beforeLookup(Lookup.Template<?> template) {
        Class<?> clazz = template.getType();
        ArrayList arrayList = null;
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.classes.get(clazz) != null) {
                return;
            }
            arrayList = new ArrayList();
        }
        if (arrayList != null) {
            serializable = new HashSet();
            for (Class serializable2 : this.allSuper(clazz, (Set<Class<?>>)((Object)serializable))) {
                this.search(serializable2, arrayList);
            }
        }
        serializable = null;
        MetaInfServicesLookup metaInfServicesLookup = this;
        synchronized (metaInfServicesLookup) {
            if (this.classes.put(clazz, "") == null) {
                LinkedHashSet<AbstractLookup.Pair<?>> linkedHashSet = this.getPairsAsLHS();
                ArrayList<Item> arrayList2 = new ArrayList<Item>();
                for (AbstractLookup.Pair pair : linkedHashSet) {
                    arrayList2.add((Item)pair);
                }
                for (AbstractLookup.Pair pair : arrayList) {
                    this.insertItem((Item)pair, arrayList2);
                }
                serializable = this.setPairsAndCollectListeners(arrayList2);
            }
        }
        if (serializable != null) {
            this.notifyIn(MetaInfServicesLookup.getRP(), (HashSet<AbstractLookup.R>)serializable);
        }
    }

    private Set<Class<?>> allSuper(Class<?> clazz, Set<Class<?>> set) {
        set.add(clazz);
        Class<?> clazz2 = clazz.getSuperclass();
        if (clazz2 != null && clazz2 != Object.class) {
            set.add(clazz2);
        }
        for (Class<?> clazz3 : clazz.getInterfaces()) {
            this.allSuper(clazz3, set);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void search(Class<?> clazz, Collection<AbstractLookup.Pair<?>> collection) {
        Enumeration<URL> enumeration;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "Searching for {0} in {1} from {2}", new Object[]{clazz.getName(), clazz.getClassLoader(), this});
        }
        String string = this.prefix + clazz.getName();
        try {
            enumeration = this.loader.getResources(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        ArrayList<Item> arrayList = new ArrayList<Item>();
        ArrayList arrayList2 = new ArrayList();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            Object object;
            if (!bl) {
                bl = true;
                object = null;
                try {
                    object = this.loader.loadClass(clazz.getName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (object != clazz) {
                    if (object != null) {
                        LOGGER.log(Level.WARNING, "{0} is not the real McCoy! Actually found it in {1} (from {2}) but searched for from {3}", new Object[]{clazz.getName(), ((Class)object).getClassLoader(), this.loader, clazz.getClassLoader()});
                    } else {
                        LOGGER.log(Level.WARNING, "{0} could not be found in {1}", new Object[]{clazz.getName(), this.loader});
                    }
                    return;
                }
            }
            object = enumeration.nextElement();
            Item item = null;
            try (InputStream inputStream = ((URL)object).openStream();){
                String string2;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                while ((string2 = bufferedReader.readLine()) != null) {
                    if ((string2 = string2.trim()).startsWith("#position=")) {
                        if (item == null) {
                            LOGGER.log(Level.INFO, "Found line ''{0}'' in {1} but there is no item to associate it with", new Object[]{string2, object});
                            continue;
                        }
                        try {
                            item.position = Integer.parseInt(string2.substring(10));
                        }
                        catch (NumberFormatException numberFormatException) {
                            numberFormatException.printStackTrace();
                        }
                    }
                    if (item != null) {
                        this.insertItem(item, arrayList);
                        item = null;
                    }
                    if (string2.length() == 0) continue;
                    boolean bl2 = false;
                    if (string2.charAt(0) == '#') {
                        if (string2.length() == 1 || string2.charAt(1) != '-') continue;
                        bl2 = true;
                        string2 = string2.substring(2);
                    }
                    Class<?> clazz2 = null;
                    try {
                        Object object2 = ((URL)object).getContent(new Class[]{ClassLoader.class});
                        if (object2 instanceof ClassLoader) {
                            clazz2 = Class.forName(string2, false, (ClassLoader)object2);
                        }
                    }
                    catch (LinkageError linkageError) {
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        LOGGER.log(Level.FINER, "No class found in " + object, classNotFoundException);
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.FINER, "URL does not support classloader protocol " + object, iOException);
                    }
                    if (clazz2 == null) {
                        try {
                            clazz2 = Class.forName(string2, false, this.loader);
                        }
                        catch (LinkageError linkageError) {
                            if (bl2) continue;
                            throw new ClassNotFoundException(linkageError.getMessage(), linkageError);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            if (bl2) continue;
                            throw classNotFoundException;
                        }
                    }
                    if (!clazz.isAssignableFrom(clazz2)) {
                        throw new ClassNotFoundException(MetaInfServicesLookup.clazzToString(clazz2) + " not a subclass of " + MetaInfServicesLookup.clazzToString(clazz));
                    }
                    if (bl2) {
                        arrayList2.add(clazz2);
                        continue;
                    }
                    item = new Item(clazz2);
                }
                if (item == null) continue;
                this.insertItem(item, arrayList);
                item = null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOGGER.log(Level.INFO, null, classNotFoundException);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.INFO, null, iOException);
            }
        }
        LOGGER.log(Level.FINER, "Found impls of {0}: {1} and removed: {2} from: {3}", new Object[]{clazz.getName(), arrayList, arrayList2, this});
        for (Item item : arrayList) {
            if (arrayList2.contains(item.clazz())) continue;
            collection.add(item);
        }
    }

    private static String clazzToString(Class<?> clazz) {
        String string = null;
        try {
            if (clazz.getProtectionDomain() != null && clazz.getProtectionDomain().getCodeSource() != null) {
                string = clazz.getProtectionDomain().getCodeSource().getLocation().toString();
            }
        }
        catch (Throwable throwable) {
            string = throwable.getMessage();
        }
        return clazz.getName() + "@" + clazz.getClassLoader() + ":" + string;
    }

    private void insertItem(Item item, List<Item> list) {
        if (item.position == -1) {
            if (!list.contains(item)) {
                list.add(item);
            }
            return;
        }
        int n = -1;
        int n2 = -1;
        for (Item item2 : list) {
            if (item2.equals(item)) {
                return;
            }
            ++n2;
            if (n >= 0 || item2.position != -1 && item2.position <= item.position) continue;
            n = n2;
        }
        if (n < 0) {
            list.add(item);
        } else {
            list.add(n, item);
        }
    }

    static Item createPair(Class<?> clazz) {
        return new Item(clazz);
    }

    private static final class CantInstantiate {
        final Class<?> clazz;

        public CantInstantiate(Class<?> clazz) {
            assert (clazz != null);
            this.clazz = clazz;
        }
    }

    private static final class Item
    extends AbstractLookup.Pair<Object> {
        private Object object;
        private int position = -1;

        public Item(Class<?> clazz) {
            this.object = clazz;
        }

        @Override
        public String toString() {
            return "MetaInfServicesLookup.Item[" + this.clazz().getName() + "]";
        }

        private Class<? extends Object> clazz() {
            Object object = this.object;
            if (object instanceof CantInstantiate) {
                return ((CantInstantiate)object).clazz;
            }
            if (object instanceof Class) {
                return (Class)object;
            }
            if (object != null) {
                return object.getClass();
            }
            return Object.class;
        }

        public boolean equals(Object object) {
            if (object instanceof Item) {
                return ((Item)object).clazz().equals(this.clazz());
            }
            return false;
        }

        public int hashCode() {
            return this.clazz().hashCode();
        }

        @Override
        protected boolean instanceOf(Class<?> clazz) {
            return clazz.isAssignableFrom(this.clazz());
        }

        @Override
        public Class<?> getType() {
            return this.clazz();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getInstance() {
            Object object = this.object;
            if (object instanceof CantInstantiate) {
                return null;
            }
            if (object instanceof Class) {
                Object object2 = object;
                synchronized (object2) {
                    Class clazz = (Class)object;
                    try {
                        object = CACHE.findInstance(clazz);
                        if (object == null) {
                            object = SharedClassObjectBridge.newInstance(clazz);
                            Object object3 = CACHE.findInstance(clazz);
                            if (object3 != null) {
                                this.object = object3;
                                return this.object;
                            }
                            CACHE.storeInstance(object);
                        }
                        this.object = object;
                    }
                    catch (Exception exception) {
                        LOGGER.log(Level.INFO, "Cannot create " + this.object, exception);
                        this.object = new CantInstantiate(clazz);
                        return null;
                    }
                    catch (LinkageError linkageError) {
                        LOGGER.log(Level.FINE, "Cannot create " + this.object, linkageError);
                        this.object = new CantInstantiate(clazz);
                        return null;
                    }
                }
            }
            return this.object;
        }

        @Override
        public String getDisplayName() {
            return this.clazz().getName();
        }

        @Override
        public String getId() {
            return this.clazz().getName();
        }

        @Override
        protected boolean creatorOf(Object object) {
            return object == this.object;
        }
    }
}

