/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import org.netbeans.Util;
import org.openide.modules.ModuleInfo;
import org.openide.modules.Modules;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.lookup.Lookups;

final class NbStartStop
implements LookupListener {
    private static final RequestProcessor RP = new RequestProcessor("On Start/Stop", 8);
    private final Map<String, RequestProcessor.Task> onStart = new HashMap<String, RequestProcessor.Task>();
    private final Lookup lkpStart;
    private final Lookup lkpStop;
    private Lookup.Result<Runnable> resStart;

    NbStartStop(Lookup lookup, Lookup lookup2) {
        this.lkpStart = lookup;
        this.lkpStop = lookup2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize() {
        for (Lookup.Item item : this.onStart().allItems()) {
            Map<String, RequestProcessor.Task> map = this.onStart;
            synchronized (map) {
                Runnable runnable;
                RequestProcessor.Task task = this.onStart.get(item.getId());
                if (task == null && (runnable = (Runnable)item.getInstance()) != null) {
                    this.onStart.put(item.getId(), RP.post(runnable));
                }
            }
        }
    }

    private synchronized Lookup.Result<Runnable> onStart() {
        if (this.resStart == null) {
            Lookup lookup = this.lkpStart != null ? this.lkpStart : Lookups.forPath((String)"Modules/Start");
            this.resStart = lookup.lookupResult(Runnable.class);
            this.resStart.addLookupListener((LookupListener)this);
        }
        return this.resStart;
    }

    private Lookup onStop() {
        return this.lkpStop != null ? this.lkpStop : Lookups.forPath((String)"Modules/Stop");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitOnStart() {
        RequestProcessor.Task[] taskArray = this.onStart;
        synchronized (this.onStart) {
            Collection<RequestProcessor.Task> collection = this.onStart.values();
            RequestProcessor.Task[] taskArray2 = collection.toArray(new RequestProcessor.Task[collection.size()]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (RequestProcessor.Task task : taskArray2) {
                task.waitFinished();
            }
            return;
        }
    }

    boolean closing(List<? extends ModuleInfo> list) {
        for (Callable callable : this.onStop().lookupAll(Callable.class)) {
            if (!list.contains(Modules.getDefault().ownerOf(callable.getClass()))) continue;
            try {
                if (!Boolean.FALSE.equals(callable.call())) continue;
                Util.err.log(Level.FINE, "{0} refused to close", callable.getClass());
                return false;
            }
            catch (Exception exception) {
                Util.err.log(Level.FINE, callable.getClass() + " thrown an exception", exception);
                return false;
            }
        }
        return true;
    }

    List<Task> startClose(List<? extends ModuleInfo> list) {
        ArrayList<Task> arrayList = new ArrayList<Task>();
        for (Runnable runnable : this.onStop().lookupAll(Runnable.class)) {
            if (!list.contains(Modules.getDefault().ownerOf(runnable.getClass()))) continue;
            arrayList.add((Task)RP.post(runnable));
        }
        return arrayList;
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.initialize();
    }
}

