/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.message.extension.psk.PSKIdentity;
import de.rub.nds.tlsattacker.core.protocol.parser.Parser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PSKIdentityParser
extends Parser<PSKIdentity> {
    private static final Logger LOGGER = LogManager.getLogger();

    public PSKIdentityParser(int startposition, byte[] array) {
        super(startposition, array);
    }

    @Override
    public PSKIdentity parse() {
        LOGGER.debug("Parsing PSKIdentity");
        PSKIdentity pskIdentity = new PSKIdentity();
        this.parseIdentityLength(pskIdentity);
        this.parseIdentity(pskIdentity);
        this.parseObfuscatedTicketAge(pskIdentity);
        return pskIdentity;
    }

    private void parseIdentityLength(PSKIdentity pskIdentity) {
        pskIdentity.setIdentityLength(this.parseIntField(2));
        LOGGER.debug("Identity length:" + pskIdentity.getIdentityLength().getValue());
    }

    private void parseIdentity(PSKIdentity pskIdentity) {
        pskIdentity.setIdentity(this.parseByteArrayField((Integer)pskIdentity.getIdentityLength().getValue()));
        LOGGER.debug("Identity:" + ArrayConverter.bytesToHexString((byte[])((byte[])pskIdentity.getIdentity().getValue())));
    }

    private void parseObfuscatedTicketAge(PSKIdentity pskIdentity) {
        pskIdentity.setObfuscatedTicketAge(this.parseByteArrayField(4));
        LOGGER.debug("Obfuscated ticket age:" + ArrayConverter.bytesToHexString((byte[])((byte[])pskIdentity.getObfuscatedTicketAge().getValue())));
    }
}

