/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler.events;

import jakarta.inject.Inject;
import org.traccar.handler.events.BaseEventHandler;
import org.traccar.helper.model.PositionUtil;
import org.traccar.model.Device;
import org.traccar.model.Event;
import org.traccar.model.Position;
import org.traccar.session.cache.CacheManager;

public class IgnitionEventHandler
extends BaseEventHandler {
    private final CacheManager cacheManager;

    @Inject
    public IgnitionEventHandler(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public void analyzePosition(Position position, BaseEventHandler.Callback callback) {
        Device device = this.cacheManager.getObject(Device.class, position.getDeviceId());
        if (device == null || !PositionUtil.isLatest(this.cacheManager, position)) {
            return;
        }
        if (position.hasAttribute("ignition")) {
            boolean ignition = position.getBoolean("ignition");
            Position lastPosition = this.cacheManager.getPosition(position.getDeviceId());
            if (lastPosition != null && lastPosition.hasAttribute("ignition")) {
                boolean oldIgnition = lastPosition.getBoolean("ignition");
                if (ignition && !oldIgnition) {
                    callback.eventDetected(new Event("ignitionOn", position));
                } else if (!ignition && oldIgnition) {
                    callback.eventDetected(new Event("ignitionOff", position));
                }
            }
        }
    }
}

