/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.resource;

import com.nimbusds.oauth2.sdk.ParseException;
import jakarta.annotation.Nullable;
import jakarta.annotation.security.PermitAll;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.Date;
import org.traccar.api.BaseResource;
import org.traccar.api.security.CodeRequiredException;
import org.traccar.api.security.LoginResult;
import org.traccar.api.security.LoginService;
import org.traccar.api.signature.TokenManager;
import org.traccar.database.OpenIdProvider;
import org.traccar.helper.LogAction;
import org.traccar.helper.WebHelper;
import org.traccar.model.User;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

@Path(value="session")
@Produces(value={"application/json"})
@Consumes(value={"application/x-www-form-urlencoded"})
public class SessionResource
extends BaseResource {
    public static final String USER_ID_KEY = "userId";
    public static final String EXPIRATION_KEY = "expiration";
    @Inject
    private LoginService loginService;
    @Inject
    @Nullable
    private OpenIdProvider openIdProvider;
    @Inject
    private TokenManager tokenManager;
    @Context
    private HttpServletRequest request;

    @PermitAll
    @GET
    public User get(@QueryParam(value="token") String token) throws StorageException, IOException, GeneralSecurityException {
        User user;
        LoginResult loginResult;
        if (token != null && (loginResult = this.loginService.login(token)) != null) {
            User user2 = loginResult.getUser();
            this.request.getSession().setAttribute(USER_ID_KEY, (Object)user2.getId());
            this.request.getSession().setAttribute(EXPIRATION_KEY, (Object)loginResult.getExpiration());
            LogAction.login(user2.getId(), WebHelper.retrieveRemoteAddress(this.request));
            return user2;
        }
        Long userId = (Long)this.request.getSession().getAttribute(USER_ID_KEY);
        if (userId != null && (user = this.permissionsService.getUser(userId)) != null) {
            return user;
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).build());
    }

    @Path(value="{id}")
    @GET
    public User get(@PathParam(value="id") long userId) throws StorageException {
        this.permissionsService.checkUser(this.getUserId(), userId);
        User user = this.storage.getObject(User.class, new Request((Columns)new Columns.All(), new Condition.Equals("id", userId)));
        this.request.getSession().setAttribute(USER_ID_KEY, (Object)user.getId());
        LogAction.login(user.getId(), WebHelper.retrieveRemoteAddress(this.request));
        return user;
    }

    @PermitAll
    @POST
    public User add(@FormParam(value="email") String email, @FormParam(value="password") String password, @FormParam(value="code") Integer code) throws StorageException {
        LoginResult loginResult;
        try {
            loginResult = this.loginService.login(email, password, code);
        }
        catch (CodeRequiredException e) {
            Response response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)"TOTP").build();
            throw new WebApplicationException(response);
        }
        if (loginResult != null) {
            User user = loginResult.getUser();
            this.request.getSession().setAttribute(USER_ID_KEY, (Object)user.getId());
            LogAction.login(user.getId(), WebHelper.retrieveRemoteAddress(this.request));
            return user;
        }
        LogAction.failedLogin(WebHelper.retrieveRemoteAddress(this.request));
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
    }

    @DELETE
    public Response remove() {
        LogAction.logout(this.getUserId(), WebHelper.retrieveRemoteAddress(this.request));
        this.request.getSession().removeAttribute(USER_ID_KEY);
        return Response.noContent().build();
    }

    @Path(value="token")
    @POST
    public String requestToken(@FormParam(value="expiration") Date expiration) throws StorageException, GeneralSecurityException, IOException {
        Date currentExpiration = (Date)this.request.getSession().getAttribute(EXPIRATION_KEY);
        if (currentExpiration != null && currentExpiration.before(expiration)) {
            expiration = currentExpiration;
        }
        return this.tokenManager.generateToken(this.getUserId(), expiration);
    }

    @PermitAll
    @Path(value="openid/auth")
    @GET
    public Response openIdAuth() {
        return Response.seeOther((URI)this.openIdProvider.createAuthUri()).build();
    }

    @PermitAll
    @Path(value="openid/callback")
    @GET
    public Response requestToken() throws IOException, StorageException, ParseException, GeneralSecurityException {
        StringBuilder requestUrl = new StringBuilder(this.request.getRequestURL().toString());
        String queryString = this.request.getQueryString();
        String requestUri = requestUrl.append('?').append(queryString).toString();
        return Response.seeOther((URI)this.openIdProvider.handleCallback(URI.create(requestUri), this.request)).build();
    }
}

