"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Facet = void 0;
var _ = require(".");
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class Facet {
  constructor({
    client: _client,
    logger,
    endpoint: _endpoint,
    useJobs = false,
    shimResponse = false
  }) {
    _defineProperty(this, "defaultClient", void 0);
    _defineProperty(this, "logger", void 0);
    _defineProperty(this, "endpoint", void 0);
    _defineProperty(this, "useJobs", void 0);
    _defineProperty(this, "shimResponse", void 0);
    _defineProperty(this, "fetch", async (context, request, endpoint) => {
      try {
        var _df$meta;
        const {
          format,
          df,
          dataSourceId,
          ...query
        } = request.body;
        const params = {
          body: {
            ...query
          },
          ...(format !== 'jdbc' && {
            format
          })
        };
        const clientId = dataSourceId !== null && dataSourceId !== void 0 ? dataSourceId : df === null || df === void 0 || (_df$meta = df.meta) === null || _df$meta === void 0 || (_df$meta = _df$meta.queryConfig) === null || _df$meta === void 0 ? void 0 : _df$meta.dataSourceId;
        const client = clientId ? context.dataSource.opensearch.legacy.getClient(clientId).callAPI : this.defaultClient.asScoped(request).callAsCurrentUser;
        const queryRes = await client(endpoint, params);
        return {
          success: true,
          data: queryRes
        };
      } catch (err) {
        this.logger.error(`Facet fetch: ${endpoint}: ${err}`);
        return {
          success: false,
          data: err
        };
      }
    });
    _defineProperty(this, "fetchJobs", async (context, request, endpoint) => {
      try {
        var _df$meta2;
        const params = request.params;
        const {
          df,
          dataSourceId
        } = request.body;
        const clientId = dataSourceId !== null && dataSourceId !== void 0 ? dataSourceId : df === null || df === void 0 || (_df$meta2 = df.meta) === null || _df$meta2 === void 0 || (_df$meta2 = _df$meta2.queryConfig) === null || _df$meta2 === void 0 ? void 0 : _df$meta2.dataSourceId;
        const client = clientId ? context.dataSource.opensearch.legacy.getClient(clientId).callAPI : this.defaultClient.asScoped(request).callAsCurrentUser;
        const queryRes = await client(endpoint, params);
        return {
          success: true,
          data: queryRes
        };
      } catch (err) {
        this.logger.error(`Facet fetch: ${endpoint}: ${err}`);
        return {
          success: false,
          data: err
        };
      }
    });
    _defineProperty(this, "describeQuery", async (context, request) => {
      const response = this.useJobs ? await this.fetchJobs(context, request, this.endpoint) : await this.fetch(context, request, this.endpoint);
      if (!this.shimResponse) return response;
      const {
        format: dataType
      } = request.body;
      const shimFunctions = {
        jdbc: data => (0, _.shimSchemaRow)(data),
        viz: data => (0, _.shimStats)(data)
      };
      return shimFunctions[dataType] ? {
        ...response,
        data: shimFunctions[dataType](response.data)
      } : response;
    });
    this.defaultClient = _client;
    this.logger = logger;
    this.endpoint = _endpoint;
    this.useJobs = useJobs;
    this.shimResponse = shimResponse;
  }
}
exports.Facet = Facet;