"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sqlAsyncSearchStrategyProvider = void 0;
var _common = require("../../../data/common");
var _utils = require("../utils");
var _common2 = require("../../common");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const sqlAsyncSearchStrategyProvider = (config$, logger, client, usage) => {
  const sqlAsyncFacet = new _utils.Facet({
    client,
    logger,
    endpoint: 'enhancements.runDirectQuery'
  });
  const sqlAsyncJobsFacet = new _utils.Facet({
    client,
    logger,
    endpoint: 'enhancements.getJobStatus',
    useJobs: true
  });
  return {
    search: async (context, request, options) => {
      try {
        var _request$body;
        // Create job: this should return a queryId and sessionId
        if (request !== null && request !== void 0 && (_request$body = request.body) !== null && _request$body !== void 0 && (_request$body = _request$body.query) !== null && _request$body !== void 0 && _request$body.qs) {
          var _request$body2, _df$meta, _df$meta2, _rawResponse$data, _rawResponse$data2, _rawResponse$data3, _request$body3;
          const df = (_request$body2 = request.body) === null || _request$body2 === void 0 ? void 0 : _request$body2.df;
          request.body = {
            query: request.body.query.qs,
            datasource: df === null || df === void 0 || (_df$meta = df.meta) === null || _df$meta === void 0 || (_df$meta = _df$meta.queryConfig) === null || _df$meta === void 0 ? void 0 : _df$meta.dataSourceName,
            lang: _common2.SEARCH_STRATEGY.SQL,
            sessionId: df === null || df === void 0 || (_df$meta2 = df.meta) === null || _df$meta2 === void 0 ? void 0 : _df$meta2.sessionId
          };
          const rawResponse = await sqlAsyncFacet.describeQuery(context, request);
          // handles failure
          if (!rawResponse.success) {
            return {
              type: _common.DATA_FRAME_TYPES.POLLING,
              body: {
                error: rawResponse.data
              },
              took: rawResponse.took
            };
          }
          const queryId = (_rawResponse$data = rawResponse.data) === null || _rawResponse$data === void 0 ? void 0 : _rawResponse$data.queryId;
          const sessionId = (_rawResponse$data2 = rawResponse.data) === null || _rawResponse$data2 === void 0 ? void 0 : _rawResponse$data2.sessionId;
          const partial = {
            ...request.body.df,
            fields: (rawResponse === null || rawResponse === void 0 || (_rawResponse$data3 = rawResponse.data) === null || _rawResponse$data3 === void 0 ? void 0 : _rawResponse$data3.schema) || []
          };
          const dataFrame = (0, _common.createDataFrame)(partial);
          dataFrame.meta = {
            ...dataFrame.meta,
            query: request.body.query,
            queryId,
            sessionId
          };
          dataFrame.name = (_request$body3 = request.body) === null || _request$body3 === void 0 ? void 0 : _request$body3.datasource;
          return {
            type: _common.DATA_FRAME_TYPES.POLLING,
            body: dataFrame,
            took: rawResponse.took
          };
        } else {
          var _asyncResponse$data, _dataFrame$fields, _asyncResponse$data2, _asyncResponse$data3, _request$body4;
          const queryId = request.params.queryId;
          request.params = {
            queryId
          };
          const asyncResponse = await sqlAsyncJobsFacet.describeQuery(context, request);
          const status = asyncResponse.data.status;
          const partial = {
            ...request.body.df,
            fields: (asyncResponse === null || asyncResponse === void 0 || (_asyncResponse$data = asyncResponse.data) === null || _asyncResponse$data === void 0 ? void 0 : _asyncResponse$data.schema) || []
          };
          const dataFrame = (0, _common.createDataFrame)(partial);
          (_dataFrame$fields = dataFrame.fields) === null || _dataFrame$fields === void 0 || _dataFrame$fields.forEach((field, index) => {
            field.values = asyncResponse === null || asyncResponse === void 0 ? void 0 : asyncResponse.data.datarows.map(row => row[index]);
          });
          dataFrame.size = (asyncResponse === null || asyncResponse === void 0 || (_asyncResponse$data2 = asyncResponse.data) === null || _asyncResponse$data2 === void 0 || (_asyncResponse$data2 = _asyncResponse$data2.datarows) === null || _asyncResponse$data2 === void 0 ? void 0 : _asyncResponse$data2.length) || 0;
          dataFrame.meta = {
            ...dataFrame.meta,
            status,
            queryId,
            error: status === 'FAILED' && ((_asyncResponse$data3 = asyncResponse.data) === null || _asyncResponse$data3 === void 0 ? void 0 : _asyncResponse$data3.error)
          };
          dataFrame.name = (_request$body4 = request.body) === null || _request$body4 === void 0 ? void 0 : _request$body4.datasource;

          // TODO: MQL should this be the time for polling or the time for job creation?
          if (usage) usage.trackSuccess(asyncResponse.took);
          return {
            type: _common.DATA_FRAME_TYPES.POLLING,
            body: dataFrame,
            took: asyncResponse.took
          };
        }
      } catch (e) {
        logger.error(`sqlAsyncSearchStrategy: ${e.message}`);
        if (usage) usage.trackError();
        throw e;
      }
    }
  };
};
exports.sqlAsyncSearchStrategyProvider = sqlAsyncSearchStrategyProvider;