"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiPagination", {
  enumerable: true,
  get: function get() {
    return _pagination.EuiPagination;
  }
});
exports.OuiPagination = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _pagination_button = require("./pagination_button");

var _button = require("../button");

var _i18n = require("../i18n");

var _text = require("../text");

var _responsive = require("../responsive");

var _pagination = require("../../eui_components/pagination/pagination");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * The OpenSearch Contributors require contributions made to
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * this file be licensed under the Apache-2.0 license or a
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * compatible open source license.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Modifications Copyright OpenSearch Contributors. See
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * GitHub history for details.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */ /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * Licensed to Elasticsearch B.V. under one or more contributor
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * license agreements. See the NOTICE file distributed with
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * this work for additional information regarding copyright
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * ownership. Elasticsearch B.V. licenses this file to you under
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * the Apache License, Version 2.0 (the "License"); you may
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * not use this file except in compliance with the License.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * You may obtain a copy of the License at
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          *    http://www.apache.org/licenses/LICENSE-2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * Unless required by applicable law or agreed to in writing,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * software distributed under the License is distributed on an
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * KIND, either express or implied.  See the License for the
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * specific language governing permissions and limitations
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * under the License.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          */

var MAX_VISIBLE_PAGES = 5;
var NUMBER_SURROUNDING_PAGES = Math.floor(MAX_VISIBLE_PAGES * 0.5);

var OuiPagination = function OuiPagination(_ref) {
  var className = _ref.className,
      _ref$pageCount = _ref.pageCount,
      pageCount = _ref$pageCount === void 0 ? 1 : _ref$pageCount,
      _ref$activePage = _ref.activePage,
      activePage = _ref$activePage === void 0 ? 1 : _ref$activePage,
      _ref$onPageClick = _ref.onPageClick,
      onPageClick = _ref$onPageClick === void 0 ? function () {} : _ref$onPageClick,
      compressed = _ref.compressed,
      ariaControls = _ref['aria-controls'],
      rest = (0, _objectWithoutProperties2.default)(_ref, ["className", "pageCount", "activePage", "onPageClick", "compressed", "aria-controls"]);

  var safeClick = function safeClick(e, pageIndex) {
    e.preventDefault();

    if (ariaControls) {
      var controlledElement = document.getElementById(ariaControls);

      if (controlledElement) {
        controlledElement.focus();
      }
    }

    onPageClick(pageIndex);
  };

  var PaginationButton = function PaginationButton(_ref2) {
    var pageIndex = _ref2.pageIndex,
        _ref2$inList = _ref2.inList,
        inList = _ref2$inList === void 0 ? true : _ref2$inList;

    var button = /*#__PURE__*/_react.default.createElement(_pagination_button.OuiPaginationButton, (0, _extends2.default)({
      isActive: pageIndex === activePage,
      totalPages: pageCount,
      onClick: function onClick(e) {
        return safeClick(e, pageIndex);
      },
      pageIndex: pageIndex
    }, hasControl && {
      'aria-controls': ariaControls
    }, {
      hideOnMobile: true
    }));

    if (inList) {
      return /*#__PURE__*/_react.default.createElement("li", {
        className: "ouiPagination__item"
      }, button);
    }

    return button;
  };

  var classes = (0, _classnames.default)('ouiPagination', className);
  var hasControl = ariaControls !== undefined;
  var pages = [];
  var firstPageInRange = Math.max(0, Math.min(activePage - NUMBER_SURROUNDING_PAGES, pageCount - MAX_VISIBLE_PAGES));
  var lastPageInRange = Math.min(pageCount, firstPageInRange + MAX_VISIBLE_PAGES);

  for (var i = firstPageInRange, index = 0; i < lastPageInRange; i++, index++) {
    pages.push( /*#__PURE__*/_react.default.createElement(PaginationButton, {
      pageIndex: i,
      key: i
    }));
  }

  var prevPageButtonProps = {};

  if (hasControl && activePage !== 0) {
    prevPageButtonProps = {
      'aria-controls': ariaControls,
      href: "#".concat(ariaControls)
    };
  } else {
    prevPageButtonProps = {
      disabled: activePage === 0
    };
  }

  var previousButton = /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
    token: "ouiPagination.previousPage",
    default: "Previous page, {page}",
    values: {
      page: activePage
    }
  }, function (previousPage) {
    return /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
      token: "ouiPagination.disabledPreviousPage",
      default: "Previous page"
    }, function (disabledPreviousPage) {
      return /*#__PURE__*/_react.default.createElement(_button.OuiButtonIcon, (0, _extends2.default)({
        onClick: function onClick(e) {
          return safeClick(e, activePage - 1);
        },
        iconType: "arrowLeft",
        color: "text",
        "aria-label": activePage === 0 ? disabledPreviousPage : previousPage,
        "data-test-subj": "pagination-button-previous"
      }, prevPageButtonProps));
    });
  });

  var firstPageButtons = [];

  if (firstPageInRange > 0) {
    firstPageButtons.push( /*#__PURE__*/_react.default.createElement(PaginationButton, {
      pageIndex: 0,
      key: 0
    }));

    if (firstPageInRange > 1 && firstPageInRange !== 2) {
      firstPageButtons.push( /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
        key: "startingEllipses",
        token: "ouiPagination.firstRangeAriaLabel",
        default: "Skipping pages 2 to {lastPage}",
        values: {
          lastPage: firstPageInRange
        }
      }, function (firstRangeAriaLabel) {
        return /*#__PURE__*/_react.default.createElement("li", {
          "aria-label": firstRangeAriaLabel,
          className: "ouiPaginationButton-isPlaceholder ouiPagination__item"
        }, "\u2026");
      }));
    } else if (firstPageInRange === 2) {
      firstPageButtons.push( /*#__PURE__*/_react.default.createElement(PaginationButton, {
        pageIndex: 1,
        key: 1
      }));
    }
  }

  var lastPageButtons = [];

  if (lastPageInRange < pageCount) {
    if (lastPageInRange + 1 === pageCount - 1) {
      lastPageButtons.push( /*#__PURE__*/_react.default.createElement(PaginationButton, {
        pageIndex: lastPageInRange,
        key: lastPageInRange
      }));
    } else if (lastPageInRange < pageCount - 1) {
      lastPageButtons.push( /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
        key: "endingEllipses",
        token: "ouiPagination.lastRangeAriaLabel",
        default: "Skipping pages {firstPage} to {lastPage}",
        values: {
          firstPage: lastPageInRange + 1,
          lastPage: pageCount - 1
        }
      }, function (lastRangeAriaLabel) {
        return /*#__PURE__*/_react.default.createElement("li", {
          "aria-label": lastRangeAriaLabel,
          className: "ouiPaginationButton-isPlaceholder ouiPagination__item"
        }, "\u2026");
      }));
    }

    lastPageButtons.push( /*#__PURE__*/_react.default.createElement(PaginationButton, {
      pageIndex: pageCount - 1,
      key: pageCount - 1
    }));
  }

  var nextPageButtonProps = {};

  if (hasControl && activePage !== pageCount - 1) {
    nextPageButtonProps = {
      'aria-controls': ariaControls,
      href: "#".concat(ariaControls)
    };
  } else {
    nextPageButtonProps = {
      disabled: activePage === pageCount - 1
    };
  }

  var nextButton = /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
    token: "ouiPagination.nextPage",
    default: "Next page, {page}",
    values: {
      page: activePage + 2
    }
  }, function (nextPage) {
    return /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
      token: "ouiPagination.disabledNextPage",
      default: "Next page"
    }, function (disabledNextPage) {
      return /*#__PURE__*/_react.default.createElement(_button.OuiButtonIcon, (0, _extends2.default)({
        onClick: function onClick(e) {
          return safeClick(e, activePage + 1);
        },
        iconType: "arrowRight",
        "aria-label": activePage === pageCount - 1 ? disabledNextPage : nextPage,
        color: "text",
        "data-test-subj": "pagination-button-next"
      }, nextPageButtonProps));
    });
  });

  var selectablePages = pages;

  if (compressed) {
    var firstPageButtonCompressed = /*#__PURE__*/_react.default.createElement(PaginationButton, {
      pageIndex: activePage,
      inList: false
    });

    var lastPageButtonCompressed = /*#__PURE__*/_react.default.createElement(PaginationButton, {
      pageIndex: pageCount - 1,
      inList: false
    });

    return /*#__PURE__*/_react.default.createElement("nav", (0, _extends2.default)({
      className: classes
    }, rest), previousButton, /*#__PURE__*/_react.default.createElement(_responsive.OuiHideFor, {
      sizes: ['xs', 's']
    }, /*#__PURE__*/_react.default.createElement(_text.OuiText, {
      size: "s",
      className: "ouiPagination__compressedText"
    }, /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
      token: "ouiPagination.pageOfTotalCompressed",
      default: "{page} of {total}",
      values: {
        page: firstPageButtonCompressed,
        total: lastPageButtonCompressed
      }
    }))), nextButton);
  }

  var accessibleName = _objectSpread(_objectSpread({}, rest['aria-label'] && {
    'aria-label': rest['aria-label']
  }), rest['aria-labelledby'] && {
    'aria-labelledby': rest['aria-labelledby']
  });

  return /*#__PURE__*/_react.default.createElement("nav", (0, _extends2.default)({
    className: classes
  }, rest), previousButton, /*#__PURE__*/_react.default.createElement("ul", (0, _extends2.default)({}, accessibleName, {
    className: "ouiPagination__list"
  }), firstPageButtons, selectablePages, lastPageButtons), nextButton);
};
/* OUI -> EUI Aliases: Build-Time */


exports.OuiPagination = OuiPagination;
OuiPagination.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
     * The total number of pages.
     */
  pageCount: _propTypes.default.number,

  /**
     * The current page using a zero based index.
     * So if you set the activePage to 1, it will activate the second page.
     */
  activePage: _propTypes.default.number,
  onPageClick: _propTypes.default.func,

  /**
     * If true, will only show next/prev arrows instead of page numbers.
     */
  compressed: _propTypes.default.bool,

  /**
     * If passed in, passes value through to each button to set aria-controls
     */
  "aria-controls": _propTypes.default.string
};
/* OUI -> EUI Aliases: Build-Time */