#!/usr/bin/env python

import sys
import datetime

def print_heading(line):
  print ""
  print ";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;"
  if line != "":
    #l = 60 - len(line)
    #if l > 0:
    #  sep = " " + ("-" * l)
    #else:
    #  sep = ""
    #print "\n;; " + line + sep
    print ";; " + line + "\n"

# ------------------------------- fold here -----------------------------

now = datetime.datetime.now()
#curr_date now.year+"-"+now.month+"-"+now.day+" "+now.hour+":"+now.minute+":"+now.second

if len(sys.argv) < 2:
  print "Usage: python make_include.py <include.txt>"
  sys.exit(0)

fp = open(sys.argv[1], "rb")

print ";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;"
print ";;"
print ";; msp430 include file generated by make_include.py"
print ";; part of the naken430asm msp430 assembler"
print ";;"
print ";; Generated by: (put your name / email here)"
print ";;   Input File: " + sys.argv[1]
print ";;         Date: " + now.strftime("%Y-%m-%d %H:%M")
print ";;        Parts: (put supported parts here)"
print ";;"
print ";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;"
print ""

while 1:
  line = fp.readline()
  if not line: break
  if line == "": continue

  if line.lower().find("reserved") != -1:
    tokens = line.strip().split()
    print "; " + (" ".join(tokens))
  elif not line.strip().endswith("h"):
    line = line.strip()
    print_heading(line)
    #if line != "":
    #  l = 60 - len(line)
    #  if l > 0:
    #    sep = " " + ("-" * l)
    #  else:
    #    sep = ""
    #  print "\n;; " + line + sep
  else:
    if not line.startswith(" "):
      if line[3:].find(line[:3]) != -1:
        i0 = line[3:].find(line[:3]) + 3
        i1 = i0
      else:
        i0 = line.find("  ")
        i1 = i0 + 2

      heading = line[:i1].strip()
      line = line[i0:].strip()
      print_heading(heading)
      #print "\n;; " + heading

    tokens = line.strip().split()
    #s = tokens[-2] + " equ " + tokens[-1]
    s = tokens[-2] + " equ " + ("0x%04x" % int(tokens[-1][:-1], 16))
    l = 25 - len(s)
    if l < 2: l = 2
    comment = line[:line.find(tokens[-2])].strip()
    print s + (" "*l) + " ; " + comment

print "\n"

fp.close()



