"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupFieldMappingRoutes = setupFieldMappingRoutes;

var _configSchema = require("@osd/config-schema");

var _constants = require("../utils/constants");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function setupFieldMappingRoutes(services, router) {
  const {
    fieldMappingService
  } = services;
  router.get({
    path: _constants.API.MAPPINGS_VIEW,
    validate: {
      query: _configSchema.schema.object({
        indexName: _configSchema.schema.string(),
        ruleTopic: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, fieldMappingService.getMappingsView);
  router.get({
    path: _constants.API.MAPPINGS_BASE,
    validate: {
      query: _configSchema.schema.object({
        indexName: _configSchema.schema.string()
      })
    }
  }, fieldMappingService.getMappings);
  router.post({
    path: _constants.API.MAPPINGS_BASE,
    validate: {
      body: _configSchema.schema.any()
    }
  }, fieldMappingService.createMappings);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkZpZWxkTWFwcGluZ1JvdXRlcy50cyJdLCJuYW1lcyI6WyJzZXR1cEZpZWxkTWFwcGluZ1JvdXRlcyIsInNlcnZpY2VzIiwicm91dGVyIiwiZmllbGRNYXBwaW5nU2VydmljZSIsImdldCIsInBhdGgiLCJBUEkiLCJNQVBQSU5HU19WSUVXIiwidmFsaWRhdGUiLCJxdWVyeSIsInNjaGVtYSIsIm9iamVjdCIsImluZGV4TmFtZSIsInN0cmluZyIsInJ1bGVUb3BpYyIsIm1heWJlIiwiZ2V0TWFwcGluZ3NWaWV3IiwiTUFQUElOR1NfQkFTRSIsImdldE1hcHBpbmdzIiwicG9zdCIsImJvZHkiLCJhbnkiLCJjcmVhdGVNYXBwaW5ncyJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQU1BOztBQUNBOztBQVBBO0FBQ0E7QUFDQTtBQUNBO0FBT08sU0FBU0EsdUJBQVQsQ0FBaUNDLFFBQWpDLEVBQXlEQyxNQUF6RCxFQUEwRTtBQUMvRSxRQUFNO0FBQUVDLElBQUFBO0FBQUYsTUFBMEJGLFFBQWhDO0FBRUFDLEVBQUFBLE1BQU0sQ0FBQ0UsR0FBUCxDQUNFO0FBQ0VDLElBQUFBLElBQUksRUFBRUMsZUFBSUMsYUFEWjtBQUVFQyxJQUFBQSxRQUFRLEVBQUU7QUFDUkMsTUFBQUEsS0FBSyxFQUFFQyxxQkFBT0MsTUFBUCxDQUFjO0FBQ25CQyxRQUFBQSxTQUFTLEVBQUVGLHFCQUFPRyxNQUFQLEVBRFE7QUFFbkJDLFFBQUFBLFNBQVMsRUFBRUoscUJBQU9LLEtBQVAsQ0FBYUwscUJBQU9HLE1BQVAsRUFBYjtBQUZRLE9BQWQ7QUFEQztBQUZaLEdBREYsRUFVRVYsbUJBQW1CLENBQUNhLGVBVnRCO0FBYUFkLEVBQUFBLE1BQU0sQ0FBQ0UsR0FBUCxDQUNFO0FBQ0VDLElBQUFBLElBQUksRUFBRUMsZUFBSVcsYUFEWjtBQUVFVCxJQUFBQSxRQUFRLEVBQUU7QUFDUkMsTUFBQUEsS0FBSyxFQUFFQyxxQkFBT0MsTUFBUCxDQUFjO0FBQ25CQyxRQUFBQSxTQUFTLEVBQUVGLHFCQUFPRyxNQUFQO0FBRFEsT0FBZDtBQURDO0FBRlosR0FERixFQVNFVixtQkFBbUIsQ0FBQ2UsV0FUdEI7QUFZQWhCLEVBQUFBLE1BQU0sQ0FBQ2lCLElBQVAsQ0FDRTtBQUNFZCxJQUFBQSxJQUFJLEVBQUVDLGVBQUlXLGFBRFo7QUFFRVQsSUFBQUEsUUFBUSxFQUFFO0FBQ1JZLE1BQUFBLElBQUksRUFBRVYscUJBQU9XLEdBQVA7QUFERTtBQUZaLEdBREYsRUFPRWxCLG1CQUFtQixDQUFDbUIsY0FQdEI7QUFTRCIsInNvdXJjZXNDb250ZW50IjpbIi8qXG4gKiBDb3B5cmlnaHQgT3BlblNlYXJjaCBDb250cmlidXRvcnNcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4gKi9cblxuaW1wb3J0IHsgSVJvdXRlciB9IGZyb20gJ29wZW5zZWFyY2gtZGFzaGJvYXJkcy9zZXJ2ZXInO1xuaW1wb3J0IHsgc2NoZW1hIH0gZnJvbSAnQG9zZC9jb25maWctc2NoZW1hJztcbmltcG9ydCB7IEFQSSB9IGZyb20gJy4uL3V0aWxzL2NvbnN0YW50cyc7XG5pbXBvcnQgeyBOb2RlU2VydmljZXMgfSBmcm9tICcuLi9tb2RlbHMvaW50ZXJmYWNlcyc7XG5cbmV4cG9ydCBmdW5jdGlvbiBzZXR1cEZpZWxkTWFwcGluZ1JvdXRlcyhzZXJ2aWNlczogTm9kZVNlcnZpY2VzLCByb3V0ZXI6IElSb3V0ZXIpIHtcbiAgY29uc3QgeyBmaWVsZE1hcHBpbmdTZXJ2aWNlIH0gPSBzZXJ2aWNlcztcblxuICByb3V0ZXIuZ2V0KFxuICAgIHtcbiAgICAgIHBhdGg6IEFQSS5NQVBQSU5HU19WSUVXLFxuICAgICAgdmFsaWRhdGU6IHtcbiAgICAgICAgcXVlcnk6IHNjaGVtYS5vYmplY3Qoe1xuICAgICAgICAgIGluZGV4TmFtZTogc2NoZW1hLnN0cmluZygpLFxuICAgICAgICAgIHJ1bGVUb3BpYzogc2NoZW1hLm1heWJlKHNjaGVtYS5zdHJpbmcoKSksXG4gICAgICAgIH0pLFxuICAgICAgfSxcbiAgICB9LFxuICAgIGZpZWxkTWFwcGluZ1NlcnZpY2UuZ2V0TWFwcGluZ3NWaWV3XG4gICk7XG5cbiAgcm91dGVyLmdldChcbiAgICB7XG4gICAgICBwYXRoOiBBUEkuTUFQUElOR1NfQkFTRSxcbiAgICAgIHZhbGlkYXRlOiB7XG4gICAgICAgIHF1ZXJ5OiBzY2hlbWEub2JqZWN0KHtcbiAgICAgICAgICBpbmRleE5hbWU6IHNjaGVtYS5zdHJpbmcoKSxcbiAgICAgICAgfSksXG4gICAgICB9LFxuICAgIH0sXG4gICAgZmllbGRNYXBwaW5nU2VydmljZS5nZXRNYXBwaW5nc1xuICApO1xuXG4gIHJvdXRlci5wb3N0KFxuICAgIHtcbiAgICAgIHBhdGg6IEFQSS5NQVBQSU5HU19CQVNFLFxuICAgICAgdmFsaWRhdGU6IHtcbiAgICAgICAgYm9keTogc2NoZW1hLmFueSgpLFxuICAgICAgfSxcbiAgICB9LFxuICAgIGZpZWxkTWFwcGluZ1NlcnZpY2UuY3JlYXRlTWFwcGluZ3NcbiAgKTtcbn1cbiJdfQ==