"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.configSchema = void 0;

var _configSchema = require("@osd/config-schema");

var _metrics = require("./server/metrics");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const configSchema = _configSchema.schema.object({
  metrics: _configSchema.schema.object({
    metricInterval: _configSchema.schema.number({
      defaultValue: _metrics.METRIC_INTERVAL.ONE_MINUTE
    }),
    windowSize: _configSchema.schema.number({
      min: 2,
      max: 10,
      defaultValue: _metrics.DEFAULT_WINDOW_SIZE
    })
  })
});

exports.configSchema = configSchema;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImNvbmZpZy50cyJdLCJuYW1lcyI6WyJjb25maWdTY2hlbWEiLCJzY2hlbWEiLCJvYmplY3QiLCJtZXRyaWNzIiwibWV0cmljSW50ZXJ2YWwiLCJudW1iZXIiLCJkZWZhdWx0VmFsdWUiLCJNRVRSSUNfSU5URVJWQUwiLCJPTkVfTUlOVVRFIiwid2luZG93U2l6ZSIsIm1pbiIsIm1heCIsIkRFRkFVTFRfV0lORE9XX1NJWkUiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFLQTs7QUFFQTs7QUFQQTtBQUNBO0FBQ0E7QUFDQTtBQU1PLE1BQU1BLFlBQVksR0FBR0MscUJBQU9DLE1BQVAsQ0FBYztBQUN4Q0MsRUFBQUEsT0FBTyxFQUFFRixxQkFBT0MsTUFBUCxDQUFjO0FBQ3JCRSxJQUFBQSxjQUFjLEVBQUVILHFCQUFPSSxNQUFQLENBQWM7QUFBRUMsTUFBQUEsWUFBWSxFQUFFQyx5QkFBZ0JDO0FBQWhDLEtBQWQsQ0FESztBQUVyQkMsSUFBQUEsVUFBVSxFQUFFUixxQkFBT0ksTUFBUCxDQUFjO0FBQUVLLE1BQUFBLEdBQUcsRUFBRSxDQUFQO0FBQVVDLE1BQUFBLEdBQUcsRUFBRSxFQUFmO0FBQW1CTCxNQUFBQSxZQUFZLEVBQUVNO0FBQWpDLEtBQWQ7QUFGUyxHQUFkO0FBRCtCLENBQWQsQ0FBckIiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuICovXG5cbmltcG9ydCB7IHNjaGVtYSwgVHlwZU9mIH0gZnJvbSAnQG9zZC9jb25maWctc2NoZW1hJztcblxuaW1wb3J0IHsgTUVUUklDX0lOVEVSVkFMLCBERUZBVUxUX1dJTkRPV19TSVpFIH0gZnJvbSAnLi9zZXJ2ZXIvbWV0cmljcyc7XG5cbmV4cG9ydCBjb25zdCBjb25maWdTY2hlbWEgPSBzY2hlbWEub2JqZWN0KHtcbiAgbWV0cmljczogc2NoZW1hLm9iamVjdCh7XG4gICAgbWV0cmljSW50ZXJ2YWw6IHNjaGVtYS5udW1iZXIoeyBkZWZhdWx0VmFsdWU6IE1FVFJJQ19JTlRFUlZBTC5PTkVfTUlOVVRFIH0pLFxuICAgIHdpbmRvd1NpemU6IHNjaGVtYS5udW1iZXIoeyBtaW46IDIsIG1heDogMTAsIGRlZmF1bHRWYWx1ZTogREVGQVVMVF9XSU5ET1dfU0laRSB9KSxcbiAgfSksXG59KTtcblxuZXhwb3J0IHR5cGUgU2VhcmNoUmVsZXZhbmNlUGx1Z2luQ29uZmlnVHlwZSA9IFR5cGVPZjx0eXBlb2YgY29uZmlnU2NoZW1hPjtcbiJdfQ==