"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.inputIsSQL = exports.inputIsQuery = exports.inputIsPPL = exports.getQueryOutput = exports.formatNotRecognized = void 0;

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const inputIsQuery = inputText => {
  return inputIsSQL(inputText) || inputIsPPL(inputText);
};

exports.inputIsQuery = inputIsQuery;

const inputIsSQL = inputText => {
  return inputText.substring(0, 4) === '%sql';
};

exports.inputIsSQL = inputIsSQL;

const inputIsPPL = inputText => {
  return inputText.substring(0, 4) === '%ppl';
};

exports.inputIsPPL = inputIsPPL;

const getQueryOutput = async (inputText, queryService) => {
  let output = {};

  if (inputIsSQL(inputText)) {
    output = await queryService.describeSQLQuery(inputText);
  } else if (inputIsPPL(inputText)) {
    output = await queryService.describePPLQuery(inputText);
  }

  return output;
};

exports.getQueryOutput = getQueryOutput;

const formatNotRecognized = inputText => {
  return inputText.substring(0, 4) !== '%sql' && inputText.substring(0, 4) !== '%ppl' && inputText.substring(0, 3) !== '%md';
};

exports.formatNotRecognized = formatNotRecognized;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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