/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.installer;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.sdk.Resource;
import com.jetbrains.python.sdk.ResourceType;
import com.jetbrains.python.sdk.installer.ResourceTypeReleaseInstaller;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/jetbrains/python/sdk/installer/PkgReleaseInstaller;", "Lcom/jetbrains/python/sdk/installer/ResourceTypeReleaseInstaller;", "()V", "buildCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "resource", "Lcom/jetbrains/python/sdk/Resource;", "path", "Ljava/nio/file/Path;", "intellij.python.sdk"})
public final class PkgReleaseInstaller
extends ResourceTypeReleaseInstaller {
    public PkgReleaseInstaller() {
        super(ResourceType.APPLE_SOFTWARE_PACKAGE);
    }

    @Override
    @NotNull
    public GeneralCommandLine buildCommandLine(@NotNull Resource resource, @NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String[] stringArray = new String[]{"installer", "-pkg", ((Object)path2.toAbsolutePath()).toString(), "-target", "/"};
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(stringArray);
        Object[] objectArray = new Object[]{resource.getFileName()};
        String string = PySdkBundle.message("python.sdk.running.sudo.prompt", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return ExecUtil.sudoCommand((GeneralCommandLine)generalCommandLine, (String)string);
    }
}

