/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.add.v2;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkToInstallKt;
import com.jetbrains.python.sdk.add.v2.PythonInterpreterCreationTargets;
import com.jetbrains.python.statistics.InterpreterTarget;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004H\u0000\u001a\u001e\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004H\u0000\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\b\u00a8\u0006\t"}, d2={"setupBaseSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "sdk", "existingSdks", "", "setupSdkIfDetected", "toStatisticsField", "Lcom/jetbrains/python/statistics/InterpreterTarget;", "Lcom/jetbrains/python/sdk/add/v2/PythonInterpreterCreationTargets;", "intellij.python.community.impl"})
public final class CommonKt {
    @NotNull
    public static final InterpreterTarget toStatisticsField(@NotNull PythonInterpreterCreationTargets $this$toStatisticsField) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toStatisticsField), (String)"<this>");
        if (WhenMappings.$EnumSwitchMapping$0[$this$toStatisticsField.ordinal()] != 1) {
            throw new NotImplementedError("PythonInterpreterCreationTargets added, but not accounted for in statistics");
        }
        return InterpreterTarget.LOCAL;
    }

    @Nullable
    public static final Sdk setupBaseSdk(@NotNull Sdk sdk2, @NotNull List<? extends Sdk> existingSdks) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        Intrinsics.checkNotNullParameter(existingSdks, (String)"existingSdks");
        Sdk installed = PySdkToInstallKt.installSdkIfNeeded(sdk2, null, existingSdks);
        if (installed == null) {
            NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Python interpreter installation");
            String string = PyBundle.message("python.sdk.installation.balloon.error.message", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            Notification notification = notificationGroup.createNotification(string, NotificationType.ERROR);
            notification.getCollapseDirection();
            notification.addAction((AnAction)NotificationAction.createSimple((String)PyBundle.message("python.sdk.installation.balloon.error.action", new Object[0]), () -> CommonKt.setupBaseSdk$lambda$0(notification)));
            IdeFrame ideFrame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
            NotificationsManager.getNotificationsManager().showNotification(notification, (Project)(ideFrame != null ? ideFrame.getProject() : null));
            return null;
        }
        return CommonKt.setupSdkIfDetected(installed, existingSdks);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Sdk setupSdkIfDetected(@NotNull Sdk sdk2, @NotNull List<? extends Sdk> existingSdks) {
        Sdk sdk3;
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        Intrinsics.checkNotNullParameter(existingSdks, (String)"existingSdks");
        if (sdk2 instanceof PyDetectedSdk) {
            void var2_2;
            Sdk sdk4 = PySdkExtKt.setup((PyDetectedSdk)sdk2, existingSdks);
            Intrinsics.checkNotNull((Object)sdk4);
            Sdk newSdk = sdk4;
            SdkConfigurationUtil.addSdk((Sdk)newSdk);
            sdk3 = var2_2;
        } else {
            sdk3 = sdk2;
        }
        return sdk3;
    }

    private static final void setupBaseSdk$lambda$0(Notification $notification) {
        Intrinsics.checkNotNullParameter((Object)$notification, (String)"$notification");
        $notification.expire();
        HelpManager.getInstance().invokeHelp("reference.settings.project.interpreter");
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PythonInterpreterCreationTargets.values().length];
            try {
                nArray[PythonInterpreterCreationTargets.LOCAL_MACHINE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

