/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.add;

import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.packaging.PyCondaPackageService;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.add.PyAddSdkPanel;
import com.jetbrains.python.sdk.add.PySdkPathChoosingComboBox;
import com.jetbrains.python.sdk.conda.PyCondaSdkCustomizer;
import icons.PythonIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B9\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\n\u0010 \u001a\u0004\u0018\u00010\bH\u0016J\b\u0010!\u001a\u00020\"H\u0014J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u0007H\u0016R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0017R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u001dX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006%"}, d2={"Lcom/jetbrains/python/sdk/add/PyAddExistingCondaEnvPanel;", "Lcom/jetbrains/python/sdk/add/PyAddSdkPanel;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "existingSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "newProjectPath", "", "context", "Lcom/intellij/openapi/util/UserDataHolder;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/Module;Ljava/util/List;Ljava/lang/String;Lcom/intellij/openapi/util/UserDataHolder;)V", "condaPathField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "makeSharedField", "Lcom/intellij/ui/components/JBCheckBox;", "getNewProjectPath", "()Ljava/lang/String;", "setNewProjectPath", "(Ljava/lang/String;)V", "panelName", "getPanelName", "sdkComboBox", "Lcom/jetbrains/python/sdk/add/PySdkPathChoosingComboBox;", "getSdkComboBox", "()Lcom/jetbrains/python/sdk/add/PySdkPathChoosingComboBox;", "getOrCreateSdk", "layoutComponents", "", "validateAll", "Lcom/intellij/openapi/ui/ValidationInfo;", "intellij.python.community.impl"})
public class PyAddExistingCondaEnvPanel
extends PyAddSdkPanel {
    @Nullable
    private final Project project;
    @Nullable
    private final Module module;
    @NotNull
    private final List<Sdk> existingSdks;
    @Nullable
    private String newProjectPath;
    @NotNull
    private final Icon icon;
    @NotNull
    private final PySdkPathChoosingComboBox sdkComboBox;
    @NotNull
    private final TextFieldWithBrowseButton condaPathField;
    @NotNull
    private final JBCheckBox makeSharedField;

    /*
     * WARNING - void declaration
     */
    public PyAddExistingCondaEnvPanel(@Nullable Project project, @Nullable Module module, @NotNull List<? extends Sdk> existingSdks, @Nullable String newProjectPath, @NotNull UserDataHolder context) {
        void $this$condaPathField_u24lambda_u240;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        Intrinsics.checkNotNullParameter(existingSdks, (String)"existingSdks");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.project = project;
        this.module = module;
        this.existingSdks = existingSdks;
        this.newProjectPath = newProjectPath;
        Icon icon = PythonIcons.Python.Anaconda;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Anaconda");
        this.icon = icon;
        this.sdkComboBox = new PySdkPathChoosingComboBox(null, null, null, null, 15, null);
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        PyAddExistingCondaEnvPanel pyAddExistingCondaEnvPanel = this;
        boolean bl = false;
        String path2 = PyCondaPackageService.Companion.getCondaExecutable(null);
        if (path2 != null) {
            $this$condaPathField_u24lambda_u240.setText(path2);
        }
        $this$condaPathField_u24lambda_u240.addBrowseFolderListener(PyBundle.message("python.sdk.select.conda.path.title", new Object[0]), null, this.project, FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor());
        pyAddExistingCondaEnvPanel.condaPathField = textFieldWithBrowseButton;
        this.makeSharedField = new JBCheckBox(PyBundle.message("available.to.all.projects", new Object[0]));
        ((ComboBoxWithWidePopup)this.sdkComboBox.getChildComponent()).addItemListener(arg_0 -> PyAddExistingCondaEnvPanel._init_$lambda$1(this, arg_0));
        if (PyCondaSdkCustomizer.Companion.getInstance().getSharedEnvironmentsByDefault()) {
            this.makeSharedField.setSelected(true);
        }
        this.layoutComponents();
    }

    @Override
    @Nullable
    public String getNewProjectPath() {
        return this.newProjectPath;
    }

    @Override
    public void setNewProjectPath(@Nullable String string) {
        this.newProjectPath = string;
    }

    @Override
    @NotNull
    public String getPanelName() {
        String string = PyBundle.message("python.add.sdk.panel.name.existing.environment", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @NotNull
    protected final PySdkPathChoosingComboBox getSdkComboBox() {
        return this.sdkComboBox;
    }

    protected void layoutComponents() {
        this.setLayout(new BorderLayout());
        JPanel formPanel = FormBuilder.createFormBuilder().addLabeledComponent(PySdkBundle.message("python.interpreter.label", new Object[0]), (JComponent)((Object)this.sdkComboBox)).addLabeledComponent(PyBundle.message("python.sdk.conda.path", new Object[0]), (JComponent)this.condaPathField).addComponent((JComponent)this.makeSharedField).getPanel();
        this.add((Component)formPanel, "North");
    }

    @Override
    @NotNull
    public List<ValidationInfo> validateAll() {
        return CollectionsKt.listOfNotNull((Object)PyAddSdkPanel.Companion.validateSdkComboBox(this.sdkComboBox, this));
    }

    @Override
    @Nullable
    public Sdk getOrCreateSdk() {
        Sdk sdk2;
        Sdk sdk3 = this.sdkComboBox.getSelectedSdk();
        String string = this.condaPathField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        PyCondaPackageService.Companion.onCondaEnvCreated(string);
        if (sdk3 instanceof PyDetectedSdk) {
            PyDetectedSdk pyDetectedSdk = (PyDetectedSdk)sdk3;
            String string2 = this.getNewProjectPath();
            if (string2 == null) {
                Project project = this.project;
                string2 = project != null ? project.getBasePath() : null;
            }
            Sdk sdk4 = PySdkExtKt.setupAssociated(pyDetectedSdk, this.existingSdks, string2);
            if (sdk4 != null) {
                Sdk sdk5;
                Sdk $this$getOrCreateSdk_u24lambda_u242 = sdk5 = sdk4;
                boolean bl = false;
                if (!this.makeSharedField.isSelected()) {
                    PySdkExtKt.associateWithModule($this$getOrCreateSdk_u24lambda_u242, this.module, this.getNewProjectPath());
                }
                sdk2 = sdk5;
            } else {
                sdk2 = null;
            }
        } else {
            sdk2 = sdk3;
        }
        return sdk2;
    }

    private static final void _init_$lambda$1(PyAddExistingCondaEnvPanel this$0, ItemEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (it.getStateChange() == 1) {
            Sdk sdk2 = this$0.sdkComboBox.getSelectedSdk();
            String respectiveCondaExecutable = PyCondaPackageService.Companion.getCondaExecutable(sdk2 != null ? sdk2.getHomePath() : null);
            TextFieldWithBrowseButton textFieldWithBrowseButton = this$0.condaPathField;
            String string = respectiveCondaExecutable;
            if (string == null) {
                string = "";
            }
            textFieldWithBrowseButton.setText(string);
        }
    }
}

