/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyAssignmentExpression;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyComprehensionForComponent;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyForPart;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyGlobalStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyNonlocalStatement;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatementListContainer;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypeDeclarationStatement;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyWithItem;
import com.jetbrains.python.psi.PyWithStatement;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.impl.PyBaseElementImpl;
import com.jetbrains.python.psi.impl.PyElementPresentation;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PyReferenceExpressionImpl;
import com.jetbrains.python.psi.impl.PyTypeProvider;
import com.jetbrains.python.psi.impl.references.PyQualifiedReference;
import com.jetbrains.python.psi.impl.references.PyTargetReference;
import com.jetbrains.python.psi.impl.stubs.CustomTargetExpressionStub;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.stubs.PyClassStub;
import com.jetbrains.python.psi.stubs.PyFunctionStub;
import com.jetbrains.python.psi.stubs.PyTargetExpressionStub;
import com.jetbrains.python.psi.types.PyABCUtil;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTargetExpressionImpl
extends PyBaseElementImpl<PyTargetExpressionStub>
implements PyTargetExpression {
    @Nullable
    private volatile QualifiedName myQualifiedName;

    public PyTargetExpressionImpl(ASTNode astNode) {
        super(astNode);
    }

    public PyTargetExpressionImpl(PyTargetExpressionStub stub) {
        super(stub, PyElementTypes.TARGET_EXPRESSION);
    }

    public PyTargetExpressionImpl(PyTargetExpressionStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyTargetExpression(this);
    }

    @Nullable
    public String getName() {
        PyTargetExpressionStub stub = (PyTargetExpressionStub)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        ASTNode node = this.getNameElement();
        return node != null ? node.getText() : null;
    }

    public int getTextOffset() {
        ASTNode nameElement = this.getNameElement();
        return nameElement != null ? nameElement.getStartOffset() : this.getTextRange().getStartOffset();
    }

    @Override
    @Nullable
    public ASTNode getNameElement() {
        return this.getNode().findChildByType((IElementType)PyTokenTypes.IDENTIFIER);
    }

    public PsiElement getNameIdentifier() {
        ASTNode nameElement = this.getNameElement();
        return nameElement == null ? null : nameElement.getPsi();
    }

    @Override
    public String getReferencedName() {
        return this.getName();
    }

    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        ASTNode oldNameElement;
        if (name2 == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(0);
        }
        if ((oldNameElement = this.getNameElement()) != null) {
            ASTNode nameElement = PyUtil.createNewName(this, name2);
            this.getNode().replaceChild(oldNameElement, nameElement);
        }
        return this;
    }

    @Override
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        if (context == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(1);
        }
        if (key == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(2);
        }
        if ("__all__".equals(this.getName())) {
            return null;
        }
        Ref<PyType> pyType = PyReferenceExpressionImpl.getReferenceTypeFromProviders(this, context, null);
        if (pyType != null) {
            return (PyType)pyType.get();
        }
        PyType type2 = this.getTypeFromDocString();
        if (type2 != null) {
            return type2;
        }
        if (!context.maySwitchToAST(this)) {
            PyResolveContext resolveContext = PyResolveContext.defaultContext(context);
            List types = StreamEx.of(this.multiResolveAssignedValue(resolveContext)).select(PyTypedElement.class).map(context::getType).toList();
            return PyUnionType.union(types);
        }
        type2 = PyTargetExpressionImpl.getTypeFromComment(this);
        if (type2 != null) {
            return type2;
        }
        PsiElement parent = this.getParent();
        if (parent instanceof PyAssignmentStatement) {
            PyAssignmentStatement assignmentStatement = (PyAssignmentStatement)parent;
            PyExpression assignedValue = assignmentStatement.getAssignedValue();
            if (assignedValue instanceof PyParenthesizedExpression) {
                assignedValue = ((PyParenthesizedExpression)assignedValue).getContainedExpression();
            }
            if (assignedValue != null) {
                if (assignedValue instanceof PyYieldExpression) {
                    PyYieldExpression assignedYield = (PyYieldExpression)assignedValue;
                    return assignedYield.isDelegating() ? context.getType(assignedValue) : null;
                }
                return context.getType(assignedValue);
            }
        }
        if (parent instanceof PyTupleExpression) {
            PsiElement nextParent = parent.getParent();
            while (nextParent instanceof PyParenthesizedExpression || nextParent instanceof PyTupleExpression) {
                nextParent = nextParent.getParent();
            }
            if (nextParent instanceof PyAssignmentStatement) {
                PyType t;
                PyType assignedType;
                PyAssignmentStatement assignment = (PyAssignmentStatement)nextParent;
                PyExpression value = assignment.getAssignedValue();
                PyExpression lhs = assignment.getLeftHandSideExpression();
                PyTupleExpression targetTuple = (PyTupleExpression)PsiTreeUtil.findChildOfType((PsiElement)lhs, PyTupleExpression.class, (boolean)false);
                if (value != null && targetTuple != null && (assignedType = PyUnionType.toNonWeakType(context.getType(value))) != null && (t = PyTypeChecker.getTargetTypeFromTupleAssignment(this, targetTuple, assignedType, context)) != null) {
                    return t;
                }
            }
        }
        if (parent instanceof PyWithItem) {
            return PyTargetExpressionImpl.getWithItemVariableType((PyWithItem)parent, context);
        }
        if (parent instanceof PyAssignmentExpression) {
            PyExpression assignedValue = ((PyAssignmentExpression)parent).getAssignedValue();
            return assignedValue == null ? null : context.getType(assignedValue);
        }
        if (parent instanceof PyGlobalStatement || parent instanceof PyNonlocalStatement) {
            PyResolveContext resolveContext = PyResolveContext.defaultContext(context);
            List collect = StreamEx.of((Object[])this.getReference(resolveContext).multiResolve(false)).map(ResolveResult::getElement).select(PyTypedElement.class).map(context::getType).toList();
            return PyUnionType.union(collect);
        }
        if (parent instanceof PyExceptPart && ((PyExceptPart)parent).isStar() && LanguageLevel.forElement(this).isAtLeast(LanguageLevel.PYTHON311)) {
            return PyClassTypeImpl.createTypeByQName(this, "ExceptionGroup", false);
        }
        PyType iterType = this.getTypeFromIteration(context);
        if (iterType != null) {
            return iterType;
        }
        PyType excType = this.getTypeFromExcept();
        if (excType != null) {
            return excType;
        }
        return null;
    }

    @Override
    @Nullable
    public PyAnnotation getAnnotation() {
        PyTargetExpressionImpl topTarget = this;
        while (topTarget.getParent() instanceof PyParenthesizedExpression) {
            topTarget = topTarget.getParent();
        }
        PsiElement parent = topTarget.getParent();
        if (parent != null) {
            PyAssignmentStatement assignment = PyUtil.as(parent, PyAssignmentStatement.class);
            if (assignment != null) {
                PyExpression[] targets = assignment.getRawTargets();
                if (targets.length == 1 && targets[0] == topTarget) {
                    return assignment.getAnnotation();
                }
            } else if (parent instanceof PyTypeDeclarationStatement) {
                return ((PyTypeDeclarationStatement)parent).getAnnotation();
            }
        }
        return null;
    }

    @Override
    @Nullable
    public String getAnnotationValue() {
        return PyTargetExpressionImpl.getAnnotationContentFromStubOrPsi(this);
    }

    @Nullable
    private static PyType getWithItemVariableType(@NotNull PyWithItem item, @NotNull TypeEvalContext context) {
        if (item == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(3);
        }
        if (context == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(4);
        }
        PyExpression withExpression = item.getExpression();
        PyType withType = context.getType(withExpression);
        PyWithStatement withStatement = (PyWithStatement)PsiTreeUtil.getParentOfType((PsiElement)item, PyWithStatement.class);
        boolean isAsync = withStatement != null && withStatement.isAsync();
        return (PyType)PyTypeUtil.toStream(withType).select(PyClassType.class).map(t -> PyTargetExpressionImpl.getEnterTypeFromPyClass(withExpression, t, isAsync, context)).collect(PyTypeUtil.toUnion());
    }

    @Nullable
    private static PyType getEnterTypeFromPyClass(@NotNull PyExpression withExpression, @NotNull PyClassType withType, boolean isAsync, @NotNull TypeEvalContext context) {
        PyClass cls;
        PyFunction enter;
        if (withExpression == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(5);
        }
        if (withType == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(6);
        }
        if (context == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(7);
        }
        if ((enter = (cls = withType.getPyClass()).findMethodByName(isAsync ? "__aenter__" : "__enter__", true, context)) != null) {
            PyType enterType = PyTargetExpressionImpl.getContextSensitiveType(enter, context, withExpression);
            if (enterType != null) {
                return isAsync ? (PyType)Ref.deref(PyTypingTypeProvider.coroutineOrGeneratorElementType(enterType)) : enterType;
            }
            for (PyTypeProvider provider : PyTypeProvider.EP_NAME.getExtensionList()) {
                PyType typeFromProvider = provider.getContextManagerVariableType(cls, withExpression, context);
                if (typeFromProvider == null) continue;
                return typeFromProvider;
            }
            return PyUnionType.createWeakType(withType);
        }
        return null;
    }

    @Nullable
    public PyType getTypeFromDocString() {
        StructuredDocString classDocString;
        PyClass cls;
        String typeName = null;
        String name2 = this.getName();
        StructuredDocString targetDocString = this.getStructuredDocString();
        if (targetDocString != null && (typeName = targetDocString.getParamType(null)) == null) {
            typeName = targetDocString.getParamType(name2);
        }
        if (typeName == null && PyUtil.isAttribute(this) && (cls = this.getContainingClass()) != null && (classDocString = cls.getStructuredDocString()) != null) {
            typeName = classDocString.getParamType(name2);
        }
        if (typeName != null) {
            return PyTypeParser.getTypeByName(this, typeName);
        }
        return null;
    }

    @Nullable
    public static PyType getTypeFromComment(PyTargetExpressionImpl targetExpression) {
        String docComment = DocStringUtil.getAttributeDocComment(targetExpression);
        if (docComment != null) {
            StructuredDocString structuredDocString = DocStringUtil.parse(docComment, targetExpression);
            String typeName = structuredDocString.getParamType(null);
            if (typeName == null) {
                typeName = structuredDocString.getParamType(targetExpression.getName());
            }
            if (typeName != null) {
                return PyTypeParser.getTypeByName(targetExpression, typeName);
            }
        }
        return null;
    }

    @Nullable
    private PyType getTypeFromIteration(@NotNull TypeEvalContext context) {
        PyComprehensionElement comprh;
        PyExpression expr;
        if (context == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(8);
        }
        PyExpression target = null;
        PyExpression source = null;
        PyForPart forPart = (PyForPart)PsiTreeUtil.getParentOfType((PsiElement)this, PyForPart.class);
        if (forPart != null && PsiTreeUtil.isAncestor((PsiElement)(expr = forPart.getTarget()), (PsiElement)this, (boolean)false)) {
            target = expr;
            source = forPart.getSource();
        }
        if ((comprh = (PyComprehensionElement)PsiTreeUtil.getParentOfType((PsiElement)this, PyComprehensionElement.class)) != null) {
            for (PyComprehensionForComponent c : comprh.getForComponents()) {
                PyExpression expr2 = c.getIteratorVariable();
                if (!PsiTreeUtil.isAncestor((PsiElement)expr2, (PsiElement)this, (boolean)false)) continue;
                target = expr2;
                source = c.getIteratedList();
            }
        }
        if (source != null) {
            PyType sourceType = context.getType(source);
            PyType type2 = PyTargetExpressionImpl.getIterationType(sourceType, source, this, context);
            if (type2 instanceof PyTupleType && target instanceof PyTupleExpression) {
                return PyTypeChecker.getTargetTypeFromTupleAssignment(this, (PyTupleExpression)target, (PyTupleType)type2);
            }
            if (target == this && type2 != null) {
                return type2;
            }
        }
        return null;
    }

    @Nullable
    public static PyType getIterationType(@Nullable PyType iterableType, @Nullable PyExpression source, @NotNull PsiElement anchor, @NotNull TypeEvalContext context) {
        PyFunction iterateMethod;
        if (anchor == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(9);
        }
        if (context == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(10);
        }
        if (iterableType instanceof PyTupleType) {
            PyTupleType tupleType = (PyTupleType)iterableType;
            return tupleType.getIteratedItemType();
        }
        if (iterableType instanceof PyUnionType) {
            return ((PyUnionType)iterableType).map(member -> PyTargetExpressionImpl.getIterationType(member, source, anchor, context));
        }
        if (iterableType != null && PyABCUtil.isSubtype(iterableType, "Iterable", context)) {
            PyFunction iterateMethod2 = PyTargetExpressionImpl.findMethodByName(iterableType, "__iter__", context);
            if (iterateMethod2 != null) {
                PyType iterateReturnType = PyTargetExpressionImpl.getContextSensitiveType(iterateMethod2, context, source);
                return PyTargetExpressionImpl.getIteratedItemType(iterateReturnType, source, anchor, context, false);
            }
            Ref<PyType> nextMethodCallType = PyTargetExpressionImpl.getNextMethodCallType(iterableType, source, anchor, context, false);
            if (nextMethodCallType != null) {
                return (PyType)nextMethodCallType.get();
            }
            PyFunction getItem = PyTargetExpressionImpl.findMethodByName(iterableType, "__getitem__", context);
            if (getItem != null) {
                return PyTargetExpressionImpl.getContextSensitiveType(getItem, context, source);
            }
        } else if (iterableType != null && PyABCUtil.isSubtype(iterableType, "AsyncIterable", context) && (iterateMethod = PyTargetExpressionImpl.findMethodByName(iterableType, "__aiter__", context)) != null) {
            PyType iterateReturnType = PyTargetExpressionImpl.getContextSensitiveType(iterateMethod, context, source);
            return PyTargetExpressionImpl.getIteratedItemType(iterateReturnType, source, anchor, context, true);
        }
        return null;
    }

    @Nullable
    private static PyType getIteratedItemType(@Nullable PyType type2, @Nullable PyExpression source, @NotNull PsiElement anchor, @NotNull TypeEvalContext context, boolean async) {
        Ref<PyType> nextMethodCallType;
        if (anchor == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(11);
        }
        if (context == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(12);
        }
        if ((nextMethodCallType = PyTargetExpressionImpl.getNextMethodCallType(type2, source, anchor, context, async)) != null && !nextMethodCallType.isNull()) {
            Object object = nextMethodCallType.get();
            if (object instanceof PyCollectionType) {
                PyCollectionType collectionType = (PyCollectionType)object;
                if (async && "typing.Awaitable".equals(collectionType.getClassQName())) {
                    return collectionType.getIteratedItemType();
                }
            }
            return (PyType)nextMethodCallType.get();
        }
        if (type2 instanceof PyCollectionType) {
            return ((PyCollectionType)type2).getIteratedItemType();
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getNextMethodCallType(@Nullable PyType type2, @Nullable PyExpression source, @NotNull PsiElement anchor, @NotNull TypeEvalContext context, boolean async) {
        if (anchor == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(13);
        }
        if (context == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(14);
        }
        if (type2 == null) {
            return null;
        }
        String nextMethodName = async ? "__anext__" : (!LanguageLevel.forElement(anchor).isPython2() ? "__next__" : "next");
        PyFunction next = PyTargetExpressionImpl.findMethodByName(type2, nextMethodName, context);
        if (next != null) {
            return Ref.create((Object)PyTargetExpressionImpl.getContextSensitiveType(next, context, source));
        }
        return null;
    }

    @Nullable
    private static PyFunction findMethodByName(@NotNull PyType type2, @NotNull String name2, @NotNull TypeEvalContext context) {
        PyResolveContext resolveContext;
        List<? extends RatedResolveResult> results;
        if (type2 == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(15);
        }
        if (name2 == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(16);
        }
        if (context == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(17);
        }
        if ((results = type2.resolveMember(name2, null, AccessDirection.READ, resolveContext = PyResolveContext.defaultContext(context))) != null) {
            List allMethods = StreamEx.of(results).map(RatedResolveResult::getElement).select(PyFunction.class).toList();
            PyFunction matchingBySelf = (PyFunction)ContainerUtil.find((Iterable)allMethods, method -> PyTargetExpressionImpl.selfParameterMatchesReceiver(method, type2, context));
            return matchingBySelf != null ? matchingBySelf : (PyFunction)ContainerUtil.getFirstItem((List)allMethods);
        }
        return null;
    }

    private static boolean selfParameterMatchesReceiver(@NotNull PyFunction method, @NotNull PyType receiverType, @NotNull TypeEvalContext context) {
        List parameters;
        if (method == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(18);
        }
        if (receiverType == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(19);
        }
        if (context == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(20);
        }
        if ((parameters = method.getParameters(context)).isEmpty()) {
            return false;
        }
        PyCallableParameter firstParameter = (PyCallableParameter)parameters.get(0);
        if (!firstParameter.isSelf()) {
            return false;
        }
        PyType selfParameterType = firstParameter.getType(context);
        return PyTypeChecker.match(selfParameterType, receiverType, context);
    }

    @Nullable
    public static PyType getContextSensitiveType(@NotNull PyFunction function, @NotNull TypeEvalContext context, @Nullable PyExpression source) {
        if (function == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(21);
        }
        if (context == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(22);
        }
        return function.getCallType(source, PyTargetExpressionImpl.buildArgumentsToParametersMap(source, function, context), context);
    }

    @NotNull
    private static Map<PyExpression, PyCallableParameter> buildArgumentsToParametersMap(@Nullable PyExpression receiver, @NotNull PyCallable callable, @NotNull TypeEvalContext context) {
        if (callable == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(23);
        }
        if (context == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(24);
        }
        if (receiver == null) {
            Map<PyExpression, PyCallableParameter> map = Collections.emptyMap();
            if (map == null) {
                PyTargetExpressionImpl.$$$reportNull$$$0(25);
            }
            return map;
        }
        PyCallableParameter firstParameter = (PyCallableParameter)ContainerUtil.getFirstItem(callable.getParameters(context));
        if (firstParameter == null || !firstParameter.isSelf()) {
            Map<PyExpression, PyCallableParameter> map = Collections.emptyMap();
            if (map == null) {
                PyTargetExpressionImpl.$$$reportNull$$$0(26);
            }
            return map;
        }
        Map<PyExpression, PyCallableParameter> map = Map.of(receiver, firstParameter);
        if (map == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(27);
        }
        return map;
    }

    @Nullable
    private PyType getTypeFromExcept() {
        PsiElement element;
        PyExceptPart exceptPart = (PyExceptPart)PsiTreeUtil.getParentOfType((PsiElement)this, PyExceptPart.class);
        if (exceptPart == null || exceptPart.getTarget() != this) {
            return null;
        }
        PyExpression exceptClass = exceptPart.getExceptClass();
        if (exceptClass instanceof PyReferenceExpression && (element = ((PyReferenceExpression)exceptClass).getReference().resolve()) instanceof PyClass) {
            return new PyClassTypeImpl((PyClass)element, false);
        }
        return null;
    }

    @Override
    public PyExpression getQualifier() {
        ASTNode qualifier = this.getNode().findChildByType(PythonDialectsTokenSetProvider.getInstance().getExpressionTokens());
        return qualifier != null ? (PyExpression)qualifier.getPsi() : null;
    }

    @Override
    @Nullable
    public QualifiedName asQualifiedName() {
        if (this.myQualifiedName == null) {
            this.myQualifiedName = PyPsiUtils.asQualifiedName(this);
        }
        return this.myQualifiedName;
    }

    @Override
    public String toString() {
        return super.toString() + ": " + this.getName();
    }

    public Icon getIcon(int flags) {
        if (this.isQualified() || PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)this, PyDocStringOwner.class) instanceof PyClass) {
            return IconManager.getInstance().getPlatformIcon(PlatformIcons.Field);
        }
        return IconManager.getInstance().getPlatformIcon(PlatformIcons.Variable);
    }

    @Override
    public boolean isQualified() {
        PyTargetExpressionStub stub = (PyTargetExpressionStub)this.getStub();
        if (stub != null) {
            return stub.isQualified();
        }
        return this.getQualifier() != null;
    }

    @Override
    @NotNull
    public List<PsiElement> multiResolveAssignedValue(@NotNull PyResolveContext resolveContext) {
        ScopeOwner owner;
        TypeEvalContext context;
        if (resolveContext == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(28);
        }
        if ((context = resolveContext.getTypeEvalContext()).maySwitchToAST(this)) {
            PyExpression value = this.findAssignedValue();
            List list = value != null ? ContainerUtil.filter(PyUtil.multiResolveTopPriority((PsiElement)value, resolveContext), Objects::nonNull) : Collections.emptyList();
            if (list == null) {
                PyTargetExpressionImpl.$$$reportNull$$$0(29);
            }
            return list;
        }
        QualifiedName qName = this.getAssignedQName();
        if (qName != null && qName.getComponentCount() != 0 && (owner = ScopeUtil.getScopeOwner(this)) != null) {
            List<PsiElement> list = PyResolveUtil.resolveQualifiedNameInScope(qName, owner, context);
            if (list == null) {
                PyTargetExpressionImpl.$$$reportNull$$$0(30);
            }
            return list;
        }
        List<PsiElement> list = Collections.emptyList();
        if (list == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(31);
        }
        return list;
    }

    @Override
    @Nullable
    public PyExpression findAssignedValue() {
        PyPsiUtils.assertValid(this);
        return (PyExpression)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.findAssignedValueInternal(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Nullable
    private PyExpression findAssignedValueInternal() {
        PyImportElement importElement;
        PyAssignmentStatement assignment = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)this, PyAssignmentStatement.class);
        if (assignment != null) {
            List<Pair<PyExpression, PyExpression>> mapping = assignment.getTargetsToValuesMapping();
            for (Pair<PyExpression, PyExpression> pair : mapping) {
                PyExpression assigned_to = (PyExpression)pair.getFirst();
                if (assigned_to != this) continue;
                return (PyExpression)pair.getSecond();
            }
        }
        if ((importElement = (PyImportElement)PsiTreeUtil.getParentOfType((PsiElement)this, PyImportElement.class)) != null) {
            return importElement.getImportReferenceExpression();
        }
        PyAssignmentExpression assignmentExpression = PyUtil.as(this.getParent(), PyAssignmentExpression.class);
        if (assignmentExpression != null) {
            return assignmentExpression.getAssignedValue();
        }
        return null;
    }

    @Override
    @Nullable
    public QualifiedName getAssignedQName() {
        return (QualifiedName)Ref.deref(PyTargetExpressionImpl.getAssignedReferenceQualifiedName(this));
    }

    @Override
    public QualifiedName getCalleeName() {
        return (QualifiedName)Ref.deref(PyTargetExpressionImpl.getAssignedCallCalleeQualifiedName(this));
    }

    @Override
    @NotNull
    public PsiReference getReference() {
        PsiPolyVariantReference psiPolyVariantReference = this.getReference(PyResolveContext.defaultContext(TypeEvalContext.codeInsightFallback(this.getProject())));
        if (psiPolyVariantReference == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(32);
        }
        return psiPolyVariantReference;
    }

    @Override
    @NotNull
    public PsiPolyVariantReference getReference(@NotNull PyResolveContext resolveContext) {
        if (resolveContext == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(33);
        }
        if (this.isQualified()) {
            return new PyQualifiedReference(this, resolveContext);
        }
        return new PyTargetReference(this, resolveContext);
    }

    @NotNull
    public SearchScope getUseScope() {
        if (this.isQualified()) {
            SearchScope searchScope = super.getUseScope();
            if (searchScope == null) {
                PyTargetExpressionImpl.$$$reportNull$$$0(34);
            }
            return searchScope;
        }
        ScopeOwner owner = ScopeUtil.getScopeOwner(this);
        if (owner != null) {
            Scope scope = ControlFlowCache.getScope(owner);
            if (scope.isGlobal(this.getName())) {
                GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)this.getProject());
                if (globalSearchScope == null) {
                    PyTargetExpressionImpl.$$$reportNull$$$0(35);
                }
                return globalSearchScope;
            }
            if (scope.isNonlocal(this.getName())) {
                return new LocalSearchScope((PsiElement)this.getContainingFile());
            }
        }
        PyElement container = this;
        while (true) {
            PyElement parentContainer;
            if ((parentContainer = (PyElement)PsiTreeUtil.getParentOfType((PsiElement)container, (Class[])new Class[]{PyFunction.class, PyClass.class})) instanceof PyClass) {
                if (!this.isQualified()) break;
                SearchScope searchScope = super.getUseScope();
                if (searchScope == null) {
                    PyTargetExpressionImpl.$$$reportNull$$$0(36);
                }
                return searchScope;
            }
            if (parentContainer == null) break;
            container = parentContainer;
        }
        if (container instanceof PyFunction) {
            return new LocalSearchScope((PsiElement)container);
        }
        SearchScope searchScope = super.getUseScope();
        if (searchScope == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(37);
        }
        return searchScope;
    }

    @Override
    public PyClass getContainingClass() {
        PyTargetExpressionStub stub = (PyTargetExpressionStub)this.getStub();
        if (stub != null) {
            StubElement functionParent;
            StubElement parentStub = stub.getParentStub();
            if (parentStub instanceof PyClassStub) {
                return (PyClass)((PyClassStub)parentStub).getPsi();
            }
            if (parentStub instanceof PyFunctionStub && (functionParent = parentStub.getParentStub()) instanceof PyClassStub) {
                return (PyClass)((PyClassStub)functionParent).getPsi();
            }
            return null;
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)this, (Class[])new Class[]{PyFunction.class, PyClass.class});
        if (parent instanceof PyClass) {
            return (PyClass)parent;
        }
        if (parent instanceof PyFunction) {
            return ((PyFunction)parent).getContainingClass();
        }
        return null;
    }

    public ItemPresentation getPresentation() {
        return new PyElementPresentation(this);
    }

    @Override
    @Nullable
    public String getDocStringValue() {
        PyTargetExpressionStub stub = (PyTargetExpressionStub)this.getStub();
        if (stub != null) {
            return stub.getDocString();
        }
        return DocStringUtil.getDocStringValue(this);
    }

    @Override
    @Nullable
    public StructuredDocString getStructuredDocString() {
        return DocStringUtil.getStructuredDocString(this);
    }

    @Override
    @Nullable
    public PyStringLiteralExpression getDocStringExpression() {
        PyExpression expression;
        PsiElement nextSibling;
        PsiElement parent = this.getParent();
        if ((parent instanceof PyAssignmentStatement || parent instanceof PyTypeDeclarationStatement) && (nextSibling = PyPsiUtils.getNextNonCommentSibling(parent, true)) instanceof PyExpressionStatement && (expression = ((PyExpressionStatement)nextSibling).getExpression()) instanceof PyStringLiteralExpression) {
            return (PyStringLiteralExpression)expression;
        }
        return null;
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        this.myQualifiedName = null;
    }

    @Override
    @Nullable
    public String getQualifiedName() {
        return QualifiedNameFinder.getQualifiedName(this);
    }

    @Override
    @Nullable
    public PsiComment getTypeComment() {
        PsiComment comment = null;
        PyAssignmentStatement assignment = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)this, PyAssignmentStatement.class);
        if (assignment != null) {
            PyExpression assignedValue = assignment.getAssignedValue();
            if (assignedValue != null && !PsiTreeUtil.isAncestor((PsiElement)assignedValue, (PsiElement)this, (boolean)false)) {
                comment = PyUtil.as(PyPsiUtils.getNextNonWhitespaceSiblingOnSameLine((PsiElement)assignedValue), PsiComment.class);
            }
        } else {
            PyWithItem withPart;
            PyStatementListContainer forOrWith = null;
            PyForPart forPart = (PyForPart)PsiTreeUtil.getParentOfType((PsiElement)this, PyForPart.class);
            if (forPart != null && PsiTreeUtil.isAncestor((PsiElement)forPart.getTarget(), (PsiElement)this, (boolean)false)) {
                forOrWith = forPart;
            }
            if ((withPart = (PyWithItem)PsiTreeUtil.getParentOfType((PsiElement)this, PyWithItem.class)) != null && PsiTreeUtil.isAncestor((PsiElement)withPart.getTarget(), (PsiElement)this, (boolean)false)) {
                forOrWith = PyUtil.as(withPart.getParent(), PyWithStatement.class);
            }
            if (forOrWith != null) {
                comment = PyUtil.getCommentOnHeaderLine(forOrWith);
            }
        }
        return comment != null && PyTypingTypeProvider.getTypeCommentValue(comment.getText()) != null ? comment : null;
    }

    @Override
    @Nullable
    public String getTypeCommentAnnotation() {
        return PyTargetExpressionImpl.getTypeCommentAnnotationFromStubOrPsi(this);
    }

    @Override
    public boolean hasAssignedValue() {
        PyTargetExpressionStub stub = (PyTargetExpressionStub)this.getStub();
        if (stub != null) {
            return stub.hasAssignedValue();
        }
        return this.findAssignedValue() != null;
    }

    @Nullable
    public static Ref<QualifiedName> getAssignedReferenceQualifiedName(@NotNull PyTargetExpression psi) {
        PyTargetExpressionStub stub;
        if (psi == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(38);
        }
        if ((stub = (PyTargetExpressionStub)psi.getStub()) != null) {
            if (stub.getInitializerType() == PyTargetExpressionStub.InitializerType.ReferenceExpression) {
                return Ref.create((Object)stub.getInitializer());
            }
            return null;
        }
        PyExpression value = psi.findAssignedValue();
        return value instanceof PyReferenceExpression ? Ref.create((Object)((PyReferenceExpression)value).asQualifiedName()) : null;
    }

    @Nullable
    public static Ref<QualifiedName> getAssignedCallCalleeQualifiedName(@NotNull PyTargetExpression psi) {
        PyTargetExpressionStub stub;
        if (psi == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(39);
        }
        if ((stub = (PyTargetExpressionStub)psi.getStub()) != null) {
            CustomTargetExpressionStub customStub;
            PyTargetExpressionStub.InitializerType initializerType = stub.getInitializerType();
            if (initializerType == PyTargetExpressionStub.InitializerType.CallExpression) {
                return Ref.create((Object)stub.getInitializer());
            }
            if (initializerType == PyTargetExpressionStub.InitializerType.Custom && (customStub = stub.getCustomStub(CustomTargetExpressionStub.class)) != null) {
                QualifiedName calleeName = customStub.getCalleeName();
                return calleeName != null ? Ref.create((Object)calleeName) : null;
            }
            return null;
        }
        PyExpression value = psi.findAssignedValue();
        return value instanceof PyCallExpression ? Ref.create((Object)PyPsiUtils.asQualifiedName(((PyCallExpression)value).getCallee())) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 25, 26, 27, 29, 30, 31, 32, 34, 35, 36, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "withExpression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "withType";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiverType";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyTargetExpressionImpl";
                break;
            }
            case 28: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyTargetExpressionImpl";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "buildArgumentsToParametersMap";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveAssignedValue";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getReference";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getWithItemVariableType";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getEnterTypeFromPyClass";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromIteration";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getIterationType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getIteratedItemType";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getNextMethodCallType";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findMethodByName";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "selfParameterMatchesReceiver";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getContextSensitiveType";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "buildArgumentsToParametersMap";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveAssignedValue";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getReference";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getAssignedReferenceQualifiedName";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getAssignedCallCalleeQualifiedName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 25, 26, 27, 29, 30, 31, 32, 34, 35, 36, 37 -> new IllegalStateException(string);
        };
    }
}

