/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.functionTypeComments.psi.PyFunctionTypeAnnotation;
import com.jetbrains.python.codeInsight.functionTypeComments.psi.PyParameterTypeList;
import com.jetbrains.python.codeInsight.typeHints.PyTypeHintFile;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.inspections.PyFinalInspection;
import com.jetbrains.python.inspections.PyFinalInspection$Visitor$visitPyFunction$;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyAnnotationOwner;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratable;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyGlobalStatement;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyLoopStatement;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyNonlocalStatement;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReferenceOwner;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypeCommentOwner;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyWhileStatement;
import com.jetbrains.python.psi.impl.PyClassImpl;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiUtil;
import com.jetbrains.python.refactoring.PyDefUseUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/inspections/PyFinalInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Visitor", "intellij.python.psi.impl"})
public final class PyFinalInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        TypeEvalContext typeEvalContext = PyInspectionVisitor.getContext(session);
        Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"getContext(...)");
        return new Visitor(holder, typeEvalContext);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J2\u0010\u0007\u001a\u00020\b2\u0014\u0010\t\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\f0\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002JH\u0010\u001e\u001a\u00020\b2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\b\u0010!\u001a\u0004\u0018\u00010\u000b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000b0#H\u0002J2\u0010$\u001a\u00020\b2\u0014\u0010\t\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\f0\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0002J6\u0010%\u001a(\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\f0\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0&2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J4\u0010'\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0&2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J#\u0010(\u001a\u00020)\"\f\b\u0000\u0010**\u00020+*\u00020,2\u0006\u0010\u0012\u001a\u0002H*H\u0002\u00a2\u0006\u0002\u0010-J\u0010\u0010(\u001a\u00020)2\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u00100\u001a\u00020)2\u0006\u0010\u0012\u001a\u000201H\u0002J\u0012\u00102\u001a\u00020)2\b\u00103\u001a\u0004\u0018\u000101H\u0002J\u0010\u00104\u001a\u00020\b2\u0006\u0010\u0012\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0019H\u0016J\u0010\u00107\u001a\u00020\b2\u0006\u0010\u0012\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u001dH\u0016J\u0010\u0010:\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010=\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\fH\u0016J\u0010\u0010>\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020?H\u0016\u00a8\u0006@"}, d2={"Lcom/jetbrains/python/inspections/PyFinalInspection$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/jetbrains/python/psi/types/TypeEvalContext;)V", "checkClassLevelFinalsAreInitialized", "", "classLevelFinals", "", "", "Lcom/jetbrains/python/psi/PyTargetExpression;", "initAttributes", "checkFinalInsideLoop", "loop", "Lcom/jetbrains/python/psi/PyLoopStatement;", "checkFinalIsOuterMost", "node", "Lcom/jetbrains/python/psi/PyReferenceExpression;", "checkFinalReassignment", "target", "Lcom/jetbrains/python/psi/PyQualifiedExpression;", "checkInheritedClassFinalReassignmentOnClassLevel", "cls", "Lcom/jetbrains/python/psi/PyClass;", "checkInstanceFinalReassignment", "checkInstanceFinalsOutsideInit", "method", "Lcom/jetbrains/python/psi/PyFunction;", "checkOverridingInheritedFinalWithNewOne", "newFinals", "inheritedFinals", "ancestorName", "notRegistered", "", "checkSameNameClassAndInstanceFinals", "getClassLevelFinalsAndInitAttributes", "Lkotlin/Pair;", "getDeclaredClassAndInstanceFinals", "isFinal", "", "T", "Lcom/jetbrains/python/psi/PyAnnotationOwner;", "Lcom/jetbrains/python/psi/PyTypeCommentOwner;", "(Lcom/jetbrains/python/psi/PyAnnotationOwner;)Z", "decoratable", "Lcom/jetbrains/python/psi/PyDecoratable;", "isTopLevelInAnnotationOrTypeComment", "Lcom/jetbrains/python/psi/PyExpression;", "resolvesToFinal", "expression", "visitPyAugAssignmentStatement", "Lcom/jetbrains/python/psi/PyAugAssignmentStatement;", "visitPyClass", "visitPyForStatement", "Lcom/jetbrains/python/psi/PyForStatement;", "visitPyFunction", "visitPyNamedParameter", "Lcom/jetbrains/python/psi/PyNamedParameter;", "visitPyReferenceExpression", "visitPyTargetExpression", "visitPyWhileStatement", "Lcom/jetbrains/python/psi/PyWhileStatement;", "intellij.python.psi.impl"})
    @SourceDebugExtension(value={"SMAP\nPyFinalInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyFinalInspection.kt\ncom/jetbrains/python/inspections/PyFinalInspection$Visitor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 7 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,424:1\n3792#2:425\n4307#2,2:426\n11383#2,9:453\n13309#2:462\n13310#2:464\n11392#2:465\n473#3:428\n179#3,2:429\n1747#4,3:431\n1747#4,3:434\n1855#4,2:437\n1855#4,2:451\n1747#4,3:466\n1747#4,3:469\n1747#4,3:472\n1#5:439\n1#5:463\n494#6,7:440\n215#7,2:447\n215#7,2:449\n*S KotlinDebug\n*F\n+ 1 PyFinalInspection.kt\ncom/jetbrains/python/inspections/PyFinalInspection$Visitor\n*L\n37#1:425\n37#1:426,2\n299#1:453,9\n299#1:462\n299#1:464\n299#1:465\n77#1:428\n78#1:429,2\n113#1:431,3\n149#1:434,3\n192#1:437,2\n285#1:451,2\n303#1:466,3\n311#1:469,3\n411#1:472,3\n299#1:463\n217#1:440,7\n225#1:447,2\n234#1:449,2\n*E\n"})
    private static final class Visitor
    extends PyInspectionVisitor {
        public Visitor(@NotNull ProblemsHolder holder, @NotNull TypeEvalContext context) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(holder, context);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitPyClass(@NotNull PyClass node) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyClass(node);
            PyClass[] pyClassArray = node.getSuperClasses(this.myTypeEvalContext);
            Intrinsics.checkNotNullExpressionValue((Object)pyClassArray, (String)"getSuperClasses(...)");
            Object[] $this$filter$iv = pyClassArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                PyClass it = (PyClass)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!this.isFinal(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List finalSuperClasses = (List)destination$iv$iv;
            boolean bl = false;
            if (!finalSuperClasses.isEmpty()) {
                String superClassList2 = CollectionsKt.joinToString$default((Iterable)finalSuperClasses, null, null, null, (int)0, null, (Function1)visitPyClass.2.superClassList.1.INSTANCE, (int)31, null);
                Object[] objectArray2 = new Object[]{superClassList2, finalSuperClasses.size()};
                this.registerProblem(node.getNameIdentifier(), PyPsiBundle.message("INSP.final.super.classes.are.marked.as.final.and.should.not.be.subclassed", objectArray2));
            }
            if (PyiUtil.isInsideStub(node)) {
                Set visitedNames = new LinkedHashSet();
                node.visitMethods((Processor<? super PyFunction>)((Processor)arg_0 -> Visitor.visitPyClass$lambda$2((Function1)new Function1<PyFunction, Boolean>((Set<String>)visitedNames, this){
                    final /* synthetic */ Set<String> $visitedNames;
                    final /* synthetic */ Visitor this$0;
                    {
                        this.$visitedNames = $visitedNames;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(PyFunction m) {
                        if (!this.$visitedNames.add(m.getName())) {
                            Intrinsics.checkNotNull((Object)m);
                            if (Visitor.access$isFinal(this.this$0, m)) {
                                this.this$0.registerProblem(m.getNameIdentifier(), PyPsiBundle.message("INSP.final.final.should.be.placed.on.first.overload", new Object[0]));
                            }
                        }
                        return true;
                    }
                }, arg_0)), false, this.myTypeEvalContext);
            } else {
                Pair<Map<String, PyTargetExpression>, Map<String, PyTargetExpression>> pair = this.getClassLevelFinalsAndInitAttributes(node);
                Map classLevelFinals = (Map)pair.component1();
                Map initAttributes = (Map)pair.component2();
                this.checkClassLevelFinalsAreInitialized(classLevelFinals, initAttributes);
                this.checkSameNameClassAndInstanceFinals(classLevelFinals, initAttributes);
            }
            this.checkOverridingInheritedFinalWithNewOne(node);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitPyFunction(@NotNull PyFunction node) {
            block22: {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                super.visitPyFunction(node);
                PyClass cls = node.getContainingClass();
                if (cls != null) {
                    Object v2;
                    block20: {
                        void $this$firstOrNull$iv;
                        Sequence $this$filterIsInstance$iv;
                        Query<PsiElement> query = PySuperMethodsSearch.search(node, this.myTypeEvalContext);
                        Intrinsics.checkNotNullExpressionValue(query, (String)"search(...)");
                        Sequence sequence = CollectionsKt.asSequence((Iterable)((Iterable)query));
                        boolean $i$f$filterIsInstance = false;
                        Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)Visitor$visitPyFunction$$inlined$filterIsInstance$1.INSTANCE);
                        Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                        $this$filterIsInstance$iv = sequence2;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            PyFunction it = (PyFunction)element$iv;
                            boolean bl = false;
                            if (!this.isFinal(it)) continue;
                            v2 = element$iv;
                            break block20;
                        }
                        v2 = null;
                    }
                    PyFunction pyFunction = v2;
                    if (pyFunction != null) {
                        Object element$iv;
                        PyFunction it = pyFunction;
                        boolean bl = false;
                        Object object = it.getQualifiedName();
                        if (object == null) {
                            PyClass pyClass = it.getContainingClass();
                            object = (pyClass != null ? pyClass.getName() : null) + "." + it.getName();
                        }
                        element$iv = object;
                        Intrinsics.checkNotNull(element$iv);
                        Object qualifiedName = element$iv;
                        element$iv = new Object[]{qualifiedName};
                        this.registerProblem(node.getNameIdentifier(), PyPsiBundle.message("INSP.final.method.marked.as.final.should.not.be.overridden", element$iv));
                    }
                    if (!PyiUtil.isInsideStub(node)) {
                        if (this.isFinal(node) && PyiUtil.isOverload(node, this.myTypeEvalContext)) {
                            this.registerProblem(node.getNameIdentifier(), PyPsiBundle.message("INSP.final.final.should.be.placed.on.implementation", new Object[0]));
                        }
                        this.checkInstanceFinalsOutsideInit(node);
                    }
                    if (PyKnownDecoratorUtil.hasAbstractDecorator(node, this.myTypeEvalContext)) {
                        if (this.isFinal(node)) {
                            this.registerProblem(node.getNameIdentifier(), PyPsiBundle.message("INSP.final.final.could.not.be.mixed.with.abstract.decorators", new Object[0]));
                        } else if (this.isFinal(cls)) {
                            String string = PyPsiBundle.message("INSP.final.final.class.could.not.contain.abstract.methods", new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                            String message = string;
                            this.registerProblem(node.getNameIdentifier(), message);
                            this.registerProblem(cls.getNameIdentifier(), message);
                        }
                    } else if (this.isFinal(node) && this.isFinal(cls)) {
                        this.registerProblem(node.getNameIdentifier(), PyPsiBundle.message("INSP.final.no.need.to.mark.method.in.final.class.as.final", new Object[0]), ProblemHighlightType.WEAK_WARNING);
                    }
                } else if (this.isFinal(node)) {
                    this.registerProblem(node.getNameIdentifier(), PyPsiBundle.message("INSP.final.non.method.function.could.not.be.marked.as.final", new Object[0]));
                }
                PyFunctionTypeAnnotation pyFunctionTypeAnnotation = PyTypingTypeProvider.getFunctionTypeAnnotation(node);
                if (pyFunctionTypeAnnotation != null) {
                    boolean bl;
                    block21: {
                        PyFunctionTypeAnnotation comment = pyFunctionTypeAnnotation;
                        boolean bl2 = false;
                        List<PyExpression> list = comment.getParameterTypeList().getParameterTypes();
                        Intrinsics.checkNotNullExpressionValue(list, (String)"getParameterTypes(...)");
                        Iterable $this$any$iv = list;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                PyExpression it = (PyExpression)element$iv;
                                boolean bl3 = false;
                                if (!this.resolvesToFinal(it instanceof PySubscriptionExpression ? ((PySubscriptionExpression)it).getOperand() : it)) continue;
                                bl = true;
                                break block21;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        this.registerProblem((PsiElement)node.getTypeComment(), PyPsiBundle.message("INSP.final.final.could.not.be.used.in.annotations.for.function.parameters", new Object[0]));
                    }
                }
                PyExpression pyExpression = PyTypingTypeProvider.getReturnTypeAnnotation(node, this.myTypeEvalContext);
                if (pyExpression == null) break block22;
                PyExpression it = pyExpression;
                boolean bl = false;
                if (this.resolvesToFinal(it instanceof PySubscriptionExpression ? ((PySubscriptionExpression)it).getOperand() : it)) {
                    PsiComment psiComment = node.getTypeComment();
                    this.registerProblem(psiComment != null ? (PsiElement)psiComment : (PsiElement)node.getAnnotation(), PyPsiBundle.message("INSP.final.final.could.not.be.used.in.annotation.for.function.return.value", new Object[0]));
                }
            }
        }

        @Override
        public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyTargetExpression(node);
            if (!node.hasAssignedValue()) {
                PyElement pyElement = node.getAnnotation();
                if (pyElement != null && (pyElement = pyElement.getValue()) != null) {
                    PyElement it = pyElement;
                    boolean bl = false;
                    if (PyiUtil.isInsideStub(node) || ScopeUtil.getScopeOwner(node) instanceof PyClass) {
                        if (this.resolvesToFinal((PyExpression)it)) {
                            this.registerProblem((PsiElement)it, PyPsiBundle.message("INSP.final.if.assigned.value.omitted.there.should.be.explicit.type.argument.to.final", new Object[0]));
                        }
                    } else if (this.resolvesToFinal((PyExpression)(it instanceof PySubscriptionExpression ? ((PySubscriptionExpression)it).getOperand() : it))) {
                        this.registerProblem(node, PyPsiBundle.message("INSP.final.final.name.should.be.initialized.with.value", new Object[0]));
                    }
                }
            } else if (!this.isFinal((PyAnnotationOwner)node)) {
                this.checkFinalReassignment(node);
            }
            if (this.isFinal((PyAnnotationOwner)node)) {
                boolean bl;
                block13: {
                    List<PsiElement> list = PyUtil.multiResolveTopPriority(node, this.getResolveContext());
                    Intrinsics.checkNotNullExpressionValue(list, (String)"multiResolveTopPriority(...)");
                    Iterable $this$any$iv = list;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            PsiElement it = (PsiElement)element$iv;
                            boolean bl2 = false;
                            if (!(!Intrinsics.areEqual((Object)it, (Object)node) && !PyDefUseUtil.isDefinedBefore(node, it))) continue;
                            bl = true;
                            break block13;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    this.registerProblem(node, PyPsiBundle.message("INSP.final.already.declared.name.could.not.be.redefined.as.final", new Object[0]));
                }
            }
        }

        @Override
        public void visitPyNamedParameter(@NotNull PyNamedParameter node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyNamedParameter(node);
            if (this.isFinal((PyAnnotationOwner)node)) {
                PyElement pyElement = node.getAnnotation();
                this.registerProblem(pyElement != null && (pyElement = pyElement.getValue()) != null ? (PsiElement)pyElement : (PsiElement)node.getTypeComment(), PyPsiBundle.message("INSP.final.final.could.not.be.used.in.annotations.for.function.parameters", new Object[0]));
            }
        }

        @Override
        public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyReferenceExpression(node);
            this.checkFinalIsOuterMost(node);
        }

        @Override
        public void visitPyForStatement(@NotNull PyForStatement node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyForStatement(node);
            this.checkFinalInsideLoop(node);
        }

        @Override
        public void visitPyWhileStatement(@NotNull PyWhileStatement node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyWhileStatement(node);
            this.checkFinalInsideLoop(node);
        }

        @Override
        public void visitPyAugAssignmentStatement(@NotNull PyAugAssignmentStatement node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyAugAssignmentStatement(node);
            PyExpression pyExpression = node.getTarget();
            Intrinsics.checkNotNullExpressionValue((Object)pyExpression, (String)"getTarget(...)");
            PyExpression target = pyExpression;
            if (target instanceof PyQualifiedExpression) {
                this.checkFinalReassignment((PyQualifiedExpression)target);
            }
        }

        private final Pair<Map<String, PyTargetExpression>, Map<String, PyTargetExpression>> getClassLevelFinalsAndInitAttributes(PyClass cls) {
            Map initAttributes;
            Map classLevelFinals;
            block1: {
                classLevelFinals = new LinkedHashMap();
                List<PyTargetExpression> list = cls.getClassAttributes();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getClassAttributes(...)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PyTargetExpression it = (PyTargetExpression)element$iv;
                    boolean bl = false;
                    if (!this.isFinal((PyAnnotationOwner)it)) continue;
                    String string = it.getName();
                    Intrinsics.checkNotNull((Object)it);
                    classLevelFinals.put(string, it);
                }
                initAttributes = new LinkedHashMap();
                PyFunction pyFunction = cls.findMethodByName("__init__", false, this.myTypeEvalContext);
                if (pyFunction == null) break block1;
                PyFunction it = pyFunction;
                boolean bl = false;
                PyClassImpl.collectInstanceAttributes(it, initAttributes);
            }
            return new Pair((Object)classLevelFinals, (Object)initAttributes);
        }

        private final Pair<Map<String, PyTargetExpression>, Map<String, PyTargetExpression>> getDeclaredClassAndInstanceFinals(PyClass cls) {
            Map instanceFinals;
            Map classFinals;
            block2: {
                classFinals = new LinkedHashMap();
                instanceFinals = new LinkedHashMap();
                for (PyTargetExpression classAttribute : cls.getClassAttributes()) {
                    String name2;
                    if (classAttribute.getName() == null || !this.isFinal((PyAnnotationOwner)classAttribute)) continue;
                    Map mapToPut = classAttribute.hasAssignedValue() ? classFinals : instanceFinals;
                    Intrinsics.checkNotNull((Object)classAttribute);
                    mapToPut.put(name2, classAttribute);
                }
                PyFunction pyFunction = cls.findMethodByName("__init__", false, this.myTypeEvalContext);
                if (pyFunction == null) break block2;
                PyFunction init = pyFunction;
                boolean bl = false;
                Map attributesInInit = new LinkedHashMap();
                PyClassImpl.collectInstanceAttributes(init, attributesInInit);
                attributesInInit.keySet().removeAll(instanceFinals.keySet());
                Map map = instanceFinals;
                Map $this$filterValues$iv = attributesInInit;
                boolean $i$f$filterValues = false;
                LinkedHashMap result$iv = new LinkedHashMap();
                for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
                    PyTargetExpression it = (PyTargetExpression)entry$iv.getValue();
                    boolean bl2 = false;
                    if (!this.isFinal((PyAnnotationOwner)it)) continue;
                    result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                }
                Map map2 = result$iv;
                map.putAll(map2);
            }
            return new Pair((Object)classFinals, (Object)instanceFinals);
        }

        private final void checkClassLevelFinalsAreInitialized(Map<String, ? extends PyTargetExpression> classLevelFinals, Map<String, ? extends PyTargetExpression> initAttributes) {
            Map<String, ? extends PyTargetExpression> $this$forEach$iv = classLevelFinals;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, ? extends PyTargetExpression>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, ? extends PyTargetExpression> element$iv;
                Map.Entry<String, ? extends PyTargetExpression> entry = element$iv = iterator.next();
                boolean bl = false;
                String name2 = entry.getKey();
                PyTargetExpression psi = entry.getValue();
                if (psi.hasAssignedValue() || initAttributes.containsKey(name2)) continue;
                this.registerProblem(psi, PyPsiBundle.message("INSP.final.final.name.should.be.initialized.with.value", new Object[0]));
            }
        }

        private final void checkSameNameClassAndInstanceFinals(Map<String, ? extends PyTargetExpression> classLevelFinals, Map<String, ? extends PyTargetExpression> initAttributes) {
            Map<String, ? extends PyTargetExpression> $this$forEach$iv = initAttributes;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, ? extends PyTargetExpression>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                String message;
                Map.Entry<String, ? extends PyTargetExpression> element$iv;
                Map.Entry<String, ? extends PyTargetExpression> entry = element$iv = iterator.next();
                boolean bl = false;
                String name2 = entry.getKey();
                PyTargetExpression initAttribute = entry.getValue();
                PyTargetExpression sameNameClassLevelFinal = classLevelFinals.get(name2);
                if (sameNameClassLevelFinal == null || !this.isFinal((PyAnnotationOwner)initAttribute)) continue;
                if (sameNameClassLevelFinal.hasAssignedValue()) {
                    this.registerProblem(initAttribute, PyPsiBundle.message("INSP.final.already.declared.name.could.not.be.redefined.as.final", new Object[0]));
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)PyPsiBundle.message("INSP.final.either.instance.attribute.or.class.attribute.could.be.type.hinted.as.final", new Object[0]), (String)"message(...)");
                this.registerProblem(sameNameClassLevelFinal, message);
                this.registerProblem(initAttribute, message);
            }
        }

        private final void checkOverridingInheritedFinalWithNewOne(PyClass cls) {
            Pair<Map<String, PyTargetExpression>, Map<String, PyTargetExpression>> pair = this.getDeclaredClassAndInstanceFinals(cls);
            Map newClassFinals = (Map)pair.component1();
            Map newInstanceFinals = (Map)pair.component2();
            Set notRegisteredClassFinals = CollectionsKt.toMutableSet((Iterable)newClassFinals.keySet());
            Set notRegisteredInstanceFinals = CollectionsKt.toMutableSet((Iterable)newInstanceFinals.keySet());
            if (notRegisteredClassFinals.isEmpty() && notRegisteredInstanceFinals.isEmpty()) {
                return;
            }
            for (PyClass ancestor : cls.getAncestorClasses(this.myTypeEvalContext)) {
                Intrinsics.checkNotNull((Object)ancestor);
                Pair<Map<String, PyTargetExpression>, Map<String, PyTargetExpression>> pair2 = this.getDeclaredClassAndInstanceFinals(ancestor);
                Map inheritedClassFinals = (Map)pair2.component1();
                Map inheritedInstanceFinals = (Map)pair2.component2();
                this.checkOverridingInheritedFinalWithNewOne(newClassFinals, inheritedClassFinals, ancestor.getName(), notRegisteredClassFinals);
                this.checkOverridingInheritedFinalWithNewOne(newInstanceFinals, inheritedInstanceFinals, ancestor.getName(), notRegisteredInstanceFinals);
                if (!notRegisteredClassFinals.isEmpty() || !notRegisteredInstanceFinals.isEmpty()) continue;
                break;
            }
        }

        private final void checkOverridingInheritedFinalWithNewOne(Map<String, ? extends PyTargetExpression> newFinals, Map<String, ? extends PyTargetExpression> inheritedFinals, String ancestorName, Set<String> notRegistered) {
            if (notRegistered.isEmpty()) {
                return;
            }
            for (String commonFinal : CollectionsKt.intersect((Iterable)newFinals.keySet(), (Iterable)inheritedFinals.keySet())) {
                String qualifiedName = ancestorName + "." + commonFinal;
                Object[] objectArray = new Object[]{qualifiedName};
                this.registerProblem(newFinals.get(commonFinal), PyPsiBundle.message("INSP.final.final.attribute.could.not.be.overridden", objectArray));
                notRegistered.remove(commonFinal);
            }
        }

        private final void checkInstanceFinalsOutsideInit(PyFunction method) {
            if (PyUtil.isInitMethod(method)) {
                return;
            }
            Map instanceAttributes = new LinkedHashMap();
            PyClassImpl.collectInstanceAttributes(method, instanceAttributes);
            Iterable $this$forEach$iv = instanceAttributes.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PyTargetExpression it = (PyTargetExpression)element$iv;
                boolean bl = false;
                if (!this.isFinal((PyAnnotationOwner)it)) continue;
                this.registerProblem(it, PyPsiBundle.message("INSP.final.final.attribute.should.be.declared.in.class.body.or.init", new Object[0]));
            }
        }

        private final void checkFinalReassignment(PyQualifiedExpression target) {
            ScopeOwner scopeOwner;
            boolean bl;
            Object[] $this$any$iv;
            List resolved;
            block15: {
                List list;
                PyType qualifierType;
                PyExpression pyExpression = target.getQualifier();
                if (pyExpression != null) {
                    PyExpression it = pyExpression;
                    boolean bl2 = false;
                    v1 = this.myTypeEvalContext.getType(it);
                } else {
                    v1 = qualifierType = null;
                }
                if (qualifierType instanceof PyClassType && !((PyClassType)qualifierType).isDefinition()) {
                    PyClass pyClass = ((PyClassType)qualifierType).getPyClass();
                    Intrinsics.checkNotNullExpressionValue((Object)pyClass, (String)"getPyClass(...)");
                    this.checkInstanceFinalReassignment(target, pyClass);
                    return;
                }
                if (target instanceof PyReferenceOwner) {
                    ResolveResult[] resolveResultArray = ((PyReferenceOwner)((Object)target)).getReference(this.getResolveContext()).multiResolve(false);
                    Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"multiResolve(...)");
                    Object[] $this$mapNotNull$iv = resolveResultArray;
                    boolean $i$f$mapNotNull = false;
                    Object[] objectArray = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    Object[] $this$forEach$iv$iv$iv = objectArray;
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv$iv$iv.length;
                    for (int i = 0; i < n; ++i) {
                        PsiElement it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                        boolean bl3 = false;
                        ResolveResult it = (ResolveResult)element$iv$iv;
                        boolean bl4 = false;
                        if (it.getElement() == null) continue;
                        boolean bl5 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                } else {
                    List list2 = PyUtil.multiResolveTopPriority((PsiElement)target, this.getResolveContext());
                    list = list2;
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"multiResolveTopPriority(...)");
                }
                resolved = list;
                $this$any$iv = resolved;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object t : $this$any$iv) {
                        PsiElement it = (PsiElement)t;
                        boolean bl6 = false;
                        if (!(it instanceof PyTargetExpression && this.isFinal((PyAnnotationOwner)it))) continue;
                        bl = true;
                        break block15;
                    }
                    bl = false;
                }
            }
            if (bl) {
                $this$any$iv = new Object[]{target.getName()};
                this.registerProblem((PsiElement)target, PyPsiBundle.message("INSP.final.final.target.could.not.be.reassigned", $this$any$iv));
                return;
            }
            for (PsiElement e : resolved) {
                boolean bl2;
                block16: {
                    if (!this.myTypeEvalContext.maySwitchToAST(e)) continue;
                    PsiElement psiElement = e.getParent();
                    boolean bl8 = false;
                    boolean bl3 = psiElement instanceof PyNonlocalStatement || psiElement instanceof PyGlobalStatement;
                    if (!bl3) continue;
                    List<PsiElement> list = PyUtil.multiResolveTopPriority(e, this.getResolveContext());
                    Intrinsics.checkNotNullExpressionValue(list, (String)"multiResolveTopPriority(...)");
                    Iterable $this$any$iv2 = list;
                    boolean bl4 = false;
                    if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv2) {
                            PsiElement it2 = (PsiElement)element$iv;
                            boolean bl10 = false;
                            if (!(it2 instanceof PyTargetExpression && this.isFinal((PyAnnotationOwner)it2))) continue;
                            bl2 = true;
                            break block16;
                        }
                        bl2 = false;
                    }
                }
                if (!bl2) continue;
                Object[] objectArray = new Object[]{target.getName()};
                this.registerProblem((PsiElement)target, PyPsiBundle.message("INSP.final.final.target.could.not.be.reassigned", objectArray));
                return;
            }
            if (!target.isQualified() && (scopeOwner = ScopeUtil.getScopeOwner((PsiElement)target)) instanceof PyClass) {
                this.checkInheritedClassFinalReassignmentOnClassLevel(target, (PyClass)scopeOwner);
            }
        }

        private final void checkInstanceFinalReassignment(PyQualifiedExpression target, PyClass cls) {
            String string = target.getName();
            if (string == null) {
                return;
            }
            String name2 = string;
            PyTargetExpression classAttribute = cls.findClassAttribute(name2, false, this.myTypeEvalContext);
            if (classAttribute != null && !classAttribute.hasAssignedValue() && this.isFinal((PyAnnotationOwner)classAttribute)) {
                if (target instanceof PyTargetExpression) {
                    ScopeOwner scopeOwner = ScopeUtil.getScopeOwner((PsiElement)target);
                    boolean bl = false;
                    boolean bl2 = scopeOwner instanceof PyFunction && Intrinsics.areEqual((Object)PyUtil.turnConstructorIntoClass((PyFunction)scopeOwner), (Object)cls);
                    if (bl2) {
                        return;
                    }
                }
                Object[] objectArray = new Object[]{name2};
                this.registerProblem((PsiElement)target, PyPsiBundle.message("INSP.final.final.target.could.not.be.reassigned", objectArray));
            }
            for (PyClass pyClass : cls.getAncestorClasses(this.myTypeEvalContext)) {
                PyTargetExpression inheritedClassAttribute = pyClass.findClassAttribute(name2, false, this.myTypeEvalContext);
                if (inheritedClassAttribute == null || inheritedClassAttribute.hasAssignedValue() || !this.isFinal((PyAnnotationOwner)inheritedClassAttribute)) continue;
                String qualifiedName = pyClass.getName() + "." + name2;
                Object[] objectArray = new Object[]{qualifiedName};
                this.registerProblem((PsiElement)target, PyPsiBundle.message("INSP.final.final.target.could.not.be.reassigned", objectArray));
                return;
            }
            Object[] objectArray = new PyClass[]{cls};
            Sequence sequence = SequencesKt.sequenceOf((Object[])objectArray);
            List<PyClass> list = cls.getAncestorClasses(this.myTypeEvalContext);
            Intrinsics.checkNotNullExpressionValue(list, (String)"getAncestorClasses(...)");
            for (PyClass pyClass : SequencesKt.plus((Sequence)sequence, (Sequence)CollectionsKt.asSequence((Iterable)list))) {
                boolean bl;
                PyFunction init = pyClass.findMethodByName("__init__", false, this.myTypeEvalContext);
                if (init == null) continue;
                Map attributesInInit = new LinkedHashMap();
                PyClassImpl.collectInstanceAttributes(init, attributesInInit);
                if ((PyTargetExpression)attributesInInit.get(name2) != null) {
                    PyTargetExpression it;
                    boolean bl3 = false;
                    bl = !Intrinsics.areEqual((Object)it, (Object)target) && this.isFinal((PyAnnotationOwner)it);
                } else {
                    bl = false;
                }
                if (!bl) continue;
                String qualifiedName = (String)(Intrinsics.areEqual((Object)cls, (Object)pyClass) ? "" : pyClass.getName() + ".") + name2;
                Object[] objectArray2 = new Object[]{qualifiedName};
                this.registerProblem((PsiElement)target, PyPsiBundle.message("INSP.final.final.target.could.not.be.reassigned", objectArray2));
                break;
            }
        }

        private final void checkInheritedClassFinalReassignmentOnClassLevel(PyQualifiedExpression target, PyClass cls) {
            String string = target.getName();
            if (string == null) {
                return;
            }
            String name2 = string;
            for (PyClass ancestor : cls.getAncestorClasses(this.myTypeEvalContext)) {
                PyTargetExpression ancestorClassAttribute = ancestor.findClassAttribute(name2, false, this.myTypeEvalContext);
                if (ancestorClassAttribute == null || !ancestorClassAttribute.hasAssignedValue() || !this.isFinal((PyAnnotationOwner)ancestorClassAttribute)) continue;
                String qualifiedName = ancestor.getName() + "." + name2;
                Object[] objectArray = new Object[]{qualifiedName};
                this.registerProblem((PsiElement)target, PyPsiBundle.message("INSP.final.final.target.could.not.be.reassigned", objectArray));
                break;
            }
        }

        private final void checkFinalIsOuterMost(PyReferenceExpression node) {
            if (this.isTopLevelInAnnotationOrTypeComment(node)) {
                return;
            }
            PsiElement psiElement = node.getParent();
            PySubscriptionExpression pySubscriptionExpression = psiElement instanceof PySubscriptionExpression ? (PySubscriptionExpression)psiElement : null;
            if (pySubscriptionExpression != null) {
                PySubscriptionExpression it = pySubscriptionExpression;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getOperand(), (Object)node) && this.isTopLevelInAnnotationOrTypeComment(it)) {
                    return;
                }
            }
            if (PyTypingTypeProvider.isInsideTypeHint((PsiElement)node, this.myTypeEvalContext) && this.resolvesToFinal(node)) {
                this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.final.final.could.only.be.used.as.outermost.type", new Object[0]));
            }
        }

        private final void checkFinalInsideLoop(PyLoopStatement loop) {
            loop.acceptChildren(new PyRecursiveElementVisitor(this){
                final /* synthetic */ Visitor this$0;
                {
                    this.this$0 = $receiver;
                }

                public void visitElement(@NotNull PsiElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    if (!(element instanceof ScopeOwner)) {
                        super.visitElement(element);
                    }
                }

                public void visitPyForStatement(@NotNull PyForStatement node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                }

                public void visitPyWhileStatement(@NotNull PyWhileStatement node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                }

                public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    if (Visitor.access$isFinal(this.this$0, node)) {
                        this.this$0.registerProblem(node, PyPsiBundle.message("INSP.final.final.could.not.be.used.inside.loop", new Object[0]));
                    }
                }
            });
        }

        private final boolean isFinal(PyDecoratable decoratable) {
            return PyTypingTypeProvider.isFinal(decoratable, this.myTypeEvalContext);
        }

        private final <T extends PyAnnotationOwner & PyTypeCommentOwner> boolean isFinal(T node) {
            return PyTypingTypeProvider.isFinal(node, this.myTypeEvalContext);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean resolvesToFinal(PyExpression expression) {
            boolean bl;
            if (!(expression instanceof PyReferenceExpression)) return false;
            Collection<String> collection = PyTypingTypeProvider.resolveToQualifiedNames(expression, this.myTypeEvalContext);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"resolveToQualifiedNames(...)");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                String it = (String)element$iv;
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)it, (Object)"typing.Final")) return true;
                if (Intrinsics.areEqual((Object)it, (Object)"typing_extensions.Final")) {
                    return true;
                }
                bl = false;
            } while (!bl);
            return true;
        }

        private final boolean isTopLevelInAnnotationOrTypeComment(PyExpression node) {
            PsiElement parent = node.getParent();
            if (parent instanceof PyAnnotation) {
                return true;
            }
            if (parent instanceof PyExpressionStatement && ((PyExpressionStatement)parent).getParent() instanceof PyTypeHintFile) {
                return true;
            }
            if (parent instanceof PyParameterTypeList) {
                return true;
            }
            return parent instanceof PyFunctionTypeAnnotation;
        }

        private static final boolean visitPyClass$lambda$2(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ boolean access$isFinal(Visitor $this, PyDecoratable decoratable) {
            return $this.isFinal(decoratable);
        }

        public static final /* synthetic */ boolean access$isFinal(Visitor $this, PyAnnotationOwner node) {
            return $this.isFinal(node);
        }
    }
}

