/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.impl.VcsFileStatusInfo;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.GitCommitRequirements;
import git4idea.history.GitLogFullRecord;
import git4idea.history.GitLogOutputSplitter;
import git4idea.history.GitLogParser;
import git4idea.log.GitLogProvider;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010#\n\u0002\b\u0003\u0018\u0000 ,2\u00020\u0001:\u0001,B1\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJD\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u000b\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u00152\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0017\"\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0018J/\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00070\u001b0\u001a2\u000b\u0010\u001c\u001a\u00070\u0014\u00a2\u0006\u0002\b\u00152\u0006\u0010\u001d\u001a\u00020\u0007H\u0002J7\u0010\u001e\u001a\u00020\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u001f0!2\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0017\"\u00020\u0014H\u0000\u00a2\u0006\u0004\b#\u0010$Jg\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00140\u001a2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u00142\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00140*2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u001f0!2\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0017\"\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010+R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lgit4idea/history/GitFileHistory;", "", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "Lcom/intellij/openapi/vcs/FilePath;", "startingRevision", "Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "fullHistory", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;Z)V", "Lorg/jetbrains/annotations/NotNull;", "createLogHandler", "Lgit4idea/commands/GitLineHandler;", "parser", "Lgit4idea/history/GitLogParser;", "Lgit4idea/history/GitLogFullRecord;", "lastCommit", "", "Lorg/jetbrains/annotations/NonNls;", "parameters", "", "(Lgit4idea/history/GitLogParser;Lcom/intellij/openapi/vcs/FilePath;Ljava/lang/String;[Ljava/lang/String;)Lgit4idea/commands/GitLineHandler;", "getParentsAndPathsIfRename", "", "Lkotlin/Pair;", "commit", "filePath", "load", "", "consumer", "Lkotlin/Function1;", "Lgit4idea/GitFileRevision;", "load$intellij_vcs_git", "(Lkotlin/jvm/functions/Function1;[Ljava/lang/String;)V", "runGitLog", "logParser", "startPath", "startRevision", "visitedCommits", "", "(Lgit4idea/history/GitLogParser;Lcom/intellij/openapi/vcs/FilePath;Ljava/lang/String;Ljava/util/Set;Lkotlin/jvm/functions/Function1;[Ljava/lang/String;)Ljava/util/List;", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitFileHistory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitFileHistory.kt\ngit4idea/history/GitFileHistory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,253:1\n1569#2,11:254\n1864#2,2:265\n288#2,2:267\n1866#2:270\n1580#2:271\n1#3:269\n*S KotlinDebug\n*F\n+ 1 GitFileHistory.kt\ngit4idea/history/GitFileHistory\n*L\n126#1:254,11\n126#1:265,2\n128#1:267,2\n126#1:270\n126#1:271\n126#1:269\n*E\n"})
public final class GitFileHistory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile root;
    @NotNull
    private final VcsRevisionNumber startingRevision;
    private final boolean fullHistory;
    @NotNull
    private final FilePath path;

    public GitFileHistory(@NotNull Project project, @NotNull VirtualFile root, @NotNull FilePath path, @NotNull VcsRevisionNumber startingRevision, boolean fullHistory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)startingRevision, (String)"startingRevision");
        this.project = project;
        this.root = root;
        this.startingRevision = startingRevision;
        this.fullHistory = fullHistory;
        FilePath filePath = VcsUtil.getLastCommitPath((Project)this.project, (FilePath)path);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getLastCommitPath(...)");
        this.path = filePath;
    }

    public /* synthetic */ GitFileHistory(Project project, VirtualFile virtualFile, FilePath filePath, VcsRevisionNumber vcsRevisionNumber, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(project, virtualFile, filePath, vcsRevisionNumber, bl);
    }

    public final void load$intellij_vcs_git(@NotNull Function1<? super GitFileRevision, Unit> consumer2, String ... parameters) throws VcsException {
        Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        GitLogParser<GitLogFullRecord> logParser = Companion.createLogParser$intellij_vcs_git(this.project);
        Set visitedCommits = new LinkedHashSet();
        Object[] objectArray = new Pair[]{new Pair((Object)this.startingRevision.asString(), (Object)this.path)};
        LinkedList linkedList = ContainerUtil.newLinkedList((Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)linkedList, (String)"newLinkedList(...)");
        LinkedList starts = linkedList;
        while (!((Collection)starts).isEmpty()) {
            Pair pair = (Pair)starts.removeFirst();
            String startRevision = (String)pair.component1();
            FilePath startPath = (FilePath)pair.component2();
            Intrinsics.checkNotNull((Object)startRevision);
            List<String> lastCommits = this.runGitLog(logParser, startPath, startRevision, visitedCommits, consumer2, Arrays.copyOf(parameters, parameters.length));
            if (lastCommits.isEmpty()) {
                return;
            }
            for (String lastCommit : lastCommits) {
                starts.addAll((Collection)this.getParentsAndPathsIfRename(lastCommit, startPath));
            }
        }
    }

    private final List<String> runGitLog(GitLogParser<GitLogFullRecord> logParser, FilePath startPath, String startRevision, Set<String> visitedCommits, Function1<? super GitFileRevision, Unit> consumer2, String ... parameters) throws VcsException {
        GitLineHandler handler = this.createLogHandler(logParser, startPath, startRevision, Arrays.copyOf(parameters, parameters.length));
        Ref.BooleanRef skipFurtherOutput = new Ref.BooleanRef();
        List lastCommits = new ArrayList();
        GitLogOutputSplitter<Object> splitter2 = new GitLogOutputSplitter<Object>(handler, logParser, arg_0 -> GitFileHistory.runGitLog$lambda$0((Function1)new Function1<GitLogFullRecord, Unit>(skipFurtherOutput, visitedCommits, this, (List<String>)lastCommits, startPath, consumer2){
            final /* synthetic */ Ref.BooleanRef $skipFurtherOutput;
            final /* synthetic */ Set<String> $visitedCommits;
            final /* synthetic */ GitFileHistory this$0;
            final /* synthetic */ List<String> $lastCommits;
            final /* synthetic */ FilePath $startPath;
            final /* synthetic */ Function1<GitFileRevision, Unit> $consumer;
            {
                this.$skipFurtherOutput = $skipFurtherOutput;
                this.$visitedCommits = $visitedCommits;
                this.this$0 = $receiver;
                this.$lastCommits = $lastCommits;
                this.$startPath = $startPath;
                this.$consumer = $consumer;
                super(1);
            }

            public final void invoke(GitLogFullRecord record) {
                if (this.$skipFurtherOutput.element || this.$visitedCommits.contains(record.getHash())) {
                    return;
                }
                String string = record.getHash();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHash(...)");
                this.$visitedCommits.add(string);
                List<VcsFileStatusInfo> list2 = record.getStatusInfos();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getStatusInfos(...)");
                VcsFileStatusInfo vcsFileStatusInfo = (VcsFileStatusInfo)CollectionsKt.firstOrNull(list2);
                if ((vcsFileStatusInfo != null ? vcsFileStatusInfo.getType() : null) == Change.Type.NEW && !GitFileHistory.access$getPath$p(this.this$0).isDirectory()) {
                    String string2 = record.getHash();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getHash(...)");
                    this.$lastCommits.add(string2);
                    if (!GitFileHistory.access$getFullHistory$p(this.this$0)) {
                        this.$skipFurtherOutput.element = true;
                    }
                }
                Project project = GitFileHistory.access$getProject$p(this.this$0);
                VirtualFile virtualFile = GitFileHistory.access$getRoot$p(this.this$0);
                Intrinsics.checkNotNull((Object)record);
                GitFileRevision revision = GitFileHistory.Companion.createGitFileRevision$intellij_vcs_git(project, virtualFile, record, this.$startPath);
                this.$consumer.invoke((Object)revision);
            }
        }, arg_0));
        Git.getInstance().runCommandWithoutCollectingOutput(handler);
        splitter2.reportErrors();
        return lastCommits;
    }

    /*
     * Unable to fully structure code
     */
    private final List<Pair<String, FilePath>> getParentsAndPathsIfRename(String commit, FilePath filePath) throws VcsException {
        requirements = new GitCommitRequirements(false, GitCommitRequirements.DiffRenames.Limit.Default.INSTANCE, GitCommitRequirements.DiffInMergeCommits.DIFF_TO_PARENTS, 1, null);
        h = new GitLineHandler(this.project, this.root, GitCommand.SHOW, requirements.configParameters());
        var7_5 = new GitLogParser.GitLogOption[]{GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.PARENTS};
        v0 = GitLogParser.createDefaultParser(this.project, GitLogParser.NameStatus.STATUS, var7_5);
        Intrinsics.checkNotNullExpressionValue(v0, (String)"createDefaultParser(...)");
        parser = v0;
        h.setStdoutSuppressed(true);
        v1 = h.getExecutable();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getExecutable(...)");
        h.addParameters(requirements.commandParameters(this.project, v1));
        var6_7 = new String[]{"--follow", "--name-status", parser.getPretty(), "--encoding=UTF-8", commit};
        h.addParameters(var6_7);
        h.endOptions();
        var6_7 = new FilePath[]{filePath};
        h.addRelativePaths((FilePath[])var6_7);
        v2 = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getOutputOrThrow(...)");
        output = v2;
        v3 = parser.parse(output);
        Intrinsics.checkNotNullExpressionValue(v3, (String)"parse(...)");
        records = v3;
        $this$mapIndexedNotNull$iv = records;
        $i$f$mapIndexedNotNull = false;
        var10_10 = $this$mapIndexedNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapIndexedNotNullTo = false;
        $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        $i$f$forEachIndexed = false;
        index$iv$iv$iv = 0;
        for (T item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            block9: {
                if ((var18_18 = index$iv$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                var19_19 = item$iv$iv$iv;
                index$iv$iv = var18_18;
                $i$a$-forEachIndexed-CollectionsKt___CollectionsKt$mapIndexedNotNullTo$1$iv$iv = false;
                var22_22 = (GitLogFullRecord)element$iv$iv;
                i = index$iv$iv;
                $i$a$-mapIndexedNotNull-GitFileHistory$getParentsAndPathsIfRename$1 = false;
                Intrinsics.checkNotNullExpressionValue(record.parseChanges(this.project, this.root), (String)"parseChanges(...)");
                $this$firstOrNull$iv = changes;
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    change = (Change)element$iv;
                    $i$a$-firstOrNull-GitFileHistory$getParentsAndPathsIfRename$1$1 = false;
                    if (!change.isMoved() && !change.isRenamed()) ** GOTO lbl-1000
                    v4 = change.getAfterRevision();
                    Intrinsics.checkNotNull((Object)v4);
                    if (Intrinsics.areEqual((Object)filePath, (Object)v4.getFile())) {
                        v5 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v5 = false;
                    }
                    if (!v5) continue;
                    v6 = element$iv;
                    break block9;
                }
                v6 = null;
            }
            var32_34 = v6;
            if (var32_34 != null) {
                change = var32_34;
                $i$a$-let-GitFileHistory$getParentsAndPathsIfRename$1$2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)record.getParentsHashes(), (String)"getParentsHashes(...)");
                if (parents.length == 0 == false) {
                    v7 = parents[i];
                    v8 = change.getBeforeRevision();
                    Intrinsics.checkNotNull((Object)v8);
                    v9 = new Pair((Object)v7, (Object)v8.getFile());
                } else {
                    v9 = null;
                }
            } else {
                v9 = null;
            }
            if (v9 == null) continue;
            it$iv$iv = v9;
            $i$a$-let-CollectionsKt___CollectionsKt$mapIndexedNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final GitLineHandler createLogHandler(GitLogParser<GitLogFullRecord> parser, FilePath path, String lastCommit, String ... parameters) {
        GitLineHandler h = new GitLineHandler(this.project, this.root, GitCommand.LOG);
        h.setStdoutSuppressed(true);
        String[] stringArray = new String[]{"--name-status", parser.getPretty(), "--encoding=UTF-8", lastCommit};
        h.addParameters(stringArray);
        if (GitVersionSpecialty.FULL_HISTORY_SIMPLIFY_MERGES_WORKS_CORRECTLY.existsIn(this.project) && Registry.is((String)"git.file.history.full")) {
            stringArray = new String[]{"--full-history", "--simplify-merges"};
            h.addParameters(stringArray);
        }
        if (!(parameters.length == 0)) {
            h.addParameters(Arrays.copyOf(parameters, parameters.length));
        }
        h.endOptions();
        stringArray = new FilePath[]{path};
        h.addRelativePaths((FilePath[])stringArray);
        return h;
    }

    private static final void runGitLog$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @JvmStatic
    public static final void loadHistory(@NotNull Project project, @NotNull FilePath path, @Nullable VcsRevisionNumber startingFrom, @NotNull Consumer<? super GitFileRevision> consumer2, @NotNull Consumer<? super VcsException> exceptionConsumer, String ... parameters) {
        Companion.loadHistory(project, path, startingFrom, consumer2, exceptionConsumer, parameters);
    }

    @JvmStatic
    @NotNull
    public static final List<VcsFileRevision> collectHistoryForRevision(@NotNull Project project, @NotNull FilePath path, @NotNull VcsRevisionNumber startingFrom, String ... parameters) throws VcsException {
        return Companion.collectHistoryForRevision(project, path, startingFrom, parameters);
    }

    @JvmStatic
    @NotNull
    public static final List<VcsFileRevision> collectHistory(@NotNull Project project, @NotNull FilePath path, String ... parameters) throws VcsException {
        return Companion.collectHistory(project, path, parameters);
    }

    public static final /* synthetic */ FilePath access$getPath$p(GitFileHistory $this) {
        return $this.path;
    }

    public static final /* synthetic */ boolean access$getFullHistory$p(GitFileHistory $this) {
        return $this.fullHistory;
    }

    public static final /* synthetic */ Project access$getProject$p(GitFileHistory $this) {
        return $this.project;
    }

    public static final /* synthetic */ VirtualFile access$getRoot$p(GitFileHistory $this) {
        return $this.root;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J7\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\fH\u0007\u00a2\u0006\u0002\u0010\rJ?\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\fH\u0007\u00a2\u0006\u0002\u0010\u0011J-\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0019J\u001b\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u001b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u001cJO\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001e0 2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\fH\u0002\u00a2\u0006\u0002\u0010!J[\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00130\"2\u000e\u0010#\u001a\n\u0012\u0006\b\u0000\u0012\u00020$0\"2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\fH\u0007\u00a2\u0006\u0002\u0010%J\u0016\u0010\u0018\u001a\u0004\u0018\u00010\t*\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006&"}, d2={"Lgit4idea/history/GitFileHistory$Companion;", "", "()V", "collectHistory", "", "Lcom/intellij/openapi/vcs/history/VcsFileRevision;", "project", "Lcom/intellij/openapi/project/Project;", "path", "Lcom/intellij/openapi/vcs/FilePath;", "parameters", "", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/FilePath;[Ljava/lang/String;)Ljava/util/List;", "collectHistoryForRevision", "startingFrom", "Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;[Ljava/lang/String;)Ljava/util/List;", "createGitFileRevision", "Lgit4idea/GitFileRevision;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "record", "Lgit4idea/history/GitLogFullRecord;", "filePath", "createGitFileRevision$intellij_vcs_git", "createLogParser", "Lgit4idea/history/GitLogParser;", "createLogParser$intellij_vcs_git", "loadHistory", "", "consumer", "Lkotlin/Function1;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;Lkotlin/jvm/functions/Function1;[Ljava/lang/String;)V", "Ljava/util/function/Consumer;", "exceptionConsumer", "Lcom/intellij/openapi/vcs/VcsException;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;Ljava/util/function/Consumer;Ljava/util/function/Consumer;[Ljava/lang/String;)V", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        private final FilePath filePath(GitLogFullRecord $this$filePath, VirtualFile root) {
            List<VcsFileStatusInfo> list2 = $this$filePath.getStatusInfos();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getStatusInfos(...)");
            VcsFileStatusInfo vcsFileStatusInfo = (VcsFileStatusInfo)CollectionsKt.firstOrNull(list2);
            if (vcsFileStatusInfo == null) {
                return null;
            }
            VcsFileStatusInfo statusInfo = vcsFileStatusInfo;
            String string = root.getPath();
            String string2 = statusInfo.getSecondPath();
            if (string2 == null) {
                string2 = statusInfo.getFirstPath();
            }
            return VcsUtil.getFilePath((String)(string + "/" + string2), (boolean)false);
        }

        @NotNull
        public final GitFileRevision createGitFileRevision$intellij_vcs_git(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitLogFullRecord record, @NotNull FilePath filePath) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            GitRevisionNumber revision = new GitRevisionNumber(record.getHash(), record.getDate());
            Couple couple = Couple.of((Object)record.getAuthorName(), (Object)record.getAuthorEmail());
            Intrinsics.checkNotNullExpressionValue((Object)couple, (String)"of(...)");
            Couple authorPair = couple;
            Couple couple2 = Couple.of((Object)record.getCommitterName(), (Object)record.getCommitterEmail());
            Intrinsics.checkNotNullExpressionValue((Object)couple2, (String)"of(...)");
            Couple committerPair = couple2;
            String[] stringArray = record.getParentsHashes();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getParentsHashes(...)");
            String[] stringArray2 = stringArray;
            List parents = CollectionsKt.listOf((Object[])Arrays.copyOf(stringArray2, stringArray2.length));
            FilePath filePath2 = this.filePath(record, root);
            if (filePath2 == null) {
                filePath2 = filePath;
            }
            FilePath revisionPath = filePath2;
            List<VcsFileStatusInfo> list2 = record.getStatusInfos();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getStatusInfos(...)");
            VcsFileStatusInfo vcsFileStatusInfo = (VcsFileStatusInfo)CollectionsKt.firstOrNull(list2);
            boolean deleted = (vcsFileStatusInfo != null ? vcsFileStatusInfo.getType() : null) == Change.Type.DELETED;
            return new GitFileRevision(project, root, revisionPath, revision, (Couple<Couple<String>>)Couple.of((Object)authorPair, (Object)committerPair), record.getFullMessage(), null, new Date(record.getAuthorTimeStamp()), parents, deleted);
        }

        @NotNull
        public final GitLogParser<GitLogFullRecord> createLogParser$intellij_vcs_git(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            GitLogParser.GitLogOption[] gitLogOptionArray = new GitLogParser.GitLogOption[]{GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.COMMITTER_EMAIL, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.BODY, GitLogParser.GitLogOption.RAW_BODY, GitLogParser.GitLogOption.AUTHOR_TIME};
            GitLogParser<GitLogFullRecord> gitLogParser = GitLogParser.createDefaultParser(project, GitLogParser.NameStatus.STATUS, gitLogOptionArray);
            Intrinsics.checkNotNullExpressionValue(gitLogParser, (String)"createDefaultParser(...)");
            return gitLogParser;
        }

        private final void loadHistory(Project project, FilePath path, VcsRevisionNumber startingFrom, Function1<? super GitFileRevision, Unit> consumer2, String ... parameters) {
            VirtualFile virtualFile = GitUtil.getRootForFile(project, path);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRootForFile(...)");
            VirtualFile detectedRoot = virtualFile;
            VirtualFile virtualFile2 = GitLogProvider.getCorrectedVcsRoot(GitRepositoryManager.getInstance(project), detectedRoot, path);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getCorrectedVcsRoot(...)");
            VirtualFile repositoryRoot = virtualFile2;
            VcsRevisionNumber vcsRevisionNumber = startingFrom;
            if (vcsRevisionNumber == null) {
                vcsRevisionNumber = (VcsRevisionNumber)GitRevisionNumber.HEAD;
            }
            VcsRevisionNumber revision = vcsRevisionNumber;
            Intrinsics.checkNotNull((Object)revision);
            new GitFileHistory(project, repositoryRoot, path, revision, false, 16, null).load$intellij_vcs_git(consumer2, Arrays.copyOf(parameters, parameters.length));
        }

        @JvmStatic
        public final void loadHistory(@NotNull Project project, @NotNull FilePath path, @Nullable VcsRevisionNumber startingFrom, @NotNull Consumer<? super GitFileRevision> consumer2, @NotNull Consumer<? super VcsException> exceptionConsumer, String ... parameters) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
            Intrinsics.checkNotNullParameter(exceptionConsumer, (String)"exceptionConsumer");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            try {
                this.loadHistory(project, path, startingFrom, (Function1<? super GitFileRevision, Unit>)((Function1)new Function1<GitFileRevision, Unit>(consumer2){

                    public final void invoke(@NotNull GitFileRevision p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        ((Consumer)this.receiver).accept(p0);
                    }
                }), Arrays.copyOf(parameters, parameters.length));
            }
            catch (VcsException e) {
                exceptionConsumer.accept(e);
            }
        }

        @JvmStatic
        @NotNull
        public final List<VcsFileRevision> collectHistoryForRevision(@NotNull Project project, @NotNull FilePath path, @NotNull VcsRevisionNumber startingFrom, String ... parameters) throws VcsException {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)startingFrom, (String)"startingFrom");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            List revisions = new ArrayList();
            this.loadHistory(project, path, startingFrom, (Function1<? super GitFileRevision, Unit>)((Function1)new Function1<VcsFileRevision, Unit>((Object)revisions){

                public final void invoke(@NotNull VcsFileRevision p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((List)this.receiver).add(p0);
                }
            }), Arrays.copyOf(parameters, parameters.length));
            return revisions;
        }

        @JvmStatic
        @NotNull
        public final List<VcsFileRevision> collectHistory(@NotNull Project project, @NotNull FilePath path, String ... parameters) throws VcsException {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            GitRevisionNumber gitRevisionNumber = GitRevisionNumber.HEAD;
            Intrinsics.checkNotNullExpressionValue((Object)gitRevisionNumber, (String)"HEAD");
            return this.collectHistoryForRevision(project, path, (VcsRevisionNumber)gitRevisionNumber, Arrays.copyOf(parameters, parameters.length));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

