/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.r.inlays.components;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefJSQuery;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.cef.browser.CefBrowser;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.visualization.r.VisualizationBundle;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.MouseWheelUtils;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.components.GithubMarkdownCss;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.components.InlayOutput;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0018\u001a\u00020\bH\u0016J\b\u0010\u0019\u001a\u00020\u0015H\u0016J\b\u0010\u001a\u001a\u00020\bH\u0002J\b\u0010\u001b\u001a\u00020\bH\u0016J\b\u0010\u001c\u001a\u00020\bH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/InlayOutputHtml;", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/InlayOutput;", "parent", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "clearAction", "Lkotlin/Function0;", "", "(Lcom/intellij/openapi/Disposable;Lcom/intellij/openapi/editor/Editor;Lkotlin/jvm/functions/Function0;)V", "height", "", "heightJsCallback", "Lcom/intellij/ui/jcef/JBCefJSQuery;", "kotlin.jvm.PlatformType", "jbBrowser", "Lcom/intellij/ui/jcef/JBCefBrowser;", "saveJsCallback", "acceptType", "", "type", "", "addData", "data", "clear", "getCollapsedDescription", "notifySize", "saveAs", "scrollToTop", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nInlayOutput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlayOutput.kt\norg/jetbrains/plugins/notebooks/visualization/r/inlays/components/InlayOutputHtml\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,473:1\n1#2:474\n*E\n"})
public final class InlayOutputHtml
extends InlayOutput {
    @NotNull
    private final JBCefBrowser jbBrowser;
    private final JBCefJSQuery heightJsCallback;
    private final JBCefJSQuery saveJsCallback;
    private int height;

    /*
     * WARNING - void declaration
     */
    public InlayOutputHtml(@NotNull Disposable parent, @NotNull Editor editor, @NotNull Function0<Unit> clearAction2) {
        void it;
        JBCefBrowser jBCefBrowser;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(clearAction2, (String)"clearAction");
        super(parent, editor, clearAction2);
        JBCefBrowser jBCefBrowser2 = jBCefBrowser = new JBCefBrowser();
        InlayOutputHtml inlayOutputHtml = this;
        boolean bl = false;
        Disposer.register((Disposable)parent, (Disposable)((Disposable)it));
        inlayOutputHtml.jbBrowser = jBCefBrowser;
        this.heightJsCallback = JBCefJSQuery.create((JBCefBrowser)this.jbBrowser);
        this.saveJsCallback = JBCefJSQuery.create((JBCefBrowser)this.jbBrowser);
        JComponent jComponent = this.jbBrowser.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        MouseWheelUtils.INSTANCE.wrapMouseWheelListeners(jComponent, parent);
        this.heightJsCallback.addHandler(arg_0 -> InlayOutputHtml._init_$lambda$1((Function1)new Function1<String, JBCefJSQuery.Response>(){

            public final JBCefJSQuery.Response invoke(String it) {
                Intrinsics.checkNotNull((Object)it);
                final int height = Integer.parseInt(it);
                if (height != height) {
                    height = height;
                    ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(){

                        public final void invoke() {
                            SwingUtilities.invokeLater(() -> 1.invoke$lambda$0(this, height));
                        }

                        private static final void invoke$lambda$0(InlayOutputHtml this$0, int $height) {
                            block0: {
                                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                                Function1<Integer, Unit> function1 = this$0.getOnHeightCalculated();
                                if (function1 == null) break block0;
                                function1.invoke((Object)$height);
                            }
                        }
                    }), (int)1, null);
                }
                return new JBCefJSQuery.Response("OK");
            }
        }, arg_0));
        Disposer.register((Disposable)((Disposable)this.jbBrowser), (Disposable)((Disposable)this.heightJsCallback));
        this.getToolbarPane().setDataComponent(this.jbBrowser.getComponent());
    }

    @Override
    public boolean acceptType(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return Intrinsics.areEqual((Object)type, (Object)"HTML") || Intrinsics.areEqual((Object)type, (Object)"URL");
    }

    @Override
    public void clear() {
    }

    private final void notifySize() {
        this.jbBrowser.getCefBrowser().executeJavaScript("var body = document.body,html = document.documentElement;var height = Math.max( body.scrollHeight, body.offsetHeight, html.clientHeight, html.scrollHeight , html.offsetHeight );window." + this.heightJsCallback.getFuncName() + "({request: String(height)});", this.jbBrowser.getCefBrowser().getURL(), 0);
    }

    @Override
    public void addData(@NotNull String data2, @NotNull String type) {
        boolean isUrl;
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        boolean bl = isUrl = StringsKt.startsWith$default((String)data2, (String)"file://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)data2, (String)"http://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)data2, (String)"https://", (boolean)false, (int)2, null);
        if (isUrl) {
            this.jbBrowser.loadURL(data2);
        } else {
            this.jbBrowser.loadHTML("<head><style>" + GithubMarkdownCss.Companion.getCss() + " </style></head><body>" + data2 + "</body>");
        }
        this.jbBrowser.getJBCefClient().addLoadHandler((CefLoadHandler)new CefLoadHandlerAdapter(this){
            final /* synthetic */ InlayOutputHtml this$0;
            {
                this.this$0 = $receiver;
            }

            public void onLoadingStateChange(@Nullable CefBrowser browser, boolean isLoading, boolean canGoBack, boolean canGoForward) {
                InlayOutputHtml.access$notifySize(this.this$0);
            }
        }, this.jbBrowser.getCefBrowser());
    }

    @Override
    public void scrollToTop() {
    }

    @Override
    @NotNull
    public String getCollapsedDescription() {
        return "html output";
    }

    @Override
    public void saveAs() {
        String title = VisualizationBundle.INSTANCE.message("inlay.action.export.as.txt.title", new Object[0]);
        String description = VisualizationBundle.INSTANCE.message("inlay.action.exports.range.csv.description", new Object[0]);
        String[] stringArray = new String[]{"txt"};
        this.saveWithFileChooser(title, description, stringArray, "output", (Function1<? super File, Unit>)((Function1)new Function1<File, Unit>(this){
            final /* synthetic */ InlayOutputHtml this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull File destination) {
                Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
                InlayOutputHtml.access$getSaveJsCallback$p(this.this$0).addHandler((Function)new Function<String, JBCefJSQuery.Response>(destination, this.this$0){
                    final /* synthetic */ File $destination;
                    final /* synthetic */ InlayOutputHtml this$0;
                    {
                        this.$destination = $destination;
                        this.this$0 = $receiver;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @NotNull
                    public JBCefJSQuery.Response apply(@NotNull String selection) {
                        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
                        Object object = this.$destination;
                        Object object2 = Charsets.UTF_8;
                        int n = 8192;
                        Object object3 = object;
                        object3 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2);
                        object = object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n);
                        object2 = null;
                        try {
                            BufferedWriter out = (BufferedWriter)object;
                            boolean bl = false;
                            out.write(selection);
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable) {
                            object2 = throwable;
                            throw throwable;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                        }
                        InlayOutputHtml.access$getSaveJsCallback$p(this.this$0).removeHandler((Function)this);
                        return new JBCefJSQuery.Response("OK");
                    }
                });
                InlayOutputHtml.access$getJbBrowser$p(this.this$0).getCefBrowser().executeJavaScript("window." + InlayOutputHtml.access$getSaveJsCallback$p(this.this$0).getFuncName() + "({request: window.getSelection().toString()})", InlayOutputHtml.access$getJbBrowser$p(this.this$0).getCefBrowser().getURL(), 0);
            }
        }));
    }

    private static final JBCefJSQuery.Response _init_$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (JBCefJSQuery.Response)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$notifySize(InlayOutputHtml $this) {
        $this.notifySize();
    }

    public static final /* synthetic */ JBCefJSQuery access$getSaveJsCallback$p(InlayOutputHtml $this) {
        return $this.saveJsCallback;
    }

    public static final /* synthetic */ JBCefBrowser access$getJbBrowser$p(InlayOutputHtml $this) {
        return $this.jbBrowser;
    }
}

