/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.jb;

import com.intellij.ide.plugins.DescriptorListLoadingContext;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.startup.importSettings.data.Product;
import com.intellij.ide.startup.importSettings.jb.JbImportServiceImpl;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010&\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b'J\t\u0010(\u001a\u00020\nH\u00c6\u0003J\t\u0010)\u001a\u00020\nH\u00c6\u0003JO\u0010*\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u00c6\u0001J\u0013\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010.H\u00d6\u0003J\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001600J\t\u00101\u001a\u00020\u0018H\u00d6\u0001J\u001d\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0000\u00a2\u0006\u0002\b8J\t\u00109\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011R\u0014\u0010\u001a\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u0007\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0013R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0011\u00a8\u0006:"}, d2={"Lcom/intellij/ide/startup/importSettings/jb/JbProductInfo;", "Lcom/intellij/ide/startup/importSettings/data/Product;", "version", "", "lastUsageTime", "Ljava/nio/file/attribute/FileTime;", "id", "name", "codeName", "configDirPath", "Ljava/nio/file/Path;", "pluginsDirPath", "(Ljava/lang/String;Ljava/nio/file/attribute/FileTime;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "_lastUsage", "Ljava/time/LocalDate;", "kotlin.jvm.PlatformType", "getCodeName$intellij_ide_startup_importSettings", "()Ljava/lang/String;", "getConfigDirPath", "()Ljava/nio/file/Path;", "descriptors", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "descriptors2ProcessCnt", "", "getId", "lastUsage", "getLastUsage", "()Ljava/time/LocalDate;", "getLastUsageTime", "()Ljava/nio/file/attribute/FileTime;", "getName", "getPluginsDirPath", "getVersion", "component1", "component2", "component3", "component4", "component5", "component5$intellij_ide_startup_importSettings", "component6", "component7", "copy", "equals", "", "other", "", "getPluginsDescriptors", "", "hashCode", "prefetchPluginDescriptors", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "context", "Lcom/intellij/ide/plugins/DescriptorListLoadingContext;", "prefetchPluginDescriptors$intellij_ide_startup_importSettings", "toString", "intellij.ide.startup.importSettings"})
public final class JbProductInfo
implements Product {
    @NotNull
    private final String version;
    @NotNull
    private final FileTime lastUsageTime;
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final String codeName;
    @NotNull
    private final Path configDirPath;
    @NotNull
    private final Path pluginsDirPath;
    @NotNull
    private final CopyOnWriteArrayList<IdeaPluginDescriptorImpl> descriptors;
    private int descriptors2ProcessCnt;
    private final LocalDate _lastUsage;
    @NotNull
    private final LocalDate lastUsage;

    public JbProductInfo(@NotNull String version, @NotNull FileTime lastUsageTime, @NotNull String id, @NotNull String name, @NotNull String codeName, @NotNull Path configDirPath, @NotNull Path pluginsDirPath) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)lastUsageTime, (String)"lastUsageTime");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)codeName, (String)"codeName");
        Intrinsics.checkNotNullParameter((Object)configDirPath, (String)"configDirPath");
        Intrinsics.checkNotNullParameter((Object)pluginsDirPath, (String)"pluginsDirPath");
        this.version = version;
        this.lastUsageTime = lastUsageTime;
        this.id = id;
        this.name = name;
        this.codeName = codeName;
        this.configDirPath = configDirPath;
        this.pluginsDirPath = pluginsDirPath;
        this.descriptors = new CopyOnWriteArrayList();
        LocalDate localDate = this._lastUsage = LocalDate.ofInstant(this.lastUsageTime.toInstant(), ZoneId.systemDefault());
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"_lastUsage");
        this.lastUsage = localDate;
    }

    @Override
    @NotNull
    public String getVersion() {
        return this.version;
    }

    @NotNull
    public final FileTime getLastUsageTime() {
        return this.lastUsageTime;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final String getCodeName$intellij_ide_startup_importSettings() {
        return this.codeName;
    }

    @NotNull
    public final Path getConfigDirPath() {
        return this.configDirPath;
    }

    @NotNull
    public final Path getPluginsDirPath() {
        return this.pluginsDirPath;
    }

    public final void prefetchPluginDescriptors$intellij_ide_startup_importSettings(@NotNull CoroutineScope coroutineScope, @NotNull DescriptorListLoadingContext context2) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JbImportServiceImpl.Companion.getLOG$intellij_ide_startup_importSettings().debug("Prefetching plugin descriptors from " + this.pluginsDirPath);
        List descriptorDeferreds = PluginDescriptorLoader.loadCustomDescriptorsFromDir((CoroutineScope)coroutineScope, (Path)this.pluginsDirPath, (DescriptorListLoadingContext)context2, null);
        this.descriptors2ProcessCnt = descriptorDeferreds.size();
        JbImportServiceImpl.Companion.getLOG$intellij_ide_startup_importSettings().debug("There are " + descriptorDeferreds.size() + " plugins in " + this.pluginsDirPath);
        for (Deferred def : descriptorDeferreds) {
            def.invokeOnCompletion((Function1)new Function1<Throwable, Unit>(coroutineScope, (Deferred<IdeaPluginDescriptorImpl>)def, this){
                final /* synthetic */ CoroutineScope $coroutineScope;
                final /* synthetic */ Deferred<IdeaPluginDescriptorImpl> $def;
                final /* synthetic */ JbProductInfo this$0;
                {
                    this.$coroutineScope = $coroutineScope;
                    this.$def = $def;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@Nullable Throwable it) {
                    BuildersKt.async$default((CoroutineScope)this.$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$def, this.this$0, null){
                        int label;
                        final /* synthetic */ Deferred<IdeaPluginDescriptorImpl> $def;
                        final /* synthetic */ JbProductInfo this$0;
                        {
                            this.$def = $def;
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object var1_1) {
                            var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    this.label = 1;
                                    v0 = this.$def.await((Continuation)this);
                                    if (v0 == var3_2) {
                                        return var3_2;
                                    }
                                    ** GOTO lbl13
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl13:
                                    // 2 sources

                                    v1 = (IdeaPluginDescriptorImpl)v0;
                                    if (v1 == null) {
                                        return Unit.INSTANCE;
                                    }
                                    descr = v1;
                                    JbProductInfo.access$getDescriptors$p(this.this$0).add(descr);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                }
            });
        }
    }

    @NotNull
    public final List<IdeaPluginDescriptorImpl> getPluginsDescriptors() {
        List retval = CollectionsKt.toList((Iterable)this.descriptors);
        if (retval.size() != this.descriptors2ProcessCnt) {
            JbImportServiceImpl.Companion.getLOG$intellij_ide_startup_importSettings().warn("found " + retval.size() + " custom plugins, but found only " + this.descriptors2ProcessCnt);
        }
        return retval;
    }

    @Override
    @NotNull
    public LocalDate getLastUsage() {
        return this.lastUsage;
    }

    @NotNull
    public final String component1() {
        return this.version;
    }

    @NotNull
    public final FileTime component2() {
        return this.lastUsageTime;
    }

    @NotNull
    public final String component3() {
        return this.id;
    }

    @NotNull
    public final String component4() {
        return this.name;
    }

    @NotNull
    public final String component5$intellij_ide_startup_importSettings() {
        return this.codeName;
    }

    @NotNull
    public final Path component6() {
        return this.configDirPath;
    }

    @NotNull
    public final Path component7() {
        return this.pluginsDirPath;
    }

    @NotNull
    public final JbProductInfo copy(@NotNull String version, @NotNull FileTime lastUsageTime, @NotNull String id, @NotNull String name, @NotNull String codeName, @NotNull Path configDirPath, @NotNull Path pluginsDirPath) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)lastUsageTime, (String)"lastUsageTime");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)codeName, (String)"codeName");
        Intrinsics.checkNotNullParameter((Object)configDirPath, (String)"configDirPath");
        Intrinsics.checkNotNullParameter((Object)pluginsDirPath, (String)"pluginsDirPath");
        return new JbProductInfo(version, lastUsageTime, id, name, codeName, configDirPath, pluginsDirPath);
    }

    public static /* synthetic */ JbProductInfo copy$default(JbProductInfo jbProductInfo, String string, FileTime fileTime, String string2, String string3, String string4, Path path, Path path2, int n, Object object) {
        if ((n & 1) != 0) {
            string = jbProductInfo.version;
        }
        if ((n & 2) != 0) {
            fileTime = jbProductInfo.lastUsageTime;
        }
        if ((n & 4) != 0) {
            string2 = jbProductInfo.id;
        }
        if ((n & 8) != 0) {
            string3 = jbProductInfo.name;
        }
        if ((n & 0x10) != 0) {
            string4 = jbProductInfo.codeName;
        }
        if ((n & 0x20) != 0) {
            path = jbProductInfo.configDirPath;
        }
        if ((n & 0x40) != 0) {
            path2 = jbProductInfo.pluginsDirPath;
        }
        return jbProductInfo.copy(string, fileTime, string2, string3, string4, path, path2);
    }

    @NotNull
    public String toString() {
        return "JbProductInfo(version=" + this.version + ", lastUsageTime=" + this.lastUsageTime + ", id=" + this.id + ", name=" + this.name + ", codeName=" + this.codeName + ", configDirPath=" + this.configDirPath + ", pluginsDirPath=" + this.pluginsDirPath + ")";
    }

    public int hashCode() {
        int result2 = this.version.hashCode();
        result2 = result2 * 31 + this.lastUsageTime.hashCode();
        result2 = result2 * 31 + this.id.hashCode();
        result2 = result2 * 31 + this.name.hashCode();
        result2 = result2 * 31 + this.codeName.hashCode();
        result2 = result2 * 31 + ((Object)this.configDirPath).hashCode();
        result2 = result2 * 31 + ((Object)this.pluginsDirPath).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JbProductInfo)) {
            return false;
        }
        JbProductInfo jbProductInfo = (JbProductInfo)other;
        if (!Intrinsics.areEqual((Object)this.version, (Object)jbProductInfo.version)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.lastUsageTime, (Object)jbProductInfo.lastUsageTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.id, (Object)jbProductInfo.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)jbProductInfo.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.codeName, (Object)jbProductInfo.codeName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.configDirPath, (Object)jbProductInfo.configDirPath)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.pluginsDirPath, (Object)jbProductInfo.pluginsDirPath);
    }

    public static final /* synthetic */ CopyOnWriteArrayList access$getDescriptors$p(JbProductInfo $this) {
        return $this.descriptors;
    }
}

